#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <signal.h> 
 
#include <linux/volte_drv.h>
#include "../libaudiomix/include/audiomix_lib.h"

T_ZDrvAudioMix_Cfg testParam;
#define BUFFER_BYTES 1024//1024ֽ 
int main(int argc, char **argv) //ע͵ִļ+++++
{
    FILE *file;  
    
    char *filename;  
    int more_chunks = 1;
    unsigned char buffer[BUFFER_BYTES] = {0};  
    int ret = 0;
    
    testParam.sample_rate = 8000;//Ҫ֤ͬƵ(16K8K)
    testParam.audioType = 1;//1-TX,2-RX//RXע͵ֺ֧չ
    
    printf("enter main\n"); 
    
    if (argc < 2) {
        fprintf(stderr, "Usage: %s \n", argv[0]);
        printf("Usage: %s \n", argv[0]);
        return 1;
    }

    filename = argv[1];
    file = fopen(filename, "rb");
    printf("fopen '%s' end\n", filename); 
    if (!file) {
        fprintf(stderr, "Unable to open file '%s'\n", filename);
        printf("Unable to open file '%s'\n", filename);
        return 1;
    }

    fseek(file, 0, SEEK_SET);
    long begin = ftell(file);
    fseek(file, 0, SEEK_END);
    long end = ftell(file);
    long file_size = end - begin;//ֽ
    int read_times = 0;
    int remain_size = 0;

    fseek(file, 0, SEEK_SET);//ûļͷ
    
    printf("zDrvAudioMix_Open start, file size is %ld\n", file_size);  
    ret = zDrvAudioMix_Open(&testParam); 
    if(ret != 0)
        return 1;
    printf("zDrvAudioMix_Open end\n"); 

    while (more_chunks){
        more_chunks = fread(buffer, sizeof(buffer), 1, file);
        
        if(more_chunks == 1){
            read_times++;
            ret = zDrvAudioMix_Write(buffer, sizeof(buffer));
            if(ret != 0)
                break;
        }
        else{ 
            remain_size = file_size - read_times * sizeof(buffer);
            printf("more_chunks=%d, read_times=%d, remain_size is %d\n", more_chunks, read_times, remain_size);
            if(remain_size == 0)
                break;
            ret = zDrvAudioMix_Write(buffer, remain_size);
            if(ret != 0)
                break;
        } 
    } 
    printf("while(more_chunks) end\n"); 

    ret = zDrvAudioMix_Close();
    if(ret != 0)
        return 1;
    printf("zDrvAudioMix_Close end\n");
    fclose(file);
    printf("fclose end\n");

    return ret;
}

