#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <stdarg.h>

#include "pub_debug_info.h"


#define DEBUG_INFO_MAX_TOTAL_LEN (140)
#define DEBUG_INFO_MAX_DATA_LEN  (128)
#define DEBUG_INFO_MEM_HEAD_LEN  (8)

typedef unsigned int UINT32;
typedef unsigned short UINT16;
typedef unsigned char UINT8;

typedef struct
{
    UINT16 module_id; // 模块id
    UINT16 sub_len;   // 用户数据长度
    UINT32 time;
    char sub_data[]; // 用户数据
} T_SHARED_MEM_DATA;

int sc_debug_info_record(unsigned int id, const char *format, ...)
{
    int fd = -1;
    ssize_t writelen;

    int len;
    va_list args;
    char str_buf[DEBUG_INFO_MAX_TOTAL_LEN] __attribute__((aligned(4)));
    T_SHARED_MEM_DATA *shareMemData;
    shareMemData = (T_SHARED_MEM_DATA *)str_buf;    

    /* args是一个char*类型指针，指向format之后的第一个参数*/
    va_start(args, format);
    len = vsnprintf(shareMemData->sub_data, DEBUG_INFO_MAX_DATA_LEN, format, args);
    va_end(args);
    if (len < 0)
    {
        printf("[libdebug_info]: vsnprintf format error, %s.\n", strerror(errno));
        return -1;
    }

    shareMemData->module_id = (UINT16)(id & 0xFFFF);
    shareMemData->sub_len = len;
    shareMemData->time = 0;

    fd = open(DEBUG_INFO_DEV_PATH, O_WRONLY);
    if (fd < 0)
    {
        printf("[libdebug_info]: sc_debug_info_record, open debug_info error, %s\n", strerror(errno));
        return -1;
    }

    writelen = write(fd, (char *)shareMemData, (len + DEBUG_INFO_MEM_HEAD_LEN));
    if (writelen < 0)
    {
        printf("[libdebug_info]: sc_debug_info_record, write debug_info error, %s\n", strerror(errno));
        return -1;
    }

    if (fd >= 0)
    {
        close(fd);
    }

    return writelen;
}
