/*******************************************************************************
 * 版权所有 (C)2022, 中兴通讯股份有限公司。
 *
 * 文件名称:     pub_flags.h
 * 文件标识:     pub_flags
 * 内容摘要:     zx298501芯片平台flags分区规划头文件
 * 使用方法:
 *
 * 修改日期        版本号      修改标记        修改人          修改内容
 * ------------------------------------------------------------------------------
 * 2022/09/15      V1.0        Create          周国坡          创建
 *
 *******************************************************************************/

#ifndef _MTD_API_H
#define _MTD_API_H

typedef enum
{
    DEVICE_MTD = 0,
    DEVICE_ZFTL = 1,
    DEVICE_MTD_BLOCK,
} device_type_t;

/**
 * @brief 根据分区名查找分区设备文件路径
 * @param partition_name      入参，分区名
 * @param type                入参，设备类型
 * @param out_mtd_path        出参，设备文件路径缓冲区
 * @param out_mtd_path_len    入参，out_mtd_path数据缓冲区长度
 * @return 成功返回0，失败返回-1
 * @retval
 * @note
 * @warning
 */
extern int mtd_find(const char *i_parti_name, device_type_t type, char *out_mtd_path, unsigned int out_mtd_path_len);

/**
 * @brief 根据分区名获取mtd分区信息
 * @param fd                  入参，mtd分区文件fd
 * @param info                出参，包括分区大小和擦除块大小
 * @return 成功返回0，失败返回-1
 * @retval
 * @note fd为打开/dev/mtdN设备句柄
 * @warning
 */
extern int mtd_get_info(int fd, struct mtd_info_user *info);

/**
 * @brief 判断block是否是坏块
 * @param fd                  入参，mtd分区文件fd
 * @param offset              入参，mtd分区偏移位置，包含坏块
 * @return 0表示非坏块，1表示坏块，-1表示失败
 * @retval
 * @note fd为打开/dev/mtdN设备句柄
 * @warning
 */
extern int mtd_block_isbad(int fd, off_t offset);

/**
 * @brief 擦除指定分区
 * @param partition_name      入参，分区名
  * @return 成功返回0，失败返回-1
 * @retval
 * @note
 * @warning
 */
extern int mtd_erase_partition(const char *partition_name);

/**
 * @brief 将指定镜像文件写到指定分区
 * @param partition_name      入参，分区名
 * @param image_file          入参，指定的镜像文件
 * @return 成功返回0，失败返回-1
 * @retval
 * @note
 * @warning 先要mtd_erase_partition函数擦除分区
 */
extern int mtd_write_partition(const char *partition_name, const char *image_file);

/**
 * @brief 擦除mtd分区指定位置数据
 * @param fd                  入参，mtd分区文件fd
 * @param offset              入参，mtd分区偏移位置,包含坏块
  * @return 成功返回0，失败返回-1
 * @retval
 * @note fd为打开/dev/mtdN设备句柄
 * @warning 
 */
extern int mtd_erase_offset(int fd, off_t offset);

/**
 * @brief 将数据写到mtd分区指定偏移位置
 * @param fd                  入参，mtd分区文件fd
 * @param offset              入参，mtd分区偏移位置
 * @param buf                 入参，数据缓冲区
 * @param count               入参，buf数据长度，不超过一个擦除块
 * @return 成功返回写入数据长度，失败返回-1
 * @retval
 * @note fd为打开/dev/mtdN设备句柄
 * @warning 先要mtd_erase_partition函数擦除分区
 */
extern ssize_t mtd_write_offset(int fd, off_t offset, const void *buf, size_t count);

/**
 * @brief 读取mtd分区指定偏移位置的数据
 * @param fd                  入参，mtd分区文件fd
 * @param offset              入参，mtd分区偏移位置
 * @param buf                 出参，数据缓冲区
 * @param count               入参，buf数据长度，不超过一个擦除块
 * @return 成功返回读取数据长度，失败返回-1
 * @retval
 * @note fd为打开/dev/mtdN设备句柄
 * @warning
 */
extern ssize_t mtd_read_offset(int fd, off_t offset, void *buf, size_t count);

#endif  /* _MTD_API_H */
