/**
* @File: codec_res_request_api.c
* @Brief: Implementation of Device Manager in Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @Author: chen.tianming@zte.com.cn
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
* */

/*******************************************************************************
 *						    ͷļ   	          					        *
******************************************************************************/
#include<stdio.h>
#include<stdlib.h>
#include<sys/msg.h>
#include<errno.h>
#include<pthread.h>
#include<string.h>
#include"softap_api.h"
	
/*******************************************************************************
 *							   궨								   *
 ******************************************************************************/

/*******************************************************************************
 *							   Ͷ 							   *
 ******************************************************************************/
 
/*******************************************************************************
 *							   ӿڶ 								   *
 ******************************************************************************/

/**
 *˵ʹaudioԴӿ
 *˵: @	reqParam ҵģţ
 		   @spData ,ӳǰص״̬
 *ֵ  true ɹ
 		   false ʧ(ڻزϳ)	  
 *ע    
 */
BOOL audio_resource_request(T_audio_Res_Request *reqParam, T_audio_UseRsp *RspData)
{
	int tempQueueId = -1;
	MSG_BUF msg = {0};
	long msgSize = 0;
	T_audio_UseReq useReqData = {0}; 
	int moduleIdTmp = MODULE_ID_AP_AUDIODYNAMIC_BASE;//ڲ̬ȡԴģIDʼֵΪMODULE_ID_AP_AUDIODYNAMIC_BASE
	
	if(!reqParam || !RspData) {
		softap_assert("audio_resource_request function: input param is null \n");
		return FALSE;
	}
	/* ϢУϢʱԣʹɾ */
//	if(-1 == (tempQueueId = msgget(reqParam->tempMouduleId, IPC_CREAT | IPC_EXCL))) 
//		softap_assert("audio_resource_request function: create Message queue Error%s", strerror(errno));

	/* ϢУϢʱԣʹɾ */
	while((tempQueueId = msgget(moduleIdTmp,IPC_CREAT | IPC_EXCL| 0600)) < 0)
	{
	    moduleIdTmp++;
		if (moduleIdTmp > MODULE_ID_AP_AUDIODYNAMIC_END) {
			//module_idMODULE_ID_AP_AUDIODYNAMIC_ENDֵʱ
			softap_assert("audio dynamatic msg queue too many now !!!!!!!!");
		}
	}

	/* װϢ͸audio , ȴظȷ */
	useReqData.type = reqParam->audioType;
	useReqData.moduleId = reqParam->moduleId;
	useReqData.tempModuleId = moduleIdTmp;
	if(0 > platform_send_msg(moduleIdTmp, MODULE_ID_CODEC, USE_AUDIO_REQ, sizeof(T_audio_UseReq), (unsigned char *)&useReqData)) 	
		softap_assert("audio_resource_request function: Send USE_AUDIO_REQ msg Error: %s", strerror(errno));
 
	/*ȴaudioػظ */
	while(1)
	{
		/*ȡϢд*/
		memset(&msg,0, sizeof(MSG_BUF));
		msgSize = sizeof(MSG_BUF) - sizeof(long);
		if(0 > msgrcv(tempQueueId, &msg, msgSize, 0, 0))
			softap_assert("audio_resource_request function: Rec msg Error %s\n", strerror(errno));

		slog(RTC_PRINT, SLOG_NORMAL, "audio_resource_request function: Rec msg now:tempModuleId(%x), srcId(%x), dstId(%x), msgCmd(%d)\n", moduleIdTmp,msg.src_id, msg.dst_id, msg.usMsgCmd);
		/*Ϣ */
		if(USE_AUDIO_RSP == msg.usMsgCmd)
		{
			T_audio_UseRsp *serverResData =(T_audio_UseRsp *) msg.aucDataBuf;
			RspData->result = serverResData->result;
			RspData->type = serverResData->type;
			RspData->using_type = serverResData->using_type;
			slog(RTC_PRINT, SLOG_NORMAL, "audio_resource_request function: get debug info:  RspData->resul(%d), using_type(%d)\n ", RspData->result, serverResData->using_type);

			/* ɾϢ */
			if(0 > msgctl(tempQueueId, IPC_RMID, 0))
			{
				slog(RTC_PRINT, SLOG_NORMAL,"error num(%d): error case:%s",errno,strerror(errno));
			}
			if(0 == serverResData->result)	// success	
			{					
				return TRUE;
			} 
			else  
			{  
				slog(RTC_PRINT, SLOG_NORMAL, "audio res request fail now:  using_type(%d)\n",serverResData->using_type);
				return FALSE;
			}

		}
		
	}

}
