
/**************************************************************************
* #include
**************************************************************************/
#include  <stdio.h>
#include  <stdlib.h>
#include  <signal.h>
#include  <sys/time.h>
#include  <syslog.h>
#include  <fcntl.h>
#include  <pthread.h>
#include  <stdlib.h>
#include  <string.h>
#include  <errno.h>
#include  <sys/types.h>
#include  <sys/prctl.h>
#include  <unistd.h>
#include  <linux/rtc.h>
#include  <time.h>
#include  <sys/ipc.h>
#include  <sys/msg.h>
#include  "softap_api.h"
#include  "message.h"
#include  "rtc_timer.h"

/**************************************************************************
* ݽṹ
**************************************************************************/
/**************************************************************************
* ⲿ
**************************************************************************/
/**************************************************************************
* 궨
**************************************************************************/

/**************************************************************************/
int rtc_timer_add(ULONG ulSec, RTC_ID  rtc_id, int src_id)//add_rtc_timer
{
	int ret = -1;
	int data_len = 0;
	RTC_DATA_BUF  buf = {0};
	char rtc_cpu[16] = {0};
	char rtc_cp_ready[8] = {0};

	//ЩӦ˶ʱrtc
	if (ulSec < 59)
		slog(MISC_PRINT, SLOG_ERR,   "rtc time is %d, less than 60. src:0x%x, id:0x%x \n", ulSec, src_id, rtc_id);

	buf.srcModule = src_id;
	buf.module = rtc_id;
	buf.ulSec = ulSec;
	buf.wakeup = 0;
	buf.is_utc = 0;
	data_len = sizeof(RTC_DATA_BUF);
	buf.time_val = time(0);
	buf.cpu = RTC_CPU_AP;

	ret = ipc_send_message(src_id, MODULE_ID_RTC_SERVICE, RTC_MSG_ADD_ALARM, data_len, (unsigned char *)&buf, 0);
	if (ret != 0) {
		slog(MISC_PRINT, SLOG_ERR,   "rtc: set rtc timer send msg failed \n");
		return -1;
	}

	return ret;
}

int rtc_timer_add_utc(struct tm *sec, RTC_ID rtc_id, int src_id, int wakeup)//add_rtc_timer
{
	int ret = -1;
	time_t cur_sec = time(0);
	time_t set_sec = mktime(sec);
	char sntp_result[20] = {0};
	char rtc_cpu[16] = {0};
	char rtc_cp_ready[8] = {0};

	slog(MISC_PRINT, SLOG_ERR,   "rtc_timer_add_utc enter \n");

#if 0
	// ʱӶʱsntpɹ
	sc_cfg_get("sntp_process_result", sntp_result, sizeof(sntp_result));
	if (strcmp("success", sntp_result) != 0) {
		slog(MISC_PRINT, SLOG_ERR,   "rtc: set utc timer should be after sntp success\n");
		return ret;
	}
#endif
	// öʱʱڵǰʱ
	if (cur_sec >= set_sec) {
		slog(MISC_PRINT, SLOG_ERR,   "rtc: set time-%ld should be after then currnet time-%ld\n", set_sec, cur_sec);
		return ret;
	}

	int data_len = 0;
	RTC_DATA_BUF buf = {0};

	buf.srcModule = src_id;
	buf.module = rtc_id;
	buf.ulSec = set_sec - cur_sec;
	buf.time_val = cur_sec;
	buf.wakeup = wakeup;
	buf.is_utc = 1;
	buf.cpu = RTC_CPU_AP;
	data_len = sizeof(RTC_DATA_BUF);

	slog(MISC_PRINT, SLOG_ERR,   "rtc add utc timer, cur:%ld, set:%ld, ulSec:%d; year:%d, mon:%d, day:%d, hour:%d, min:%d, sec:%d, wday:%d, yday:%d \n", buf.time_val, set_sec, buf.ulSec, sec->tm_year, sec->tm_mon, sec->tm_mday, sec->tm_hour, sec->tm_min, sec->tm_sec, sec->tm_wday, sec->tm_yday);
	ret =  ipc_send_message(src_id, MODULE_ID_RTC_SERVICE, RTC_MSG_ADD_ALARM, data_len, (unsigned char *)&buf, 0);
	if (ret != 0) {
		slog(MISC_PRINT, SLOG_ERR,   "rtc: set rtc utc timer send msg failed \n");
		return -1;
	}

	return ret;
}

int rtc_timer_del(RTC_ID rtc_id, int src_id)
{
	int ret = -1;
	int data_len = 0;
	RTC_DATA_BUF  buf = {0};

	buf.srcModule = src_id;
	buf.module = rtc_id;
	buf.cpu = RTC_CPU_AP;
	data_len = sizeof(RTC_DATA_BUF);

	ret = ipc_send_message(src_id, MODULE_ID_RTC_SERVICE, RTC_MSG_DEL_ALARM, data_len, (unsigned char *) &buf, 0);
	if (ret == 0)
		return 0;
	else
		return -1;
}

int rtc_timer_del_all(int src_id, unsigned short req_cmd)
{
	int ret = -1;

	ret = ipc_send_message(src_id, MODULE_ID_RTC_SERVICE, RTC_MSG_DEL_ALL, sizeof(unsigned short), &req_cmd, 0);
	if (ret == 0)
		return 0;
	else
		return -1;
}

int  rtc_set_time(int src_id)
{
	int ret = -1;
	time_t cur_time = time(0);

	ret = ipc_send_message(src_id, MODULE_ID_RTC_SERVICE, RTC_MSG_SET_TIME, sizeof(time_t), &cur_time, 0);
	if (ret == 0)
		return 0;
	else
		return -1;
}


