
#ifndef LIB_ZTE_DMAPP_H
#define LIB_ZTE_DMAPP_H

#include "fota_common.h"


// fotaflag ú궨
#define ZTE_DUA_FOTAFLAG_PART           "/device/name"
#define ZTE_DUA_FOTAFLAG            "fotaflag"
#define ZTE_DUA_PART_UPDATED_DEV        "/dev"
#define ZTE_DUA_FOTAFLAG_BLOCK_PART  "/sys/class/block"
#define ZTE_FOTA_FLAG_PART_NAME_MAX_LEN 255


/**************************************************************************
*                                                                *
**************************************************************************/
/* webui֪ͨdmģϢ */
typedef enum {
	DM_WEBUI_START_FOTA  = 0,//
	DM_WEBUI_PARAM_CHANGED//޸˲

}  E_WebUINotifyType;

/* ֪ͨdmģǷҵϢ */
typedef enum {
	DM_HAS_DTA_COMM  = 0,//ǰû
	DM_HAS_NO_DTA_COMM//
}  E_MCDataRes;

/* ֪ͨdmģǷҵϢ */
typedef enum {
	DM_BSP_PRO_OK  = 0,//ɹ
	DM_BSP_PRO_FAILED
}  E_BSPProcRes;

/* ֪ͨdmģ豸˯ߺͻ*/
typedef enum DeviceSleepWakeUpState_tag {
	DM_WAKE_UP_OK  = 0,//ѳɹ
	DM_FALL_ASLEEP_OK = 1, //ʧ
} DeviceSleepWakeUpState ;


#define DMAPP_IF_ACTIVATE_PDP 0x0001

typedef struct {
	int cmd;
	char data[256];
} DmApp_IF_CMD;

/**************************************************************************
*                        ȫֺԭ                                     *
**************************************************************************/
/**
* @brief ֪ͨDMлAPNĽ
* @param int result
* @param char * reason  ʧܵԭ,δ
* @return 1--ɹ 0--
*/
int Zte_DmApp_IF_MCNotifyAPNResult(int result, char * reason);

/**
* @brief WebUI֪ͨDM
* @param eType ֪ͨ¼
* @return 1--ɹ 0--
*/
int Zte_DmApp_IF_WebUINotifyDM(E_WebUINotifyType eType);

/**
* @brief MC֪ͨDMǷҵڽ
* @param eRes Ƿҵ
* @return 1--ɹ 0--
*/

int Zte_DmApp_IF_MCNotifyDataResult(E_MCDataRes eRes);
/**
* @brief BSP֪ͨDM
* @param eRes Ƿɹ
* @return 1--ɹ 0--
*/
int Zte_DmApp_IF_BSPNotifyProResult(E_BSPProcRes eRes);

/**
* @brief MC֪ͨDM豸
* @param eRes Ƿɹ
* @return 1--ɹ 0--
*/
int Zte_DmApp_IF_McNotifyDeviceSleepWakeUpState(DeviceSleepWakeUpState  sleepWakeUpState);


typedef enum DevicePowerState_tag {
	DEVICE_IS_POWER_ON = 0, //豸
	DEVICE_IS_NOT_POWER_ON,//豸δ
} DevicePowerState;

/**
* @brief MC֪ͨDM뿪״̬
* @param eRes Ƿɹ
* @return 1--ɹ 0--
*/
int Zte_DmApp_IF_McNotifyDevicePowerOn(DevicePowerState devicePowerState);


/**
* @brief ˯ģ֪ͨDMģ˯ģʽ
* @param eRes Ƿɹ
* @return 1--ɹ 0--
*/

int  Zte_DmApp_IF_SleepModuleNotifyDmToSleep(void);

int  zte_fota_browse_fotaflag(char *pathname, char *fota_flag_part_name, unsigned int len);
int zte_fota_set_updateflag(char *updateflag);
char* zte_fota_get_updateflag(char *updateflag_buf);
int zte_fota_set_stateflag(stateflag_t stateflag);
int zte_fota_get_stateflag();
stateflag_t translate_stateflag_str_to_flag(char *stateflag_str);
char* translate_stateflag_flag_to_str(stateflag_t stateflag);
int zte_fota_set_netdogflag(int index, int value);
int zte_fota_get_netdogflag_single(int index);
char* zte_fota_get_netdogflag_all(char *netdogflag_buf);

int Zte_DmApp_IF_GetVersionStatus(void);
int Zte_DmApp_IF_GetCurOps(void);
int Zte_DmApp_IF_GetUpdateCmd(void);
int Zte_DmApp_IF_SetUpdateCmd(int cmd);
int Zte_DmApp_IF_GetDLProgress(int *totalSize, int *downloadSize);
int Zte_DmApp_IF_GetFotaPkgInfo(int *totalSize, char *pkgName, char *pkgVer, char *pkgDesc);
int Zte_DmApp_IF_GetUpdateResult(void);
int Zte_DmApp_IF_GetUpdateSettings(int *mode, int *interval, int *enableRoaming);
int Zte_DmApp_IF_SetUpdateSettings(int mode, int interval, int enableRoaming);
#endif
