/*
* ES8312.h  --  ES8312 ALSA SoC Audio Codec
*
* Authors:
*
* Based on ES8374.h by David Yang
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*/

#ifndef _ES8312_H
#define _ES8312_H

/*
*	ES8312_REGISTER NAME_REG_REGISTER ADDRESS
*/
#define ES8312_RESET_REG00			0x00  /*reset digital,csm,clock manager etc.*/

/*
* Clock Scheme Register definition
*/
#define ES8312_CLK_MANAGER_REG01		0x01 /* select clk src for mclk, enable clock for codec */
#define ES8312_CLK_MANAGER_REG02		0x02 /* clk divider and clk multiplier */
#define ES8312_CLK_MANAGER_REG03		0x03 /* adc fsmode and osr  */
#define ES8312_CLK_MANAGER_REG04		0x04 /* dac osr */
#define ES8312_CLK_MANAGER_REG05		0x05 /* clk divier for adc and dac */
#define ES8312_CLK_MANAGER_REG06		0x06 /* bclk inverter and divider */
#define ES8312_CLK_MANAGER_REG07		0x07 /* tri-state, lrck divider */
#define ES8312_CLK_MANAGER_REG08		0x08 /* lrck divider */
#define ES8312_SDPIN_REG09			0x09 /* dac serial digital port */
#define ES8312_SDPOUT_REG0A			0x0A /* adc serial digital port */
#define ES8312_SYSTEM_REG0B			0x0B /* system */
#define ES8312_SYSTEM_REG0C			0x0C /* system */
#define ES8312_SYSTEM_REG0D			0x0D /* system, power up/down */
#define ES8312_SYSTEM_REG0E			0x0E /* system, power up/down */
#define ES8312_SYSTEM_REG0F			0x0F /* system, low power */
#define ES8312_SYSTEM_REG10			0x10 /* system */
#define ES8312_SYSTEM_REG11			0x11 /* system */
#define ES8312_SYSTEM_REG12			0x12 /* system, Enable DAC */
#define ES8312_SYSTEM_REG13			0x13 /* system */
#define ES8312_SYSTEM_REG14			0x14 /* system, select DMIC, select analog pga gain */
#define ES8312_ADC_REG15			0x15 /* ADC, adc ramp rate, dmic sense */
#define ES8312_ADC_REG16			0x16 /* ADC */
#define ES8312_ADC_REG17			0x17 /* ADC, volume */
#define ES8312_ADC_REG18			0x18 /* ADC, alc enable and winsize */
#define ES8312_ADC_REG19			0x19 /* ADC, alc maxlevel */
#define ES8312_ADC_REG1A			0x1A /* ADC, alc automute */
#define ES8312_ADC_REG1B			0x1B /* ADC, alc automute, adc hpf s1 */
#define ES8312_ADC_REG1C			0x1C /* ADC, equalizer, hpf s2 */

#define ES8312_ADC_EQ_REG1D			0x1D /* ADC equalizer */
#define ES8312_ADC_EQ_REG1E			0x1E /* ADC equalizer */
#define ES8312_ADC_EQ_REG1F		 	0x1F /* ADC equalizer */
#define ES8312_ADC_EQ_REG20		  	0x20 /* ADC equalizer */
#define ES8312_ADC_EQ_REG21			0x21 /* ADC equalizer */
#define ES8312_ADC_EQ_REG22		  	0x22 /* ADC equalizer */
#define ES8312_ADC_EQ_REG24			0x24 /* ADC equalizer */
#define ES8312_ADC_EQ_REG25			0x25 /* ADC equalizer */
#define ES8312_ADC_EQ_REG26			0x26 /* ADC equalizer */
#define ES8312_ADC_EQ_REG27			0x27 /* ADC equalizer */
#define ES8312_ADC_EQ_REG28			0x28 /* ADC equalizer */
#define ES8312_ADC_EQ_REG29			0x29 /* ADC equalizer */
#define ES8312_ADC_EQ_REG2A			0x2A /* ADC equalizer */
#define ES8312_ADC_EQ_REG2B		 	0x2B /* ADC equalizer */
#define ES8312_ADC_EQ_REG2C		    0x2C /* ADC equalizer */
#define ES8312_ADC_EQ_REG2D			0x2D /* ADC equalizer */
#define ES8312_ADC_EQ_REG2E		 	0x2E /* ADC equalizer */
#define ES8312_ADC_EQ_REG2F		  	0x2F /* ADC equalizer */
#define ES8312_ADC_EQ_REG30		 	0x30 /* ADC equalizer */

#define ES8312_DAC_REG31			0x31 /* DAC, mute */
#define ES8312_DAC_REG32			0x32 /* DAC, volume */
#define ES8312_DAC_REG33			0x33 /* DAC, offset */
#define ES8312_DAC_REG34			0x34 /* DAC, drc enable, drc winsize */
#define ES8312_DAC_REG35			0x35 /* DAC, drc maxlevel, minilevel */

#define ES8312_DAC_REG37			0x37 /* DAC, ramprate */
#define ES8312_DAC_EQ_REG38		    0x38 /* DAC equalizer */
#define ES8312_DAC_EQ_REG39			0x39 /* DAC equalizer */
#define ES8312_DAC_EQ_REG40			0x40 /* DAC equalizer */
#define ES8312_DAC_EQ_REG41			0x41 /* DAC equalizer */
#define ES8312_DAC_EQ_REG42			0x42 /* DAC equalizer */
#define ES8312_DAC_EQ_REG43			0x43 /* DAC equalizer */

#define ES8312_GPIO_REG44			0x44 /* GPIO, dac2adc for test */
#define ES8312_GP_REG45				0x45 /* GP CONTROL */

#define ES8312_I2C_REGFA			0xFA /* DAC offset */
#define ES8312_FLAG_REGFC			0xFC /* CHIP state machine, adc automute flag */
#define ES8312_CHD1_REGFD			0xFD /* CHIP ID1 */
#define ES8312_CHD2_REGFE			0xFE /* CHIP ID2 */
#define ES8312_CHVER_REGFF			0xFF /* VERSION */

#define ES8312_MAX_REGISTER			0xFF



#define ES8312_CLKID_MCLK		0
#define ES8312_CLKID_BCLK		1
#endif
