/*
 * zx29_snd_ctrl.c  --  zx29 snd  mixer control
 *
 * Copyright (C) 2017, ZTE Corporation.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <sound/soc.h>

typedef long SINT32;
#if 0
extern SINT32 zDrvVp_SetEchoDelay_Wrap(int val);
extern SINT32 zDrvVp_GetEchoDelay_Wrap(void);
extern SINT32 zDrvVp_SetTxNsMode_Wrap(int val);
extern SINT32 zDrvVp_GetTxNsMode_Wrap(void);
extern SINT32 zDrvVp_SetRxNsMode_Wrap(int val);
extern SINT32 zDrvVp_GetRxNsMode_Wrap(void);
extern int zDrvVp_GetTxVol_Wrap(void);
extern int zDrvVp_SetTxVol_Wrap(int volume);
#endif



#define SND_SOC_INTEGER_EXT(xname, xcount, xhandler_get, xhandler_put) \
{	.iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, \
	.info = snd_soc_interger_info_ext, \
	.get = xhandler_get, .put = xhandler_put, \
	.private_value = xcount \
}
int snd_soc_interger_info_ext(struct snd_kcontrol *kcontrol,
		       struct snd_ctl_elem_info *uinfo)
{
	int count = (void *)kcontrol->private_value;
	uinfo->type = SNDRV_CTL_ELEM_TYPE_INTEGER;
	uinfo->count = count;

	return 0;
}
static int vp_SetEchoDelay(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetEchoDelay(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);

static int vp_SetTxNsMode(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetTxNsMode(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_SetRxNsMode(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetRxNsMode(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetTxVol(struct snd_kcontrol *kcontrol,struct snd_ctl_elem_value *ucontrol);
static int vp_SetTxvol(struct snd_kcontrol *kcontrol,struct snd_ctl_elem_value *ucontrol);
static int vp_GetModuleState(struct snd_kcontrol *kcontrol,	struct snd_ctl_elem_value *ucontrol);
static int vp_SetModuleState(struct snd_kcontrol *kcontrol,	struct snd_ctl_elem_value *ucontrol);
static int vp_SetVpLoop(struct snd_kcontrol *kcontrol,struct snd_ctl_elem_value *ucontrol);
static int vp_GetVpLoop(struct snd_kcontrol *kcontrol,struct snd_ctl_elem_value *ucontrol);



const struct snd_kcontrol_new voice_process_controls[] =
{

	SOC_SINGLE_EXT("echo delay", 0, 0, 270, 0, vp_GetEchoDelay, vp_SetEchoDelay),
	SOC_SINGLE_EXT("tx ns mode", 0, 0, 3, 0, vp_GetTxNsMode, vp_SetTxNsMode),
	SOC_SINGLE_EXT("rx ns mode", 0, 0, 3, 0, vp_GetRxNsMode, vp_SetRxNsMode),
	SOC_SINGLE_EXT("tx vol", 0, 0, 5, 0, vp_GetTxVol, vp_SetTxvol),
	SND_SOC_INTEGER_EXT("vp ctrl", 9,vp_GetModuleState, vp_SetModuleState),
	SOC_SINGLE_EXT("vp loop",0, 5, 5, 0,vp_GetVpLoop, vp_SetVpLoop),

};
int vp_controls_size = sizeof(voice_process_controls) / sizeof(voice_process_controls[0]);
static int vp_SetEchoDelay(struct snd_kcontrol *kcontrol,
                           struct snd_ctl_elem_value *ucontrol)
{
	int val = 0, ret = 0;
	val = ucontrol->value.integer.value[0];
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetEchoDelay_Wrap)(val);

	// ret = zDrvVp_SetApEchoDelay_Wrap(val);
	if (ret < 0)
	{
		printk(KERN_ERR "vp_SetEchoDelay fail = %d\n", val);
		return ret;
	}
	return 0;
}
static int vp_GetEchoDelay(struct snd_kcontrol *kcontrol,
                           struct snd_ctl_elem_value *ucontrol)
{
	//ucontrol->value.integer.value[0] = zDrvVp_GetApEchoDelay_Wrap();
	ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetEchoDelay_Wrap)();
	return 0;
}

static int vp_SetTxNsMode(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	int val = 0, ret = 0;
	val = ucontrol->value.integer.value[0];
	//ret = zDrvVp_SetApNsMode_Wrap(val);
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetTxNsMode_Wrap)(val);
	if (ret < 0)
	{
		printk(KERN_ERR "vp_SetTxNsMode fail = %d\n", val);
		return ret;
	}
	return 0;
}
static int vp_GetTxNsMode(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	//ucontrol->value.integer.value[0] = zDrvVp_GetApNsMode_Wrap();
	ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetTxNsMode_Wrap)();
	return 0;
}


static int vp_SetRxNsMode(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	int val = 0, ret = 0;
	val = ucontrol->value.integer.value[0];
	//ret = zDrvVp_SetApNsMode_Wrap(val);
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetRxNsMode_Wrap)(val);
	if (ret < 0)
	{
		printk(KERN_ERR "vp_SetRxNsMode fail = %d\n", val);
		return ret;
	}
	return 0;
}
static int vp_GetRxNsMode(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	//ucontrol->value.integer.value[0] = zDrvVp_GetApNsMode_Wrap();
	ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetRxNsMode_Wrap)();
	return 0;
}


static int vp_SetTxvol(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	int val = 0, ret = 0;
	val = ucontrol->value.integer.value[0];
	//ret = zDrvVp_SetApNsMode_Wrap(val);
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetTxVol_Wrap)(val);
	if (ret < 0)
	{
		printk(KERN_ERR "vp_SetTxvol fail = %d\n", val);
		return ret;
	}
	return 0;
}
static int vp_GetTxVol(struct snd_kcontrol *kcontrol,
                        struct snd_ctl_elem_value *ucontrol)
{
	//ucontrol->value.integer.value[0] = zDrvVp_GetApNsMode_Wrap();
	ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetTxVol_Wrap)();
	return 0;
}


static int vp_GetModuleState(struct snd_kcontrol *kcontrol,
	struct snd_ctl_elem_value *ucontrol)
{

	unsigned long params = kcontrol->private_value;
       int count = (void *)kcontrol->private_value;
	int *val;
	val = (int *)ucontrol->value.integer.value;
       CPPS_FUNC(cpps_callbacks, zDrvVp_GetModuleState_Wrap)(val,count);


	return 0;
}


static int vp_SetModuleState(struct snd_kcontrol *kcontrol,
	struct snd_ctl_elem_value *ucontrol)
{
       int count = (void *)kcontrol->private_value;
	int *val;
	val = (int *)ucontrol->value.integer.value;
       CPPS_FUNC(cpps_callbacks, zDrvVp_SetModuleState_Wrap)(val,count);	   
	return 0;
}


static int vp_SetVpLoop(struct snd_kcontrol *kcontrol,
							   struct snd_ctl_elem_value *ucontrol)
{
	   int path = 0,ret = 0;
	   path = ucontrol->value.integer.value[0];
	   pr_info("ALSA:%s start path=%d \n",__func__,path);
	   
	   //ret = zDrvVp_SetVpLoop_Wrap(path);
	   
	   ret = CPPS_FUNC(cpps_callbacks, zDrvVp_Loop)(path);
	   if(ret < 0)
	   {
		  printk(KERN_ERR "vp_SetVpLoop fail = %d\n",path);
		  return ret;
	  }
	   pr_info("ALSA:%s end\n",__func__);
	   
	return 0;
}

static int vp_GetVpLoop(struct snd_kcontrol *kcontrol,
							   struct snd_ctl_elem_value *ucontrol)
{		
	   //ucontrol->value.integer.value[0] = zDrvVp_GetVpLoop_Wrap();
	   ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetVpLoop_Wrap)();
	   pr_info("ALSA:%s end vploop state =%d \n",__func__,ucontrol->value.integer.value[0]);
	   return 0;
}

	
