export CURPRJPATH=$(shell cd .. && pwd)
export PRJ_NAME=$(shell basename $(CURPRJPATH))

export TOPDIR_AP=$(shell pwd)/../../../..
export RF_TYPE ?= 220A1
export DCXO ?= no
export PRJ_PRODUCT_DIR=$(TOPDIR_AP)/project/$(CHIP_NAME)/$(PRJ_NAME)
export PRJ_CONF_DIR=$(TOPDIR_AP)/project/$(CHIP_NAME)/$(PRJ_NAME)/config

ifeq ($(DCXO), yes)
export PRJ_BIN_DIR=$(PRJ_PRODUCT_DIR)/bin/$(RF_TYPE)_dcxo
else
export PRJ_BIN_DIR=$(PRJ_PRODUCT_DIR)/bin/$(RF_TYPE)
endif

export SIGN=$(TOPDIR_AP)/../tools/SignTool/SignImage
export OBFU_TOOL=$(TOPDIR_AP)/../tools/stunnix/bin/cxx-obfus
export LIBPS_BUILD_SHELL ?= build_modem_merge.sh
export USE_TestHarness ?= no

export CUSTOM_MACRO=-DAPP_OS_LINUX=1 \
			-DAPP_OS_TOS=2 \
			-DAPP_OS_ZEPHYR=3 \
			-DAPP_OS_YUNOS=4 \
			-DPRODUCT_MIFI_CPE=0 \
			-DPRODUCT_PHONE=1 \
			-DPRODUCT_DATACARD=2

export THUMB ?= yes
export CONFIG_MEMCHECK=no
# copy libstdc++.so.6 to rootfs /lib
export USE_LIBSTDCPP ?= no
export LARGEFILE_SPLIT_ENABLE ?= no
export KO_SPLIT_ENABLE ?= no
export SPLIT_BLOCK_SIZE ?= 512K
#lzma dictionary, default 512KB
export LZMA_DICT ?= 512
export USE_RESOURCE ?= no
export ROOT_FS_TYPE ?= ubifs
export USERDATA_FS_TYPE ?= ubifs

export CROSS_COMPILE_VERSION ?= gcc-4.9.4_thumb_linux
#prj_mdl_min prj_mifi_min
export PRJ_IS_MIN ?= no
export USE_VOICE_SUPPORT ?= yes
export MODEM_TYPE ?= all
export USE_CPPS_KO ?= yes
export USE_ENABLE_LTO ?= no
export CONFIG_KLOCWORK ?= yes
export USE_CAP_SYS ?= no
export USE_BTRUNK_SUPPORT ?= no
export USE_FOTA ?= yes
export USE_FOTA_AB ?= no

#remove shell scripts comment in rootfs
export USE_REMOVE_COMMENT ?= no

# y for yes, n for no, keep same format with kernel configuration
export CONFIG_MIN_8M_VERSION ?= n

export USE_ZCAT_MBIM ?= no
export USE_RECOVERYFS ?= no
export USE_OEM_FS ?= no
export USE_VEHICLE_DC ?= no
export USE_ZXIC_DEBUG_INFO ?= no
export LIBC_TYPE ?= uClibc
export LIBC_VERSION ?= uClibc-0.9.33.2
export CROSS_COMPILE_PREFIX ?= arm-buildroot-linux-uclibcgnueabi-
export USE_GLIBC ?= no
export LIBGCC_KERNEL ?= libgcc.a
export LIBNVRAM_API_NEW ?= no
export LIBSOFT_TIMER_API_NEW ?= no
export USE_OPTEE ?= no
export USE_VEHICLE_DC_REF ?= no
export USE_NVRO_BACKUP ?= no

export MK_SDK_VERSION=yes
