
#include "drv_rsa.h"
#include <sdio.h>

/*  : ʵ- N^-1 mod 2^32 㷨*/
static u32 get_N_inv(u32 N0)
{
	u32 N_inv=1;
	u32 i,a,b;

	for(i=1; i<32; i++)
	{
		a = 1<<i;
		b = (N0*N_inv)&((2<<i)-1);
		if(a<b)
		{
		  N_inv = N_inv+ a;
		}
	}
	
	return (0xffffffff-N_inv+1);
}

static void rsa_WriteDataToReg(u32* pudAddr, u32 udReg, u32 Len)
{
    u32 udI;
    for(udI=0;udI<Len;udI++)
    {
	//ģ͵ַĴŵ͵ַݣݴǵ͵ַŸλ
	REG32(udReg + udI*4) = *(pudAddr+Len-1-udI);
    }
}

static void rsa_ReadDataFromReg(u32* pudAddr, u32 udReg, u32 Len)
{
    u32 udI;
    for(udI=0;udI<Len;udI++)
    {
	//ģ͵ַĴŵ͵ַݣݴǵ͵ַŸλ
	*(pudAddr+Len-1-udI) = REG32(udReg + udI*4);
    }
}

#ifdef RSA_CODE_SUPPORT_ALL
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ˷
 * 
 * :
 *     - Rsa_BigNumMultipleڲ, 书:
 *      - 
 *     
 * :
 * 
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 rsa_BigNumMultiple(u32 udNbitLen, u32* pudInputM, u32* pudInputE, u32* pudOutputP)
{
    u32 Nlen_word, Elen_word;
    //input M, E, udNbitLen
    if(udNbitLen>2048||udNbitLen==0\
	||pudInputM==NULL||pudInputE==NULL||pudOutputP==NULL)
    {
        return 1;
    }
	
    REG32(RSA_INT_MASK)   = 0;                          /*unmask interrupt*/    
    REG32(RSA_INT_ENABLE) = 0;                          /*disable interrupt*/
    REG32(RSA_CALC_MODE)  = RSA_BIG_NUM_MULTIPLE;      /* set computemode*/
    
    //M,E RAMĴ	
    Nlen_word = (udNbitLen+31)/32;
    rsa_WriteDataToReg(pudInputM, RSA_M_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputE, RSA_E_RAM, Nlen_word);
    //N bit 
   REG32(RSA_MODULAR_LENGTH) = udNbitLen-1;/*set modelength, λbit*/

    //enable compute
    REG32(RSA_MODULE_ENABLE) = 1;  

   /*check interrupt status, waiting for calculating finished*/
    while(!(REG32(RSA_INT_STATUS)& 0x01));
    
   /* clear the interrupt,input any */
    REG32(RSA_INT_STATUS) = 1;
   
    /* read the result */
    rsa_ReadDataFromReg(pudOutputP, RSA_RESULT_RAM, Nlen_word);
	
    /*close mode enable*/
    REG32(RSA_MODULE_ENABLE) = 0;  

    return 0;

}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼ
 * 
 * :
 *     - Rsa_InitComputeڲ, 书:
 *      - ʼ c= r*r mod N
 *     
 * :
 *
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 rsa_InitCompute(u32 udNbitLen, u32* pudInputN, u32* pudOutputP)
{
    u32 Nlen_word;
    //input N, udNbitLen
    if(udNbitLen>2048||udNbitLen==0\
		||pudInputN==NULL||pudOutputP==NULL)
    {
        return 1;
    }
		
    REG32(RSA_INT_MASK)   = 0;                          /*unmask interrupt*/    
    REG32(RSA_INT_ENABLE) = 0;                          /*disable interrupt*/
    REG32(RSA_CALC_MODE)  = RSA_INIT_COMPUTE;      /* set computemode*/
    
    //N RAMĴ	
    Nlen_word = (udNbitLen+31)/32;
    rsa_WriteDataToReg(pudInputN, RSA_N_RAM, Nlen_word);
	
    //N bit 
    if((pudInputN[0]&0x80000000) == 0)
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-2;/*set modelength, λbit*/
    }
    else
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-1;/*set modelength, λbit*/
    }
	
    //enable compute
    REG32(RSA_MODULE_ENABLE) = 1;  

   /*check interrupt status, waiting for calculating finished*/
    while(!(REG32(RSA_INT_STATUS)& 0x01));
    
   /* clear the interrupt,input any */
    REG32(RSA_INT_STATUS) = 1;
   
    /* read the result */
    rsa_ReadDataFromReg(pudOutputP, RSA_INIT_CALC_RAM, Nlen_word);
	
    /*close mode enable*/
    REG32(RSA_MODULE_ENABLE) = 0;  

    return 0;

}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼģ
 * 
 * :
 *     - Rsa_ModMultipleNoInitڲ, 书:
 *      - ģУгʼ
 *     
 * :
 * 
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void rsa_ModMultipleNoInit(u32 udNbitLen, u32 udEbitLen, u32* pudInputM, u32* pudInputE, u32* pudInputN, u32* pudInputC, u32* pudOutputP)
{
    u32 Nlen_word, Elen_word;
    //input M, E, N, C, udNbitLen, udEbitLen
    if(udNbitLen>2048||udNbitLen==0||udEbitLen>2048||udEbitLen==0\
	||pudInputM==NULL||pudInputE==NULL||pudInputN==NULL||pudInputC==NULL||pudOutputP==NULL)
    {
        return 1;
    }
		
    REG32(RSA_INT_MASK)   = 0;                          /*unmask interrupt*/    
    REG32(RSA_INT_ENABLE) = 0;                          /*disable interrupt*/
    REG32(RSA_CALC_MODE)  = RSA_MOD_MULTIPLE_NO_INIT;      /* set computemode*/
    
    Nlen_word = (udNbitLen+31)/32;
    Elen_word = (udEbitLen+31)/32;
	
    //òN0, ڲN λ
    REG32(RSA_NZORE) = pudInputN[Nlen_word-1];
    // òN0'  ,    - N^-1 mod 2^32
    REG32(RSA_NZORE_INV) = get_N_inv(pudInputN[Nlen_word-1]);

    //M,E,N RAMĴ	
    rsa_WriteDataToReg(pudInputM, RSA_M_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputE, RSA_E_RAM, Elen_word);
    rsa_WriteDataToReg(pudInputN, RSA_N_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputC, RSA_INIT_CALC_RAM, Nlen_word);
	
    //N,E bit 
    if((pudInputN[0]&0x80000000) == 0)
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-2;/*set modelength, λbit*/
    }
    else
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-1;/*set modelength, λbit*/
    }
    REG32(RSA_EXP_LENGTH)          = (Elen_word-1)<<5;      /*set expolength, λword*/

    //enable compute
    REG32(RSA_MODULE_ENABLE) = 1;  

   /*check interrupt status, waiting for calculating finished*/
    while(!(REG32(RSA_INT_STATUS)& 0x01));
    
   /* clear the interrupt,input any */
    REG32(RSA_INT_STATUS) = 1;
   
    /* read the result */
    rsa_ReadDataFromReg(pudOutputP, RSA_RESULT_RAM, Nlen_word);
	
    /*close mode enable*/
    REG32(RSA_MODULE_ENABLE) = 0;  

    return 0;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼģ
 * 
 * :
 *     - Rsa_ModMultipleWithInitڲ, 书:
 *      - ģУгʼ
 *     
 * :
 * 
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 rsa_ModMultipleWithInit(u32 udNbitLen, u32 udEbitLen, u32* pudInputM, u32* pudInputE, u32* pudInputN, u32* pudOutputP)
{
    u32 Nlen_word, Elen_word;
    //input M, E, N, udNbitLen, udEbitLen
    if(udNbitLen>2048||udNbitLen==0||udEbitLen>2048||udEbitLen==0\
	||pudInputM==NULL||pudInputE==NULL||pudInputN==NULL||pudOutputP==NULL)
    {
        return 1;
    }
		
    REG32(RSA_INT_MASK)   = 0;                          /*unmask interrupt*/    
    REG32(RSA_INT_ENABLE) = 0;                          /*disable interrupt*/
    REG32(RSA_CALC_MODE)  = RSA_MOD_MULTIPLE_WITH_INIT;      /* set computemode*/
    
    Nlen_word = (udNbitLen+31)/32;
    Elen_word = (udEbitLen+31)/32;
	
    //òN0, ڲN λ
    REG32(RSA_NZORE) = pudInputN[Nlen_word-1];
    // òN0'  ,    - N^-1 mod 2^32
    REG32(RSA_NZORE_INV) = get_N_inv(pudInputN[Nlen_word-1]);

    //M,E,N RAMĴ	
    rsa_WriteDataToReg(pudInputM, RSA_M_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputE, RSA_E_RAM, Elen_word);
    rsa_WriteDataToReg(pudInputN, RSA_N_RAM, Nlen_word);
	
    //N,E bit 
    if((pudInputN[0]&0x80000000) == 0)
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-2;/*set modelength, λbit*/
    }
    else
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-1;/*set modelength, λbit*/
    }
    REG32(RSA_EXP_LENGTH)          = (Elen_word-1)<<5;      /*set expolength, λword*/

    //enable compute
    REG32(RSA_MODULE_ENABLE) = 1;  

   /*check interrupt status, waiting for calculating finished*/
    while(!(REG32(RSA_INT_STATUS)& 0x01));
    
   /* clear the interrupt,input any */
    REG32(RSA_INT_STATUS) = 1;
   
    /* read the result */
    rsa_ReadDataFromReg(pudOutputP, RSA_RESULT_RAM, Nlen_word);
	
    /*close mode enable*/
    REG32(RSA_MODULE_ENABLE) = 0;  

    return 0;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼģ
 * 
 * :
 *     - Rsa_ModExpoNoInitڲ, 书:
 *      - ģУгʼ
 *     
 * :
 *
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 rsa_ModExpoNoInit(u32 udNbitLen, u32 udEbitLen, u32* pudInputM, u32* pudInputE, u32* pudInputN, u32* pudInputC, u32* pudOutputP)
{
    u32 Nlen_word, Elen_word;
    //input M, E, N, C, udNbitLen, udEbitLen
    if(udNbitLen>2048||udNbitLen==0||udEbitLen>2048||udEbitLen==0\
	||pudInputM==NULL||pudInputE==NULL||pudInputN==NULL||pudInputC==NULL||pudOutputP==NULL)
    {
        return 1;
    }
		
    REG32(RSA_INT_MASK)   = 0;                          /*unmask interrupt*/    
    REG32(RSA_INT_ENABLE) = 0;                          /*disable interrupt*/
    REG32(RSA_CALC_MODE)  = RSA_MOD_EXPO_NO_INIT;      /* set computemode*/
    
    Nlen_word = (udNbitLen+31)/32;
    Elen_word = (udEbitLen+31)/32;
	
    //òN0, ڲN λ
    REG32(RSA_NZORE) = pudInputN[Nlen_word-1];
    // òN0'  ,    - N^-1 mod 2^32
    REG32(RSA_NZORE_INV) = get_N_inv(pudInputN[Nlen_word-1]);

    //M,E,N RAMĴ	
    rsa_WriteDataToReg(pudInputM, RSA_M_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputE, RSA_E_RAM, Elen_word);
    rsa_WriteDataToReg(pudInputN, RSA_N_RAM, Nlen_word);
    rsa_WriteDataToReg(pudInputC, RSA_INIT_CALC_RAM, Nlen_word);
	
    //N,E bit 
    if((pudInputN[0]&0x80000000) == 0)
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-2;/*set modelength, λbit*/
    }
    else
    {
        REG32(RSA_MODULAR_LENGTH) = udNbitLen-1;/*set modelength, λbit*/
    }
    REG32(RSA_EXP_LENGTH)          = (Elen_word-1)<<5;      /*set expolength, λword*/

    //enable compute
    REG32(RSA_MODULE_ENABLE) = 1;  

   /*check interrupt status, waiting for calculating finished*/
    while(!(REG32(RSA_INT_STATUS)& 0x01));
    
   /* clear the interrupt,input any */
    REG32(RSA_INT_STATUS) = 1;
   
    /* read the result */
    rsa_ReadDataFromReg(pudOutputP, RSA_RESULT_RAM, Nlen_word);
	
    /*close mode enable*/
    REG32(RSA_MODULE_ENABLE) = 0;  

    return 0;
}
#endif

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼģ
 * 
 * :
 *     - Rsa_ModExpoWithInitڲ, 书:
 *      - ģУгʼ
 *     
 * :
 * 
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 rsa_ModExpoWithInit(u32 udNbitLen, u32 udEbitLen, u32* pudInputM, u32* pudInputE, u32* pudInputN, u32* pudOutputP)
{
	u32 Nlen_word, Elen_word;
	//input M, E, N, udNbitLen, udEbitLen
	if(udNbitLen>2048||udNbitLen==0||udEbitLen>2048||udEbitLen==0\
		||pudInputM==NULL||pudInputE==NULL||pudInputN==NULL||pudOutputP==NULL)
	{
		return 1;
	}

	REG32(RSA_INT_MASK) = 0;    /*unmask interrupt*/    
	REG32(RSA_INT_ENABLE) = 0;    /*disable interrupt*/
	REG32(RSA_CALC_MODE) = RSA_MOD_EXPO_WITH_INIT;    /* set computemode*/

	Nlen_word = (udNbitLen+31)/32;
	Elen_word = (udEbitLen+31)/32;

	//òN0, ڲN λ
	REG32(RSA_NZORE) = pudInputN[Nlen_word-1];
	// òN0'  ,    - N^-1 mod 2^32
	REG32(RSA_NZORE_INV) = get_N_inv(pudInputN[Nlen_word-1]);

	//M,E,N RAMĴ
	rsa_WriteDataToReg(pudInputM, RSA_M_RAM, Nlen_word);
	rsa_WriteDataToReg(pudInputE, RSA_E_RAM, Elen_word);
	rsa_WriteDataToReg(pudInputN, RSA_N_RAM, Nlen_word);

	//N,E bit 
	if((pudInputN[0]&0x80000000) == 0)
	{
		REG32(RSA_MODULAR_LENGTH) = udNbitLen - 2;    /*set modelength, λbit*/
	}
	else
	{
		REG32(RSA_MODULAR_LENGTH) = udNbitLen -1;    /*set modelength, λbit*/
	}
	REG32(RSA_EXP_LENGTH) = (Elen_word-1)<<5;    /*set expolength, λword*/

	//enable compute
	REG32(RSA_MODULE_ENABLE) = 1;  

	/*check interrupt status, waiting for calculating finished*/
	while(!(REG32(RSA_INT_STATUS)& 0x01));

	/* clear the interrupt,input any */
	REG32(RSA_INT_STATUS) = 1;

	/* read the result */
	rsa_ReadDataFromReg(pudOutputP, RSA_RESULT_RAM, Nlen_word);

	/*close mode enable*/
	REG32(RSA_MODULE_ENABLE) = 0;  

	return 0;
}
/*  
:RSA ּĽӿں
:
	ptInput ṹ˵
*/
u32 Rsa_Calculate(T_Rsa_Paramter ptInput)
{
	switch(ptInput.udCalMode)
	{
#ifdef RSA_CODE_SUPPORT_ALL
		case RSA_BIG_NUM_MULTIPLE: //input M, E, udNbitLen
			return rsa_BigNumMultiple(ptInput.udNbitLen, ptInput.pudInputM, ptInput.pudInputE, ptInput.pudOutputP);
	            
		case RSA_INIT_COMPUTE: //input N, udNbitLen
			return rsa_InitCompute(ptInput.udNbitLen, ptInput.pudInputN, ptInput.pudOutputP);
				
		case RSA_MOD_MULTIPLE_NO_INIT: //input M, E, N, C, udNbitLen, udEbitLen
			return rsa_ModMultipleNoInit(ptInput.udNbitLen, ptInput.udEbitLen, ptInput.pudInputM, ptInput.pudInputE, ptInput.pudInputN, ptInput.pudInputC, ptInput.pudOutputP);
				
		case RSA_MOD_EXPO_NO_INIT: 	//input M, E, N, C, udNbitLen, udEbitLen
			return rsa_ModExpoNoInit(ptInput.udNbitLen, ptInput.udEbitLen, ptInput.pudInputM, ptInput.pudInputE, ptInput.pudInputN, ptInput.pudInputC, ptInput.pudOutputP);
				
		case RSA_MOD_MULTIPLE_WITH_INIT: //input M, E, N, udNbitLen, udEbitLen
			return rsa_ModMultipleWithInit(ptInput.udNbitLen, ptInput.udEbitLen, ptInput.pudInputM, ptInput.pudInputE, ptInput.pudInputN, ptInput.pudOutputP);
#endif		
		case RSA_MOD_EXPO_WITH_INIT:       //input M, E, N, udNbitLen, udEbitLen
			return rsa_ModExpoWithInit(ptInput.udNbitLen, ptInput.udEbitLen, ptInput.pudInputM, ptInput.pudInputE, ptInput.pudInputN, ptInput.pudOutputP);
				
		default:
			return 1;
	}
}

