/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_efuse_program.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zhangdongdong
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include "downloader_config.h"
#include "downloader_nand.h"
#include "downloader_serial.h"
#include <secure_verify.h>
#include <asm/arch/efuse.h>

/*
*******************************************************************
* 	                                     Macro define
*******************************************************************
*/
#define BOARD_TYPE_ZX297520V3		0x0
#define BOARD_TYPE_ZX297520V3E32M	0x1
#define BOARD_TYPE_ZX297520V3E64M	0x2
#define BOARD_TYPE_ZX297520V3E256M	0x3

#define BOARD_TYPE_UNKNOWN			0xFF


/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
extern char *tsp_console_buffer;

/*******************************************************************************
 * Function:do_efuse_program
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_efuse_program(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    char *cmd = NULL;
	unsigned int secure_en = 0;
	unsigned int chip_flag = 0;
	unsigned int puk_hash[4] = {0};

	if(argc<6)
    {
    	printf("invalid parameter\n");
        return cmd_usage(cmdtp);
    }

	cmd = argv[1];

	if (strcmp(cmd, "secure_en") == 0) 
    {
    	printf("argv2 = %4s\n",argv[2]);
		if(strcmp(argv[2], "enable") == 0)
			efuse_program_secure_en(1);
		else if(strcmp(argv[2], "disable") == 0)
			efuse_program_secure_en(0);
		else
			return -1;

        return 0;
	}

	if (strcmp(cmd, "chip_flag") == 0) 
    {
		chip_flag = (unsigned int)simple_strtoul (argv[2], NULL, 16);
		printf("efuse chip_flag=0x%x\n",chip_flag);
		efuse_program_chip_flag(chip_flag);
			
        return 0;
	}

	if (strcmp(cmd, "puk_hash") == 0) 
    {
		puk_hash[0] = (unsigned int)simple_strtoul (argv[2], NULL, 16);
		puk_hash[1] = (unsigned int)simple_strtoul (argv[3], NULL, 16);
		puk_hash[2] = (unsigned int)simple_strtoul (argv[4], NULL, 16);
		puk_hash[3] = (unsigned int)simple_strtoul (argv[5], NULL, 16);
		printf("efuse puk hash0=0x%x, hash1=0x%x, hash2=0x%x, hash3=0x%x\n",puk_hash[0],puk_hash[1],puk_hash[2],puk_hash[3]);
		efuse_program_puk_hash(puk_hash);
        return 0;
	}

	return -1;	
}


/*******************************************************************************
 * Function:do_efuse_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_efuse_read(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    char *cmd = NULL;
    char *rx_buffer = tsp_console_buffer;
    char *ack = tsp_console_buffer;
	efuse_struct efuse_info ={0};	
	unsigned int dev_id[3] = {0};


	if(argc < 2)
    {
    	printf("invalid read parameter\n");
        return cmd_usage(cmdtp);
    }

	cmd = argv[1];

	efuse_get_devinfo(&efuse_info);
	
	if (strcmp(cmd, "dev_id") == 0) 
    {
	
		dev_id[0] = efuse_info.dev_id[0];
		dev_id[1] = efuse_info.dev_id[1];
		dev_id[2] = efuse_info.dev_id[2];
		
		sprintf(ack,"dev_id:");
		downloader_serial_write(ack, strlen(ack)+1);

		memcpy((unsigned char*)(DOWNLOADER_BUFFER_BASE),(unsigned char *)(dev_id),12);	
		downloader_serial_write_actuallen((const char *)DOWNLOADER_BUFFER_BASE, 12); 
		
		printf("devid:[id0] =0x%x, [id1]=0x%x, [id2] =0x%x\n",dev_id[0],dev_id[1],dev_id[2]);

		downloader_readline(rx_buffer);
		if(memcmp(rx_buffer,"OKAY",4)==0)
	    {
	    	sprintf(ack,"DEVID SUCCESS");
		    downloader_serial_write(ack, strlen(ack)+1);		
	        return 0;
	    }	
	}
	
   sprintf(ack,"FAIL COMMAND ERROR");
   downloader_serial_write(ack, strlen(ack)+1);
   return -1;	
}


U_BOOT_CMD(
	efuse_program, CONFIG_SYS_MAXARGS, 0, do_efuse_program,
	"efuse_program: program [puk_hash/secure_en/chip_flag] [hash0/enable/SPE][hash1][hash2][hash3]",
	""
);

U_BOOT_CMD(
	efuse_read, CONFIG_SYS_MAXARGS, 0, do_efuse_read,
	"efuse_read: read [devid]",
	""
);

/*
 ******************************************************************************
 * Function:do_read_board_type
 * Description:
 * Parameters:
 *	 Input:
 *	 Output:
 * Returns:
 * Others:
 *******************************************************************************
 */
 int do_read_board_type(cmd_tbl_t *cmdtp, int flag, 
 								int argc, char * const argv[])
{
    char *ack = tsp_console_buffer;
	efuse_struct efuse_info ={0};
	unsigned int secure_flag = 0;
	unsigned int chip_flag = 0;
	unsigned int board_type = 0;

	if(argc != 1)
    {
        return cmd_usage(cmdtp);
    }

	efuse_get_devinfo(&efuse_info);

	secure_flag = efuse_info.secure_flag;
	chip_flag = secure_flag >> 8;
	if((chip_flag == ZX297520V3_GW_NYB_1G_DDR)
		||(chip_flag == ZX297520V3_GW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3ECO_GW_NYB_1G_DDR)
		||(chip_flag == ZX297520V3ECO_GW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3SC_GW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3ECOSCC_GW_UNILC_1G_DDR)
		||(chip_flag == ZX297520V3ECOSCC_GW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3ECOSC_GW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3ECOSC_GW_UNILC_1G_DDR)
		||(chip_flag == ZX297520V3_ZW_NYB_1G_DDR)
		||(chip_flag == ZX297520V3_ZW_NYC_1G_DDR)
		||(chip_flag == ZX297520V3ECO_ZW_NYB_1G_DDR)
		||(chip_flag == ZX297520V3ECO_ZW_NYC_1G_DDR))
	{
		printf("chip_flag=0x%x board_type is V3.\n", chip_flag);
		board_type = BOARD_TYPE_ZX297520V3;
	}
	else if((chip_flag == ZX297520V3ECO_GW_UNILC_512M_DDR)
			||(chip_flag == ZX297520V3ECO_GW_APM_512M_DDR)
			||(chip_flag == ZX297520V3ECO_GW_ESMT_512M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_UNILC_512M_DDR)
			||(chip_flag == ZX297520V3ECO_AZW_UNILC_512M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_APM_512M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_ESMT_512M_DDR))
	{
		printf("chip_flag=0x%x board_type is V3E.\n", chip_flag);
		board_type = BOARD_TYPE_ZX297520V3E64M;
	}
	else if((chip_flag == ZX297520V3ECOSC_GW_NYC_2G_DDR)
			||(chip_flag == ZX297520V3ECOGG_GW_NYC_2G_DDR)
			||(chip_flag == ZX297520V3ECOGG_GW_NYC_NOR_2G_DDR)
			||(chip_flag == ZX297520V3ECOSC_GW_NYC_NOR_2G_DDR))
	{
		printf("chip_flag=0x%x board_type is V3E.\n", chip_flag);
		board_type = BOARD_TYPE_ZX297520V3E256M;
	}	
	else if((chip_flag == ZX297520V3ECO_GW_WINBD_256M_DDR)
			||(chip_flag == ZX297520V3ECO_GW_UNILC_256M_DDR)
			||(chip_flag == ZX297520V3ECO_GW_APM_256M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_WINBD_256M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_UNILC_256M_DDR)
			||(chip_flag == ZX297520V3ECO_ZW_APM_256M_DDR))
	{
		printf("chip_flag=0x%x board_type is V3T.\n", chip_flag);
		board_type = BOARD_TYPE_ZX297520V3E32M;
	}
	else
	{
		printf("chip_flag=0x%x board_type is unknown.\n", chip_flag);
		board_type = BOARD_TYPE_UNKNOWN;
	}

	sprintf(ack,"%04x", board_type);
	downloader_serial_write(ack, strlen(ack)+1);
   	return 0;	
}

U_BOOT_CMD(
	read_board_type, CONFIG_SYS_MAXARGS, 0, do_read_board_type,
	"read board type.",
	""
);

