/*********************************************************************
 Copyright 2016 by  ZIXCCorporation.
*
* FileName::    boot_mode.c
* File Mark:
* Description:  
* Others:
* Version:   v1.0
* Author:   zhouqi
* Date:   2014-1-15

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <asm/io.h>    
#include <boot_mode.h>
#include <load_image.h>
#include <zx234290.h>
#include <power.h>
#include <config.h>
#include <partition_table.h>
#include <linux/mtd/compat.h>

#define NVRWALL_PATH "/nvrwall.bin"
//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC) || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
extern int imagefs_flag;
#endif

int g_iftype = IF_TYPE_UNKNOWN; // initialize to UNKNOWN DEVICE
boot_reason_t g_boot_reason = RB_POWER_KEY;
u_char ucBootReason1st = 0xff;
u_char ucBootReason2nd = 0xff;

u_char battery_detect_flag = 0xff;

int nvrw_flag_init(void)
{
	u_char *p_boot_reason = NULL;
	char cmd[64] = {0};

//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC) || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
    if(imagefs_flag == 1)
	    sprintf(cmd, "fsload imagefs 0x%x %s", (ulong)CONFIG_SYS_SDRAM_TEMP_BASE, NVRWALL_PATH);
	else
		sprintf(cmd, "fsload imagefs2 0x%x %s", (ulong)CONFIG_SYS_SDRAM_TEMP_BASE, NVRWALL_PATH);
#else	
	sprintf(cmd, "fsload imagefs 0x%x %s", (ulong)CONFIG_SYS_SDRAM_TEMP_BASE, NVRWALL_PATH);
#endif
	run_command(cmd, 0);

	p_boot_reason = (u_char*)CONFIG_SYS_SDRAM_TEMP_BASE;

	ucBootReason1st = *(p_boot_reason + ARM_AMT_FLAG_OFFSET);
	ucBootReason2nd = *(p_boot_reason + ARM_AMT_FLAG_OFFSET + 1);

	battery_detect_flag = *(p_boot_reason + ARM_DRV_PERIPHERAL_OFFSET);
	if(battery_detect_flag != 0)
	{
		battery_detect_flag = 1;
	}

	printf("ucBootReason1st=0x%x, ucBootReason2nd=0x%x, battery_detect_flag=0x%x\n", 
			ucBootReason1st, ucBootReason2nd, battery_detect_flag);

	return 0;
}

int get_battery_detect_flag(void)
{
	if(battery_detect_flag != 0)
	{
		return 1;
	}

	return 0;
}



/*******************************************************************************
 * Function:    get_load_mode
 * Description:ȡloadģʽʹUBOOTӦģʽ 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:      Z-Load  --->   uboot ģʽ
                T-Load  --->   uboot ģʽ:
 ********************************************************************************/
load_mode_t get_load_mode( void )
{
	uint32_t mode = readl(CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT);

	if( mode == CFG_TLOAD_MODE )
	{
		return TLOAD_MODE;
	}
	else if( mode == CFG_ZLOAD_MODE )
	{
		return ZLOAD_MODE;
	}
	else
	{
		return UNKNOWN_LOAD_MODE;
	}
}


/*******************************************************************************
 * Function:    
 * Description: get_boot_reason
 * Parameters:  ȡԭ
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int get_boot_reason(void)
{ 
	int ret = 0;

	/* tsp_nvrw_0x00050000.binǰֽжʽ
	 * ΪTM0x54,0x4DΪAMTģʽ
	 * Ϊ汾 */
	if((0x54 == ucBootReason1st) && (0x4D == ucBootReason2nd))
	{
		g_boot_reason = RB_AMT;
	}
	else if((0x54 == ucBootReason1st) && (0x02 == ucBootReason2nd))
	{
		g_boot_reason = RB_PRODUCTION;
	}
	else
	{
		struct pmu_opt *pmu = get_pmu_opt();
		ret = pmu->get_boot_reason(&g_boot_reason);
		ret += get_fota_update_flag();
	}
	BOOT_PRINTF(UBOOT_DBG, "g_boot_reason=0x%x, ret=0x%x.\n", g_boot_reason, ret);
	return ret;
}

/*******************************************************************************
 * Function:    read_boot_reason
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
boot_reason_t read_boot_reason(void)
{
	return g_boot_reason;
}


void get_boot_flashtype(void)
{
	uint32_t type = readl(CFG_BOOT_MODE_START_MODE_FOR_UBOOT);
	
	switch( type )
	{
		case CFG_START_MODE_NAND:
			g_iftype = IF_TYPE_NAND;
			break;
		case CFG_START_MODE_SPI_NAND:
			g_iftype = IF_TYPE_SPI_NAND;
			break;
		case CFG_START_MODE_SDIO:
			g_iftype = IF_TYPE_SD;
			break;
		case CFG_START_MODE_EMMC:
			g_iftype = IF_TYPE_MMC;
			break;	
		case CFG_START_MODE_NOR:
			g_iftype = IF_TYPE_NOR;
			break;	
		default:
			g_iftype = IF_TYPE_UNKNOWN;
			break;
	}
}

int read_boot_flashtype(void)
{
	return g_iftype;
}

