/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spi_nand.c
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <malloc.h> 
#include <errno.h>
#include <asm/io.h> 
#include <linux/mtd/mtd.h>
#include <asm-generic/ioctl.h>
#include <config.h>
#include <common.h>
#include <command.h>
#include <asm/arch/nand.h> 
#include <linux/mtd/nand.h>
#include <asm/arch/lsp_crpm.h>
#include <drvs_gpio.h>
#include "spi_nand.h"
#include <boot_mode.h>

int flash_dmabuf_disable_flag = 0; 

extern struct nand_flash_device_para nand_flash_para[];
extern struct mtd_info nand_info[];
extern struct nand_chip nand_chip[];
extern struct nand_flash_device_para *g_nand_dev_info;
static int spi_nand_read_oob(struct mtd_info *mtd, struct nand_chip *chip,
			   int page, int sndcmd);

#define mtd_to_spi_nand(m) 		(struct spi_nand_info *)(((struct nand_chip *)(m->priv))->priv)

#define __ECC_CHECK_SUPPORT__

#ifdef __ECC_CHECK_SUPPORT__
static void spi_nand_enable_ecc(struct mtd_info *mtd, int enable)
{
    int ret = 0;
    uint8_t feature = 0x0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;	

	ret = ctrl->get_feature(REG_FEATURE, &feature);
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_get_feature]\n");
	}

	if(enable)
		feature |= ECC_EN;
	else
		feature &= ~ECC_EN;		
	ret = ctrl->set_feature(REG_FEATURE, &feature);
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_set_feature]\n");
	}
}
#else
static void spi_nand_enable_ecc(struct mtd_info *mtd, int enable){}
#endif


/*******************************************************************************
 * Function:    spi_nand_read_byte
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint8_t spi_nand_read_byte(struct mtd_info *mtd)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	uint8_t result = 0xff;

	if (spi_nand->buf.head < spi_nand->buf.tail)
		result = spi_nand->buf.buf[spi_nand->buf.head++];

	return result;
}

/*******************************************************************************
 * Function:    reset_buf
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void reset_buf(struct spi_nand_info *spi_nand)
{
	spi_nand->buf.head = spi_nand->buf.tail = 0;
}


/*******************************************************************************
 * Function:    write_byte_to_buf
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void write_byte_to_buf(struct spi_nand_info *spi_nand, uint8_t byte)
{
	BUG_ON(spi_nand->buf.tail >= SPI_NAND_BUF_SIZE/*sizeof(spi_nand->buf.buf)*/);
	spi_nand->buf.buf[spi_nand->buf.tail++] = byte;
}


/*******************************************************************************
 * Function:    read_status
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void read_status(struct spi_nand_info *spi_nand)
{
	uint32_t status; 
    status = 0X80;
    //spi_nand_debug("[SPI-NAND][read_status]\n");
	write_byte_to_buf(spi_nand, status);
}

/*******************************************************************************
 * Function:    spi_nand_read_word
 * Description: nand_block_badУȡoobϢ(nand_chip->oob_poi)ǰ2ֽ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint16_t spi_nand_read_word(struct mtd_info *mtd)
{
    struct nand_chip *chip = mtd->priv;
	uint16_t result = 0x0;

    result = (uint16_t)(*(chip->oob_poi));
    result = result << 8;
    result |= (uint16_t)(*(chip->oob_poi + 1));
    
	return result;
}


/*******************************************************************************
 * Function:    spi_nand_select_chip
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_select_chip(struct mtd_info *mtd, int chip)
{
}


/*******************************************************************************
 * Function:    spi_nand_waitfunc
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_waitfunc(struct mtd_info *mtd, struct nand_chip *chip)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
    
	int status = spi_nand->status;
	spi_nand->status = 0;
    
	return status;
}

/*******************************************************************************
 * Function:    spi_nand_get_real_page
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_get_real_page(struct mtd_info *mtd, int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int die;

	if(spi_nand->para->die_num == 1)
		return page;

	die = page/spi_nand->pages_per_die;
	if(ctrl->switch_die(die))
		return -1;

	return (page-die*spi_nand->pages_per_die);
}

/*******************************************************************************
 * Function:    spi_nand_erase
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_erase(struct mtd_info *mtd, int page)
{   
    int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int real_page = spi_nand_get_real_page(mtd, page);
    
    //spi_nand_debug("\n[SPI-NAND][spi_nand_erase][page] = 0x%0x\n", page);

    ret = ctrl->write_enable();
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_write_enable][ERROR]\n");
    }  

    ret = ctrl->erase(real_page);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_erase][ERROR]\n");
    }

    if( ret != 0 )
    {
        spi_nand->status = NAND_STATUS_FAIL;
        printf("[SPI-NAND][spi_nand_erase][NAND_STATUS_FAIL][ret] = %d\n", ret);
    }
    else
    {
        spi_nand->status = 0;
        //spi_nand_debug("[SPI-NAND][spi_nand_erase][PASS]\n");
    }
    
    ret = ctrl->write_disable();
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_write_disable][ERROR]\n");
    }

}


/*******************************************************************************
 * Function:    spi_nand_cmdfunc
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_cmdfunc(struct mtd_info *mtd, unsigned int cmd, int col,
			   int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
    
	switch (cmd) {
    	case NAND_CMD_PAGEPROG:
    		break;
    	case NAND_CMD_STATUS:
            reset_buf(spi_nand);
    		read_status(spi_nand);
    		break;
    	case NAND_CMD_READID:
    	case NAND_CMD_PARAM:
    		reset_buf(spi_nand);
            
            write_byte_to_buf(spi_nand, spi_nand->para->manuf_id);
            write_byte_to_buf(spi_nand, spi_nand->para->device_id);
                       
    		break;
    	case NAND_CMD_READ0:
    	case NAND_CMD_SEQIN:
    		spi_nand->page = page;
    		break;
    	case NAND_CMD_RESET:
            ctrl->reset();
    		break;
    	case NAND_CMD_READOOB:
            reset_buf(spi_nand);      //zhouqi
            spi_nand_read_oob(mtd, mtd->priv, page, 0);
    		/* TODO: Read OOB data */
    		break;
    	default:
    		debug(": unsupported command"
    				" received 0x%x\n", cmd);
    		break;
	}
}

/*******************************************************************************
 * Function:    spi_nand_ecc_calculate
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_ecc_calculate(struct mtd_info *mtd, const uint8_t *data,
				uint8_t *ecc_code)
{
	debug("spi_nand_ecc_calculate called unexpectedly\n");
	return -1;
}


/*******************************************************************************
 * Function:    spi_nand_ecc_correct
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_ecc_correct(struct mtd_info *mtd, uint8_t *data,
				uint8_t *read_ecc, uint8_t *calc_ecc)
{
	debug("spi_nand_ecc_correct called unexpectedly\n");
	return -1;
}


/*******************************************************************************
 * Function:    spi_nand_ecc_hwctl
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_ecc_hwctl(struct mtd_info *mtd, int mode)
{
	debug("spi_nand_ecc_hwctl called unexpectedly\n");
}


/*******************************************************************************
 * Function:    spi_nand_check_ecc
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_check_ecc(struct spi_nand_info *spi_nand, uint32_t *ecc)
{
    int ret = 0;
    uint8_t feature = 0x0;
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;	

    ret = ctrl->get_feature(REG_STATUS, &feature);
    
    //spi_nand_debug("[SPI-NAND][check_ecc][feature] = 0x%0x\n", feature);
    
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature]\n");
    }
    
    if( (feature>>ECC_ERR_BIT & 0x3) == 2 )
    {
        printf("[SPI-NAND][REG_STATUS][ECC-ERROR]\n");
        *ecc = 1;
    }
    else
        *ecc = 0;
    
    return ret;
}

static int spi_nand_write(struct mtd_info *mtd, int raw, 
							const unsigned char *buf, unsigned char *oob_buf) 
{
	int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int page = spi_nand_get_real_page(mtd, spi_nand->page);
	uint32_t column_offset = 0;
	
	ret = ctrl->write_enable();
	if ( ret != 0 )
	{
		printf("[SPI-NAND][spi_fc_write_enable][ERROR]\n");
	}

	if(buf)
    	memcpy((void*)spi_nand->buf.buf, buf, mtd->writesize);				
	else /* write oob */
		memset((uint8_t *)spi_nand->buf.buf, 0xFF, mtd->writesize);

	memcpy((void*)(spi_nand->buf.buf + mtd->writesize), oob_buf, mtd->oobsize);

	if((spi_nand->para->planes == 2) && (((page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
	
	ret = ctrl->page_load(column_offset, (uint8_t *)spi_nand->buf.dma_buf, mtd->writesize, oob_buf, mtd->oobsize);	
	
	if ( ret != 0 )
	{
		printf("[SPI-NAND][spifc_page_load][ERROR]\n");
	}

	ret = ctrl->program_exec(page);
	if ( ret != 0 )
	{
		spi_nand->status = NAND_STATUS_FAIL;
		printf("[SPI-NAND][spi_fc_program_exec][NAND_STATUS_FAIL][ret] = %d\n", ret);
	}
	else
	{
		spi_nand->status = 0;
	}

	ret = ctrl->write_disable();
	if ( ret != 0 )
	{
		printf("[SPI-NAND][spi_fc_write_disable][ERROR]\n");
	}
	
	return ret;
}

/*******************************************************************************
 * Function:    spi_nand_write_page
 * Description: 
 *                  
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_write_page(struct mtd_info *mtd, struct nand_chip *chip,
				const uint8_t *buf, struct mtd_oob_ops *ops)
{
	spi_nand_write(mtd, 0, buf, chip->oob_poi);
}

/*******************************************************************************
 * Function:    spi_nand_write_page_raw
 * Description: MTD Interface ʹ ECC, д MAIN + OOB
 *                  
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_write_page_raw(struct mtd_info *mtd, struct nand_chip *chip,
					const uint8_t *buf)
{
	spi_nand_enable_ecc(mtd, 0);
	spi_nand_write(mtd, 1, buf, chip->oob_poi);
	spi_nand_enable_ecc(mtd, 1);		
}


/*******************************************************************************
 * Function:    spi_nand_write_oob
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_write_oob(struct mtd_info *mtd, struct nand_chip *chip,
			    int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);

    spi_nand->page=page;
    
	return spi_nand_write(mtd, 0, NULL, chip->oob_poi);
}

/*******************************************************************************
 * Function:    spi_nand_read_oob
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_oob(struct mtd_info *mtd, struct nand_chip *chip,
			   int page, int sndcmd)
{   
    int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int real_page = spi_nand_get_real_page(mtd, page);
	uint32_t column_offset = mtd->writesize;
	
    ret = ctrl->read_page_to_cache(real_page);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
    }

	if((spi_nand->para->planes == 2) && (((real_page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
		
    ret = ctrl->read_from_cache(column_offset, mtd->oobsize, (uint8_t *)spi_nand->buf.dma_buf);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
    }

    memcpy(chip->oob_poi, (void*)(spi_nand->buf.dma_buf), mtd->oobsize);
   
	return 0; 
}


/*******************************************************************************
 * Function:    spi_nand_read_page
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_page(struct mtd_info *mtd, struct nand_chip *chip,
			    uint8_t *buf, int page, struct mtd_oob_ops *ops)
{
    int ret = 0;
    uint32_t ecc = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int real_page; 
	uint32_t column_offset = 0;
	 
    if (page != spi_nand->page) 
    {
		debug("IN %s: page %d is not"
				" equal to denali->page %d, investigate!!",
				__func__, page, spi_nand->page);
	}

	real_page = spi_nand_get_real_page(mtd, page);

    ret = ctrl->read_page_to_cache(real_page);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
    }
    
    ret = spi_nand_check_ecc(spi_nand, &ecc);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_nand_check_ecc]\n");
    }
    if( ecc != 0 )
    {
        printf("[SPI-NAND][ECC-spifc_read_page_raw][ECC-ERROR][%x]\n",real_page*mtd->writesize);
		mtd->ecc_stats.failed++;		
    }

	if((spi_nand->para->planes == 2) && (((real_page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
	
	if(flash_dmabuf_disable_flag== 0)
	{
	    ret = ctrl->read_from_cache(column_offset, (mtd->writesize+mtd->oobsize), (uint8_t *)spi_nand->buf.dma_buf);
	    if( ret != 0 )
	    {
	        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
	    }	
		memcpy(buf, (void*)spi_nand->buf.dma_buf, mtd->writesize);
		memcpy(chip->oob_poi, (void*)(spi_nand->buf.dma_buf + mtd->writesize), mtd->oobsize);		
	}
	else
	{
	    ret = ctrl->read_from_cache(column_offset, (mtd->writesize), (uint8_t *)buf);
	    if( ret != 0 )
	    {
	        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
	    }
	}

    return 0;
}


/*******************************************************************************
 * Function:    spi_nand_read_page_raw
 * Description: ʹECCȡ MAIN + OOB
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_page_raw(struct mtd_info *mtd, struct nand_chip *chip,
				uint8_t *buf, int page)
{
    int ret = 0;
    uint32_t ecc = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;
	int real_page; 
	uint32_t column_offset = 0;
	
    if (page != spi_nand->page) 
    {
		debug("IN %s: page %d is not"
				" equal to denali->page %d, investigate!!",
				__func__, page, spi_nand->page);
	}

	spi_nand_enable_ecc(mtd, 0); 
	
	real_page = spi_nand_get_real_page(mtd, page);
	
    ret = ctrl->read_page_to_cache(real_page);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
    }

	if((spi_nand->para->planes == 2) && (((real_page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}

    ret = ctrl->read_from_cache(column_offset, (mtd->writesize+mtd->oobsize), (uint8_t *)spi_nand->buf.dma_buf);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_read_page_to_cache]\n");
    }

    memcpy(buf, (void*)spi_nand->buf.dma_buf, mtd->writesize);
	memcpy(chip->oob_poi, (void*)(spi_nand->buf.dma_buf + mtd->writesize), mtd->oobsize);
   
	spi_nand_enable_ecc(mtd, 1); 
	
    return 0;
}


#define ECC_4BITS	32
static uint8_t bbt_pattern[] = {'B', 'b', 't', '0' };
static uint8_t mirror_pattern[] = {'1', 't', 'b', 'B' };

static struct nand_bbt_descr bbt_main_descr = {
	.options = NAND_BBT_LASTBLOCK | NAND_BBT_CREATE | NAND_BBT_WRITE
		| NAND_BBT_2BIT | NAND_BBT_VERSION | NAND_BBT_PERCHIP,
	.offs =	4,
	.len = 4,
	.veroffs = 20,
	.maxblocks = 16,
	.pattern = bbt_pattern,
};


static struct nand_bbt_descr bbt_mirror_descr = {
	.options = NAND_BBT_LASTBLOCK | NAND_BBT_CREATE | NAND_BBT_WRITE
		| NAND_BBT_2BIT | NAND_BBT_VERSION | NAND_BBT_PERCHIP,
	.offs =	4,
	.len = 4,
	.veroffs = 20,
	.maxblocks = 16,
	.pattern = mirror_pattern,
};

//static 
int spi_nand_common_init(struct spi_nand_info *spi_nand)
{   
    int ret = SUCCESS;
    uchar feature = 0x0;
	struct spi_nand_ctrl_info *ctrl = spi_nand->ctrl;	

    feature = 0x0;
    ret = ctrl->set_feature(REG_PROTECTION, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_feature]\n");
    }

	ctrl->get_feature(REG_PROTECTION, &feature);
    
    printf("[SPI-NAND][A0] = 0x%0x\n", feature);

    /*
    * enable ecc nand Quad mode
    */

	feature= 0;
    feature = (ECC_EN|QE);
	/*micron 4G flash*/
	if((spi_nand->para->manuf_id == NAND_MFR_MICRON) && (spi_nand->para->device_id == 0x35))
	{
        /*continute_readλ0*/
		feature &= ~(1<<0);
    }
    ret = ctrl->set_feature(REG_FEATURE, &feature);
    if ( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_feature]\n");
    }

	ctrl->get_feature(REG_FEATURE, &feature);
    
    printf("[SPI-NAND][B0] = 0x%0x\n", feature);

	return ret;
}
int spi_nand_register(struct spi_nand_info *spi_nand, struct spi_nand_ctrl_info *ctrl)
{
	int ret = -1; 
	struct mtd_info *	mtd;
	struct nand_chip *	chip;

	mtd  = spi_nand->mtd;
	chip = spi_nand->nand;

	chip->priv = spi_nand;
	spi_nand->ctrl = ctrl;

	/* register the driver with the NAND core subsystem */
	chip->select_chip	= spi_nand_select_chip;
	chip->cmdfunc		= spi_nand_cmdfunc;
	chip->read_byte 	= spi_nand_read_byte;
	chip->read_word 	= spi_nand_read_word;
	chip->waitfunc		= spi_nand_waitfunc;

	/* scan for NAND devices attached to the controller
	 * this is the first stage in a two step process to register
	 * with the nand subsystem */
	if (nand_scan_ident(mtd, spi_nand->total_used_banks, NULL)) 
    {
       	debug("nand ident: cant ident this nand device");
		return -1;
	}

	/* MTD supported page sizes vary by kernel. We validate our
	 * kernel supports the device here.
	 */
	if (mtd->writesize > NAND_MAX_PAGESIZE) 
    {
		ret = -1;
		debug("Spectra: device size not supported by this "
			"version of MTD.");
		return ret;
	}

	/* support for multi nand
	 * MTD known nothing about multi nand,
	 * so we should tell it the real pagesize
	 * and anything necessery
	 */
	spi_nand->devnum = 1;
    chip->pagemask = (chip->chipsize >> chip->page_shift) - 1;
    spi_nand->bbtskipbytes = 0x2;

	/* second stage of the NAND scan
	 * this stage requires information regarding ECC and
	 * bad block management. */

	/* Bad block management */
	chip->bbt_td = &bbt_main_descr;
	chip->bbt_md = &bbt_mirror_descr;

	/* skip the scan for now until we have OOB read and write support */
	chip->options |= NAND_USE_FLASH_BBT;//NAND_SKIP_BBTSCAN
	chip->ecc.mode = NAND_ECC_HW_SYNDROME;

	/* Denali Controller only support 15bit and 8bit ECC in MRST,
	 * so just let controller do 15bit ECC for MLC and 8bit ECC for
	 * SLC if possible.
	 * */
	chip->ecc.bytes = ECC_4BITS;

	/* These functions are required by the NAND core framework, otherwise,
	 * the NAND core will assert. However, we don't need them, so we'll stub
	 * them out. */
	chip->ecc.size = 512;
	chip->ecc.calculate = spi_nand_ecc_calculate;
	chip->ecc.correct = spi_nand_ecc_correct;
	chip->ecc.hwctl = spi_nand_ecc_hwctl;
	chip->ecc.read_page = spi_nand_read_page;
	chip->ecc.read_page_raw = spi_nand_read_page_raw;
	chip->ecc.write_page = spi_nand_write_page;
	chip->ecc.write_page_raw = spi_nand_write_page_raw;
	chip->ecc.read_oob = spi_nand_read_oob;
	chip->ecc.write_oob = spi_nand_write_oob;
	chip->erase_cmd = spi_nand_erase;

    /*
    * remove spi nand chip write protection
    */
	spi_nand_common_init(spi_nand);
	spi_nand_special_init(spi_nand);

	if (nand_scan_tail(mtd)) 
    {
		ret = -1;
	}
      
	return 0;
}

