/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spi_nand_debug.c
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <malloc.h> 
#include <errno.h>
#include <asm/io.h> 
#include <linux/mtd/mtd.h>
#include <asm-generic/ioctl.h>
#include <config.h>
#include <common.h>
#include <command.h>
#include <asm/arch/nand.h> 
#include <linux/mtd/nand.h>
#include <asm/arch/lsp_crpm.h>
#include <drvs_gpio.h>
#include "spi_nand.h"

/* DEBUG */
struct spi_debug_reg
{
    //0x00  VER_REG
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t rev:             16;    
            uint32_t min:             8;    
            uint32_t main:            8;                    
        }BIT;            
    }VER_REG;

    //0x04  SFC_START
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t busy_start:       1; 
            uint32_t rev:             31;    
        }BIT;            
    }SFC_START;

    //0x08  SFC_EN
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t en:              1; 
            uint32_t en_back:         1; 
            uint32_t rev:             30;                    
        }BIT;            
    }SFC_EN;

    //0x0C  SFC_CTRL0
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t wr_protect:                 1;    
            uint32_t spi_mode:                 1;  
            uint32_t rev:                   1;
            uint32_t wdog_en:                  1;
            uint32_t rx_dma_en:                     1;
            uint32_t tx_dma_en:                1;
            uint32_t rxfifo_thres:                 1;
            uint32_t rev1:          3;
            uint32_t txfifo_thres:               1;
            uint32_t rev2:          3;
            uint32_t rxfifo_clr:               1;
            uint32_t txfifo_clr:               1;
            uint32_t pause_en:               1;
            uint32_t pause_clr:               1;
            uint32_t rev3:               14;
            
        }BIT;            
    }SFC_CTRL0;

    //0x10  SFC_CTRL1
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t write_data_en:      1;    
            uint32_t read_data_en:   1;  
            uint32_t dummy_tx_en:  1;
            uint32_t rev:               1; 
            uint32_t addr_tx_en:               1;   
            uint32_t rev1:              27; 
        }BIT;            
    }SFC_CTRL1;

    //0x14  SFC_CTRL2 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t trans_mod:               1;    
            uint32_t rev:                     1;  
            uint32_t data_multi_en:           1;
            uint32_t rev1:                    1; 
            uint32_t addr_multi_en:           1;   
            uint32_t addr_byte_num:           2; 
            uint32_t rev2:                    1; 
            uint32_t dummy_bit_num:           3;
            uint32_t rev3:                    1; 
            uint32_t dummy_byte_num:          4;
            uint32_t rev4:                    16; 
        }BIT;            
    }SFC_CTRL2;
   
    //0x18  SFC_BYTE_NUM 
    union
    {
        uint32_t VALUE;        
    }SFC_BYTE_NUM;
    
    //0x1C  SFC_ADDR 
    union
    {
        uint32_t VALUE;         
    }SFC_ADDR;

    //0x20  SFC_INS 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t cmd:                    8;    
            uint32_t Reserved:               24;   
        }BIT;            
    }SFC_INS;

    //0x24  SFC_TIMING 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t cs_desle:                4; 
            uint32_t rev:                     2; 
            uint32_t cs_hold:                 3; 
            uint32_t rev1:                    2; 
            uint32_t cs_setup:                3;   
            uint32_t rev2:                    2; 
            uint32_t rd_delay:                2; 
            uint32_t rev3:                    14; 
        }BIT;            
    }SFC_TIMING;

    //0x28  SFC_INT_EN 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t int_en_cmd_end:                  1;    
            uint32_t int_en_fmt_err:                  1;  
            uint32_t int_en_wdog_over:                1;
            uint32_t rev1:                            1; 
            uint32_t int_en_rx_over:                  1;   
            uint32_t int_en_tx_underrun:               1;    
            uint32_t int_en_rx_byd_thres:              1;  
            uint32_t int_en_tx_byd_thres:             1;
            uint32_t rev2:                            24; 

        }BIT;            
    }SFC_INT_EN;

    //0x2C  SFC_INT_RAW 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t int_raw_cmd_end:                  1;    
            uint32_t int_raw_fmt_err:                  1;  
            uint32_t int_raw_wdog_over:                1;
            uint32_t rev1:                            1; 
            uint32_t int_raw_rx_over:                  1;   
            uint32_t int_raw_tx_underrun:               1;    
            uint32_t int_raw_rx_byd_thres:              1;  
            uint32_t int_raw_tx_byd_thres:             1;
            uint32_t rev2:                            24;   
        }BIT;            
    }SFC_INT_RAW;

    //0x30  SFC_INT_SW_CLR 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t int_clr_cmd_end:                  1;    
            uint32_t int_clr_fmt_err:                  1;  
            uint32_t int_clr_wdog_over:                1;
            uint32_t rev1:                            1; 
            uint32_t int_clr_rx_over:                  1;   
            uint32_t int_clr_tx_underrun:               1;    
            uint32_t int_clr_rx_byd_thres:              1;  
            uint32_t int_clr_tx_byd_thres:             1;
            uint32_t rev2:                            24;   
        }BIT;            
    }SFC_INT_SW_CLR;

    //0x34  SFC_SW 
    union
    {
        uint32_t VALUE;
        struct
        {
            uint32_t rev:                             1;    
            uint32_t fmt_err:                         1;  
            uint32_t wait_flag:                       1;
            uint32_t sck_pause_flay:                  1; 
            uint32_t rx_byd_thres:                    1;   
            uint32_t tx_byd_thres:                    1;    
            uint32_t rev2:                            2;  
            uint32_t rx_fifo_cnt:                     5;
            uint32_t rev3:                            3; 
            uint32_t tx_fifo_cnt:                     5;
            uint32_t rev4:                            11; 
        }BIT;            
    }SFC_SW;

    //0x38  SFC_DATA 
    union
    {
        uint32_t VALUE;           
    }SFC_DATA;

};

#if	SPI_NAND_DEBUG
struct spi_debug_reg *debug = NULL;
#define spifc_debug(fmt,args...)	printf (fmt ,##args)
#define spifc_debugX(level,fmt,args...) if (DEBUG>=level) printf(fmt,##args);
#else
#define spifc_debug(fmt,args...)
#define spifc_debugX(level,fmt,args...)
#endif	/* DEBUG */

#if	SPI_NAND_DEBUG

void spi_nand_read_oob( uint32_t off )
{
    struct spifc_nand_info *spifc = g_spifc;
    uint8_t buf[64] = {0};
    uint32_t i = 0;

    spifc->page = off>>11;
    
    spifc_read_oob(spifc->mtd, spifc->nand, off>>11, 0);

    memcpy(buf, spifc->nand->oob_poi, 64);  

    for( i=0; i<64; i++ )
    {   
        printf("%x ",buf[i]);
    }
    printf("\n");

					
}

void spi_nand_write_page_ops(uint32_t off)
{
    struct spifc_nand_info *spifc = g_spifc;
    uint8_t buf[2112];
    uint32_t i = 0;
    uint8_t val = 0;
    

    for( i=0; i<2112; i++ )
    {
        buf[i] = val++;
    }

    struct mtd_oob_ops *ops = NULL;

    memcpy(spifc->nand->oob_poi, buf, 64);  

    spifc->page = off>>11;
    
    spifc_write_page(spifc->mtd, spifc->nand, buf, ops);

					
}

void spi_nand_write_page(uint32_t off)
{
    struct spifc_nand_info *spifc = g_spifc;
    uint8_t buf[2112];
    uint32_t i = 0;
    uint8_t val = 0;
    
    struct mtd_oob_ops *ops = NULL;
    
    for( i=0; i<2112; i++ )
    {
        buf[i] = val++;
    }

    memset(spifc->nand->oob_poi, 0xff, 64);  

    spifc->page = off>>11;
    
    spifc_write_page(spifc->mtd, spifc->nand, buf, ops);

					
}

void spi_nand_erase(uint32_t off)
{
    struct spifc_nand_info *spifc = g_spifc;

    //printf("[SPI-NAND][spi_nand_erase][offset] = 0x%0x\n", off);

    spifc_erase(spifc->mtd, off>>11);
}


void spi_nand_write_page_raw(uint32_t off)
{
    struct spifc_nand_info *spifc = g_spifc;
    uint8_t buf[2112];
    uint32_t i = 0;
    uint8_t val = 0;
    

    for( i=0; i<2112; i++ )
    {
        buf[i] = val++;
    }

    memcpy(spifc->nand->oob_poi, buf, 64);  

    spifc->page = off>>11;
    
    spifc_write_page_raw(spifc->mtd, spifc->nand, buf);
					
}


int spi_nand_get_feture(void)
{
    int ret = 0;
    uint8_t feature = 0xff;

    ret = spi_fc_get_feature(REG_PROTECTION, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature][--ERROR--]\n");
        goto error_spi_nand1;
    }
    printf("[SPI-NAND][PROTECTION] = 0x%0x\n", feature);

    ret = spi_fc_get_feature(REG_FEATURE, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature][--ERROR--]\n");
        goto error_spi_nand1;
    }
    printf("[SPI-NAND][FEATURE] = 0x%0x\n", feature);

    ret = spi_fc_get_feature(REG_STATUS, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature][--ERROR--]\n");
        goto error_spi_nand1;
    }
    printf("[SPI-NAND][STATUS] = 0x%0x\n", feature);
    printf("\n");

    return 0;    
error_spi_nand1:
    return ret;        
}

int spi_nand_set_ecc(void)
{
    int ret = 0;
    uint8_t feature = 0xff;

    ret = spi_fc_get_feature(REG_FEATURE, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature]\n");
        goto error_spi_nand2;
    }
    feature |= ECC_EN;

    ret = spi_fc_set_feature(REG_FEATURE, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_feature]\n");
        goto error_spi_nand2;
    }

    printf("\n");

    return 0; 
    
error_spi_nand2:
    return ret;     
}

int spi_nand_clear_ecc(void)
{
    int ret = 0;
    uint8_t feature = 0xff;

    ret = spi_fc_get_feature(REG_FEATURE, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_get_feature]\n");
        goto error_spi_nand3;
    }
    feature &= (~ECC_EN);

    ret = spi_fc_set_feature(REG_FEATURE, &feature);
    if( ret != 0 )
    {
        printf("[SPI-NAND][spi_fc_set_feature]\n");
        goto error_spi_nand3;
    }

    printf("\n");

    return 0; 
    
error_spi_nand3:
    return ret;     
}

#endif

void spi_nand_debug_init(void)
{
#if SPI_NAND_DEBUG
	debug = (struct spi_debug_reg *)SYS_SPI_NAND_BASE;
#endif
}

