/*******************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ drv_usb3slave.h
* ļʶ 
* ժҪ 
* ˵ zx297520 project
* ǰ汾 1.0
* ߣ tangjian
* ڣ 
*
*
*******************************************************************************/

#ifndef __USB3_SLAVE_DRV_H
#define __USB3_SLAVE_DRV_H
  
/* *INDENT-OFF* */
#ifdef __cplusplus
extern "C" {
#endif
/* *INDENT-ON* */

/*
**==================================================================
** 	               		Include files
**==================================================================
*/
#include "usb.h"
#include "global.h"
#include "drv_usb3slave_reg.h"
#include "dwc_otg_cil.h"   //ڶص
#include <linux/types.h>
typedef void (*F_USB_CB)(WORD32 dwPara, WORD32 dwResult, WORD32 dwLen, WORD32 dwWantLen);

/* DRV */
#define SOK                         (0)         /**< ȷ */
#define ERR_FAIL                    (0x01)      /**< һ */
#define ERR_INUSE                   (0x02)      /**< Դʹ */
#define ERR_XIO                     (0x03)      /**< Դ */
#define ERR_OVFL                    (0x04)      /**< Դľ */
#define ERR_INVHANDLE               (0x05)      /**< Ч */
#define ERR_INVPARAMS               (0x06)      /**< Ч */
#define ERR_INVCMD                  (0x07)      /**< Ч */
#define ERR_NOMEM                   (0x08)      /**< ڴľ */
#define ERR_UNSUPPORTED             (0x09)      /**< Ϊ֧ */
#define ERR_INVHWVERSION            (0x10)      /**< Ӳ汾ƥ */

#define FALSE                        0
#define TRUE                         1

#define DWC3_DCFG_SPEED_MASK	(7 << 0)

#define DWC3_DCFG		0xc700
#define DWC3_DCFG_DEVADDR(addr)	((addr) << 3)
#define DWC3_DCFG_DEVADDR_MASK	DWC3_DCFG_DEVADDR(0x7f)
#define DWC3_DCTL		0xc704
#define DWC3_DCTL_CSFTRST	(1 << 30)
/*0x200-0x23c*/
#define DWC3_GUSB2PHYCFG(n)	(0xc200 + (n * 0x04))
/*0x2C0-0x2fc*/
#define DWC3_GUSB3PIPECTL(n)	(0xc2c0 + (n * 0x04))

/*0x300-0x37C*/
#define DWC3_GTXFIFOSIZ(n)	(0xc300 + (n * 0x04))

/*0x380-0x3fc*/
#define DWC3_GRXFIFOSIZ(n)	(0xc380 + (n * 0x04))

#define DWC3_GCTL		0xc110
#define DWC3_DCTL_RUN_STOP	(1 << 31)

#define DWC3_DEVTEN_USBSUSPENDEN    (1 << 6)
#define DWC3_DEVTEN_WKUPEVTEN		(1 << 4)
#define DWC3_DEVTEN_ULSTCNGEN		(1 << 3)
#define DWC3_DEVTEN_CONNECTDONEEN	(1 << 2)
#define DWC3_DEVTEN_USBRSTEN		(1 << 1)
#define DWC3_DEVTEN_DISCONNEVTEN	(1 << 0)

#define DWC3_DEVTEN		0xc708
#define DWC3_DSTS		0xc70c

#define DWC3_DALEPENA   0xc720
/**  */  
#define USB_DT_DEVICE                           0x01
#define USB_DT_CONFIG                           0x02
#define USB_DT_STRING                           0x03
#define USB_DT_INTERFACE                        0x04
#define USB_DT_ENDPOINT	                        0x05
#define USB_DT_DEVICE_QUALIFIER                 0x06
#define USB_DT_OTHER_SPEED_CONFIG               0x07
#define USB_DT_INTERFACE_POWER                  0x08
/** these are from a minor usb 2.0 revision (ECN) */   
#define USB_DT_OTG                              0x09
#define USB_DT_DEBUG                            0x0a
#define USB_DT_INTERFACE_ASSOCIATION            0x0b
/** these are from the Wireless USB spec */  
#define USB_DT_SECURITY                         0x0c
#define USB_DT_KEY                              0x0d
#define USB_DT_ENCRYPTION_TYPE                  0x0e
#define USB_DT_BOS                              0x0f
#define USB_DT_DEVICE_CAPABILITY                0x10
#define USB_DT_WIRELESS_ENDPOINT_COMP           0x11
#define USB_DT_WIRE_ADAPTER                     0x21
#define USB_DT_RPIPE                            0x22
#define USB_DT_CS_RADIO_CONTROL                 0x23
/** From the T10 UAS specification */   
#define USB_DT_PIPE_USAGE                       0x24
/** From the USB 3.0 spec */   
#define	USB_DT_SS_ENDPOINT_COMP                 0x30
/** USB directions */
#define USB_DIR_OUT                             0       /* to device */
#define USB_DIR_IN                              0x80    /* to host */
/** USB types, the second of three bmRequestType fields, Э9.3.1 */
#define USB_TYPE_MASK                           (0x03 << 5)
#define USB_TYPE_STANDARD                       (0x00 << 5)
#define USB_TYPE_CLASS                          (0x01 << 5)
#define USB_TYPE_VENDOR                         (0x02 << 5)
#define USB_TYPE_RESERVED                       (0x03 << 5)
/** USB recipients, the third of three bmRequestType fields */
#define USB_RECIP_MASK                          0x1f
#define USB_RECIP_DEVICE                        0x00
#define USB_RECIP_INTERFACE                     0x01
#define USB_RECIP_ENDPOINT                      0x02
#define USB_RECIP_OTHER                         0x03
/** From Wireless USB 1.0 */ 
#define USB_RECIP_PORT                          0x04
#define USB_RECIP_RPIPE                         0x05
/*
* Standard requests, for the bRequest field of a SETUP packet.
*
* These are qualified by the bmRequestType field, so that for example
* TYPE_CLASS or TYPE_VENDOR specific feature flags could be retrieved
* by a GET_STATUS request.
*/
#define USB_REQ_GET_STATUS                      0x00
#define USB_REQ_CLEAR_FEATURE                   0x01
#define USB_REQ_SET_FEATURE                     0x03
#define USB_REQ_SET_ADDRESS                     0x05
#define USB_REQ_GET_DESCRIPTOR                  0x06
#define USB_REQ_SET_DESCRIPTOR                  0x07
#define USB_REQ_GET_CONFIGURATION               0x08
#define USB_REQ_SET_CONFIGURATION               0x09
#define USB_REQ_GET_INTERFACE                   0x0A
#define USB_REQ_SET_INTERFACE                   0x0B
#define USB_REQ_SYNCH_FRAME                     0x0C
#define USB_REQ_GET_MAX_LUN                     0xFE
/*
* USB feature flags are written using USB_REQ_{CLEAR,SET}_FEATURE, and
* are read as a bit array returned by USB_REQ_GET_STATUS.  (So there
* are at most sixteen features of each type.)  Hubs may also support a
* new USB_REQ_TEST_AND_SET_FEATURE to put ports into L1 suspend.
*/
#define USB_DEVICE_SELF_POWERED                 0	/**< (read only) */
#define USB_DEVICE_REMOTE_WAKEUP                1	/**< dev may initiate wakeup */
#define USB_DEVICE_TEST_MODE                    2	/**< (wired high speed only) */
#define USB_DEVICE_BATTERY                      2	/**< (wireless) */
#define USB_DEVICE_B_HNP_ENABLE                 3	/**< (otg) dev may initiate HNP */
#define USB_DEVICE_WUSB_DEVICE                  3	/**< (wireless)*/
#define USB_DEVICE_A_HNP_SUPPORT                4	/**< (otg) RH port supports HNP */
#define USB_DEVICE_A_ALT_HNP_SUPPORT            5	/**< (otg) other RH port does */
#define USB_DEVICE_DEBUG_MODE                   6	/**< (special devices only) */
/*
* New Feature Selectors as added by USB 3.0
* See USB 3.0 spec Table 9-7
* Suspend Options, Table 9-7 USB 3.0 spec
*/
#define USB_DEVICE_U1_ENABLE                    48	/**< dev may initiate U1 transition */
#define USB_DEVICE_U2_ENABLE                    49	/**< dev may initiate U2 transition */
#define USB_DEVICE_LTM_ENABLE                   50	/**< dev may send LTM */

#define USB_INTRF_FUNC_SUSPEND                  0	/**< function suspend */
#define USB_INTR_FUNC_SUSPEND_OPT_MASK          0xFF00
#define USB_INTRF_FUNC_SUSPEND_LP               (1 << (8 + 0))
#define USB_INTRF_FUNC_SUSPEND_RW               (1 << (8 + 1))

#define USB_ENDPOINT_HALT                       0	/**< IN/OUT will STALL */

/** Bit array elements as returned by the USB_REQ_GET_STATUS request */
#define USB_DEV_STAT_U1_ENABLED                 2	/**< transition into U1 state */
#define USB_DEV_STAT_U2_ENABLED                 3	/**< transition into U2 state */
#define USB_DEV_STAT_LTM_ENABLED                4	/**< Latency tolerance messages */
/**
* USB function drivers should return USB_GADGET_DELAYED_STATUS if they
* wish to delay the data/status stages of the control transfer till they
* are ready. The control transfer will then be kept from completing till
* all the function drivers that requested for USB_GADGET_DELAYED_STAUS
* invoke usb_composite_setup_continue().
*/
#define USB_GADGET_DELAYED_STATUS               0x7fff	/**< Impossibly large value */
//#define EP0_PACKET_SIZE                         64 
//#define	MAX_EPS				(0x8)

/**
* struct usb_ctrlrequest - SETUP data for a USB device control request
* Note that the driver for any interface can issue control requests.
* For most devices, interfaces don't coordinate with each other, so
* such requests may be made at any time.
*/

 typedef struct T_USB3Slave_CtrlReq
{
    u8 bmRequestType;                         /**< ƥsetupbmRequestType */
    u8 bRequest;                              /**< ƥsetupbRequest  */
    u16 wValue;                              /**< ƥsetupwValue */
    u16 wIndex;                              /**< ƥsetupwIndex */
    u16 wLength;                             /**< ƥsetupwLength */
}__attribute__ ((__packed__)) T_USB3Slave_CtrlReq;

/** ˵㴫͵Ⱥ궨 */
#define USB_ENDPOINT_NUMBER_MASK                0x0f	/* in bEndpointAddress */
#define USB_ENDPOINT_DIR_MASK                   0x80

#define USB_ENDPOINT_XFERTYPE_MASK              0x03	/* in bmAttributes */
#define USB_ENDPOINT_XFER_CONTROL               0
#define USB_ENDPOINT_XFER_ISOC                  1
#define USB_ENDPOINT_XFER_BULK                  2
#define USB_ENDPOINT_XFER_INT                   3
#define USB_ENDPOINT_MAX_ADJUSTABLE             0x80

/** СЭ飬Ϊ1024 */
#define HS_MAX_PACKET_SIZE                         512  
#define FS_MAX_PACKET_SIZE                         64
/** ƴС */
/** ˵Ŀ */
#define ENDPOINTS_NUM                      6   
/** Э˵ */

/** TRBиλεĺ궨*/
#define TRBCTL_NORMAL                           1
#define TRBCTL_CONTROL_SETUP                    2
#define TRBCTL_CONTROL_STATUS2                  3
#define TRBCTL_CONTROL_STATUS3                  4
#define TRBCTL_CONTROL_DATA                     5
#define TRBCTL_ISOCHRONOUS_FIRST                6
#define TRBCTL_ISOCHRONOUS                      7
#define TRBCTL_LINK_TRB                         8
/** struct T_USB3Slave_TRBToHW - transfer request block (hw format) */
typedef struct T_USB3Slave_TRBToHW
{
    u32  udBpl;                              /**< ָbufferĵ32λַ */
    u32  udBph;                              /**< ָbufferĸ32λַ  */
    u32  udSize;                             /**< ݴĳ */
    u32  udCtrl;                             /**< TRB */
}__attribute__ ((__packed__)) T_USB3Slave_TRBToHW;

/** struct T_USB3Slave_TRB - transfer request block */ 
 typedef struct T_USB3Slave_TRB
{
    u64    bplh;                              /**< ָbufferַ */

     union
    {
         struct
        {
             u32    BUFSIZ:24;                /**< ݴĳ */
             u32    PCM1:2;                   /**< Packet Count M1 */
             u32    Reserved27_26:2;
             u32    TRBSTS:4;                 /**< TRB״̬ */
        }bit;
        u32 udVal;
    }len_pcm;

     union
    {
         struct
        {
             u32    HWO:1;                    /**< ָʾӲӵеTRB */
             u32    LST:1;                    /**< һTRB */
             u32    CHN:1;                    /**< TRBһTRB */
             u32    CSP:1;                    /**< յһ̰coreһBuffer Descriptor */
             u32    TRBCTL:6;                 /**< TRB  */
             u32    ISP_IMI:1;                /**< Interrupt on Short Packet/Interrupt on Missed ISOC */
             u32    IOC:1;                    /**< ãʾɺж */
             u32    Reserved13_12:2;
             u32    StreamID_SOFNum:16;       /**< Stream ID/SOF Number */
             u32    Reserved31_30:2;
        }bit;
        u32 udVal;
    }control;
}__attribute__ ((__packed__)) T_USB3Slave_TRB;

/** EVENT bufferС */
#define EVENT_BUFFERS_SIZE                 256//256  

/**
* struct T_USB3Slave_EventBuf - Software event buffer representation
*/

typedef struct
{
    u32  EvtBuf[EVENT_BUFFERS_SIZE];         /**< EVENT Buffer */
    u32  udLength;                           /**< EVENT Buffer С */
    u32  udLpos;                             /**< ָʾǰEVENTʼλ */
}T_USB3Slave_EventBuf;


/** EVENT  */
#define EVENT_TYPE_MASK                         0xfe
#define EVENT_TYPE_DEV	                        0
#define EVENT_TYPE_CARKIT	                    3
#define EVENT_TYPE_I2C	                        4
typedef struct T_USB3Slave_EventType
{
    u32	udIs_devspec:1;                     /**< жǶ˵EVENT豸EVENT */
    u32	udType:6;                           /**< EVENT  */
    u32	udReserved8_31:25;
}__attribute__ ((__packed__)) T_USB3Slave_EventType;

/** ˵EVENT */
#define DEPEVT_XFERCOMPLETE                     0x01
#define DEPEVT_XFERINPROGRESS                   0x02
#define DEPEVT_XFERNOTREADY                     0x03
#define DEPEVT_RXTXFIFOEVT                      0x04
#define DEPEVT_STREAMEVT                        0x06
#define DEPEVT_EPCMDCMPLT                       0x07

#define DEPEVT_STATUS_BUSERR                    (1 << 0)
#define DEPEVT_STATUS_SHORT                     (1 << 1)
#define DEPEVT_STATUS_IOC                       (1 << 2)
#define DEPEVT_STATUS_LST                       (1 << 3)
/** Stream event only */
#define DEPEVT_STREAMEVT_FOUND                  1
#define DEPEVT_STREAMEVT_NOTFOUND               2
/** Control-only Status */
#define DEPEVT_STATUS_CONTROL_SETUP	            0
#define DEPEVT_STATUS_CONTROL_DATA	            1
#define DEPEVT_STATUS_CONTROL_STATUS            2
#define DEPEVT_STATUS_STATUS_SETUP              10
/**
* struct dwc3_event_depvt - Device Endpoint Events
* @udOne_bit: indicates this is an endpoint event (not used)
* @udEndpoint_number: number of the endpoint
* @udEndpoint_event: The event we have:
*	0x00	- Reserved
*	0x01	- XferComplete
*	0x02	- XferInProgress
*	0x03	- XferNotReady
*	0x04	- RxTxFifoEvt (IN->Underrun, OUT->Overrun)
*	0x05	- Reserved
*	0x06	- StreamEvt
*	0x07	- EPCmdCmplt
* @udReserved11_10: Reserved, don't use.
* @EventStatus: Indicates the status of the event. Refer to databook for more information.
* @EventParam: Parameters of the current event. Refer to databook for more information.
*/
/** μֲ7.2.8.1˵EVENT */
 typedef struct T_USB3Slave_EpEvt
{
    u32	udOne_bit:1;                        /**< 1bitжǶ˵event豸event */
    u32	udEndpoint_number:5;                /**< ָʾ˵ */
    u32	udEndpoint_event:4;                 /**< ָʾ˵event */
    u32	udReserved11_10:2;
    u32	EventStatus:4;                      /**< ָʾevent״̬Refer to databook for more information*/
    u32	EventParam:16;                      /**< ǰevent. Refer to databook for more information */
}__attribute__ ((__packed__)) T_USB3Slave_EpEvt;

/**
* struct T_USB3Slave_DevEvt - Device Events
* @udOne_bit: indicates this is a non-endpoint event (not used)
* @udDevice_event: indicates it's a device event. Should read as 0x00
* @udType: indicates the type of device event.
*	0	- DisconnEvt
*	1	- USBRst
*	2	- ConnectDone
*	3	- ULStChng
*	4	- WkUpEvt
*	5	- Reserved
*	6	- EOPF
*	7	- SOF
*	8	- Reserved
*	9	- ErrticErr
*	10	- CmdCmplt
*	11	- EvntOverflow
*	12	- VndrDevTstRcved
* @udReserved15_12: Reserved, not used
* @udEvtInfo: Information about this event
* @udReserved31_24: Reserved, not used
*/
/** DEVICE EVENT  */
#define DEVICE_EVENT_DISCONNECT                 0
#define DEVICE_EVENT_RESET	                    1
#define DEVICE_EVENT_CONNECT_DONE               2
#define DEVICE_EVENT_LINK_STATUS_CHANGE         3
#define DEVICE_EVENT_WAKEUP                     4
#define DEVICE_EVENT_EOPF                       6
#define DEVICE_EVENT_SOF                        7
#define DEVICE_EVENT_ERRATIC_ERROR              9
#define DEVICE_EVENT_CMD_CMPL                   10
#define DEVICE_EVENT_OVERFLOW                   11

typedef struct T_USB3Slave_DevEvt
{
    u32	udOne_bit:1;                        /**< 1bitжǶ˵event豸event */
    u32	udDevice_event:7;                   /**< 豸event */
    u32	udType:4;                           /**< ָʾĸevent */
    u32	udReserved15_12:4;
    u32	udEvtInfo:8;                        /**< event ϢءָʾǷSSlink state */
    u32	udReserved31_24:8;
}__attribute__ ((__packed__)) T_USB3Slave_DevEvt;

/**
* struct T_USB3Slave_Event_GEvt - Other Core Events
* @udOne_bit: indicates this is a non-endpoint event (not used)
* @udDevice_event: indicates it's (0x03) Carkit or (0x04) I2C event.
* @udPhy_port_number: self-explanatory
* @udReserved31_12: Reserved, not used.
*/

 typedef struct T_USB3Slave_Event_GEvt
{
    u32	udOne_bit:1;
    u32	udDevice_event:7;
    u32	udPhy_port_number:4;
    u32	udReserved31_12:20;
}__attribute__ ((__packed__)) T_USB3Slave_Event_GEvt;

/** union T_USB3Slave_Event - representation of Event Buffer contents */

typedef union
{
    u32                  udRaw;              /**< ָʾǰeventֵ */
    T_USB3Slave_EventType   tType;              /**< ָʾevent (00hʾdevice specific event) */
    T_USB3Slave_EpEvt       tEpEvt;             /**< ˵event */
    T_USB3Slave_DevEvt      tDevEvt;            /**< 豸event */
    T_USB3Slave_Event_GEvt  tGetEvt;            /**< Other Core Events */
}T_USB3Slave_Event;

/** EPıǺ */
#define EP_ENABLED                              (1 << 0)
#define EP_STALL                                (1 << 1)
#define EP_WEDGE                                (1 << 2)
#define EP_BUSY                                 (1 << 4)
#define EP_PENDING_REQUEST                      (1 << 5)
/** This last one is specific to EP0 */
#define EP0_DIR_IN                             ((u32)1 << 31)
/** EP */
#define EP_FLAG_STALLED                         (1 << 0)
#define EP_FLAG_WEDGED                          (1 << 1)
/** EP */
#define EP_DIRECTION_TX                         true
#define EP_DIRECTION_RX                         false

/** ˵״̬仯*/
typedef enum
{
    EP_IDLE = 0,                            /**< EP */
    EP_HALTED,                              /**< EP halt */
    EP0_CTRLIN_SETUP,                       /**< EP0ƽIN׶ */
    EP0_CTRLOUT_SETUP,                      /**< EP0ƽOUT׶ */
    EP0_CTRLNULL_SETUP,                     /**< EP0ƽΪ */
    EP0_CTRL_INDATA,                        /**< EP0INݽ׶ */
    EP0_CTRL_OUTDATA,                       /**< EP0OUTݽ׶ */
    EP0_CTRL_INSTATUS,                      /**< EP0IN״̬׶ */
    EP0_CTRL_OUTSTATUS,                     /**< EP0OUT״̬׶ */
    EP_RX,                                  /**< EP״ָ̬ʾ */
    EP_TX                                   /**< EP״ָ̬ʾ */
}E_USB3Slave_EpState;

/** ָʾEp0һEVENT */
typedef enum
{
    EP0_UNKNOWN = 0,
    EP0_COMPLETE,                               /**< EP0״ָ̬ʾΪ*/
    EP0_NRDY_SETUP,                             /**< EP0״̬NRDYָʾΪ׶*/
    EP0_NRDY_DATA,                              /**< EP0״̬NRDYָʾΪݽ׶*/
    EP0_NRDY_STATUS,                            /**< EP0״̬NRDYָʾΪ״̬׶*/
} E_USB3Slave_Ep0Next;
/** ָʾEP0ƴ׶ */
typedef enum
{
    EP0_UNCONNECTED	= 0,
    EP0_SETUP_PHASE,                            /**< EP0ƴĽ׶ */
    EP0_DATA_PHASE,                             /**< EP0ƴݽ׶ */
    EP0_STATUS_PHASE,                           /**< EP0ƴ״̬׶ */
}E_USB3Slave_Ep0State;
/** ģʽµ״̬ */


/** ƴö״̬׶ */
typedef enum
{
    DEFAULT_STATE = 0,                          /**< ȱʡ״̬ */
    ADDRESS_STATE,                              /**< ַ״̬ */
    CONFIGURED_STATE,                           /**< ״̬ */
    SETINTERFACE_STATE,                         /**< ýӿ״̬*/
    GETMAXLUN_STATE,                            /**<GET MAX lUN*/
    BULKIN_CMPL,                                /**< BULK IN״̬ */
    BULKOUT_CMPL,                               /**< BULK OUT״̬ */
    IntrIN_CMPL,                                /**< Interrupt IN״̬ */
    IntrOUT_CMPL,                               /**< Interrupt OUT״̬ */
}E_USB3Slave_ReqState;

/** USB3.0ٶͣտֲP513, DCFGĴ0:2 */
typedef enum
{
    USB3_HIGHSPEED  = 0,                        /**< 3'b000 USB2.0 PHY clock is 30 MHz or 60 MHz */ 
    USB3_FULLSPEED  = 1,                        /**< 3'b001 USB2.0 PHY clock is 30 MHz or 60 MHz */
    USB3_SUPERSPEED = 4,                        /**< 3'b100 USB3.0 PHY clock is 30 MHz or 60 MH */
}E_USB3Slave_SpeedMode;
/** ָʾӵ豸ٶ */
typedef enum
{
    USB30_SPEED_UNKNOWN = 0,                      /**< enumerating */
    USB30_SPEED_LOW, USB30_SPEED_FULL,              /**< usb 1.1 */
    USB30_SPEED_HIGH,                             /**< usb 2.0 */
    USB30_SPEED_WIRELESS,                         /**< wireless (usb 2.5) */
    USB30_SPEED_SUPER,                            /**< usb 3.0 */
}E_USB3Slave_Speed;

/** T_USB3Slave_HWPARAMS - copy of HWPARAMS registers */

typedef struct
{
    u32	udHwparams0;                        /**< ӦGHWPARAMS0Ĵȡֵ */
    u32	udHwparams1;                        /**< ӦGHWPARAMS1Ĵȡֵ */
    u32	udHwparams2;                        /**< ӦGHWPARAMS2Ĵȡֵ */
    u32	udHwparams3;                        /**< ӦGHWPARAMS3Ĵȡֵ */
    u32	udHwparams4;                        /**< ӦGHWPARAMS4Ĵȡֵ */
    u32	udHwparams5;                        /**< ӦGHWPARAMS5Ĵȡֵ */
    u32	udHwparams6;                        /**< ӦGHWPARAMS6Ĵȡֵ */
    u32	udHwparams7;                        /**< ӦGHWPARAMS7Ĵȡֵ */
    u32	udHwparams8;                        /**< ӦGHWPARAMS8Ĵȡֵ */
}T_USB3Slave_HWPARAMS;


/** ڶ˵ */
 typedef struct T_USB3Slave_EpCmdPara
{
    u32	Parameter2;                         /**< ָʾ豸˵2 */
    u32	Parameter1;                         /**< ָʾ豸˵1 */
    u32	Parameter0;                         /**< ָʾ豸˵0 */
}__attribute__ ((__packed__)) T_USB3Slave_EpCmdPara;

/** DEPCFG parameter 1 */ 
#define DEPCFG_INT_NUM(n)                       ((n) << 0)
#define DEPCFG_XFER_COMPLETE_EN                 (1   << 8)
#define DEPCFG_XFER_IN_PROGRESS_EN              (1   << 9)
#define DEPCFG_XFER_NOT_READY_EN                (1   << 10)
#define DEPCFG_FIFO_ERROR_EN                    (1   << 11)
#define DEPCFG_STREAM_EVENT_EN                  (1   << 13)
#define DEPCFG_BINTERVAL_M1(n)                  ((n) << 16)
#define DEPCFG_STREAM_CAPABLE                   (1   << 24)
#define DEPCFG_EP_NUMBER(n)                     ((n) << 25)
#define DEPCFG_BULK_BASED                       (1   << 30)
#define DEPCFG_FIFO_BASED                       (1   << 31)

/** DEPCFG parameter 0 */
#define DEPCFG_EP_TYPE(n)                       ((n) << 1)
#define DEPCFG_MAX_PACKET_SIZE(n)               ((n) << 3)
#define DEPCFG_FIFO_NUMBER(n)                   ((n) << 17)
#define DEPCFG_BURST_SIZE(n)                    ((n) << 22)
#define DEPCFG_DATA_SEQ_NUM(n)                  ((n) << 26)
#define DEPCFG_IGN_SEQ_NUM                      (1   << 31)

/** DEPXFERCFG parameter 0 */
#define DEPXFERCFG_NUM_XFER_RES(n)              ((n) & 0xffff)

/** ˵Ϣṹ */
#pragma pack (4) /*ָ4ֽڶ*/
typedef struct
{

    u32                  udEpNum;            /**< ǰep  */
    u8                   *pucBuf;            /**< ָ */
    u32                  udPos;              /**< дָ */
    u32                  udLen;              /**< ܳ */
    u32                  udMaxPacket;        /**< ĴС */
    u32                  udMaxStream;        /**< ֵ֧ */
    u32                  udMaxBurst;         /**< ö˵ֵ֧burst */
    T_USB3Slave_TRBToHW     *ptTRB;           /**< ׼trbĻ */
    u32                  udDMAChannel;       /**< ˵ʹõdmaͨ, 16Ϊģʽ16Ϊͨ */
    u8                   ucType;             /**< ֵ֧Ĵ */
    void                    *pPara;             /**< صĲ */
    E_USB3Slave_EpState     eEpState;           /**< ˵״̬ */
    u32                  udDirection;        /**< ˵㴫䷽ * @direction: true for TX, false for RX */
    void                    *DriverData;        /**< ڴ,Կܻõ*/
    u32                  udInterval;         /**< ˵Interval */
    u32                  udBusySlot;         /**< æ״̬TRB */
    u32                  udFreeSlot;         /**< ڿ״̬TRB */
    u32                  *pudAddrData;       /**< ĿǰҪBULKڽպͷݵĵַ */    
    u8                   ucAddress;          /**< ַ */
    u32                  udFlags;            /**< ˵ */
    u32                  udCurrentTrb;       /**< ǰTRB */
    u8                   ucResTransIdx;      /**< Դ */
    u32                  udStreamCapable;    /**< Ƿ */
    F_USB_CB	         fnUsbCb;	    //˵ɺĻص
}T_USB3Slave_Ep;
#pragma pack () /*ȡ*/
/** struct dwc3 - representation of our controller */
/** ȫdeviceϢṹ壬 */
#pragma pack (4) /*ָ4ֽڶ*/
typedef struct
{

    u32                   udRegs_base;                  /**< ¼Ĵַ */
    E_USB3Slave_SpeedMode    eSpeedMode;                   /**< ǰ豸ٶ */
    E_USB3Slave_Speed        eDeviceSpeedType;             /**< ٶͣlinuxʹô */
    T_USB3Slave_HWPARAMS     tHwParams;                    /**< Ӳ */
    u32                   udMode;                       /**< ǰģʽ */
    T_USB3Slave_EventBuf     *ptEvtBuffs;                /**< event */ 
    u32                   udNumEvtBufs;          /**< ¼evnetӲл*/
    T_USB3Slave_Ep           tEps[ENDPOINTS_NUM];          /**< ˵Ϣ */
    u32                   udIsSelfPowered;             /**< Թture*/
    u32                   udThreeStageSetup;          /**< ׶*/
    u32                   udEp0Bounced;                /**< bounce buffer for ep0 */
    u32                   udEp0ExpectIn;              /**< true when we expect a DATA IN transfer */
    u32                   udSetupPacketPending;       /**< true when there's a Setup Packet in FIFO. Workaround */
    u32                   udDelayedStatus;             /**< ӳ״̬*/
    u32                   udEventsequence;              /**< event */
    E_USB3Slave_Ep0Next	     eEp0NextEvent;                /**< ָʾ˵һEVENT */
    E_USB3Slave_Ep0State     eEp0State;                    /**< ep0״̬*/
    E_USB3Slave_ReqState     eDevState;                    /**< 豸״̬ */
    u32                   udUSBSate;                    /**< ö״̬ */
/*ݳԱòlinux 3.3.6жusb3ĳʼ*/
    T_USB3Slave_CtrlReq	     *tCtrlReq;                     /**<  */
    T_USB3Slave_TRBToHW	     *ptEp0TRB;                    /**< ep0 TRB*/
    u8                    aucSetupBuf[2];              /**< buffer  δĿǰ */
    u8                    ucSpeed;                      /**< ٶ */
    u32                   *pudTxData;                   /**< ָ͵ݴС */
}T_USB3Slave_SlaveObj;
#pragma pack () /*ȡ*/

/** SlaveObj ȫֱ*/

/** DWC3 Features to be used as Driver Data Ŀǰûõʱ*/
/*#define HAS_PERIPHERAL		   BIT(0)
#define HAS_XHCI			       BIT(1)
#define HAS_OTG			           BIT(3)*/
#define DATA_32BIT_MASK            0xFFFFFFFF
#define ADDRESS_MAX                127

/* *INDENT-OFF* */
#ifdef __cplusplus
}
#endif
/* *INDENT-ON* */
  
#endif  /* __USB3_SLAVE_DRV_H */


/** @} */
