#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include <common.h>
#include <asm/arch/hardware.h>
#include <asm/arch/uart.h>
#include <asm/arch/cpu.h>
#include <asm/arch/lsp_crpm.h>
#include "errno.h"
#include <drvs_gpio.h>


#if CONFIG_HARDWARE_TEST

/* ================================================================================
 *  do_test_nand  :  
 *                  ɹ: GPIO17 GPIO16 
 *                  ʧ: GPIO17          
 */
int do_test_nand(void) 
{
	uint32_t is_ok = 0;
	static uint32_t nand_led_state = 0;
	static uint32_t test_cnt=0;

	test_cnt++;
	
    memcpy((uint8_t *)0x21000000, (uint8_t *)0x82000000, 0x4000);   //SYS_IRAM2_BASE

    run_command("nand erase 0x300000 0x20000", 0);
    run_command("nand write 0x21000000 0x300000 0x4000", 0);
    run_command("nand read 0x22000000 0x300000 0x4000", 0);
    is_ok = memcmp((uint8_t *)0x21000000, (uint8_t *)0x22000000, 0x4000);
    if( is_ok != 0 )
        goto error;
    printf("test round:%d\n",test_cnt);

    run_command("nand erase 0x500000 0x20000", 0);
    run_command("nand write 0x21000000 0x500000 0x4000", 0);
    run_command("nand read 0x23000000 0x500000 0x4000", 0);
    is_ok = memcmp((uint8_t *)0x21000000, (uint8_t *)0x23000000, 0x4000);
    if( is_ok != 0 )
        goto error;
	printf("test round:%d\n",test_cnt);

    run_command("nand erase 0x5000000 0x20000", 0);
    run_command("nand write 0x21000000 0x5000000 0x4000", 0);
    run_command("nand read 0x24000000 0x5000000 0x4000", 0);
    is_ok = memcmp((uint8_t *)0x21000000, (uint8_t *)0x24000000, 0x4000);
    if( is_ok != 0 )
        goto error;
    printf("test round:%d\n",test_cnt);

    run_command("nand erase 0xf000000 0x20000", 0);
    run_command("nand write 0x21000000 0xf000000 0x4000", 0);
    run_command("nand read 0x25000000 0xf000000 0x4000", 0);
    is_ok = memcmp((uint8_t *)0x21000000, (uint8_t *)0x25000000, 0x4000);
   if( is_ok != 0 )
        goto error;
     printf("test round:%d\n",test_cnt);

    if( nand_led_state ==0 )
    {
		zDrvGpio_SetOutputValue(GPIO33,GPIO_HIGH);
        nand_led_state = 1;
    }
    else
    {
		zDrvGpio_SetOutputValue(GPIO33,GPIO_LOW);
        nand_led_state = 0;
    }

    udelay(500000);
    
    return 0;

    error:
		zDrvGpio_SetOutputValue(GPIO75,GPIO_HIGH);
		while(1);
     printf("nand test failed !");
        run_command("nand erase 0x300000 0x20000", 0);
        run_command("nand erase 0x500000 0x20000", 0);
        run_command("nand erase 0x5000000 0x20000", 0);
        run_command("nand erase 0xf000000 0x20000", 0);
        return -1;
    
}

U_BOOT_CMD(
	test_nand, CONFIG_SYS_MAXARGS, 0, do_test_nand,
	"test_nand: test_nand ",
	""
);

#endif
