/*******************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ drv_usb3slave.c
* ļʶ 
* ժҪ 
* ˵ zx297520 project
* ǰ汾 1.0
* ߣ tangjian
* ڣ 
*
*
*******************************************************************************/
   

/*
**==================================================================
** 	               		Include files
**==================================================================
*/
#include <commond.h>
#include "drv_usb3slave.h"
#include "config.h"
#include <asm/string.h>

/*zloaderѡΪnostdlib,εͷļ*/
//#include <stdlib.h>
//#include <string.h>

/*
**==================================================================
** 	          	  		Global Variables
**==================================================================
*/
/* ¼deviceصϢȫֽṹ*/

extern __align(4) dwc_device_descriptor_t  Para_Section device_desc ;
extern __align(4) dwc_config_all_t  Para_Section desc ;
extern __align(4) dwc_string_descriptor_t Para_Section * pStrDescIdx[] ;
extern __align(4) dwc_dev_qual_descriptor_t Para_Section dev_qual_desc ;
__align(EVENT_BUFFERS_SIZE*4) T_USB3Slave_EventBuf Para_Section *gp_USB3Slave_EventBuf;   //EventBufEVENT_BUFFERS_SIZE*4ֽڶ
__align(16) T_USB3Slave_TRBToHW  Para_Section USB3Slave_TRB ;  //TRB16ֽڶ
__align(16) T_USB3Slave_TRBToHW  Para_Section USB3Slave_TRB_EP[4] ;  //TRB16ֽڶ
__align(16) T_USB3Slave_CtrlReq Para_Section pCtrlReq ;   /**<  */
T_USB3Slave_SlaveObj Para_Section g_USB3Slave={0};
u8 g_needSetStall = 0;
u32 g_debugFaultVal = 0;

__align(EVENT_BUFFERS_SIZE*4) T_USB3Slave_EventBuf Para_Section USB3Slave_EventBuf;   //EventBufEVENT_BUFFERS_SIZE*4ֽڶ

extern void usb_timeout_usdelay(u32 us);
#if 0
static inline void delay(unsigned long loops)
{
    /*
	__asm__ volatile ("1:\n" "subs %0, %1, #1\n"
			  "bne 1b":"=r" (loops):"0"(loops));
	*/
}

static inline void udelay(unsigned long us)
{
	delay(us * 200); /* approximate */
}

void usdelay(unsigned us)
{
	udelay(us);
}
#endif

static T_USB3Slave_Ep *USB3Slave_GetEpObj(T_USB3Slave_SlaveObj *ptUsb3Slave, u16 uwIndex_le)
{
    T_USB3Slave_Ep		*ptDep;
    u32        udEpnum;

    udEpnum = (uwIndex_le & USB_ENDPOINT_NUMBER_MASK) << 1;
    
    if ( USB_DIR_IN == (uwIndex_le & USB_ENDPOINT_DIR_MASK))
        udEpnum |= 1;

    ptDep = &(ptUsb3Slave->tEps[udEpnum]);
    
    /*if (ptDep->udFlags & EP_ENABLED)*/
        return (T_USB3Slave_Ep*)ptDep;

    //return (T_USB3Slave_Ep*)NULL;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ˵дͨú
 *
 * :
 *     - USB3Slave_SendDevEpCmd ڲ, 书:
 *     - ˵дͨú
 *
 * :
 *     - ptUsb3Slave: usb3 豸ṹ
 *     - udEp: ˵
 *     - udCmd: ,DEPCMDĴCmdTypġ
 *        -00h: Reserved
 *        -01h: Set Endpoint Configuration
 *        -02h: Set Endpoint Resource Configuration
 *        -03h: Get Endpoint State
 *        -04h: Set Stall
 *        -05h: Clear Stall
 *        -06h: Start Transfer
 *        -07h: Update Transfer
 *        -08h: End Transfer
 *        -09h: Start New Configuration
 *     - ptParams: 
 *
 *   ֵ: :u32
 *     - 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/

static u32 USB3Slave_SendDevEpCmd(T_USB3Slave_SlaveObj *ptUsb3Slave, u32 udEp,
                               u32 udCmd, T_USB3Slave_EpCmdPara *ptParams)
{
    volatile u32			udTimeout = 500;
    u32			udRegValue;


    REG32(ptUsb3Slave->udRegs_base + DEPCMDPAR0(udEp)) = ptParams->Parameter0;
    REG32(ptUsb3Slave->udRegs_base + DEPCMDPAR1(udEp)) = ptParams->Parameter1;
    REG32(ptUsb3Slave->udRegs_base + DEPCMDPAR2(udEp)) = ptParams->Parameter2;

    REG32(ptUsb3Slave->udRegs_base +  DEPCMD(udEp)) = udCmd | USB3Slave_DEPCMD_CMDACT_1;
    // cmdĴ10λд1(command active)ԶѸλ0

    do
    {
        udRegValue = REG32(ptUsb3Slave->udRegs_base + DEPCMD(udEp));

        if(!(udRegValue & USB3Slave_DEPCMD_CMDACT_1)) break;

        udTimeout--;

        if(!udTimeout)
        {
            return ERR_FAIL;
        }
    } while(1);

    return SOK;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief TRBṹλʽתTRBṹʽڶTRB
 * 
 * :
 *     - USB3Slave_TrbToHWڲ, 书:
 *      - TRBṹλʽתTRBṹʽڶTRB
 *     
 * :
 *     - ptTrbBit: TRBλʽṹ
 *     - ptTrbRaw: TRB ṹʽ
 * 
 *   ֵ:  
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_TrbToHW(T_USB3Slave_TRB *ptTrbBit, T_USB3Slave_TRBToHW *ptTrbRaw)
{
        ptTrbRaw->udBpl = ptTrbBit->bplh & DATA_32BIT_MASK;
        ptTrbRaw->udBph = 0;
        ptTrbRaw->udSize = ptTrbBit->len_pcm.udVal;
        /* HWO is written last */
        ptTrbRaw->udCtrl = ptTrbBit->control.udVal;
}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ڿʼ֮ǰҪȸep0д9:ʼµstart new configuration
 *
 * :
 *     - USB3Slave_StartCfg ڲ, 书:
 *      - ڿʼ֮ǰҪȸep0д9Ϊ0
 *
 * :
 *     - ptUsb3Slave: usb 3.0豸ṹ
 *     - ptDep: ˵Ϣṹ
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_StartCfg(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_Ep *ptDep)
{
    T_USB3Slave_EpCmdPara tParams = {0};
    u32		  udCmd;

    /* DEPCMD д9 */  /*ִCMD9ڶ˵02һֻڶ˵0˵2ео*/
    if (0 == ptDep->udEpNum)
    {
        udCmd = USB3Slave_DEPCMD_DEPSTARTCFG;        
        return USB3Slave_SendDevEpCmd(ptUsb3Slave, ptDep->udEpNum, udCmd, &tParams);
    }
    return SOK;
}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief Զ˵
 *
 * :
 *     - USB3Slave_SetEpCfgCmdڲ, 书:
 *     - Զ˵
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptDep: ˵Ϣṹ
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_SetEpCfgCmd(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_Ep *ptDep)
{
    T_USB3Slave_EpCmdPara tParams = {0};
  
    if((0 == ptDep->udEpNum)||(1 == ptDep->udEpNum))
		ptDep->ucType = USB_ENDPOINT_XFER_CONTROL;    //¼˵Ĵ
    else
        ptDep->ucType = USB_ENDPOINT_XFER_BULK;
    

    tParams.Parameter0 = DEPCFG_EP_TYPE(ptDep->ucType & USB_ENDPOINT_XFERTYPE_MASK) \
                    | DEPCFG_MAX_PACKET_SIZE(ptDep->udMaxPacket & 0xffff)
                    | DEPCFG_BURST_SIZE(ptDep->udMaxBurst);
    /*
     * We must use the lower 16 TX FIFOs even though
     * HW might have more
     */
    if (ptDep->udDirection)
        tParams.Parameter0 |= DEPCFG_FIFO_NUMBER(ptDep->udEpNum >> 1);

    if((0 == ptDep->udEpNum)||(1 == ptDep->udEpNum))
		tParams.Parameter1 = DEPCFG_XFER_COMPLETE_EN | DEPCFG_XFER_NOT_READY_EN;                     
    else
        tParams.Parameter1 = DEPCFG_XFER_COMPLETE_EN;
                      
    /*
     * We are doing 1:1 mapping for endpoints, meaning
     * Physical Endpoints 2 maps to Logical Endpoint 2 and
     * so on. We consider the direction bit as part of the physical
     * endpoint number. So USB endpoint 0x81 is 0x03.
     */
    tParams.Parameter1 |= DEPCFG_EP_NUMBER(ptDep->udEpNum);

    return USB3Slave_SendDevEpCmd(ptUsb3Slave, ptDep->udEpNum,
                                   USB3Slave_DEPCMD_SETEPCONFIG, &tParams);
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief Ϊÿ˵ôԴ
 *
 * :
 *     - USB3Slave_SetXferResourceڲ, 书:
 *     - Ϊÿ˵ôԴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptDep: ˵Ϣṹ
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_SetXferResource(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_Ep *ptDep)
{
    T_USB3Slave_EpCmdPara tParams;

    memset(&tParams, 0x00, sizeof(tParams));

    tParams.Parameter0 = DEPXFERCFG_NUM_XFER_RES(1);
   /* ôԴ*/
    return USB3Slave_SendDevEpCmd(ptUsb3Slave, ptDep->udEpNum,
                                   USB3Slave_DEPCMD_SETTRANSFRESOURCE, &tParams);
}


/**
 * __dwc3_gadget_ep_enable - Initializes a HW endpoint
 * @ptDep: endpoint to be initialized
 * @ptDesc: USB Endpoint Descriptor
 *
 * Caller should take care of locking
 */
/**-------------------------------------------------------------------------------------------------------------------@n
* @brief ʼһӲ˵㣬ʼááԴãtrbøֵӲ豸trb
*
* :
*     - USB3Slave_CfgEpڲ, 书:
*     - ʹһӲ˵㣬ʼááԴãtrbøֵӲ豸trb
*
* :
*     - ptDep: ʼ˵㣬˵Ϣṹ
*     - ptDesc: USB ˵
*     - ptComp_desc: ˵companion 
*
*   ֵ: :u32
*     - 
*
*--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_CfgEp(T_USB3Slave_Ep *ptDep)
{
    T_USB3Slave_SlaveObj *pUSB3Slv = &g_USB3Slave;
    
    if (!(ptDep->udFlags & EP_ENABLED))
    {
//step0:ep0˵ÿʼִcmd=9start new conguration
        USB3Slave_StartCfg(pUSB3Slv, ptDep);
    }

//step1:ִcmd1SET EP CONFIG
    USB3Slave_SetEpCfgCmd(pUSB3Slv, ptDep);

//step2:ִcmd2Set Endpoint Transfer Resource Configuration param0 = 1

    if (!(ptDep->udFlags & EP_ENABLED))
    {        
        USB3Slave_SetXferResource(pUSB3Slv, ptDep);

        ptDep->udFlags |= EP_ENABLED;
	if(global.need_enum ==1)
	{

//step3:active ep ,0xc720 һ˵һbit   
        REG32(pUSB3Slv->udRegs_base + DWC3_DALEPENA)|= (1u<<ptDep->udEpNum);
	}
 
    }

    return SOK;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0
 *
 * :
 *     - USB3Slave_Ep0StartXferڲ, 书:
 *     - ep0
 *
 * :
 *     - ptUsb3Slave: 豸ϢĽṹ
 *     - ucEpnum: ˵
 *     - udBufAddr: ַ
 *     - udLen: 
 *     - udType: TRB
 *
 *   ֵ: :u32
 *     - 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0StartXfer(T_USB3Slave_SlaveObj *ptUsb3Slave, u8 ucEpnum, u32 udBufAddr,
                            u32 udLen, u32 udType)
{
    T_USB3Slave_EpCmdPara        tParams;
    T_USB3Slave_TRBToHW          *ptTrbRaw;
    T_USB3Slave_TRB              tTrbBit;
    T_USB3Slave_Ep               *ptDep;

    ptDep = &(ptUsb3Slave->tEps[ucEpnum]);

    ptUsb3Slave->ptEp0TRB = ptDep->ptTRB;
    ptTrbRaw = ptUsb3Slave->ptEp0TRB;

    memset(&tTrbBit, 0, sizeof(tTrbBit));

    tTrbBit.control.bit.TRBCTL = udType;
    tTrbBit.bplh =udBufAddr ;
    tTrbBit.len_pcm.bit.BUFSIZ = udLen;

    tTrbBit.control.bit.HWO	= 1;
    tTrbBit.control.bit.LST	= 1;
    /*tTrbBit.control.bit.IOC	= 1;
      tTrbBit.control.bit.ISP_IMI = 1;*/
   
    USB3Slave_TrbToHW(&tTrbBit, ptTrbRaw);

    memset(&tParams, 0, sizeof(tParams));
    tParams.Parameter0 = 0;   /*tTrbBit32λַĬΪ0*/
    tParams.Parameter1 = (u32)((u32)(ptUsb3Slave->ptEp0TRB)& (u32)0xFFFFFFFF);/* ys */

    USB3Slave_SendDevEpCmd(ptUsb3Slave, ptDep->udEpNum,
                                       USB3Slave_DEPCMD_STARTTRANSFER, &tParams);
    ptDep->udFlags |= EP_BUSY;

//ôԴ
    ptDep->ucResTransIdx = (REG32(ptUsb3Slave->udRegs_base + ((u32)DEPCMD(ptDep->udEpNum)>>16)));

    ptUsb3Slave->eEp0NextEvent = EP0_COMPLETE;

    return SOK;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ch 9.4.5,״̬׶ηص
 *
 * :
 *     - USB3Slave_Ep0HandleStatusڲ, 书:
 *     - ch 9.4.5,״̬׶ηص
 *
 * :
 *     - ptUsb3Slave: 豸ϢĽṹ
 *     - ptCtrlReq: ׼
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0HandleStatus(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq)
{
    T_USB3Slave_Ep                            *ptDep;
    u32                                    udRetVal,udRecip;
    u16                                    uwUsb_status = 0;
    u16                                    *puwResponse_pkt;
    u32                                    udDirection;

    udRecip = ptCtrlReq->bmRequestType & USB_RECIP_MASK;
    switch (udRecip)
    {
        case USB_RECIP_DEVICE:
        {
            /*
            * We are self-powered. U1/U2/LTM will be set later
            * once we handle this states. RemoteWakeup is 0 on SS
            */
            uwUsb_status |= ptUsb3Slave->udIsSelfPowered << USB_DEVICE_SELF_POWERED;
            break;
        }
        case USB_RECIP_INTERFACE:
        {
            /*
            * Function Remote Wake Capable	D0
            * Function Remote Wakeup	D1
            */
            break;
        }
        case USB_RECIP_ENDPOINT:
        {
            ptDep = USB3Slave_GetEpObj(ptUsb3Slave, ptCtrlReq->wIndex);
            if (!ptDep)
            return ERR_INVPARAMS;
            if (ptDep->udFlags & EP_STALL)
                uwUsb_status = 1 << USB_ENDPOINT_HALT;
            break;
        }
        default:
        {
            return ERR_INVPARAMS;
        }
    };

    puwResponse_pkt = (u16 *) ptUsb3Slave->aucSetupBuf;
    *puwResponse_pkt = uwUsb_status;

    ptDep = &(ptUsb3Slave->tEps[0]);

    udDirection = ptDep->udFlags & EP0_DIR_IN;

    if (ptUsb3Slave->eEp0State != EP0_DATA_PHASE) //ȴ״̬⣬доpxp
    {
        return 0;
    }

    udRetVal = USB3Slave_Ep0StartXfer(ptUsb3Slave, udDirection,
                                    (u32)ptUsb3Slave->aucSetupBuf, sizeof(*puwResponse_pkt),
                                    TRBCTL_CONTROL_DATA);
    ptDep->udFlags &= ~(EP_PENDING_REQUEST | EP0_DIR_IN);
    return udRetVal;
}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief halt
 *
 * :
 *     - USB3Slave_EpSetHaltڲ, 书:
 *     - halt
 *
 * :
 *     - ptDep: ˵Ϣṹ
 *     - udValue: 0ʱstallԣ1ʱstall
 *
 *   ֵ: :u32
 *     - 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_EpSetHalt(T_USB3Slave_Ep *ptDep, u32 udValue)
{
    T_USB3Slave_EpCmdPara	tParams;
    T_USB3Slave_SlaveObj *pUSB3Slv = &g_USB3Slave;
    u32        udRetVal;

    memset(&tParams, 0x00, sizeof(tParams));

    if (udValue)
    {
        if (0 == ptDep->udEpNum || 1 == ptDep->udEpNum)
        {
            /*
             * Whenever EP0 is stalled, we will restart
             * the state machine, thus moving back to
             * Setup Phase
             */
            pUSB3Slv->eEp0State = EP0_SETUP_PHASE;
        }
         printf("USB3Slave_EpSetHalt");
//		 udRetVal = USB3Slave_SendDevEpCmd(pUSB3Slv, ptDep->udEpNum,
 //                                          USB3Slave_DEPCMD_CLEARSTALL, &tParams);
        if(((global.need_enum ==0) || (1 == g_USB3Slave.udUSBSate))&&g_needSetStall!=1)
        {
            udRetVal = USB3Slave_SendDevEpCmd(pUSB3Slv, ptDep->udEpNum,
            							  USB3Slave_DEPCMD_CLEARSTALL, &tParams);
        }
        else
        {
            g_needSetStall = 0;
            pUSB3Slv->eEp0NextEvent = EP0_COMPLETE;
            udRetVal = USB3Slave_SendDevEpCmd(pUSB3Slv, ptDep->udEpNum,
                                               USB3Slave_DEPCMD_SETSTALL, &tParams);
            
            USB3Slave_Ep0StartXfer(pUSB3Slv, 0, (u32)(pUSB3Slv->tCtrlReq), 8,
                             TRBCTL_CONTROL_SETUP);
        }

    }

    return udRetVal;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0
 *
 * :
 *     - USB3Slave_Ep0HandleFeatureڲ, 书:
 *     - ep0
 *
 * :
 *     - ptUsb3Slave: 豸ϢĽṹ
 *     - ptCtrlReq: ׼
 *     - udSet: 1ʱԣ0ʱ
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0HandleFeature(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq, u32 udSet)
{
    T_USB3Slave_Ep		*ptDep;
    u32			udRecip;
    u32			udIndex;
    u32			udRet;

    udIndex = ptCtrlReq->wIndex;
    udRecip = ptCtrlReq->bmRequestType & USB_RECIP_MASK;
    switch (udRecip)
    {
        case USB_RECIP_ENDPOINT:
        {    
           
            ptDep =  USB3Slave_GetEpObj(ptUsb3Slave, udIndex);
            if (!ptDep)
                return ERR_INVPARAMS;
           udRet = USB3Slave_EpSetHalt(ptDep, udSet);
            if (udRet)
            return ERR_INVPARAMS;
            break;                      
        }
        default:
            return ERR_INVPARAMS;
    };

    return SOK;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0ַ
 *
 * :
 *     - USB3Slave_Ep0SetAddrڲ, 书:
 *     - ep0ַ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptCtrlReq: ׼
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0SetAddr(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq)
{
    u32 udAddr;
    u32 udRegVal;

    udAddr = ptCtrlReq->wValue;
   
    udRegVal = REG32(ptUsb3Slave->udRegs_base + DWC3_DCFG);
    udRegVal &= ~(DWC3_DCFG_DEVADDR_MASK);
    udRegVal |= DWC3_DCFG_DEVADDR(udAddr);
    REG32(ptUsb3Slave->udRegs_base + DWC3_DCFG) = udRegVal;

    if (udAddr)
        ptUsb3Slave->eDevState = ADDRESS_STATE;
    else
        ptUsb3Slave->eDevState = DEFAULT_STATE;

    return SOK;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ȡ豸нӿڣݲʵ
 *
 * :
 *     - USB3Slave_Ep0HandleDescڲ, 书:
 *     - ȡ豸нӿڣݲʵ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptCtrlReq:  ׼
 *     - udIsSet:
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0HandleDesc(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq, u32 udIsSet)
{
    
    u32 udLen = 0;
    u32 udDirection = 0;
    u16 uwValue = ptCtrlReq->wValue;
    u8  ucIdx =(u8)(ptCtrlReq->wValue &0xff);
    u32 udRetVal = 0;
    T_USB3Slave_Ep * ptDep = &ptUsb3Slave->tEps[1];
    u16 temp = uwValue >> 8;

        if( USB_DT_DEVICE == temp )
        {
            udDirection = 1;
            udLen    = MIN(sizeof(dwc_device_descriptor_t), ptCtrlReq->wLength);
            udRetVal = USB3Slave_Ep0StartXfer(ptUsb3Slave, udDirection,
                                        (u32)&device_desc, udLen,
                                        TRBCTL_CONTROL_DATA);
            ptUsb3Slave->eEp0State = EP0_DATA_PHASE;

        }
        else if( USB_DT_CONFIG == temp)
        {
            udDirection = 1;
            udLen = MIN(sizeof(dwc_config_all_t), ptCtrlReq->wLength);
            udRetVal = USB3Slave_Ep0StartXfer(ptUsb3Slave, udDirection,
                                        (u32)&desc, udLen,
                                        TRBCTL_CONTROL_DATA);
            ptUsb3Slave->eEp0State=EP0_DATA_PHASE;
          
        }
        else if( USB_DT_STRING == temp)
        {   
            udDirection = 1;
            if(ucIdx > 5)
            {
                USB3Slave_EpSetHalt(ptDep,1);
            }
            else
            {
                udLen = MIN(((dwc_string_descriptor_t*)(pStrDescIdx[ucIdx]))->bLength, ptCtrlReq->wLength);
                udRetVal = USB3Slave_Ep0StartXfer(ptUsb3Slave, udDirection,
                                        (u32)pStrDescIdx[ucIdx], udLen, 
                                        TRBCTL_CONTROL_DATA);
                ptUsb3Slave->eEp0State=EP0_DATA_PHASE;
            }
         
        }  
        
        else if( USB_DT_DEVICE_QUALIFIER == temp)
        {
            udDirection = 1;
            udLen    =MIN(sizeof(dwc_dev_qual_descriptor_t), ptCtrlReq->wLength);
            udRetVal = USB3Slave_Ep0StartXfer(ptUsb3Slave, udDirection,
                                        (u32)&dev_qual_desc, udLen,
                                        TRBCTL_CONTROL_DATA);
            ptUsb3Slave->eEp0State = EP0_DATA_PHASE;
        
        }
        else
			
        {
            USB3Slave_EpSetHalt(ptDep,1);
            
        }
    
    return udRetVal;

}

/*úʵдۣpxp */
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0
 *
 * :
 *     - USB3Slave_Ep0HandleCfgڲ, 书:
 *     - ep0
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptCtrlReq: ׼
 *     - udIsSet:
 *
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0HandleCfg(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq, u32 udIsSet)
{
    u32 udCfg;
    udCfg = ptCtrlReq->wValue;

    if (udIsSet && udCfg)
    {
        ptUsb3Slave->eDevState = CONFIGURED_STATE;
		REG32(ptUsb3Slave->udRegs_base + DWC3_DALEPENA) = 0x3f;

#if SIM_EN == EMULATION
    REG32(ARM_PORTA)=0x30;
#endif

        return SOK;
    }
    return SOK;
}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0׼
 *
 * :
 *     - USB3Slave_Ep0Requestڲ, 书:
 *     - ep0׼
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptCtrlReq: ׼
 *        -bmRequestType: ݴ䷽ͽ͡
 *        -bRequest     : ͡
 *        -wValue       : ֳ,ݲͬı
 *        -wIndex       : ֳ,ݲͬı.ڴƫ.
 *        -wLength      : ݴͽ׶,Ϊֽ.
 *   ֵ: :u32
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static u32 USB3Slave_Ep0Request(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_CtrlReq *ptCtrlReq)
{
    u32 udRet 				= 0;
    T_USB3Slave_Ep *ptDep0	= 0;
    u8 temp = 0;
   //tj жbmRequestTypeǷΪ׼ǣֱӻstall
    if(UT_GET_TYPE(ptCtrlReq->bmRequestType)!=UT_STANDARD)
	{
        ptDep0 = USB3Slave_GetEpObj(ptUsb3Slave,ptCtrlReq->wIndex);
        USB3Slave_EpSetHalt(ptDep0, 1);
        printf"command err.\n");
        return 1;
	}
    temp = ptCtrlReq->bRequest;
        if( USB_REQ_GET_STATUS == temp)
			
        {
            printf("USB_REQ_GET_STATUS\n");
            udRet = USB3Slave_Ep0HandleStatus(ptUsb3Slave, ptCtrlReq);
           
        }
		else if(USB_REQ_CLEAR_FEATURE == temp)
        {
            printf("USB_REQ_CLEAR_FEATURE\n");
//            udRet = USB3Slave_Ep0HandleFeature(ptUsb3Slave, ptCtrlReq, 0);		  
         udRet = USB3Slave_Ep0HandleFeature(ptUsb3Slave, ptCtrlReq, 1);
           
        }
        else if( USB_REQ_SET_ADDRESS == temp)
        {
        
		printf("USB_REQ_SET_ADDRESS\n");
            udRet = USB3Slave_Ep0SetAddr(ptUsb3Slave, ptCtrlReq);
            
        }
        else if( USB_REQ_GET_DESCRIPTOR == temp)
        {
            printf("USB_REQ_GET_DESCRIPTOR\n");
            udRet = USB3Slave_Ep0HandleDesc(ptUsb3Slave, ptCtrlReq,0);
            
        }
        else if( USB_REQ_SET_CONFIGURATION == temp)
        {
        
		printf("USB_REQ_SET_CONFIGURATION\n");
            udRet = USB3Slave_Ep0HandleCfg(ptUsb3Slave, ptCtrlReq,1);
        
        }
        else 
        {
        
		printf("USB3Slave_EpSetHalt\n");
            USB3Slave_EpSetHalt(ptDep0, 1);
        }
    

    return udRet;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0 setup ׶
 *
 * :
 *     - USB3Slave_Ep0InspectSetupڲ, 书:
 *     - ep0 setup ׶
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0InspectSetup(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                   const T_USB3Slave_EpEvt *ptEpEvt)
{
    u32 udRetVal = 0;
    u16 uwLen = 0;
    T_USB3Slave_CtrlReq *ptCtrlReq = (ptUsb3Slave->tCtrlReq);
	
    uwLen = ptCtrlReq->wLength;
    /*ݳΪ0ʾûݽ׶,׶Σݽ׶Σ׶*/
    if (!uwLen)
    {
        ptUsb3Slave->udThreeStageSetup = FALSE;
        ptUsb3Slave->udEp0ExpectIn = FALSE;
        ptUsb3Slave->eEp0NextEvent = EP0_NRDY_STATUS;
    }
    else
    {
        ptUsb3Slave->udThreeStageSetup = TRUE;
        ptUsb3Slave->udEp0ExpectIn = !!(ptCtrlReq->bmRequestType & USB_DIR_IN);
        ptUsb3Slave->eEp0NextEvent = EP0_NRDY_DATA;
    }
    printf("USB3Slave_Ep0Request\n");
    udRetVal = USB3Slave_Ep0Request(ptUsb3Slave,ptCtrlReq);

    if (udRetVal == USB_GADGET_DELAYED_STATUS)
        ptUsb3Slave->udDelayedStatus = TRUE;
 }
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0 data׶
 *
 * :
 *     - USB3Slave_Ep0CmpltDataڲ, 书:
 *     - ep0 data׶
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0CmpltData(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                   const T_USB3Slave_EpEvt *ptEpEvt)
{
    /*bootûеȺУݲκδ*/
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0 status ׶Σοƴ䣬״̬ع
 *
 * :
 *     - USB3Slave_Ep0CmpltRequestڲ, 书:
 *     - ep0 status ׶Σοƴ䣬״̬ع
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0CmpltRequest(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                  const T_USB3Slave_EpEvt *ptEpEvt)
{
    if(ptUsb3Slave->eDevState == CONFIGURED_STATE)
    {
		ptUsb3Slave->udUSBSate = 1;
#if SIM_EN == EMULATION
    REG32(ARM_PORTA)=0x31;
#endif

    }
    ptUsb3Slave->eEp0State = EP0_SETUP_PHASE;
    USB3Slave_Ep0StartXfer(ptUsb3Slave, 0, (u32)(ptUsb3Slave->tCtrlReq), 8,
                         TRBCTL_CONTROL_SETUP);

}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief xfercomplete¼
 *
 * :
 *     - USB3Slave_Ep0XferCmpltڲ, 书:
 *     - xfercomplete¼
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
/*xfercomplete¼*/
static void USB3Slave_Ep0XferCmplt(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                   const T_USB3Slave_EpEvt *ptEpEvt)
{
    T_USB3Slave_Ep *ptDep = &(ptUsb3Slave->tEps[ptEpEvt->udEndpoint_number]);

    ptDep->udFlags &= ~EP_BUSY;
    ptUsb3Slave->udSetupPacketPending = 0;
    switch (ptUsb3Slave->eEp0State)
    {
        case EP0_SETUP_PHASE:
        {
            USB3Slave_Ep0InspectSetup(ptUsb3Slave, ptEpEvt);
            break;
        }
        case EP0_DATA_PHASE:
        {
            USB3Slave_Ep0CmpltData(ptUsb3Slave, ptEpEvt);
            break;
        }
        case EP0_STATUS_PHASE:
        {
            USB3Slave_Ep0CmpltRequest(ptUsb3Slave, ptEpEvt);
            break;
        }
        default:
        {
            break;
        }
    }
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼ䣬ƽ׶
 *
 * :
 *     - USB3Slave_Ep0OutStartڲ, 书:
 *     - ʼ䣬ƽ׶εͨýӿ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0OutStart(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    USB3Slave_Ep0StartXfer(ptUsb3Slave, 0, (u32)(ptUsb3Slave->tCtrlReq), 8,
                         TRBCTL_CONTROL_SETUP);

}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ƽ׶ͨýӿ
 *
 * :
 *     - USB3Slave_Ep0DoCtrlSetupڲ, 书:
 *     - ƽ׶ͨýӿ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0DoCtrlSetup(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                      const T_USB3Slave_EpEvt *ptEpEvt)
{
    USB3Slave_Ep0OutStart(ptUsb3Slave);
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ״̬׶Σʼ䣬ٻ˵ṹд
 *
 * :
 *     - USB3Slave_Ep0DoCtrlStatusڲ, 书:
 *     - ״̬׶Σʼ䣬ٻ˵ṹд
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - udEpnum: ˵
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0DoCtrlStatus(T_USB3Slave_SlaveObj *ptUsb3Slave, u32 udEpnum)
{
    u32 udType;
    T_USB3Slave_Ep		*ptDep = &(ptUsb3Slave->tEps[udEpnum]);
    /* ȷƴ״̬ */
    udType = ptUsb3Slave->udThreeStageSetup ? TRBCTL_CONTROL_STATUS3
             : TRBCTL_CONTROL_STATUS2;
    /* ʼȴжϲ */
    USB3Slave_Ep0StartXfer(ptUsb3Slave, ptDep->udEpNum,
                         (u32)(ptUsb3Slave->tCtrlReq), 0, udType);
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ݽ׶
 *
 * :
 *     - USB3Slave_Ep0DoCtrlDataڲ, 书:
 *     - ݽ׶
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0DoCtrlData(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                     const T_USB3Slave_EpEvt *ptEpEvt)
{
    if (ptEpEvt->udEndpoint_number)
        ptUsb3Slave->tEps[ptEpEvt->udEndpoint_number].udFlags |= EP0_DIR_IN;
    
    /* linuxﻹȥжǷΪսдûУȷ  */

}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief xfernotready¼
 *
 * :
 *     - USB3Slave_Ep0XferNotReadyڲ, 书:
 *     - xfernotready¼
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0XferNotReady(T_USB3Slave_SlaveObj *ptUsb3Slave,
                                  const T_USB3Slave_EpEvt *ptEpEvt)
{
    u8 usb3Event = 0;
    T_USB3Slave_Ep * ptDep = &ptUsb3Slave->tEps[0];
    ptUsb3Slave->udSetupPacketPending = 1;
    /*
     * This part is very tricky: If we has just handled
     * XferNotReady(Setup) and we're now expecting a
     * XferComplete but, instead, we receive another
     * XferNotReady(Setup), we should STALL and restart
     * the state machine.
     *
     * In all other cases, we just continue waiting
     * for the XferComplete event.
     *
     * We are a little bit unsafe here because we're
     * not trying to ensure that last event was, indeed,
     * XferNotReady(Setup).
     *
     * Still, we don't expect any condition where that
     * should happen and, even if it does, it would be
     * another error condition.
     */
     /*
    if ((1 == ptUsb3Slave->udEventsequence) && (EP0_COMPLETE == ptUsb3Slave->eEp0NextEvent))
    {
        switch (ptEpEvt->EventStatus)
        {
            case DEPEVT_STATUS_CONTROL_SETUP:
            {
                IC_DBG(IC_DEBUG_INFO, "Unexpected XferNotReady(Setup)\n");
                break;
            }
            case DEPEVT_STATUS_CONTROL_DATA:
            {
                IC_DBG(IC_DEBUG_INFO, "DEPEVT_STATUS_CONTROL_DATA: XferNotReady\n");
                break;
            }
            case DEPEVT_STATUS_CONTROL_STATUS:
                break;
            default:
                IC_DBG(IC_DEBUG_INFO, "Uwaiting for XferComplete\n");
        }
        return;
    }
    */
    usb3Event = (u8)(ptEpEvt->EventStatus);
    if (DEPEVT_STATUS_CONTROL_SETUP == usb3Event)
    {
        printf("USB3Slave event DEPEVT_STATUS_CONTROL_SETUP\n");
        ptUsb3Slave->eEp0State = EP0_SETUP_PHASE;
        USB3Slave_Ep0DoCtrlSetup(ptUsb3Slave, ptEpEvt);
    }
    else if (DEPEVT_STATUS_CONTROL_DATA == usb3Event)
    {
        printf("USB3Slave event DEPEVT_STATUS_CONTROL_DATA\n");
        if ( ptUsb3Slave->eEp0NextEvent == EP0_COMPLETE)
        {
            return;
        }
        ptUsb3Slave->eEp0State = EP0_DATA_PHASE;
        USB3Slave_Ep0DoCtrlData(ptUsb3Slave, ptEpEvt);
    }
    else if (DEPEVT_STATUS_CONTROL_STATUS == usb3Event)
    {
        printf("USB3Slave event DEPEVT_STATUS_CONTROL_STATUS\n");
        ptUsb3Slave->eEp0State = EP0_STATUS_PHASE;
        USB3Slave_Ep0DoCtrlStatus(ptUsb3Slave, ptEpEvt->udEndpoint_number);
    }
    else if (DEPEVT_STATUS_STATUS_SETUP == usb3Event)
    {
        printf("USB3Slave event DEPEVT_STATUS_STATUS_SETUP\n");
        g_needSetStall = 1;
        USB3Slave_EpSetHalt(ptDep,1);
    }
    else
    {
        g_debugFaultVal = ptEpEvt->EventStatus;
        printf("USB3Slave event default\n");
    }
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ep0ж
 *
 * :
 *     - USB3Slave_Ep0ISRڲ, 书:
 *     - ж
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_Ep0ISR(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_EpEvt *ptEpEvt)
{
    switch (ptEpEvt->udEndpoint_event)
    {
        case DEPEVT_XFERCOMPLETE:
        {
            USB3Slave_Ep0XferCmplt(ptUsb3Slave, ptEpEvt);
            break;
        }
        case DEPEVT_XFERNOTREADY:
        {
            USB3Slave_Ep0XferNotReady(ptUsb3Slave, ptEpEvt);
            break;
        }
        default:
            break;
    }
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ָʾ
 *
 * :
 *     - USB3Slave_EpXferCmpltڲ, 书:
 *     - ָʾ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptDep: ˵Ϣṹ
 *     - ptEpEvt: ˵¼
 *     - udStart_new:
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_EpXferCmplt(T_USB3Slave_SlaveObj *ptUsb3Slave,
        T_USB3Slave_Ep *ptDep, const T_USB3Slave_EpEvt *ptEpEvt,u32 udStart_new)
{

		u32 udXfercount;
		T_USB3Slave_TRB *tTrbBit;
	
		tTrbBit = (T_USB3Slave_TRB *)ptDep->ptTRB ;
		udXfercount = ptDep->udLen - tTrbBit->len_pcm.bit.BUFSIZ;
	  	
		if((0x0 == ptDep->udDirection) && (0x2 == ptDep->ucType))
			ptUsb3Slave->eDevState	= BULKOUT_CMPL;  
		if((0x1 == ptDep->udDirection) && (0x2 == ptDep->ucType))
			ptUsb3Slave->eDevState = BULKIN_CMPL;
		
		ptDep->udFlags &= ~EP_BUSY;
		ptDep->ucResTransIdx = 0;
	  
	
		if(ptDep->fnUsbCb)
		    ptDep->fnUsbCb((u32)(ptDep->pPara), 0, udXfercount, ptDep->udLen);
}

static void USB3Slave_Init_TRB(T_USB3Slave_Ep *ptDep)
{
    T_USB3Slave_TRBToHW	*ptTrbRaw;
    T_USB3Slave_TRB		tTrbBit;

    ptTrbRaw = ptDep->ptTRB;

    memset(&tTrbBit, 0, sizeof(tTrbBit));

    tTrbBit.control.bit.CHN    = 0;
    tTrbBit.control.bit.LST    = 1;
    tTrbBit.control.bit.TRBCTL = TRBCTL_NORMAL;
	tTrbBit.control.bit.HWO    = 1;

    tTrbBit.len_pcm.bit.BUFSIZ	= ptDep->udLen;

    tTrbBit.bplh=(u64)(ptDep->pudAddrData);
    

    USB3Slave_TrbToHW(&tTrbBit, ptTrbRaw);
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ͨ˵ݴ
 *
 * :
 *     - USB3Slave_EpStartXferڲ, 书:
 *     - ͨ˵ݴ
 *
 * :
 *     - ptDep: ˵Ϣṹ
 *     - uwCmd_param: 
 *     - udStart_new:
 *
 *   ֵ: :INT
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
/*ͨ˵ݴ*/
static u32 USB3Slave_EpStartXfer(T_USB3Slave_Ep *ptDep, u16 uwCmd_param,
		u32 udStart_new)
{
	T_USB3Slave_EpCmdPara tParams;
	T_USB3Slave_SlaveObj *pUSB3Slv = &g_USB3Slave;
	u32  udCmd;

    USB3Slave_Init_TRB(ptDep);   //TRB
	memset(&tParams, 0, sizeof(tParams));

	tParams.Parameter0 = 0;   /*trb32λַĬΪ0*/
	tParams.Parameter1 = (u32)((u32)(ptDep->ptTRB)& (u32)0xFFFFFFFF);/* ys */

	if (udStart_new)
		udCmd = USB3Slave_DEPCMD_STARTTRANSFER;
	else
		udCmd = USB3Slave_DEPCMD_UPDATETRANSFER;

	udCmd |= USB2Slave_DEPCMD_PARAM(uwCmd_param);   //0
    
	USB3Slave_SendDevEpCmd(pUSB3Slv, ptDep->udEpNum, udCmd, &tParams);

	return SOK;
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ˵͵eventжϴ
 *
 * :
 *     - USB3Slave_EpISRڲ, 书:
 *     - ˵͵eventжϴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEpEvt: ˵¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_EpISR(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_EpEvt *ptEpEvt)
{
    T_USB3Slave_Ep *ptDep;

    u8 ucEpnum = ptEpEvt->udEndpoint_number;
 
    ptDep = &(ptUsb3Slave->tEps[ucEpnum]);

    if (0 == ucEpnum || 1 == ucEpnum)
    {
        USB3Slave_Ep0ISR(ptUsb3Slave, ptEpEvt);
        return;
    }

    switch (ptEpEvt->udEndpoint_event)
    {
        case DEPEVT_XFERCOMPLETE:
        {
            USB3Slave_EpXferCmplt(ptUsb3Slave, ptDep, ptEpEvt, 1);
            break;
        }
        default:
            break;
    }

}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief 豸λжϴ
 *
 * :
 *     - USB3Slave_ResetISRڲ, 书:
 *     - 豸λжϴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_ResetISR(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    u32    udRegVal;

    printf("R");
//tangjian:־usb
	global.g_Connet = 1;

/* Reset device address to zero */
    udRegVal = REG32(ptUsb3Slave->udRegs_base + DWC3_DCFG);
    udRegVal &= ~(0x7f<<3);
    REG32(ptUsb3Slave->udRegs_base + DWC3_DCFG) = udRegVal;

}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ȡusb 3.0ʱ
 *
 * :
 *     - USB3Slave_UpdateRamClkSelڲ, 书:
 *     - ȡusb 3.0ʱ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ucSpeed: ָʾٶ
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_UpdateRamClkSel(T_USB3Slave_SlaveObj *ptUsb3Slave, u32 ucSpeed)
{
    u32 udRegVal;
    /*
     * RAMClkSel is reset to 0 after USB reset, so it must be reprogrammed
     * each time on Connect Done.
     */

    /* GCTLĴ,sel bus = 0*/
    udRegVal = REG32(ptUsb3Slave->udRegs_base + DWC3_GCTL);
    udRegVal &= ~(0x3<<6);
    REG32(ptUsb3Slave->udRegs_base + DWC3_GCTL) = udRegVal;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief 豸жϴ
 *
 * :
 *     - USB3Slave_ConnectdoneISR ڲ, 书:
 *     - 豸жϴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_ConnectdoneISR(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    T_USB3Slave_Ep		*ptDep;
    u32    udRegVal;
    u8 ucSpeed;

    printf("D");


    udRegVal = REG32(ptUsb3Slave->udRegs_base + DWC3_DSTS); 
    ucSpeed = udRegVal&0x7;
	
    ptUsb3Slave->ucSpeed = ucSpeed;    
    USB3Slave_UpdateRamClkSel(ptUsb3Slave, ucSpeed);
    if(USB3_HIGHSPEED == ucSpeed)
    {
		
        printf("2");
		ptUsb3Slave->tEps[2].udMaxPacket = 512;
		ptUsb3Slave->tEps[3].udMaxPacket = 512;
		ptUsb3Slave->tEps[4].udMaxPacket = 512;
		ptUsb3Slave->tEps[5].udMaxPacket = 512;
	    ptUsb3Slave->eDeviceSpeedType = USB30_SPEED_HIGH;
        desc.atTxEP[0].wMaxPacketSize  = USB_HIGHSPEED_BULK_MAXSIZE;
        desc.atRxEP[0].wMaxPacketSize  = USB_HIGHSPEED_BULK_MAXSIZE;
        desc.atTxEP1[0].wMaxPacketSize = USB_HIGHSPEED_BULK_MAXSIZE;
        desc.atRxEP1[0].wMaxPacketSize = USB_HIGHSPEED_BULK_MAXSIZE;
    }
    else if(USB3_FULLSPEED == ucSpeed)
    {
		
        printf("1");
        ptUsb3Slave->tEps[2].udMaxPacket = 64;
		ptUsb3Slave->tEps[3].udMaxPacket = 64;
		ptUsb3Slave->tEps[4].udMaxPacket = 64;
		ptUsb3Slave->tEps[5].udMaxPacket = 64; 
        ptUsb3Slave->eDeviceSpeedType = USB30_SPEED_FULL;
        desc.atTxEP[0].wMaxPacketSize = USB_FULLSPEED_BULK_MAXSIZE;
        desc.atRxEP[0].wMaxPacketSize = USB_FULLSPEED_BULK_MAXSIZE;
        desc.atTxEP1[0].wMaxPacketSize = USB_FULLSPEED_BULK_MAXSIZE;
        desc.atRxEP1[0].wMaxPacketSize = USB_FULLSPEED_BULK_MAXSIZE;
    }
//tangjian:ep0Ķ˵Ϣ

    ptDep = &(ptUsb3Slave->tEps[0]);    
    USB3Slave_SetEpCfgCmd(ptUsb3Slave, ptDep);
    ptDep = &(ptUsb3Slave->tEps[1]);
    USB3Slave_SetEpCfgCmd(ptUsb3Slave, ptDep);

#if SIM_EN == EMULATION

	REG32(REG_GPIO_OUT)=5;
//	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;

	REG32(REG_GPIO_OUT)=6;
//	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;

	REG32(REG_GPIO_OUT)=7;
//	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;

	REG32(REG_GPIO_OUT)=8;
//	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;

#endif

    
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief 豸жϴ(Ͽλӡѡ״̬ı䡢EOPFɡ)
 *
 * :
 *     - USB3Slave_DevISRڲ, 书:
 *      - 豸жϴ(Ͽλӡѡ״̬ı䡢EOPFɡ)
  *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptDevEvt: 豸¼
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/

static void USB3Slave_DevISR(T_USB3Slave_SlaveObj *ptUsb3Slave, const  T_USB3Slave_DevEvt *ptDevEvt)
{
    switch (ptDevEvt->udType)
    {
        case DEVICE_EVENT_RESET:
        {
            USB3Slave_ResetISR(ptUsb3Slave);
            break;  
        }
        case DEVICE_EVENT_CONNECT_DONE:
        {
            USB3Slave_ConnectdoneISR(ptUsb3Slave);
            break;
        }
        case DEVICE_EVENT_EOPF:
        {
            printf("S");
            break;
        }
        default:
            break;
    }
}



/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ͬжϺ
 *
 * :
 *     - USB3Slave_ProcessEvtEntryڲ, 书:
 *     - ͬжϺ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - ptEvt: ʾevent buffer 
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_ProcessEvtEntry(T_USB3Slave_SlaveObj *ptUsb3Slave, T_USB3Slave_Event *ptEvt)
{
    /* Endpoint IRQ, handle it and return early */
    /*0bit 0豸˵ж 1豸ж*/
    if (0 == ptEvt->tType.udIs_devspec)
        USB3Slave_EpISR(ptUsb3Slave, &ptEvt->tEpEvt);  /* tDepevt */
    else
        USB3Slave_DevISR(ptUsb3Slave, &ptEvt->tDevEvt);
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief event buffer еevent,ַͬevent bufferм¼жϣٵжڳ
 *
 * :
 *     - USB3Slave_ProcessEvtBufڲ, 书:
 *     - event buffer еevent,ַͬevent bufferм¼жϣٵжڳ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *     - udBufNum: ʾevent bufferĳevent
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_ProcessEvtBuf(T_USB3Slave_SlaveObj *ptUsb3Slave, u32 udBufNum)
{
    T_USB3Slave_EventBuf *ptevt;
    T_USB3Slave_Event ptEvt;
    u32 udLeft;
    u32 udCount;
    
//step0:жϴлȡevent countжм¼ӦĴ	
    udCount = REG32((ptUsb3Slave->udRegs_base + GEVNTCOUNT(udBufNum)));
    if(!udCount)
        return;
    ptevt = ptUsb3Slave->ptEvtBuffs;
    udLeft = udCount;
    ptUsb3Slave->udEventsequence = 1;/* ys */
//step1:Ӧ¼    
    while (udLeft > 0)
    {
        ptEvt.udRaw = ptevt->EvtBuf[ptevt->udLpos];

        USB3Slave_ProcessEvtEntry(ptUsb3Slave, &ptEvt);
        /*
         * XXX we wrap around correctly to the next entry as almost all
         * entries are 4 bytes in size. There is one entry which has 12
         * bytes which is a regular entry followed by 8 bytes data. ATM
         * I don't know how things are organized if were get next to the
         * a boundary so I worry about that once we try to handle that.
         */
        ptevt->udLpos = (ptevt->udLpos + 1) % EVENT_BUFFERS_SIZE;
        udLeft -= 4;
        ptUsb3Slave->udEventsequence++;
    }

	/*When read, returns the number of valid events in the Event Buffer (in bytes).
      When written, hardware decrements the count by the value written.
      The interrupt line remains high when count is not 0.*/
    REG32(ptUsb3Slave->udRegs_base + GEVNTCOUNT(udBufNum)) = udCount;    
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief жں
 *
 * :
 *     - USB3Slave_ISRڽӿں, 书:
 *     - жں
 *
 * :
 *     - udIntNo: жϺ
 *     - udPara: жϲ
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
void USB3Slave_ISR(u32 udIntNo,u32 udPara)
{
    T_USB3Slave_SlaveObj *pUSB3Slv = &g_USB3Slave;
    u32    udIndex ;

	for (udIndex = 0; udIndex < pUSB3Slv->udNumEvtBufs; udIndex++)
    {
        USB3Slave_ProcessEvtBuf(pUSB3Slv,udIndex);
    }

}

/*ʼڼ¼豸Ϣȫֽṹ*/
/*һд ڴ벹Ĺ*/
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼȫֽṹptUsb3Slave
 *
 * :
 *     - USB3Slave_Initڲ, 书:
 *     - ʼṹȫֱ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void  USB3Slave_Init(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
	T_USB3Slave_HWPARAMS	*parms = &ptUsb3Slave->tHwParams;

    gp_USB3Slave_EventBuf = &USB3Slave_EventBuf;
    ptUsb3Slave->udRegs_base = SYS_USB_BASE;
    ptUsb3Slave->eSpeedMode  = USB3_HIGHSPEED;

    parms->udHwparams0 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS0);
    parms->udHwparams1 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS1);
    parms->udHwparams2 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS2);
    parms->udHwparams3 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS3);
    parms->udHwparams4 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS4);
    parms->udHwparams5 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS5);
    parms->udHwparams6 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS6);
    parms->udHwparams7 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS7);
    parms->udHwparams8 = REG32(ptUsb3Slave->udRegs_base + GHWPARAMS8);
 
    ptUsb3Slave->udNumEvtBufs = (parms->udHwparams1&(0x3f<<15))>>15;  //ȡevent_int_num
//	if(global.need_enum ==0)
    {
        gp_USB3Slave_EventBuf->udLength = EVENT_BUFFERS_SIZE*4;
        gp_USB3Slave_EventBuf->udLpos	 = 0;
    }

    ptUsb3Slave->ptEvtBuffs  = gp_USB3Slave_EventBuf;  

    ptUsb3Slave->tCtrlReq = &pCtrlReq;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ¼event bufferַĴ
 *
 * :
 *     - USB3Slave_EvtBufSetupڲ, 书:
 *     - ¼event bufferַĴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: :INT
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_EvtBufSetup(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    T_USB3Slave_EventBuf *ptevt;
    u32 udIndex = 0;
    u32 udTemp_data;/*ַ*/

    ptevt = ptUsb3Slave->ptEvtBuffs;
    udTemp_data = (u32)&ptevt->EvtBuf;
    REG32(ptUsb3Slave->udRegs_base + GEVNTADRLO(udIndex)) = udTemp_data;
    REG32(ptUsb3Slave->udRegs_base + GEVNTADRHI(udIndex)) = 0;
    REG32(ptUsb3Slave->udRegs_base + GEVNTSIZ(udIndex)) = ptevt->udLength & 0xffff;
    REG32(ptUsb3Slave->udRegs_base + GEVNTCOUNT(udIndex)) = ptevt->udLpos;
}
/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ¼event bufferַĴ
 *
 * :
 *     - USB3Slave_EvtBufSetupڲ, 书:
 *     - ¼event bufferַĴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: :INT
 *     - 
 *
 *--------------------------------------------------------------------------------------------------------------------*/

static void USB3Slave_EvtBufRestore(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    /*T_USB3Slave_EventBuf *ptevt;
    u32 udIndex = 0;
    u32 udTemp_data;
    ptevt = ptUsb3Slave->ptEvtBuffs;
    udTemp_data = (u32)&ptevt->EvtBuf;
    REG32(ptUsb3Slave->udRegs_base + GEVNTADRLO(udIndex)) = udTemp_data;
    REG32(ptUsb3Slave->udRegs_base + GEVNTADRHI(udIndex)) = 0;
    REG32(ptUsb3Slave->udRegs_base + GEVNTSIZ(udIndex)) = ptevt->udLength & 0xffff;
    REG32(ptUsb3Slave->udRegs_base + GEVNTCOUNT(udIndex)) = ptevt->udLpos;*/
    u32 udRegVal;
    u8 ucSpeed;

    T_USB3Slave_EventBuf *ptevt;
    u32 udIndex = 0;
    ptevt = ptUsb3Slave->ptEvtBuffs;
    ptUsb3Slave->ptEvtBuffs = (T_USB3Slave_EventBuf *)(REG32(ptUsb3Slave->udRegs_base + GEVNTADRLO(udIndex))); 
    ptevt->udLength =REG32(ptUsb3Slave->udRegs_base + GEVNTSIZ(udIndex)); 
    //  ptevt->udLpos = REG32(ptUsb3Slave->udRegs_base + GEVNTCOUNT(udIndex)) ;
    ptUsb3Slave->tCtrlReq = (T_USB3Slave_CtrlReq *)(*(u32 *)(*(u32 *)(0x0200c804)));

    udRegVal = REG32(ptUsb3Slave->udRegs_base + DWC3_DSTS); 
    ucSpeed = udRegVal&0x7;
    ptUsb3Slave->ucSpeed = ucSpeed;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ö˵0ʼȴпƴ
 *
 * :
 *     - USB3Slave_StartCtrlXferڲ, 书:
 *     - ö˵0ʼȴпƴ
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_StartCtrlXfer(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    T_USB3Slave_Ep *ptDep;
    u32 udIndex;

    for (udIndex=0; udIndex < 2; udIndex++)  /*//MAX_EPS*2  2˵bulk out3˵bulk in 4˵intr out5˵ intr in*/
    {
        ptDep = &(ptUsb3Slave->tEps[udIndex]);
        ptDep->ptTRB= &USB3Slave_TRB;  //tjÿ˵ʹͬһtrb mem
		ptDep->udEpNum = udIndex;
        if(global.need_enum ==1)
        {
            USB3Slave_CfgEp(ptDep);
        }
    }
    ptUsb3Slave->eEp0State = EP0_SETUP_PHASE;
//ִcmd6ʾstart transfer
    USB3Slave_Ep0StartXfer(ptUsb3Slave, 0, (u32)(ptUsb3Slave->tCtrlReq), 8, TRBCTL_CONTROL_SETUP);
}



/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼ˵ṹ壬ԼӦĴ(˵ţ˵״̬䷽򣬰С)
 *
 * :
 *     - USB3Slave_InitEpڲ, 书:
 *     - ʼ˵ṹ壬ԼӦĴ(˵ţ˵״̬䷽򣬰С)
 *
 * :
 *     - ptUsb3Slave: 豸Ϣṹ
 *
 *   ֵ: 
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void USB3Slave_InitEp(T_USB3Slave_SlaveObj *ptUsb3Slave)
{
    T_USB3Slave_Ep *ptDep;
    u32 udIndex;
    /* u32 udFifoNum = 0,udTxfram_space; */
    for (udIndex = 0; udIndex < ENDPOINTS_NUM; udIndex++)
    {
        ptDep = &(ptUsb3Slave->tEps[udIndex]);
        ptDep->udEpNum = udIndex;
        ptDep->eEpState = EP_IDLE;
        ptDep->udFlags  = 0;   //tj add flagĬΪ0
        ptDep->udMaxBurst = 0; //tj add burst size 0-15 : 1-16
        ptDep->udDirection = udIndex & 1;/*崫䷽*/
        if (0 == udIndex|| 1 == udIndex)
        {
            ptDep->udMaxPacket = EP0_PACKET_SIZE;/*Э涨ƴС512*/
        }
        else
        {
            ptDep->udMaxPacket = HS_MAX_PACKET_SIZE;
        }
    }
}



/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʼĴ
 *
 * :
 *     - USB3Slave_Init ڽӿں, 书:
 *     - ʼĴ
 *
 * :
 *     - eUSBSpeedType: USB 豸ٶ
 *
 *   ֵ: :u32
 *     - 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
u32 USB3Slave_Ctrl_Init(void)
{
    u32 udRegValue, i = 0;

    T_USB3Slave_SlaveObj *pUSB3Slv = &g_USB3Slave;
//step0: Խṹg_USB3Slaveиֵ
    USB3Slave_Init(pUSB3Slv);
    
//step1:DCTLԿλ
	if(global.need_enum ==1)
{

    REG32(pUSB3Slv->udRegs_base + DWC3_DCTL) |= DWC3_DCTL_CSFTRST; 
    while(1)
    {
       i++;
       usdelay(10);
       udRegValue =REG32(pUSB3Slv->udRegs_base + DWC3_DCTL);
       if ((!(udRegValue & DWC3_DCTL_CSFTRST))||(i>0x1000))/*λϺλԶ*/
  	   break;
    }
}
//step2:USB2 PHY */   //0x0007a510
    /*bit3: 0:8bit 1:16bit
      bit4: 0:utmi 1:ulpi
      bit[13:10] 5:16bit utmi 9:8bit utim/ulpi*/
 if(global.need_enum ==1)
{
    #if(SIM_EN == FPGA)
        #if (USB_PHY == ULPI)
            udRegValue  = 0x7a510|(1<<9); //0xf<<15+0x9<<10+0x1<<4+0x0<<3;
        #elif (USB_PHY == UTMI)
            udRegValue  = 0x00001408|(1<<9);//0x0<<15|0x5<<10|0x0<<4+0x1<<3;
        #endif
    #elif ((SIM_EN == ASIC) || (SIM_EN == EMULATION))
        udRegValue  = 0x00002400|(1<<9);//0x0<<15|0x9<<10|0x0<<4+0x0<<3;
    #endif


	REG32(pUSB3Slv->udRegs_base + DWC3_GUSB2PHYCFG(0)) = udRegValue;

//step3:DCTLԿٴνλ
	REG32(pUSB3Slv->udRegs_base + DWC3_DCTL) |= DWC3_DCTL_CSFTRST; 
	while(1)
	{
	   i++;
	   usdelay(10);
	   udRegValue =REG32(pUSB3Slv->udRegs_base + DWC3_DCTL);
	   if ((!(udRegValue & DWC3_DCTL_CSFTRST))||(i>0x1000))/*λϺλԶ*/
	   break;
	}

}
//step4:params1лȡeventnumӲĬΪ1,event_buffer
	 if(global.need_enum ==1)
{

    USB3Slave_EvtBufSetup(pUSB3Slv);
}
	 else
{
	USB3Slave_EvtBufRestore(pUSB3Slv);
}

//step5: üĴc110dev mode,c700,high speed
if(global.need_enum ==1)
{

    udRegValue = REG32(pUSB3Slv->udRegs_base + DWC3_GCTL);
    udRegValue = (udRegValue & 0xffff0000) | 0x200c;//ԭ0x2008 scaledown
    udRegValue = udRegValue & (~(1<<17)); // In the real hardware, this bit must be set to 1'b0
    udRegValue = udRegValue & (~(1<<16));//2012.11.9,never attempts three more times to connect at SS
#if SIM_EN == EMULATION
    udRegValue = (udRegValue & 0xffff0000) | 0x2008;
    udRegValue = udRegValue|(0x3<<4);      //lanxiang   scaledown
    udRegValue = udRegValue|(1<<16);
#endif
    REG32(pUSB3Slv->udRegs_base + DWC3_GCTL) = udRegValue;

    udRegValue = REG32(pUSB3Slv->udRegs_base + DWC3_DCFG);
	udRegValue &= ~(DWC3_DCFG_SPEED_MASK);  //0Ϊhigh speed
	udRegValue &= (~(0x1f<<17));
	udRegValue |= pUSB3Slv->eSpeedMode | (1<<17) ;  /*117Ϊ֤дpxp*/
	REG32(pUSB3Slv->udRegs_base + DWC3_DCFG)= udRegValue;
}
    pUSB3Slv->eDeviceSpeedType = USB30_SPEED_UNKNOWN;

//step6:ʼEP˵㣬bootֻõ012345ĿԿǲҪ

    USB3Slave_InitEp(pUSB3Slv);

//step7:ж(reset , connect done)ʹܣӣ31bitΪrun
if(global.need_enum ==1)
{
	udRegValue = REG32(pUSB3Slv->udRegs_base + DWC3_DEVTEN);
	udRegValue = udRegValue | (DWC3_DEVTEN_CONNECTDONEEN | DWC3_DEVTEN_USBRSTEN|DWC3_DEVTEN_USBSUSPENDEN);
	//udRegValue = udRegValue & (~(1<<6)) & (~(1<<7));
	REG32(pUSB3Slv->udRegs_base + DWC3_DEVTEN) = udRegValue; 
}
//step8:start control tranfer
    USB3Slave_StartCtrlXfer(pUSB3Slv);
	if(global.need_enum ==1)
{

//step9:run softconnect
	udRegValue = REG32(pUSB3Slv->udRegs_base + DWC3_DCTL);
	udRegValue |= (1U<<31);	//tj add 31bit for run or stop,correspond to softdisconnect
	REG32(pUSB3Slv->udRegs_base + DWC3_DCTL) = udRegValue;


#if SIM_EN == EMULATION
	//for hsic
	REG32(REG_GPIO_OUT)=2;
//	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;
#endif
}

    return SOK;
}


u32 USB3_RecvOutData(u32 dwEPNo, u8 *pchBuf, u32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{
    T_USB3Slave_Ep *ptDep;
    T_USB3Slave_SlaveObj *ptUsb3Slave = &g_USB3Slave;

    ptDep = &(ptUsb3Slave->tEps[dwEPNo]);

    ptDep->pudAddrData =(u32*)pchBuf;
    ptDep->udLen = dwLen;
    ptDep->fnUsbCb    = fnUsbCb;
	ptDep->pPara      = pPara;

    USB3Slave_EpStartXfer(ptDep, 0, 1);

#if SIM_EN == EMULATION
    REG32(ARM_PORTA)=0x80;
#endif

    return SOK;
}



u32 USB3_SendInData(u32 dwEPNo, u8 *pchBuf, u32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{

    T_USB3Slave_Ep *ptDep;
    T_USB3Slave_SlaveObj *ptUsb3Slave = &g_USB3Slave;

    ptDep = &(ptUsb3Slave->tEps[dwEPNo]);

    ptDep->pudAddrData = (u32*)pchBuf;
    ptDep->udLen = dwLen;
    ptDep->fnUsbCb    = fnUsbCb;
	ptDep->pPara      = pPara;

    USB3Slave_EpStartXfer(ptDep, 0, 1);

#if SIM_EN == EMULATION
	REG32(ARM_PORTA)=0x82;
#endif
    
    return SOK;
}

u32 USB3Slave_IsNeedZero(u32 dwLen)
{
    T_USB3Slave_Ep *ptDep;
    T_USB3Slave_SlaveObj *ptUsb3Slave = &g_USB3Slave;
    u32 udMaxPacket;
    
    if (ptUsb3Slave->ucSpeed == USB3_HIGHSPEED)
    {
        udMaxPacket = HS_MAX_PACKET_SIZE;
    }
    else if (ptUsb3Slave->ucSpeed == USB3_FULLSPEED)
    {
        udMaxPacket = FS_MAX_PACKET_SIZE;
    }
    if (dwLen%udMaxPacket == 0)
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/*öٺ*/
u32 USB3Slave_CDC_Enum(void)
{
    T_USB3Slave_Ep *ptDep;
    u32 dwCount=0;
    u32 dwCount1=0;
    u32 udIndex;
    
    
    global.g_Connet = 0; 
    USB3Slave_Ctrl_Init();
	if(global.need_enum ==0)
	{
		for (udIndex=2; udIndex < 6; udIndex++)  /*//MAX_EPS*2  2˵bulk out3˵bulk in 4˵intr out5˵ intr in*/
        {
            ptDep = &(g_USB3Slave.tEps[udIndex]);
            ptDep->ptTRB= &USB3Slave_TRB_EP[udIndex-2];  //tjÿ˵ʹͬһtrb mem
    		ptDep->udEpNum = udIndex;
			
			//USB3Slave_CfgEp(ptDep);
		}
	}
if(global.need_enum ==1)
{
    while(1)
    {
		USB3Slave_ISR(0,0);
        if(0 == global.g_Connet)
        {
            dwCount++;
            usb_timeout_usdelay(50000);
            if(dwCount>(4000*global.g_USB_TIMEOUT))
                return 1;

        }
        else if(1 == g_USB3Slave.udUSBSate)
        {
            for (udIndex=2; udIndex < 6; udIndex++)  /*//MAX_EPS*2  2˵bulk out3˵bulk in 4˵intr out5˵ intr in*/
            {
                ptDep = &(g_USB3Slave.tEps[udIndex]);
                ptDep->ptTRB= &USB3Slave_TRB_EP[udIndex-2];  //tjÿ˵ʹͬһtrb mem
        		ptDep->udEpNum = udIndex;
                USB3Slave_CfgEp(ptDep);
            }
            break;
        }
        else
        {
            dwCount1++;
            usb_timeout_usdelay(50000);
            if(dwCount1>(200000*global.g_USB_TIMEOUT))
            {
                return 1;
            }

        }
    }
}
    return 0;
}

extern void USB_Boot(void);
extern void USB_Pll_Clk_Rst_InitEnv(void);

void USB3Slave_boot(void)
{
    u32 dwConnect;
    global.g_USB_MODE = 0;
    global.need_enum = 0;
// 1:config clock
    if(global.need_enum ==1)
    {
        USB_Pll_Clk_Rst_InitEnv();
    }
// 2:USB30_CDC_Enum
    dwConnect = USB3Slave_CDC_Enum();
    if(1==dwConnect)
    {
        printf("NOLINK\n");
        return ;
    }
    
#if 0//SIM_EN == EMULATION
    REG32(ARM_PORTA)=0x32;
#endif
    printf("FAILED\n");
}
      
/** @} */

      
