/*
 * (C) Copyright 2004
 * Texas Instruments
 *
 * (C) Copyright 2000-2004
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __COMMON_H_
#define __COMMON_H_	1

#undef	_LINUX_CONFIG_H
#define _LINUX_CONFIG_H 1	/* avoid reading Linux autoconf.h file	*/

#include <config.h>
#include <linux/types.h>
#include <stdarg.h>
#include <asm/arch/uart.h>


#ifdef CONFIG_ARM
#define asmlinkage	/* nothing */
#endif

 
#ifdef CONFIG_ARM
# include <asm/setup.h>
# include <asm/z-load-arm.h>	/* ARM version to be fixed! */
#endif /* CONFIG_ARM */


#if CFG_PRINTF
#define printf(x)    uart_puts(x)
#else
#define printf(x)
#endif	/* CFG_PRINTF */


void clk_init (void);
int tsp_usb_init(void);
    
void usb_boot(u32 USB_ADDR);
 
/* cpu/$(CPU)/cpu.c */
void 	usdelay (u32 usec);


/* lib/board.c */
void	hang		(void) __attribute__ ((noreturn));

#define Para_Section  __attribute__((__section__ (".para")))
  

#endif	/* __COMMON_H_ */
