/*******************************************************************************
 * Copyright (C) 2016, ZXIC Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:      
 * Author:        
 * Date:          
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/
#ifndef __SDIO_H__
#define __SDIO_H__


//#if 0
typedef signed char 			s8;
typedef unsigned char 			u8;

typedef signed short 			s16;
typedef unsigned short 			u16;

typedef signed int 				s32;
typedef unsigned int 			u32;
typedef unsigned long long 		u64;
//#endif

typedef u8						BYTE;
typedef	u32						WORD32;
typedef	u16						WORD16;

#if 0
typedef int						int32_t;
typedef u32						uint32_t;
typedef u16						uint16_t;
typedef u8						uint8_t;
#endif


#define MIN(x,y)		  		((x) < (y) ? (x) : (y))
#define MAX(x,y)      			((x) > (y) ? (x) : (y))
#define ARRAY_SIZE(x) 			(sizeof(x) / sizeof((x)[0]))
#define REG(x)				    (*(volatile u32*)(x))
#define REG8(x)				    (*(volatile u8*)(x))
#define REG16(x)			    (*(volatile u16*)(x))
#define REG32(x)			    (*(volatile u32*)(x))
#define DWC_READ_REG32(a)     	(*(volatile u32 *)(a))
#define DWC_WRITE_REG32(a,v)    ((*(volatile u32 *)(a)) = v)


/*SDIO */
#define SYS_SDIO_REGS_BASE                      0x01540000  //SD1
#define CFG_SDIO_LOAD_BASE                      0x20000000      // SDIO DMA ݰ˵

#define	SDIO_CMD0    0   /* GO_IDLE_STATE        bc                    */
#define SDIO_CMD1    1   /* SEND_OP_COND         bcr  [31:0]  OCR  R3  */
#define SDIO_CMD2    2   /* ALL_SEND_CID         bcr               R2  */
#define SDIO_CMD3    3   /* SET_RELATIVE_ADDR    ac   [31:16] RCA  R1  */
#define SDIO_CMD4    4   /* SET_DSR              bc   [31:16] RCA      */
#define SDIO_CMD5    5   /* IO_SEND_OP_COND            ??   ??               */
#define SDIO_CMD6    6   /* SWITCH FUNC             ac                R1  */
					/* For ACMD6:SET_BUS_WIDTH  ??   ??               */
#define SDIO_CMD7    7   /* SELECT_CARD          ac   [31:16] RCA  R1  */
#define SDIO_CMD8    8   /* SEND_IF_COND      adtc [31:16] RCA  R1  */
#define SDIO_CMD9    9   /* SEND_CSD             ac   [31:16] RCA  R2  */
/* class 7 */
#define SDIO_CMD52   52  /* SDIO_RW_DIRECT           ??                 R5  */
#define SDIO_CMD53   53  /* SDIO_RW_EXTENDED         ??                 R5  */

/*Ĵƫ*/
#define  SDIO_SLAVE_REGS              SYS_SDIO_REGS_BASE
#define  SDIO_SLAVE_CTRL             (SDIO_SLAVE_REGS+0x00)
#define  SDIO_SLAVE_CMD   	         (SDIO_SLAVE_REGS+0x04)
#define  SDIO_SLAVE_ARGU  	         (SDIO_SLAVE_REGS+0x08)
#define  SDIO_SLAVE_BLKCNT           (SDIO_SLAVE_REGS+0x0C)
#define  SDIO_SLAVE_DMA1ADDR         (SDIO_SLAVE_REGS+0x10)
#define  SDIO_SLAVE_DMA1CTRL         (SDIO_SLAVE_REGS+0x14)

#define  SDIO_SLAVE_ERASE_W_BLKSTART (SDIO_SLAVE_REGS+0x20)
#define  SDIO_SLAVE_ERASE_W_BLKEND   (SDIO_SLAVE_REGS+0x24)
#define  SDIO_SLAVE_PASSLE           (SDIO_SLAVE_REGS+0x28)
#define  SDIO_SLAVE_SECBLKCNT        (SDIO_SLAVE_REGS+0x2C)

#define  SDIO_SLAVE_INTSTATUS        (SDIO_SLAVE_REGS+0x3C)
#define  SDIO_SLAVE_INTSTATUS_EN     (SDIO_SLAVE_REGS+0x40)
#define  SDIO_SLAVE_INTSIGNAL_EN 	 (SDIO_SLAVE_REGS+0x44)
#define  SDIO_SLAVE_CARD_ADDR        (SDIO_SLAVE_REGS+0x48)
#define  SDIO_SLAVE_CARD_DATA  	     (SDIO_SLAVE_REGS+0x4C)
#define  SDIO_SLAVE_IOREADY  	     (SDIO_SLAVE_REGS+0x50)
#define  SDIO_SLAVE_FUN1CTRL         (SDIO_SLAVE_REGS+0x54)
#define  SDIO_SLAVE_FUN2CTRL         (SDIO_SLAVE_REGS+0x58)
#define  SDIO_SLAVE_SDIO_CCCR_CTRL   (SDIO_SLAVE_REGS+0x5C)
#define  SDIO_SLAVE_SDIO_FBRx_CTRL   (SDIO_SLAVE_REGS+0x60)  /* **sdio fbrx ctrl 0x60-0x7c*/

#define  SDIO_SLAVE_CARD_SIZE        (SDIO_SLAVE_REGS+0x80)
#define  SDIO_SLAVE_CARD_OCR         (SDIO_SLAVE_REGS+0x84)
#define	 SDIO_SLAVE_CTRL2            (SDIO_SLAVE_REGS+0x88)

#define  SDIO_SLAVE_FUN3CTRL         (SDIO_SLAVE_REGS+0x90)
#define  SDIO_SLAVE_FUN4CTRL         (SDIO_SLAVE_REGS+0x94)
#define  SDIO_SLAVE_FUN5CTRL         (SDIO_SLAVE_REGS+0x98)
#define  SDIO_SLAVE_INT_STATUS2      (SDIO_SLAVE_REGS+0x9C)
#define  SDIO_SLAVE_INT_STATUS_EN2   (SDIO_SLAVE_REGS+0xA0)
#define  SDIO_SLAVE_INT_SIGNAL_EN2   (SDIO_SLAVE_REGS+0xA4)
/*#define  SDIO_SLAVE_PASS_127_96      (SDIO_SLAVE_REGS+0xA8)
#define  SDIO_SLAVE_PASS_95_64       (SDIO_SLAVE_REGS+0xAC)
#define  SDIO_SLAVE_PASS_63_32       (SDIO_SLAVE_REGS+0xB0)
#define  SDIO_SLAVE_PASS_31_0        (SDIO_SLAVE_REGS+0xB4)
#define  SDIO_SLAVE_ADMA_ERR_STATUS  (SDIO_SLAVE_REGS+0xB8)
#define  SDIO_SLAVE_RCA              (SDIO_SLAVE_REGS+0xBC)
#define  SDIO_SLAVE_DBG0             (SDIO_SLAVE_REGS+0xC0)
#define  SDIO_SLAVE_DBG1             (SDIO_SLAVE_REGS+0xC4)
#define  SDIO_SLAVE_DBG2             (SDIO_SLAVE_REGS+0xC8)
#define  SDIO_SLAVE_DBG3             (SDIO_SLAVE_REGS+0xCC)
#define  SDIO_SLAVE_DBG4             (SDIO_SLAVE_REGS+0xD0)
#define  SDIO_SLAVE_DBG5             (SDIO_SLAVE_REGS+0xD4)
#define  SDIO_SLAVE_DBG6             (SDIO_SLAVE_REGS+0xD8)
#define  SDIO_SLAVE_AHB              (SDIO_SLAVE_REGS+0xDC)
#define  SDIO_SLAVE_ARGU2            (SDIO_SLAVE_REGS+0xE0)*/


/*SDIO_SLAVE_INT_STATUS*/
#define SDIO_STS_B_C        (1<<31)	//BOOT COMPLETE
#define SDIO_STS_LRST       (1<<30)	//LRST
#define SDIO_STS_F_A        (1<<29)	//FUNCTIONX Abort
#define SDIO_STS_F_CRC_E    (1<<28)	//FunctionX CRC End Error
#define SDIO_STS_CMD_R1B    (1<<27)	//CMD R1B
#define SDIO_STS_CMD40      (1<<26)	//CMD40
#define SDIO_STS_PRG_ST     (1<<25)	//PROGRAM START
#define SDIO_STS_CMD11_C_ST (1<<24)	//CMD11 CLK START
#define SDIO_STS_CMD11_C_SP (1<<23)	//CMD11 CLK STOP
#define SDIO_STS_F2_R	    (1<<22)	//Funtion2 reset
#define SDIO_STS_F1_R	    (1<<21)	//Funtion1 reset
#define SDIO_STS_BS		    (1<<20)	//Boot Start
#define SDIO_STS_CMD4		(1<<19)	//CMD4
#define SDIO_STS_CMD20		(1<<17)	//CMD20
#define SDIO_STS_ACMD23		(1<<16)	//ACMD23
#define SDIO_STS_P_CSD		(1<<15)	//Program CSD interrupt
#define SDIO_STS_CMD6_SD	(1<<14)	//CMD6-Switch Done
#define SDIO_STS_CMD6_CD	(1<<13)	//CMD6-Check Done
#define SDIO_STS_CMD2_CMD52 (1<<12)	//Soft Reset
#define SDIO_STS_CMD11		(1<<11)	//Command11 Voltage switch interrupt
#define SDIO_STS_E		    (1<<10)	//Erase
#define SDIO_STS_FE		    (1<<9)	//Force Erase
#define SDIO_STS_UC	        (1<<8)	//Unlock Card
#define SDIO_STS_LC 		(1<<7)	//Lock Card
#define SDIO_STS_PR 		(1<<6)	//Password Reset
#define SDIO_STS_PS		    (1<<5)	//Password Set
#define SDIO_STS_RS 		(1<<4)	//Read Start
#define SDIO_STS_WS		    (1<<3)	//Write Start
#define SDIO_STS_SA		    (1<<2)	//Sleep awake
#define SDIO_STS_DMA1		(1<<1)	//Dma1 interrupt
#define SDIO_STS_TC 		(1<<0)	//Transfer Complete interrupt


void sdio_slave_process(void);



#endif /* __SDIO_DRV_H__ */


