

#include <config.h>
		
.globl RegionNumSet		
RegionNumSet:
	mcr		p15, 0, r0, c6, c2, 0		@set region number, select region
	mov	pc, lr

.globl 	RegionNumGet
RegionNumGet:
	mrc		p15, 0, r0, c6, c2, 0		@get region number
	mov	pc, lr

.globl 	RegionBaseSet
RegionBaseSet:							@set region base address
	bic		r0, r0, #0x1f
	mcr		p15, 0, r0, c6, c1, 0
	mov	pc, lr

.globl 	RegionBaseGet
RegionBaseGet:							@set region base address
	bic		r0, r0, #0x1f
	mrc		p15, 0, r0, c6, c1, 0
	mov	pc, lr

.globl 	RegionAttrSet	
RegionAttrSet:							@set region attribution
	mcr		p15, 0, r0, c6, c1, 4
	mov	pc, lr

.globl 	RegionAttrGet	
RegionAttrGet:							@get region attribution
	mcr		p15, 0, r0, c6, c1, 4
	mov	pc, lr

.globl 	RegionSizeSet	
RegionSizeSet:							@set size
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0x3e
	ORR		r1, r1, r0, lsl #1
	mcr		p15, 0, r1, c6, c1, 2
	mov	pc, lr

.globl 	SubRegionSet
SubRegionSet:							@sub-region	set
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0xff00
	ORR		r1, r1, r0, lsl #8
	DSB
	mcr		p15, 0, r1, c6, c1, 2
	ISB
	mov	pc, lr

.globl 	RegionSizeEnSet
RegionSizeEnSet:							@sub-region	set
	mcr		p15, 0, r0, c6, c1, 2
	DSB
	ISB
	mov	pc, lr

.globl 	RegionEn    
RegionEn:								@region enable
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0x1
	ORR		r1, r1, r0
	DSB
	mcr		p15, 0, r1, c6, c1, 2
	ISB
	mov	pc, lr

.globl 	RegionSizeGet
RegionSizeGet:							@get region size and enable reg	
	mrc		p15, 0, r0, c6, c1, 2 
	mov	pc, lr

.globl  MPUEnable		
MPUEnable:
	mrc		p15, 0, r0, c1, c0, 0
	ORR		r0, r0, #0x1
	DSB
	mcr		p15, 0, r0, c1, c0, 0
	ISB
	mov	pc, lr

.globl 	MPUDisable
MPUDisable:
	mrc		p15, 0, r0, c1, c0, 0
	bic		r0, r0, #0x1
	DSB
	mcr		p15, 0, r0, c1, c0, 0
	ISB
	mov	pc, lr

.globl 	MPUEn	
MPUEn:
	mrc		p15, 0, r1, c1, c0, 0
	bic		r1, r1, #0x1
	ORR		r1, r1, r0
	DSB
	mcr		p15, 0, r1, c1, c0, 0
	ISB
	mov	pc, lr

.globl 	MPURegionNum
MPURegionNum:
    mrc     p15, 0, r0, c0, c0, 4
    MOV     r0, r0, lsr #8
    mov	pc, lr

.globl 	MPUSizeSec
MPUSizeSec:
    CLZ     r1, r0
    MOV     r2, #31
    SUB     r0, r2, r1
    SUB     r0, r0, #1
    mov	pc, lr
    
