/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#include <common.h>
#include <asm/proc-armv/ptrace.h>
#include <asm/arch/hardware.h>
#include <asm/arch/timer.h> 
#include <div64.h>
#include <asm/arch/lsp_crpm.h>


#define TIMER_LOAD_VAL 0xffffffff       

#define RM_TIMER_SEL	RM_TIMER0_SEL
#define RM_TIMER_DIV	RM_TIMER0_DIV1


/* macro to read the 16 bit timer */
static inline ulong read_timer(void)
{
	return __REG(TIMER_COUNT_REG);
}

/* Internal tick units */
/* Last decremneter snapshot */
static unsigned long lastdec;
/* Monotonic incrementing timer */
static unsigned long long timestamp;

int timer_init(void)
{
    unsigned int reg = 0x0;
	unsigned int tmp = 0;

    __REG(RM_MOD_CLKSEL) |= RM_TIMER_SEL;   	/* SEL 26M clock*/
	tmp = __REG(RM_MOD_CLKDIV) & (~0xf);
    __REG(RM_MOD_CLKDIV) = tmp | RM_TIMER_DIV;    /* 12Ƶ,26M/12 ,udelay (100000);//test 3s*/
        
    __REG(TIMER_START_REG) = 0x0;                    /*  ֹͣ */
    __REG(TIMER_CONFIG_REG) &= 0x0;                  /*  mask Ϊ 0 */
    __REG(TIMER_CONFIG_REG) |= (PTV_DIV_1 | AUTO);   /*  ʱӷƵ 2Ƶ(->1M),Զװ */
    __REG(TIMER_LOAD_REG) = TIMER_LOAD_VAL;                

    reg = __REG(TIMER_SET_EN_REG);
    reg ^= 0xf;

    __REG(TIMER_SET_EN_REG) = reg;
    __REG(TIMER_START_REG) = TIMER_START; // ʼ
    
    lastdec = TIMER_LOAD_VAL;
	timestamp = 0;

	return 0;
}

/*
 * This function is derived from PowerPC code (read timebase as long long).
 * On ARM it just returns the timer value.
 */
unsigned long long get_ticks(void)
{
	ulong now = read_timer();

	//printf("clk_sel=0x%x, clk_div=0x%x, ptv_div=0x%x.\n", __REG(RM_MOD_CLKSEL), __REG(RM_MOD_CLKDIV), __REG(TIMER_CONFIG_REG));

	if (lastdec >= now) 
    {
		/* normal mode */
		timestamp += lastdec - now;
	} 
    else 
	{
		/* we have an overflow ... */
		timestamp += (TIMER_LOAD_VAL - (now - lastdec));
	}
	lastdec = now;

	return timestamp;
}


ulong get_timer(ulong base)
{
	return get_ticks()/26*(RM_TIMER_DIV+1) - base;
}

void __udelay(unsigned long usec)
{
	unsigned long long tmp;
	tmp = get_ticks() + usec*26/(RM_TIMER_DIV+1);	/* get current timestamp */
	while (get_ticks() < tmp)   /* loop till event */
		 /*NOP*/;
}
