/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:     cmd_getvar.c
 * File Mark:
 * Description:   get information such as IMEI,SN,NV CONFIG from UE.
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-3-6
 * History 1:
 *     Date:      2013-11-6
 *     Version:
 *     Author:
 *     Modification: mod for after-sale tool
 * History 2:
  ********************************************************************************/
/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include "downloader_serial.h"
#include <jffs2/load_kernel.h>
#include "downloader_nand.h"
#include "errno.h"

extern char *tsp_console_buffer;

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/*NVR AMT LENGTH*/
#define ZPS_ImeiLen                                    20
#define ZPS_ImeiSvLen                                  20
#define ZPS_DEV_MSINFO_MAX_BORDNAME_LEN                20
#define ZPS_DEV_MSINFO_MAX_MSerialNum_LEN              20
#define ZPS_DEV_MSINFO_MAX_ValidFlag_LEN               4
#define ZPS_DEV_MSINFO_MAX_InternalMAC_LEN             20
#define ZPS_DEV_MSINFO_MAX_ExternalMAC_LEN             20
#define ZPS_DEV_MSINFO_MAX_WIFIMAC_LEN                 20
#define ZPS_DEV_MSINFO_MAX_NvVersion_LEN               40
#define ZPS_DEV_MSINFO_MAX_TestInfo_LEN                200
#define ZPS_DEV_MSINFO_MAX_SOFTVERSION_LEN             10 
#define ZPS_NVR_LEN                                    394

/*NVRW AMT LENGTH*/
#define SoftVersion_LEN         10
#define Register_LEN            77
#define Bflag_LEN               1
#define Reserve_LEN             40
#define AfterSaleVersion_LEN    670
#define InerVersion_LEN         100
#define ExVersion_LEN           100
#define HWVersion_LEN           100
#define PCUIVersion_LEN         100
#define InerMdelNum_LEN         32
#define ExModelNum_LEN          32
#define ModemVersion_LEN        100
#define ZPS_NVRW_LEN            1362

/****************************************************************************
*							Local Types
****************************************************************************/
typedef struct
{
    unsigned int nvID;        /*NV file ID */
    unsigned char nvPart[4];  /* NV partition name,nvr or nvrw */
    unsigned int addr;        /*NV file address */
    unsigned int size;        /*NV file size*/
}Tsp_Nv_Config_Item;     /*NV CONFIG ITEM*/

#define TSP_NV_COUNT 7
Tsp_Nv_Config_Item tspNvConfig[TSP_NV_COUNT]=
{
{0,"nvro",0x0,16384},
{1,"nvro",0x4000,98304},
{2,"nvro",0x1c000,32768},
{3,"nvro",0x24000,16384},
{4,"nvro",0x28000,32768},
{5,"nvro",0x30000,32768},
{6,"nvro",0x38000,32768},
};


typedef struct getvar_info_nvr
{
     
	/********************************************************************************
        ܣ   Ӳ豸
        ȡֵΧIMEIÿһBCD뷶ΧΪ0-9
        ֵɳ̾
         *********************************************************************************/
    unsigned char    abImei[ZPS_ImeiLen]; 
    
	/********************************************************************************
          ܣ   汾
          ȡֵΧIMEISVÿһBCD뷶ΧΪ0-9
          ֵɳ̾
          *********************************************************************************/
    unsigned char    abImeiSv[ZPS_ImeiSvLen];
    
    /********************************************************************************
    ܣ   ţBCD
    ȡֵΧÿһBCD뷶ΧΪ0-9
    ֵɳ̾
    *********************************************************************************/
    unsigned char    abBordNum[ZPS_DEV_MSINFO_MAX_BORDNAME_LEN];
    
    /********************************************************************************
    ܣ   
    ȡֵΧַ,'\0'ʾ
    ֵɳ̾
    *********************************************************************************/
    unsigned char    abMSerialNum[ZPS_DEV_MSINFO_MAX_MSerialNum_LEN];
    
    /********************************************************************************
    ܣ  	MACַѡ־λ
    ȡֵΧ0x300x31ĬΪ0x30
    ֵ0x30
    *********************************************************************************/
    unsigned char	abValidFlag[ZPS_DEV_MSINFO_MAX_ValidFlag_LEN];
    
    /********************************************************************************
    ܣ   ڲMAC ַ
    ȡֵΧBCD
    ֵɴ汾״ʱд
    *********************************************************************************/
    unsigned char    abInternalMAC[ZPS_DEV_MSINFO_MAX_InternalMAC_LEN];
    
    /********************************************************************************
    ܣ   ⲿMAC ַ
    ȡֵΧBCD
    ֵɴ汾״ʱд
    *********************************************************************************/
    unsigned char    abExternalMAX[ZPS_DEV_MSINFO_MAX_ExternalMAC_LEN];
	
    /********************************************************************************
    ܣ   WIFI MACַ
    ȡֵΧBCD
    ֵɴ汾״ʱд
    *********************************************************************************/
    unsigned char    abWiFiMAC[ZPS_DEV_MSINFO_MAX_WIFIMAC_LEN];
   
    /********************************************************************************
    ܣ   ָʾNV汾
    ȡֵΧɼASCIIַַ'\0'ʣֽ0x00
    ֵɴ汾״ʱд
    *********************************************************************************/
    unsigned char    abNVVersion[ZPS_DEV_MSINFO_MAX_NvVersion_LEN];
    
    /********************************************************************************
    ܣ  Ա־λ
    ȡֵΧ
    ֵɴ汾״ʱд
    *********************************************************************************/
	unsigned char	 abTestInfo[ZPS_DEV_MSINFO_MAX_TestInfo_LEN];

}getvar_info_nvr_t;

typedef struct getvar_info_nvrw
{
     
	/********************************************************************************
        ܣ   汾
        ȡֵΧ
        ֵɳ̾
         *********************************************************************************/
    unsigned char    SoftVersion[SoftVersion_LEN]; 
	 
	/********************************************************************************
        ܣ   עϢ
        ȡֵΧ
        ֵɳ̾
         *********************************************************************************/              
    unsigned char    Register[Register_LEN];  
   	
	/********************************************************************************
	  ܣ	 BFLAGСϵͳģʽϢ
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/ 
	unsigned char	 Bflag[Bflag_LEN];
      
	/********************************************************************************
	  ܣ 
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/ 
    unsigned char   Reserve[Reserve_LEN];
   
	/********************************************************************************
	  ܣ ۺ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
	unsigned char   AfterSaleVersion[AfterSaleVersion_LEN];   
      
	/********************************************************************************
	  ܣ ڲ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    unsigned char   InerVersion[InerVersion_LEN];
	  
	/********************************************************************************
	  ܣⲿ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    unsigned char   ExVersion[ExVersion_LEN]; 
	   
	/********************************************************************************
	  ܣӲ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    unsigned char   HWVersion[HWVersion_LEN];
      
   /********************************************************************************
		 ܣPCUI 汾
		 ȡֵΧ
		 ֵɳ̾
    ********************************************************************************/
    unsigned char   PCUIVersion[PCUIVersion_LEN];
     
   /********************************************************************************
	  ܣڲͺ
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    unsigned char   InerMdelNum[InerMdelNum_LEN]; 
     
   /********************************************************************************
	  ܣⲿͺ
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    unsigned char   ExModelNum[ExModelNum_LEN]; 
     
   /********************************************************************************
	  ܣMODEM汾
	  ȡֵΧ
	  ֵɳ̾
      ********************************************************************************/
    unsigned char   ModemVersion[ModemVersion_LEN]; 
}getvar_info_nvrw_t;

typedef struct getvar_info_dl
{
    unsigned char    abImei[ZPS_ImeiLen];   
	/********************************************************************************
        ܣ   Ӳ豸
        ȡֵΧIMEIÿһBCD뷶ΧΪ0-9
        ֵɳ̾
         *********************************************************************************/
    unsigned char    abBordNum[ZPS_DEV_MSINFO_MAX_BORDNAME_LEN];
    /********************************************************************************
    ܣ   ţBCD
    ȡֵΧÿһBCD뷶ΧΪ0-9
    ֵɳ̾
    *********************************************************************************/
    unsigned char   InerVersion[InerVersion_LEN];   
	/********************************************************************************
	  ܣ ڲ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
	unsigned char   ExVersion[ExVersion_LEN];   
	/********************************************************************************
	  ܣⲿ汾
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
	unsigned char	InerMdelNum[InerMdelNum_LEN];	
   /********************************************************************************
	 ܣڲͺ
	 ȡֵΧ
	 ֵɳ̾
	********************************************************************************/

	unsigned char   ExModelNum[ExModelNum_LEN];   
   /********************************************************************************
	  ܣⲿͺ
	  ȡֵΧ
	  ֵɳ̾
	********************************************************************************/
    
}getvar_info_dl_t;

/*******************************************************************************
 * Function:do_getvar
 * Description:Sending UE information to After_sale update toll. 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:0 :success;
 *            -1:fail;
 *
 * Others:
 ********************************************************************************/ 
int do_getvar(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
#if 0 //hsy
    char *ack = NULL;
    char *cmd = NULL;
	int ret = 0;
	partition_entry_t *part = NULL;
	getvar_info_nvr_t *info_nvr = NULL;
	getvar_info_nvrw_t *info_nvrw = NULL;
	getvar_info_dl_t *info_dl = NULL;
	
	char *data_nvr = kzalloc(ZPS_NVR_LEN, GFP_KERNEL);
	char *data_nvrw = kzalloc(ZPS_NVRW_LEN, GFP_KERNEL);
	ack = tsp_console_buffer;
	info_dl = kzalloc(4096, GFP_KERNEL);
    cmd = argv[1];
    if (argc < 2)
    {
        return cmd_usage(cmdtp);
    }
	part = downloader_get_part("nvro");   /*NVR READ*/
	ret = downloader_zftl_read( part, 0, ZPS_NVR_LEN,  (unsigned char *)data_nvr);

	part = downloader_get_part("nvrw");  /*NVRW READ*/
	ret = downloader_zftl_read( part, 0, ZPS_NVRW_LEN,  (unsigned char *)data_nvrw);
	if(ret)
	{
        sprintf(ack,"FAIL ZFTL READ ");
        downloader_serial_write(ack, strlen(ack)+1);
        kfree(data_nvr);
        kfree(data_nvrw);
		kfree(info_dl);
        return ENOSYS;  /* Function not implemented */           
	}
	info_nvr = (getvar_info_nvr_t *)data_nvr;
	info_nvrw = (getvar_info_nvrw_t *)data_nvrw;

	memcpy(info_dl->abImei,info_nvr->abImei,ZPS_ImeiLen);     /*copy information from NV*/
    memcpy(info_dl->abBordNum,info_nvr->abBordNum,ZPS_DEV_MSINFO_MAX_BORDNAME_LEN);
	memcpy(info_dl->InerVersion,info_nvrw->InerVersion,InerVersion_LEN);
	memcpy(info_dl->ExVersion,info_nvrw->ExVersion,ExVersion_LEN);
	memcpy(info_dl->InerMdelNum,info_nvrw->InerMdelNum,InerMdelNum_LEN);
	memcpy(info_dl->ExModelNum,info_nvrw->ExModelNum,ExModelNum_LEN);

	if(strcmp(cmd,"version") == 0)
    {
		sprintf(ack,"DATA %08x",sizeof(getvar_info_dl_t));
		downloader_serial_write(ack, strlen(ack)+1);    /* send length info*/
		
		downloader_readline(tsp_console_buffer); 
	    if(memcmp(tsp_console_buffer,"OKAY",4)==0)               /* receive OKAY*/
	    {
            memcpy(ack,info_dl,sizeof(getvar_info_dl_t)); /* send information*/
		    downloader_serial_write_actuallen(ack,sizeof(getvar_info_dl_t));
	    }
		else
	    {
            sprintf(ack,"FAIL COMMAND ERROR");
            downloader_serial_write(ack, strlen(ack)+1);
	        return EBADRQC;		/* Invalid request code */
	    }
    }
	
    else if(strcmp(cmd,"nv")== 0)
    {
        sprintf(ack,"DATA %08x",sizeof(tspNvConfig)+1);
		downloader_serial_write(ack, strlen(ack)+1);    /* send length info*/

		downloader_readline(tsp_console_buffer); 
	    if(memcmp(tsp_console_buffer,"OKAY",4)==0)                /* receive OKAY*/
	    {
            ack[0] = TSP_NV_COUNT;
            memcpy(&ack[1],&tspNvConfig,sizeof(tspNvConfig)); /* send nv config*/
		    downloader_serial_write_actuallen(ack,sizeof(tspNvConfig)+1);
	    }
		else
	    {
            sprintf(ack,"FAIL COMMAND ERROR");
            downloader_serial_write(ack, strlen(ack)+1);
	        return EBADRQC;		/* Invalid request code */
	    }
    }
    else
    {
	    sprintf(ack,"FAIL NOINFORMATION");
        downloader_serial_write(ack,strlen(ack)+1);
		kfree(data_nvr);
        kfree(data_nvrw);
		kfree(info_dl);
        return -1;
    }
    kfree(data_nvr);
    kfree(data_nvrw);
	kfree(info_dl);
#endif

	return 0;
}
U_BOOT_CMD(
	getvar, CONFIG_SYS_MAXARGS, 0, do_getvar,
	"Downloader get information: getvar [info]",
	""
);



