/*********************************************************************
 Copyright 2016 by  ZIXC Corporation.
*
* FileName::    zx234290.c
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <command.h>
#include <malloc.h>
#include <asm/io.h>
#include <boot_mode.h>
#include <i2c.h>
#include <zx234502.h>



/*******************************************************************************
 * Function:    zx234290_i2c_read_reg
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234502_i2c_read_reg(ushort reg, uchar *val)
{
    return i2c_read(1, ZX234502_I2C_SLAVE_ADDR, reg, 8, val, 1);
}



/*******************************************************************************
 * Function:    zx234290_i2c_write_reg
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234502_i2c_write_reg(ushort reg, uchar *val)
{
    return i2c_write(1, ZX234502_I2C_SLAVE_ADDR, reg, 8, val, 1);
}

/*******************************************************************************
 * Function:    zx234502_boost_flag
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234502_boost_flag(int *boost_flag)
{
    int ret = 0;
    uchar reg = 0;


    ret = zx234502_i2c_read_reg(ZX234502_REG_PIS, &reg);
    if( ret != 0 ){
		printf( "[zx234502_boost_flag]ERROR!!\n");
        return 1;
    }
    printf( "    [zx234502_boost_flag][ZX234502_REG_PIS = 0x%x] ...\n", reg);

    *boost_flag = reg & ZX234502_REG_PIS_POWERON_IT_MASK;

    return 0;
}

/*******************************************************************************
 * Function:    zx234502_battery_status
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234502_battery_status(int *bat_state)
{
    int ret = 0;
    uchar reg = 0;

    ret = zx234502_i2c_read_reg(ZX234502_REG_CBIS, &reg);
    if( ret != 0 ){
		printf( "[zx234502_battery_status]ERROR!!\n");
        return 1;
    }
    printf( "    [zx234502_boost_flag][zx234502_battery_status = 0x%x] ...\n", reg);

    *bat_state = reg & ZX234502_REG_CBIS_NOBAT_MASK;

    return 0;
}

int zx234502_charger_enable()
{
	unsigned char  reg = 0;
	reg &= ~0xF;
	zx234502_i2c_write_reg(0, &reg);

    return 0;
}
