/*******************************************************************************
* Copyright (C) 2016, ZIXC Corporation.
*
* File Name:   hal_gpio.h
* File Mark:
* Description: 
* Others:
* Version:       v1.0
* Author:        zhangdongdong
* Date:          2015-07-31
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
********************************************************************************/

#ifndef _HAL_GPIO_H
#define _HAL_GPIO_H


/****************************************************************************
*                                           Include files
****************************************************************************/

/****************************************************************************
*                                           Macros
****************************************************************************/
#define reg32(addr)			(*(volatile unsigned long *)(addr))

#define get_reg_val(regAddr)            reg32(regAddr)
#define set_reg_val(regAddr,regVal)     reg32(regAddr) = regVal

#define set_reg_bit(regName, bitAddr, bitValue)      \
do{                                                  \
    if(bitValue == TRUE)                             \
        reg32(regName) |= (0x1<<bitAddr);            \
    else                                             \
        reg32(regName) &= ~(0x1<<bitAddr);           \
}while(0)

#define set_reg_bits(regName, bitsAddr, bitsLen, bitsValue)   \
do{                                                             \
    reg32(regName) = (reg32(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);\
}while(0)

#define INVLID_ADDR 0xffffffff
#define INVLID_VALUE 0xffff
/****************************************************************************
*                                           Types
****************************************************************************/

typedef signed char SINT8;
typedef unsigned char UINT8;

typedef signed short SINT16;
typedef unsigned short UINT16;

typedef signed int SINT32;
typedef unsigned int UINT32;
typedef signed char  CHAR;

typedef struct _T_GpioRegCfgInfo
{
    UINT32 regBase;          /*gpio operation register base address*/
    UINT16 offset;           /*gpio operation domain offset in register*/
    UINT16 size;             /*gpio operation domain size*/
} T_GpioRegCfgInfo;

typedef struct _T_Gpio
{
    const char name[22];                     /*gpio name*/
    const UINT32 gpio;
    UINT32 flag;
    const T_GpioRegCfgInfo pdFuncSel;        /*gpio pd func sel*/
    const T_GpioRegCfgInfo aonFuncSel;       /*gpio aon func sel*/
    const T_GpioRegCfgInfo topFuncSel;       /*gpio top func sel, 0:aon  1:pd*/
    const T_GpioRegCfgInfo ioCfg;            /*gpio config*/
} T_Gpio;

typedef enum{
	
	NAND_WE             = 0  ,
	NAND_CSN            = 1  ,
	NAND_READY          = 2  ,
	NAND_CLE_            = 3  ,
	NAND_ALE_            = 4  ,
	NAND_RE             = 5  ,
	NAND_WP             = 6  ,
	NAND_DATA0          = 7  ,
	NAND_DATA1          = 8  ,
	NAND_DATA2          = 9  ,
	NAND_DATA3          = 10 ,
	NAND_DATA4          = 11 ,
	NAND_DATA5          = 12 ,
	NAND_DATA6          = 13 ,
	NAND_DATA7          = 14 ,
	CLK_OUT0            = 15 ,
	CLK_OUT1            = 16 ,
	CLK_OUT2            = 17 ,
	CLK_32K_OUT         = 18 ,
	RMII_CLK_I			= 19 ,
	RMII_CLK_O			= 20 ,
	CLK_REQ0			= 21,
	CLK_REQ1			= 22,
	PWR_CTRL			= 23 ,
	PS_HOLD				= 24 ,
	SSP0_CS 			= 25 ,
	SSP0_CLK			= 26 ,
	SSP0_RXD			= 27,
	SSP0_TXD			= 28 ,
	UART0_RXD			= 29 ,
	UART0_TXD			= 30 ,
	UART0_CTS			= 31 ,
	UART0_RTS			= 32 ,
	UART1_RXD			= 33 ,
	UART1_TXD			= 34 ,
	I2S0_WS 			= 35 ,
	I2S0_CLK			= 36 ,
	I2S0_DIN			= 37 ,
	I2S0_DOUT			= 38 ,
	I2S1_WS 			= 39 ,
	I2S1_CLK			= 40 ,
	I2S1_DIN			= 41 ,
	I2S1_DOUT			= 42 ,
	SCL0				= 43 ,
	SDA0				= 44 ,
	SCL1				= 45 ,
	SDA1				= 46 ,
	EXT_INT0			= 47 ,
	EXT_INT1			= 48 ,
	EXT_INT2			= 49 ,
	EXT_INT3			= 50 ,
	EXT_INT4			= 51 ,
	EXT_INT5			= 52 ,
	EXT_INT6			= 53 ,
	EXT_INT7			= 54 ,
	RMII_TXEN			= 55 ,
	RMII_RXEN			= 56 ,
	RMII_RXD0			= 57 ,
	RMII_RXD1			= 58 ,
	RMII_TXD0			= 59,
	RMII_TXD1			= 60,
	MDC_SCLK			= 61,
	MDC_SDIO			= 62,
	PHY_RST				= 63,
	PHY_INT				= 64,
	PHY_WAKE			= 65,
	SD0_CLK 			= 66 ,
	SD0_CMD 			= 67 ,
	SD0_DATA0			= 68 ,
	SD0_DATA1			= 69 ,
	SD0_DATA2			= 70 ,
	SD0_DATA3			= 71,
	SD1_CLK 			= 72 ,
	SD1_CMD 			= 73 ,
	SD1_DATA0			= 74 ,
	SD1_DATA1			= 75 ,
	SD1_DATA2			= 76 ,
	SD1_DATA3			= 77,
	JTAG_TCK			= 78 ,
	JTAG_TDI			= 79 ,
	JTAG_TDO			= 80 ,
	JTAG_TMS			= 81 ,
	JTAG_TRST			= 82 ,
	KBC_0				= 83 ,
	KBC_1				= 84 ,
	KBR_0				= 85 ,
	KBR_1				= 86 ,
	CAM_SPI_CS			= 87 ,
	CAM_SPI_CLK		= 88 ,
	CAM_SPI_DATA0		= 89 ,
	CAM_SPI_DATA1		= 90 ,
	CAM_SPI_DATA2		= 91 ,
	CAM_SPI_DATA3		= 92 ,
	SPIFC_CS			= 93 ,
	SPIFC_CLK			= 94 ,
	SPIFC_DATA0		= 95 ,
	SPIFC_DATA1		= 96 ,
	SPIFC_DATA2		= 97 ,
	SPIFC_DATA3		= 98 ,
	RESETB_OUT			= 99 ,
	RF_SPI_STR			= 100 ,
	RF_SPI_CLK 		= 101 ,	
	RF_SPI_DATA		= 102 ,
	RF_ISOLATE_EN 		= 103 ,
	RF_CONTROL0 		= 104,
	RF_CONTROL1 		= 105,
	RF_CONTROL2 		= 106,
	RF_CONTROL3 		= 107,
	RF_CONTROL4 		= 108,
	RF_CONTROL5 		= 109,
	RF_CONTROL6 		= 110,
	RF_CONTROL7 		= 111,
	RF_CONTROL8 		= 112,
	RF_CONTROL9 		= 113,
	RF_CONTROL10		= 114,
	RF_CONTROL11		= 115,
	RF_CONTROL12		= 116,
	RF_CONTROL13		= 117,
	RF_CONTROL14		= 118,
	SIM_RST				= 119,
	SIM_CLK				= 120,
	SIM_DATA 			= 121,
	GPIO_119         	= 122 ,
	GPIO_120         	= 123 ,
	GPIO_121          	= 124 ,
	GPIO_122          	= 125 ,
	GPIO_123          	= 126 ,
	GPIO_124          	= 127 ,
	GPIO_125          	= 128 ,
	GPIO_126          	= 129 ,
	GPIO_127          	= 130 ,
	GPIO_128          	= 131 ,
	GPIO_129          	= 132 ,
	GPIO_130          	= 133 ,
	GPIO_131          	= 134 ,
	GPIO_132          	= 135 ,
}T_ZDrvGpio_Name;

#endif

