/*********************************************************************
 Copyright 2016 by  ZIXC Corporation.
*
* FileName::    partition.c
* File Mark:
* Description:  
* Others:
* Version:   v1.0
* Author:   zhouqi
* Date:   2014-1-15

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <command.h>
#include <malloc.h>
#include <jffs2/load_kernel.h>
#include <linux/list.h>
#include <linux/ctype.h>
#include <linux/err.h>
#include <linux/mtd/mtd.h>
#include <nand.h>  
#include <linux/mtd/partitions.h>
#include <asm/io.h>  
#include <load_image.h>
#include <boot_mode.h>
#include <config.h>
#include <boot_mode.h>
#include <../drivers/hash/drv_hash.h>
#include <../drivers/rsa/drv_rsa.h>
#include <../drivers/hash/sha256.h>
#include <secure_verify.h>
#include <asm/arch/efuse.h>

#define DEFINE_PARTITION_TABLE
#include <partition_table.h>      
#include <boot_mode.h>


#if defined(CONFIG_CMD_NAND)
#include <linux/mtd/nand.h>
#include <nand.h>
#endif

#include <linux/mtd/nor_spifc.h>

u_char * g_table = NULL;                        /* ȡķϢ 2k+64 */
partition_table_t * g_partition_table = NULL;   /* ָϢ */
extern partition_table_t * g_partition_table_dl;
extern struct fsl_qspi spi_nor_flash;
extern unsigned int guiOtpStatus;
extern unsigned int guiEfuseStatus;

//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC) || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
extern int imagefs_flag;
#endif

unsigned char key_hash[128] = {0};
unsigned char *bin2hex(const unsigned char *old, const size_t oldlen)
{
    size_t i, j;
    int b = 0;

    for (i = j = 0; i < oldlen; i++)
    {
        b = old[i] >> 4;
        key_hash[j++] = (char)(87 + b + (((b - 10) >> 31) & -39));
        b = old[i] & 0xf;
        key_hash[j++] = (char)(87 + b + (((b - 10) >> 31) & -39));
    }
    key_hash[j] = '\0';
    return key_hash;
}


/* ================================================================================
 *  add_partition_to_bootargs  :  ӷϢ bootargs
 */
// #ifdef CONFIG_ZX297520V3E_MDL_AB
 #if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC) || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
 void add_partition_to_bootargs( void )
{
	int ret = 0;
	uint32_t part_nums = 0;
	uint32_t i = 0;
	uint32_t start_entry = 0;               /*  */
	uchar bootargs_cmd[1024] = {0};
	uchar bootargs_cmd_cap[1024] = {0};
	uchar boot_reason_para[32] = {0};
	uchar boot_mode_para[16] = {0};
	uint32_t otp_pubkey_hash[8] = {0};
	uint32_t efuse_pubkey_hash[4] = {0};
	uint32_t uiHashResLen = 0;
	unsigned int *poweron_type = (unsigned int *)POWERON_TYPE_ADDR;  //ʱʹ
	
	part_nums = g_partition_table->entrys;    

	partition_entry_t * entry = &g_partition_table->table[0];

	if(g_nor_flag == 1)
	{
	    sha256_csum_wd((const unsigned char *)OTP_SECURE_PUK_BASE, 380, (unsigned char *)otp_pubkey_hash);
		bin2hex((unsigned char *)otp_pubkey_hash, 32);
	}   
	else
	{
        Hash_Calculate(HASH_MODE_MD5, HASH_SMALL_ENDIAN, CFG_SECURE_PUK_ADDR, 256, NULL, 0, efuse_pubkey_hash, &uiHashResLen);
		bin2hex((unsigned char *)efuse_pubkey_hash, 16);
	}
	
	/* console=ttyS1,115200 no_console_suspend */
	sprintf((char *)bootargs_cmd, "console=ttyS1,921600 no_console_suspend ");
    sprintf((char *)bootargs_cmd_cap, "console=ttyS1,921600n8 earlycon no_console_suspend ");

	if(g_nor_flag == 1)
	{
        sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "EnhancedSecurity=1 ");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "EnhancedSecurity=1 ");
		if(guiOtpStatus == 0)
		{
			sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "pubkeyhash=");
		    sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), key_hash);

		}	
	}
	else
	{
	    sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "EnhancedSecurity=0 ");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "EnhancedSecurity=0 ");
		if(guiEfuseStatus == 0)
		{
			sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "pubkeyhash=");
            sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), key_hash);
		}
	}
	/* denali-nand: */
	if(read_boot_flashtype() == IF_TYPE_NAND)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=denali-nand:");
	}
	else if (read_boot_flashtype() == IF_TYPE_SPI_NAND)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=spi-nand:");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " mtdparts=spi0.0:");
	}
	else if (read_boot_flashtype() == IF_TYPE_NOR)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=spi-nor-dt:");
	}

	/* ȥ2 ddr raw */
	for( i=0; i<part_nums-VIRTUAL_PART_NUM-1; i++ )
	{
		if( (entry->part_size >= 0x100000) && (entry->part_size%0x100000 == 0) )
		{
			sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dm@0x%lx(%s),", 
				(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
			sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "%dm@0x%lx(%s),", 
				(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
		}
		else
		{
			sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dk@0x%lx(%s),", 
				 (entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
			sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "%dk@0x%lx(%s),", 
				 (entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
		}

		/* ȡ */
		//if(read_fota_update_flag())
		if(imagefs_flag == 1)
		{
			if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_ROOTFS_IMAGE ) )
			{
				start_entry = i;
			}
		}
		else if(imagefs_flag == 2)
		{
			if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_ROOTFS2_IMAGE ) )
			{
				start_entry = i;
			}
		}

		entry++;
	}

	/* ȡ */ 
	if(imagefs_flag == 1)    
    {
		if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_ROOTFS_IMAGE) )
		{
			start_entry = i + 1;
		}
	}
	else if(imagefs_flag == 2)   
	{
		if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_ROOTFS2_IMAGE ) )
		{
			start_entry = i + 1;
		}
	}

	/* һ */
	if( (entry->part_size >= 0x100000) && (entry->part_size%0x100000 == 0) )
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dm@0x%lx(%s)",
			(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "%dm@0x%lx(%s)",
			(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
	}
	else
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dk@0x%lx(%s)",
			(entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), "%dk@0x%lx(%s)",
			(entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
	}
	
	/* rootfs=/dev/mtdblock7 rootfs2=/dev/mtdblock8 */
    sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), 
		" root=/dev/mtdblock%d ro rootfstype=jffs2", start_entry);

	//sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), 
		//" rdinit=/sbin/init ubi.block=0,vol_rootfs root=/dev/ubiblock0_0 rootfstype=squashfs");

	printf("rootfs%d entry...\n",start_entry);

	if(RB_AMT == read_boot_reason())
	{
		*poweron_type = POWER_ON_AMT;
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " boot_reason=%d", *poweron_type);
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " bootmode=amt");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " boot_reason=%d", *poweron_type);
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " bootmode=amt");
	}
	else
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " boot_reason=%d", *poweron_type);
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " boot_reason=%d", *poweron_type);
	}
	BOOT_PRINTF(UBOOT_INFO, "CONFIG_SYS_START_FLAG_ADDR = 0x%x, poweron_type = 0x%x.\n",
		 POWERON_TYPE_ADDR, *poweron_type);

	if(imagefs_flag == 1)    
   	{
#ifdef DM_VERITY
        sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=system_a");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " system=system_a");
#else
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=system_a");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " system=system_a ubi.mtd=caprootfs");
#endif
	}
	else if(imagefs_flag == 2)   
	{
#ifdef DM_VERITY
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=system_b");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " system=system_b");
#else
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=system_b");
		sprintf((char *)bootargs_cmd_cap + strlen(bootargs_cmd_cap), " system=system_b ubi.mtd=caprootfs2");
#endif
	}	

	/* save */
	setenv("bootargs", (char *)bootargs_cmd);
	setenv("bootargs_cap", (char *)bootargs_cmd_cap);
}
#else
void add_partition_to_bootargs( void )
{
	int ret = 0;
	uint32_t part_nums = 0;
	uint32_t i = 0;
	uint32_t start_entry = 0;               /*  */
	uchar bootargs_cmd[1024] = {0};
	uchar boot_reason_para[32] = {0};
	uchar boot_mode_para[16] = {0};
	unsigned int *poweron_type = (unsigned int *)POWERON_TYPE_ADDR;  //ʱʹ
	
	part_nums = g_partition_table->entrys;    

	partition_entry_t * entry = &g_partition_table->table[0];

	/* console=ttyS1,115200 no_console_suspend */
	sprintf((char *)bootargs_cmd, "console=ttyS1,921600 no_console_suspend");

	sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " EnhancedSecurity=0");
	
	/* denali-nand: */
	if(read_boot_flashtype() == IF_TYPE_NAND)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=denali-nand:");
	}
	else if (read_boot_flashtype() == IF_TYPE_SPI_NAND)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=spi-nand:");
	}
	else if (read_boot_flashtype() == IF_TYPE_NOR)
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " mtdparts=spi-nor-dt:");
	}

	/* ȥ2 ddr raw */
	for( i=0; i<part_nums-VIRTUAL_PART_NUM-1; i++ )
	{
		if( (entry->part_size >= 0x100000) && (entry->part_size%0x100000 == 0) )
		{
			sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dm@0x%lx(%s),", 
				(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
		}
		else
		{
			sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dk@0x%lx(%s),", 
				 (entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
		}

		/* ȡ */
		if(read_fota_update_flag())
		{
			if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_RECOVERY_USERDATA_IMAGE ) )
			{
				start_entry = i;
			}
		}
		else
		{
			if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_USERDATA_IMAGE ) )
			{
				start_entry = i;
			}
		}

		entry++;
	}

	/* ȡ */ 
	if(read_fota_update_flag())    /* 3ʾFOTA-RECOVERY */
    	{
		if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_RECOVERY_USERDATA_IMAGE) )
		{
			start_entry = i + 1;
		}
	}
	else    /*  */
	{
		if ( 0 == strcmp( (char *)entry->part_name, (char *)ARM_USERDATA_IMAGE ) )
		{
			start_entry = i + 1;
		}
	}

	/* һ */
	if( (entry->part_size >= 0x100000) && (entry->part_size%0x100000 == 0) )
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dm@0x%lx(%s)",
			(entry->part_size) >> 20, (entry->part_offset), (entry->part_name));
	}
	else
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), "%dk@0x%lx(%s)",
			(entry->part_size) >> 10, (entry->part_offset), (entry->part_name));
	}
	 
	if(RB_AMT == read_boot_reason())
	{
		*poweron_type = POWER_ON_AMT;
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " boot_reason=%d", *poweron_type);
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " bootmode=amt");
	}
	else
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " boot_reason=%d", *poweron_type);
	}
	BOOT_PRINTF(UBOOT_INFO, "CONFIG_SYS_START_FLAG_ADDR = 0x%x, poweron_type = 0x%x.\n",
		 POWERON_TYPE_ADDR, *poweron_type);

    if(read_fota_update_flag())    
   	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=recovery");
	}
	else  
	{
		sprintf((char *)bootargs_cmd + strlen(bootargs_cmd), " system=normal");
	}	
	
	/* save */
	setenv("bootargs", (char *)bootargs_cmd);
}
#endif
/*******************************************************************************
 * Function:    read_partition_and_check
 * Description: FLASHжȡ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * @return 0        :  ȡЧ
 * @return 1        :  ȡЧ
 *
 * Others:
 ********************************************************************************/
int read_partition_and_check( void )
{
	struct flash_ops *flash = NULL;
	nand_info_t *nand = &nand_info[nand_curr_device];
	int table_size = 2048;
	int ret = 0;
	int type = 0;
	int buf_size = 0;
	struct fsl_qspi *nor;

	nor = &spi_nor_flash;
    
	flash = get_flash_ops();
	type = read_boot_flashtype();
	if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
	{
		buf_size = nand->writesize + nand->oobsize;
	}
	else if(type == IF_TYPE_NOR)
	{
		buf_size = table_size;
	}
	
	g_table = (u_char *)kzalloc(buf_size, GFP_KERNEL);
	if ( g_table == NULL ) 
	{
		BOOT_PRINTF(UBOOT_ERR, "kzalloc Failed!\n");
		return -EIO;
	}
    
	/* ȡ */
	/*
    +------------------------------------------------------------+
    |       z-load.bin                 |    partition_table.bin  |                
    +------------------------------------------------------------+
                                       8k           one page     10k
    */ 
    if(g_nor_flag == 1)
	{
        if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
		{
			ret = flash->read_with_ecc(nand, (loff_t)0x8000, &table_size, g_table);
			if(ret)
			{
				BOOT_PRINTF(UBOOT_ERR, "read_no_ecc Failed! ret = %d.\n", ret);
				return -1;
			}
		}
		else if(type == IF_TYPE_NOR)
		{
			ret = nand_read(&(nor->nor[0].mtd), (loff_t)0x8000, &table_size, g_table);
			if(ret)
			{
				BOOT_PRINTF(UBOOT_ERR, "nand_read error! ret = %d.\n", ret);
				return -1;
			}
		}
	}
	else
	{
	     if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
		{
			ret = flash->read_with_ecc(nand, (loff_t)8*1024, &table_size, g_table);
			if(ret)
			{
				BOOT_PRINTF(UBOOT_ERR, "read_no_ecc Failed! ret = %d.\n", ret);
				return -1;
			}
		}
		else if(type == IF_TYPE_NOR)
		{
			ret = nand_read(&(nor->nor[0].mtd), (loff_t)8*1024, &table_size, g_table);
			if(ret)
			{
				BOOT_PRINTF(UBOOT_ERR, "nand_read error! ret = %d.\n", ret);
				return -1;
			}
		}
	}

	g_partition_table = (partition_table_t *)g_table;
	if( g_partition_table->magic != PARTITION_MAGIC )
	{
		BOOT_PRINTF(UBOOT_ERR, "Partition Table Invalid! ret = %d.\n", ret);
		return -EIO; 
	}

	return SUCCESS;
}


/*******************************************************************************
 * Function:    find_partition_para
 * Description:  ͨҷ׵ַ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/ 
partition_entry_t * find_partition_para( uchar * name )
{
	partition_entry_t *entry = NULL;
	uint32_t entry_nums = 0;
	
	if(get_load_mode() == TLOAD_MODE) 
	{
		entry = &g_partition_table_dl->table[0];
		entry_nums = g_partition_table_dl->entrys;
	}
	else
	{
		entry = &g_partition_table->table[0];
		entry_nums = g_partition_table->entrys;
	}
	while( entry_nums-- )
	{
		if ( strcmp( (char *)entry->part_name, (char *)name ) == 0 )
		{
			return entry;
		}
		entry++;
	}
	return NULL;
}

/*******************************************************************************
 * Function:    partition_init
 * Description:  ͨҷ׵ַ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/ 
int partition_init(void)
{
	int ret = 0;

	ret = read_partition_and_check();

	if( ret != 0 )
	{
		BOOT_PRINTF(UBOOT_ERR, "read_partition ERROR !!!\n");
		return -1;
	}

	return 0;
}


