/******************************************************************/
#include <usb/global.h>
#include <usb/dwc_otg_driver.h>
#include <usb/drv_usb3slave.h>
#include <asm/arch/cpu.h>
#include <asm/io.h>
#include <config.h>


#define SYS_SOC_MOD_CLKSEL         (SYS_SOC_CRM_BASE+0x54)
#define SYS_SOC_MOD_RSTEN          (SYS_SOC_CRM_BASE+0x8c)          
#define SYS_SOC_MOD_USBSTATECTRL   (SYS_SOC_CRM_BASE+0x90)

#define ST_WAIT_SYNC_FLAG   (0x0)
#define ST_WAIT_REG_CONFIG  (0x1)
#define ST_REG_CONFIG       (0x2)
#define ST_WAIT_DOWNLOAD    (0x3)
#define ST_DOWNLOAD_HEAD    (0x4)
#define ST_DOWNLOAD_DATA    (0x5)
#define ST_DOWNLOAD_ADDR    (0x6)

#define SYNC_FLAG           (0x5a) // "Z"
#define REG_CONFIG_FLAG     (0x6a) // ""
#define DOWNLOAD_FLAG       (0x7a) // "z"
#define RUN_FLAG            (0x8a) // ""
#define GET_ID			    (0x9a) // new added

WORD32 Para_Section SyncACK=0xa5;
__align(4) BYTE Para_Section CHIP_ID[8]={'Z','X','7','5','2','0','V','2'};
WORD32 Para_Section  UsbACK = 0;

extern void udelay(unsigned long usec);
void USB_isr(WORD32 dwIntNo,WORD32 dwPara);

void Out_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen);


void In_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen);



void usdelay(unsigned us)
{
	udelay(us);
}

static inline void delay0(unsigned long loops)
{
    /*
	__asm__ volatile ("1:\n" "subs %0, %1, #1\n"
			  "bne 1b":"=r" (loops):"0"(loops));
	*/
}
static inline void udelay0(unsigned long us)
{
	delay0(us * 200); /* approximate */
}

void usbdelay(unsigned us)
{
	udelay0(us);
}

void USB_TstDev_Isr(void)
{
    USB_isr(0,0);    //жϷ
}


WORD32 USB_RecvOutData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{
    dwc_otg_pcd_ep_t *ep = NULL;
    ep = &(global.g_dwc_otg_dev_t.pcd->out_ep[dwEPNo-1]);
    ep->dwc_ep.is_in = 0;
    ep->dwc_ep.num = dwEPNo;
    ep->dwc_ep.data_pid_start = 0;
    ep->dwc_ep.tx_fifo_num = dwEPNo;
    ep->dwc_ep.start_xfer_buff = pchBuf;
    ep->dwc_ep.xfer_buff = pchBuf;
    ep->dwc_ep.xfer_len = 0;
    ep->dwc_ep.xfer_count = 0;
    ep->dwc_ep.fnUsbCb = fnUsbCb;
    ep->dwc_ep.pPara = pPara;
    ep->dwc_ep.total_len = dwLen;
    dwc_otg_ep_start_transfer(global.g_dwc_otg_dev_t.core_if,&ep->dwc_ep);
    return 0;
}

WORD32 USB_SendInData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{
    dwc_otg_pcd_ep_t *ep = NULL;
    ep = &(global.g_dwc_otg_dev_t.pcd->in_ep[dwEPNo-1]);
    ep->dwc_ep.is_in = 1;
    ep->dwc_ep.num = dwEPNo;
    ep->dwc_ep.data_pid_start = 0;
    ep->dwc_ep.tx_fifo_num = dwEPNo;
    ep->dwc_ep.start_xfer_buff = pchBuf;
    ep->dwc_ep.xfer_buff = pchBuf;
    ep->dwc_ep.fnUsbCb = fnUsbCb;
    ep->dwc_ep.pPara = pPara;
    ep->dwc_ep.xfer_len = 0;
    ep->dwc_ep.xfer_count = 0;
    ep->dwc_ep.total_len = dwLen;
    dwc_otg_ep_start_transfer(global.g_dwc_otg_dev_t.core_if,&ep->dwc_ep);
    return 0;
}


WORD32 usb_read(WORD32 dwLen, BYTE *pchBuf)
{
	WORD32 dwDone;

	global.dwRxQuit=0;
	USB_RecvOutData( 1,(BYTE *)pchBuf,dwLen,Out_callback,(void *)&dwDone);
	while(!global.dwRxQuit)
	{
        USB_TstDev_Isr();
	}
	return dwDone;
}


WORD32 usb_write(WORD32 dwLen, BYTE *pchBuf)
{
	WORD32 dwDone;

	global.dwTxQuit=0;
	USB_SendInData(1,pchBuf, dwLen, In_callback,(void *)&dwDone);
	while(!global.dwTxQuit)
	{

    		USB_TstDev_Isr();
	}

	return dwDone;
}

#if 0
WORD32 USB_Check_Sync(BYTE *pchBuf, WORD32 dwLen)
{
	WORD32 dwDone;
	WORD32 dwCount = 0;

	global.dwRxQuit=0;
	printf("########USB_RecvOutData start##########\n");
	USB_RecvOutData( 1,(BYTE *)pchBuf,dwLen,Out_callback,(void *)&dwDone);
	printf("########USB_RecvOutData end##########\n");
	dwCount=0;
	while(1)
	{
        USB_TstDev_Isr();
		if(0==global.dwRxQuit)
		{
			dwCount++;
			if(dwCount>(200*global.g_USB_TIMEOUT))
			{
				//return 0;
			}
#if SIM_EN
        	//usbdelay(5000);
#else
            usbdelay(1);
#endif
		}
		else
		{
		    printf("global.dwRxQuit == 1 \n");
			break;
		}
	}
    printf("########5a##########\n");
	if(0x5A!=*pchBuf)
	{
	    printf("0x5A!=*pchBuf \n");
		return 0;
	}
    printf("########end 5a##########\n");
	return dwDone;
}
#endif

#if 0
char the_write_data;
void Boot_Process(BYTE *pkt,int len)
{
    int i=0;
    static int count=0;
    static int addr;
    static int value;
    char cTmp=0;
    //WORD32 SyncACK=0xa5;
    int case_state;
    if(0==len)
        return ;
    while(i<len)
    {
        cTmp=pkt[i++];
		the_write_data=cTmp;
        printf("usb_booting 0 \n");
           case_state = global.g_State;
           if( ST_WAIT_SYNC_FLAG == case_state)
           	{
           	  printf("usb_booting 1 \n");
                if(SYNC_FLAG==cTmp)
                {   
                    printf("get 5A  \n");
                    global.g_State=ST_WAIT_DOWNLOAD;
#if CFG_USB
                    printf("usb_write A5\n");
                    usb_write(1,(BYTE *)&SyncACK);
					 printf("usb_write A5 over\n");
#else
                    printf(" CFG_USB ==0  \n");
                    UART_Write((BYTE *)&SyncACK,1);
#endif
                }
           	}
		   	else if(GET_ID==cTmp)//ȡоƬID
	        {
#if CFG_USB
                    usb_write(8,(BYTE*)CHIP_ID);
#else
                    UART_Write((BYTE *)CHIP_ID,8);
#endif	            
	        }
            else if(ST_REG_CONFIG ==case_state)
            	{
                if(count<4)    // 4 bytes addr
                {
                    addr<<=8;
                    addr|=cTmp;
                }
                else if(count<8)    // 4 byte data
                {
                    value<<=8;
                    value|=cTmp;
                }

                count++;

                if(4==count)
                {
                    if(0==addr)
                    {
                       global.g_State=ST_WAIT_DOWNLOAD;
					   UsbACK=0xA6;
#if CFG_USB					  
                       usb_write(1,&UsbACK);
#else
						UART_Write(&UsbACK,1);
#endif
                    }
                }
                else if(8==count)
                {
                    REG32(addr)=value;
                    count=0;
                }

            	}
            else if (ST_WAIT_DOWNLOAD==case_state)
            	{
                if(REG_CONFIG_FLAG==cTmp)
                {
                    global.g_State=ST_REG_CONFIG;
                    count=0;
                }
                else if(DOWNLOAD_FLAG==cTmp)
                {
                    global.g_State=ST_DOWNLOAD_HEAD;
                    count=0;
                    value=0;
                }
                else if(RUN_FLAG==cTmp)    //ֶ֧0818
                {
                    global.g_State=ST_DOWNLOAD_ADDR;
                    count=0;
                    value=0;
                }
            	}
            else if( ST_DOWNLOAD_HEAD==case_state)
            	{
                if(count<4)    // 4 byte addr
                {
                    addr<<=8;
                    addr|=cTmp;
                }
                else if(count<8) // 4 byte size
                {
                    value<<=8;
                    value|=cTmp;
                }

                count++;

                if(count==8)
                {
                    count=0;
                    global.g_bootaddr=addr; //ַ
                    global.g_bootsize=value;//
                    global.g_State=ST_DOWNLOAD_DATA;
					UsbACK=0xA1;
                    usb_write(1,&UsbACK);
                }
            	}
            else if( ST_DOWNLOAD_DATA==case_state)
            	{
                if(global.g_bootsize==len)
                {
                    if(global.g_bootaddr==(int)pkt)
                        {
                        global.g_State=ST_WAIT_DOWNLOAD;//ֶ֧0818
                        UsbACK=0xA7;
						usb_write(1,&UsbACK);
                            return;
                        }
                    }
                    else
                    {
                    global.g_bootaddr+=len;
                    global.g_bootsize-=len;
                        return ;
                }
            	}
            else if( ST_DOWNLOAD_ADDR==case_state)
            	{
                if(count<4)    // 4 byte addr
                {
                    addr<<=8;
                    addr|=cTmp;
                }

                count++;

                if(count==4)
                {
                    count=0;
                    global.g_bootaddr=addr;
                    global.g_bootfinish=1;
					UsbACK=0xA8;
                    usb_write(1,&UsbACK);
                    return ;
                }
            	}
		else
		{

		}

           }
     
}
#endif

__align(4) BYTE Para_Section tmp[64]={0};


#if 0   //loaderµã
void USB_Boot(void)
{
    WORD32			dwLen;
    WORD32  		dwMaxLen;
    BYTE 			*pbyBuf;
    printf("######enter USB_Boot#####\n");
    global.g_State	= ST_WAIT_SYNC_FLAG;
    pbyBuf 			= (BYTE*)tmp;

    for(dwMaxLen = 0; dwMaxLen < 64; dwMaxLen++)
    {
    	tmp[dwMaxLen] = 0;
    }

	dwMaxLen = 512;  //Ҫbulk outʱճȴڵ512
/* usb_mode =1ʱHSIC,usb_mode =0ʱUSB */
    if(global.g_USB_MODE == 0)
    {
        printf("########USB_Check_Sync##########\n");
		dwLen=USB_Check_Sync(pbyBuf,dwMaxLen);

        if(0==dwLen)
        {
            return ;
        }
        printf("0!=dwLen,enter boot_process\n"); 

        Boot_Process(pbyBuf,dwLen);
    }
	printf("########globalfinish##########\n");
    while(0 == global.g_bootfinish)
    {
        //dwLen=usb_read(pbyBuf,dwMaxLen);
        dwLen=usb_read(dwMaxLen,pbyBuf);

        Boot_Process(pbyBuf,dwLen);

        if((ST_DOWNLOAD_DATA==global.g_State)&&(global.g_bootaddr!=0))
        {
            pbyBuf=(BYTE *)global.g_bootaddr;
            dwMaxLen=512;//global.g_bootsize;
        }
        else
        {
            pbyBuf=tmp;
            dwMaxLen=512;//յַϢ
        }

    }

    if(1==global.g_bootfinish)
    {
       #if 0 /*shield dma function*/
        dwc_otg_core_dev_disconnet(global.g_dwc_otg_pcd_tp.core_if);
        printf("disconnect usb controller\n");
	#endif
    	writel(0xE59ff000, SYS_IRAM1_BASE);                 /* תr7ִtboot */
        writel(global.g_bootaddr, SYS_IRAM1_BASE + 8); 
	    printf("Starting the t-boot ...\n");
        writel(0xf, CPU_A9_SUBSYS_CFG);
    }
}
#endif

void usb_boot(WORD32 USB_ADDR)
{
    global.g_USB_TIMEOUT = 0xff;

    //printf( "#######tsp_usb_init...\n");
    tsp_usb_init();  /*ΧöTLOADERUSB˿*/
	//printf("tsp_usb_init...end\n");
	
    //USB_Boot();    /*usb bootģʽ*/
}


void USB_isr(WORD32 dwIntNo,WORD32 dwPara)
{
    dwc_otg_pcd_handle_intr(global.g_dwc_otg_dev_t.pcd);
}

#if 0
void USB_Pll_Clk_Rst_InitEnv(void)
{

#if ((SIM_EN == ASIC)||(SIM_EN == EMULATION))

    WORD32 i;
    if(0 == global.g_pll_cfg)
    {
	//add pll config
	    REG32(SYS_SOC_CRM_BASE+0x30)  = 0x1ffff;    //pll_MAIN lock need delay time
	    REG32(SYS_SOC_CRM_BASE+0x34)  = 0x1ffff;    //pll_U lock need delay time for HSIC
	//open pll_624_MainPll
	    REG32(SYS_SOC_CRM_BASE+0x14) &= 0xffffffff;
	    REG32(SYS_SOC_CRM_BASE+0x10) &= 0x7fffffff;
    
	    i = 0;
	    do
	    {
	        i++;
	        usdelay(PLL_8X(40));
	        if(i>50000) 
	        {
	            printk("E1");
	            break;
	        }
	    }while((REG32(SYS_SOC_CRM_BASE+0x10)&0x40000000) ==0);

	 //HSIC need pll_480   
	    if(1 == global.g_USB_MODE)
	    {
	        //open pll_480
	        REG32(SYS_SOC_CRM_BASE+0x24) &= 0xffffffff;
	        REG32(SYS_SOC_CRM_BASE+0x20) &= 0x7fffffff;

	        i = 0;
	        do
	        {
	            i++;
	            usdelay(PLL_8X(40));
	            if(i>50000) 
	            {
	                printk("E2");
	                break;
	            }
	        }while((REG32(SYS_SOC_CRM_BASE+0x20)&0x40000000) ==0);
	    }
 
	// m0 and axi clk sel config ,M0 208M,axi 156M
	    REG32(SYS_SOC_CRM_BASE+0x50) &= (~0x7);    //0:m0 sel pll_208   1:mclk
	    REG32(SYS_STD_CRM_BASE+0x0) &= (~0x7);    //0:axi  sel 156m    1:mclk
    
#if SIM_EN == EMULATION
		/* 1.pin mux*/
		REG32(SYS_PAD_CTRL0_BASE+0x7c)&= 0x3ff00000;
		REG32(SYS_PAD_CTRL0_BASE+0x80)&= (~0x3ff);
		REG32(SYS_PAD_CTRL0_BASE+0x84)&= 0x3ff00000;
		REG32(SYS_PAD_CTRL0_BASE+0x74)&= 0xc00ffc00; 	   
		REG32(SYS_PAD_CTRL0_BASE+0x88)&= (~0xffc00);

		/* 2.out or in enable*/
		REG32(0x145000)&=0xff00;   //in
		REG32(0x145000+0x40)|=0xff; //out		
#endif
    } 
    if(0 == global.g_USB_MODE)
    {

        REG32(SYS_SOC_MOD_RSTEN)|=(0x3<<5);
        usdelay(10);    
        //select bus clk early
        REG32(SYS_SOC_MOD_CLKSEL) &= ~0x3;
        //release usb  phy reset 
        usdelay(10);
        REG32(SYS_SOC_MOD_RSTEN) |= 1<<4;     
    }
    else if(1 == global.g_USB_MODE)
    {
        REG32(SYS_SOC_MOD_RSTEN)|=(0x3<<1);
        usdelay(10);
        //select bus clk early
        REG32(SYS_SOC_MOD_CLKSEL) &= ~0x3;  /*0:156M*/
        usdelay(10);
        //release usb hsic phy reset 
        REG32(SYS_SOC_MOD_RSTEN) |= 0x1;
        usdelay(100);
        i = 0;
        while((REG32(SYS_SOC_MOD_USBSTATECTRL)&0x1) == 0)
        {
            i++;
            usdelay(20);
            if(i>250000) 
            {
                printk("E4");
                break;
            }
        }
#if SIM_EN == EMULATION
	   usdelay(20);
	   REG32(REG_GPIO_OUT)=1;
//		 while(REG32(REG_GPIO_IN)!=0xFF);
	   usdelay(1);
	   REG32(REG_GPIO_OUT)=0;
#endif	   

    }
    else if(2 == global.g_USB_MODE)
    {
		REG32(SYS_LSP_CRM_BASE+0x28) &= (~(0x7<<4)); /*0:104M 1:26M,2:52M,4:156M*/
        usdelay(10);
        REG32(SYS_STD_CRM_BASE+0x4)&= ~0x3;  /*div 0:1 1:2 4:4*/
        usdelay(10);
    }

#elif (SIM_EN == FPGA)
    if(0 == global.g_USB_MODE)
    {

        REG32(SYS_SOC_MOD_RSTEN)|=(0x3<<5);
        usdelay(10);    
        //select bus clk early
        REG32(SYS_SOC_MOD_CLKSEL) &= ~0x3;
        //release usb  phy reset 
        usdelay(10);
        REG32(SYS_SOC_MOD_RSTEN) |= 1<<4;     
    }

#endif
}
#endif

T_USB_ENUM USB_Need_Enum(WORD32 USB_ADDR)
{
	WORD32 temp = 0;
	temp = DWC_READ_REG32(USB_ADDR+0x14);
	if(((temp>>13)|1)==1)
	{
		return DONOT_NEED_ENUM;
	}
	return NEED_ENUM;
}
unsigned int g_testVal = 0;

WORD32 USB_CDC_Enum(WORD32 USB_ADDR)
{
	WORD32 dwCount=0;
	WORD32 dwCount1=0;
	if(NEED_ENUM == global.g_enum)
	{
		global.g_Connet = 0;
	}
	else
	{
        	global.g_Connet = 1;
	}

	global.g_USB_TIMEOUT	= 10;

	g_testVal = 20/5;
	dwc_otg_driver_probe(USB_ADDR);
	if(global.g_enum == NEED_ENUM)
	{
	 //printk("enuming\n");
	while (1)
	{
	//poll mode or interrupt mode
		USB_TstDev_Isr();
#if SYNC_SETADDRESS
	    if (global.g_dwc_otg_dev_t.pcd->request_config == 2)
	    break;
#else
	    //ȴ̬
		if (global.g_dwc_otg_dev_t.pcd->request_config == 1)
			break;
#endif
/* usb_mode =1ʱHSIC,usb_mode =0ʱUSB */
	    if(global.g_USB_MODE == 0)
        {
		    if(0==global.g_Connet)
	        {
			   dwCount++;
#if SIM_EN
			   usbdelay(5000);
#else
               usbdelay(1);
#endif
			   if(dwCount>(400*global.g_USB_TIMEOUT))
			   {
				   //return 1;
			   }
		    }
#if SYNC_SETADDRESS            
	        else if(global.g_dwc_otg_dev_t.pcd->request_config == 2)
#else
            else if(global.g_dwc_otg_dev_t.pcd->request_config == 1)
#endif
	        {
	        	break;
	        }
		    else
		    {
			    dwCount1++;
#if SIM_EN
			    //usbdelay(5000);
#else
                usbdelay(1);
#endif
			    if(dwCount1>(200*global.g_USB_TIMEOUT))
			    {
				    //return 1;  huhuahong
			    }
	        }
        }
     }
		}
     return 0;
}

void Out_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen)
{
	*((WORD32 *)dwPara) = dwDone;
	global.dwRxQuit	= 1;
#if SIM_EN == EMULATION
    REG32(ARM_PORTA)=0x81;
#endif

}

void In_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen)
{
	*((WORD32 *)dwPara) = dwDone;
	global.dwTxQuit	= 1;
#if SIM_EN == EMULATION
        REG32(ARM_PORTA)=0x83;
#endif
}


//tangjian:usb3.0ݶд
extern WORD32 USB3_RecvOutData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara);
extern WORD32 USB3_SendInData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara);
extern void USB3Slave_ISR(u32 udIntNo,u32 udPara);
extern u32 USB3Slave_IsNeedZero(u32 dwLen);









int dwc_otg_driver_probe(WORD32 USB_ADDR)
{
    uint32_t udj = 0;
    uint32_t *ptbase = (uint32_t *)USB_ADDR;
    uint8_t* ptg_dwc_otg_dev_t = (uint8_t* )(&global.g_dwc_otg_dev_t);
	
    for(udj= 0;udj<sizeof(global.g_dwc_otg_dev_t);udj++)
    {
       ptg_dwc_otg_dev_t[udj] = 0;
    }
    global.g_dwc_otg_dev_t.core_if = dwc_otg_cil_init(ptbase);

    /*
    * Initialize the DWC_otg core.
    */
    dwc_otg_core_init(global.g_dwc_otg_dev_t.core_if);
    /*
     * Initialize the PCD,pcd_initժ
     */
    global.g_dwc_otg_dev_t.pcd = dwc_otg_pcd_init(global.g_dwc_otg_dev_t.core_if);

#if SYNC_USB_CTRL
    REG32(ARM_PORTA)=0x22; 
#endif

#if SIM_EN == EMULATION
	//for hsic
	REG32(REG_GPIO_OUT)=2;
	//while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;
#endif
	global.g_dwc_otg_dev_t.pcd->otg_dev = (&global.g_dwc_otg_dev_t);
	if(global.g_enum == NEED_ENUM)
	{
		DWC_MODIFY_REG32(&global.g_dwc_otg_dev_t.core_if->core_global_regs->gahbcfg, 0, 1);
	} 
	 return 0;
}


