/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#ifndef __POWER_H__
#define __POWER_H__

#include <boot_mode.h> 


/* PMUӿں */
struct pmu_opt{
    int (*read_reg)(ushort reg, uchar *val);
    int (*write_reg)(ushort reg, uchar *val);
    int (*get_boot_reason)(boot_reason_t *boot_reason);
    int (*ps_hold_pull_on)(void);
    int (*ps_hold_pull_off)(void);
    int (*ps_hold2_pull_on)(void);
    int (*ps_hold2_pull_off)(void);
    int (*power_off)(void);
    
};

int pmu_init(void);
int power_init(void);
int register_pmu_opt(struct pmu_opt *opt);
struct pmu_opt * get_pmu_opt(void);


#endif	/* __POWER_H__ */
