/*********************************************************************
 Copyright 2016 by  ZXIC Corporation.
*
* FileName::    spi_fc.h
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 2014.1.15
*     Version:
*     Author: zhouqi
*     Modification:
* History 2:
**********************************************************************/

#ifndef __SPI_FC_H__
#define __SPI_FC_H__


#define SYS_SPI_NAND_BASE           0x01407000

    
struct spi_t
{
    uint32_t     VER_REG;                        //0x00
    uint32_t     SFC_START;                      //0x04
    uint32_t     SFC_EN;                         //0x08
	uint32_t	 SFC_CTRL0;						//0x0c 
	uint32_t	 SFC_CTRL1;						//0x10
	uint32_t	 SFC_CTRL2;						//0x14 
	uint32_t	 SFC_BYTE_NUM;					//0x18
	uint32_t	 SFC_ADDR;						//0x1c
	uint32_t	 SFC_INS;						//0x20
	uint32_t	 SFC_TIMING;					//0x24
	uint32_t	 SFC_INT_EN;					//0x28
    uint32_t     SFC_INT_RAW;                    //0x2c
    uint32_t     SFC_INT_SW_CLR;                 //0x30
    uint32_t     SFC_SW;                         //0x34
    uint32_t     SFC_DATA;                       //0x38
};

/*spifc start 0x4*/
#define     FC_START      (1<<0)
#define     FC_BUSY       (1<<0)

/*spifc enable 0x8*/
#define     FC_EN_BACK          (1<<1)
#define     FC_EN               (1<<0)

/*spifc main ctr0 0xc*/
#define     FC_SCLK_PAUSE_CLR_ALLOW     (1<<17)
#define     FC_SCLK_PAUSE_EN            (1<<16)
#define     FC_TXFIFO_CLR               (1<<15)
#define     FC_RXFIFO_CLR               (1<<14)
#define     FC_TXFIFO_THRES             (1<<10)
#define     FC_RXFIFO_THRES             (1<<6)
#define     FC_TX_DMA_EN                (1<<5)
#define     FC_RX_DMA_EN                (1<<4)
#define     FC_WDOG_EN                  (1<<3)
#define     FC_SPI_MODE                 (1<<1)
#define     FC_WR_PROTECT               (1<<0)

/*spifc ctrl1 0x10  in the condition : SFC_EN = 1 SFC_BUSY = 0*/
#define     FC_ADDR_TX_EN           (4)
#define     FC_DUMMY_TX_EN          (2)
#define     FC_READ_DAT_EN          (1)
#define     FC_WRITE_DAT_EN         (0)

/*spifc ctrl2 0x14*/
#define     FC_DUMMY_BYTE_NUM           (12)  /* [12:15} */
#define     FC_DUMMY_BIT_NUM            (8)   /* [8:10] */
#define     FC_ADDR_BYTE_NUM            (5)   /* [5:6] */
#define         FC_ADDR_BYTE_NUM_8             (0) 
#define         FC_ADDR_BYTE_NUM_16            (1) 
#define         FC_ADDR_BYTE_NUM_24            (2)  
#define         FC_ADDR_BYTE_NUM_32            (3)   
#define     FC_ADDR_MULTI_LINE_EN       (1<<4)
#define     FC_DAT_MULTI_LINE_EN        (1<<2)
#define     FC_TRANS_MOD                (1<<0)

/*spifc timing 0x24*/
#define     FC_READ_DELAY           (1<<16)   /* [17:16} */
#define     FC_T_CS_SETUP           (1<<11)   /* [11:13} */
#define     FC_T_CS_HOLD            (1<<6)    /* [8:6} */
#define     FC_T_CS_DESEL           (1<<0)    /* [0:3} */


/*spifc int enable 0x28*/
#define     FC_INT_EN_TX_BYD_THES           (1<<7)
#define     FC_INT_EN_RX_BYD_THES           (1<<6)
#define     FC_INT_EN_TX_UNDERRUN           (1<<5)
#define     FC_INT_EN_RX_OVERRUN            (1<<4)
#define     FC_INT_EN_WDOG_OVERRUN          (1<<2)
#define     FC_INT_EN_FMT_ERR               (1<<1)
#define     FC_INT_EN_CMD_END               (1<<0)

/*spifc raw interrupt 0x2c*/
#define     FC_INT_RAW_TX_BYD_THES           (1<<7)
#define     FC_INT_RAW_RX_BYD_THES           (1<<6)
#define     FC_INT_RAW_TX_UNDERRUN           (1<<5)
#define     FC_INT_RAW_RX_OVERRUN            (1<<4)
#define     FC_INT_RAW_WDOG_OVERRUN          (1<<2)
#define     FC_INT_RAW_FMT_ERR               (1<<1)
#define     FC_INT_RAW_CMD_END               (1<<0)
#define     FC_INT_RAW_MASK              	 (FC_INT_RAW_TX_UNDERRUN|	\
                                              FC_INT_RAW_RX_OVERRUN|	\
                                              FC_INT_RAW_WDOG_OVERRUN|	\
                                              FC_INT_RAW_FMT_ERR|		\
                                              FC_INT_RAW_CMD_END)

/*spifc int startus and clr 0x30*/
#define     FC_INT_CLR_TX_BYD_THES           (1<<7)
#define     FC_INT_CLR_RX_BYD_THES           (1<<6)
#define     FC_INT_CLR_TX_UNDERRUN           (1<<5)
#define     FC_INT_CLR_RX_OVERRUN            (1<<4)
#define     FC_INT_CLR_WDOG_OVERRUN          (1<<2)
#define     FC_INT_CLR_FMT_ERR               (1<<1)
#define     FC_INT_CLR_CMD_END               (1<<0)

/*spifc sw 0x34*/
#define     FC_TX_FIFO_CNT              (16)         /* [16:20} */
#define         FC_TX_FIFO_CNT_MASK         (0x1F)      /* [8:12} */
#define     FC_RX_FIFO_CNT              (8)             /* [8:12} */
#define         FC_RX_FIFO_CNT_MASK         (0x1F)      /* [8:12} */
#define     FC_TX_BYD_THRES             (1<<5)  
#define     FC_RX_BYD_THRES             (1<<4)  
#define     FC_SCLK_PAUSE_FLAG          (1<<3)  
#define     FC_WAIT_FLAG                (1<<2) 
#define     FC_FORMAT_ERR               (1<<1)  


#define         FC_DMA_NONE           0
#define         FC_DMA_TX             1
#define         FC_DMA_RX             2


#define ADDR_TX_EN      1   /* ַ뷢ʹ */
#define ADDR_TX_DIS     0
#define DATA_TX_EN      1
#define DATA_TX_DIS     0
#define DATA_RX_EN      1
#define DATA_RX_DIS     0
#define DUMY_TX_EN      1
#define DUMY_TX_DIS     0

#define ADDR_WIDTH_8    0
#define ADDR_WIDTH_16   1
#define ADDR_WIDTH_24   2
#define ADDR_WIDTH_32   3

struct spiflash_cmd_t
{
    uint8_t cmd;			/* ָ */
    uint8_t addr_tx_en;     /* ַ뷢ʹ */
    uint8_t addr_width;     /* ַ */
    uint8_t data_tx_en;     /* ʹ---д */
    uint8_t data_rx_en;     /* ʹ--- */
    uint8_t dumy_tx_en;     /* еȴʹ */
    uint8_t dumy_bytes;     /* еȴ x8 */
    uint8_t dumy_bits;      /* еȴ x1 */
};


/* SPI NAND CMD */
#define CMD_WRITE_ENABLE            0x06
#define CMD_WRITE_DISABLE           0x04
#define CMD_GET_FEATURE		        0x0F
#define CMD_SET_FEATURE		        0x1F

#define CMD_READ_PAGE_TO_CACHE	     0x13
#define CMD_READ_FROM_CACHE          0x03
//#define CMD_READ_FROM_CACHE_X2       0x3B
#define CMD_READ_FROM_CACHE_X4       0x6B
#define CMD_READ_FROM_CACHE_QIO      0xEB

#define CMD_READ_ID		            0x9F
#define     ID_ADDR0		            0x00
#define     ID_ADDR1		            0x01

#define CMD_PROGRAM_LOAD		    0x02
#define CMD_PROGRAM_LOAD_X4		    0x32

#define CMD_PROGRAM_EXECUTE		    0x10
//#define CMD_PROGRAM_LOAD_RANDOM      0x84
//#define CMD_PROGRAM_LOAD_RANDOM_X4   0xC4
//#define CMD_PROGRAM_LOAD_RANDOM_QIO  0x72

#define CMD_BLOCK_ERASE             0xD8

#define CMD_RESET                   0xFF

//fpga
#define CMD_READ_BYTE					0x03
#define CMD_READ_TO_CACHE				0x13
#define CMD_GET_FEATURE				0x0F
#define CMD_END							0x00//unused cmd
#define OIP_BIT		(1<<0)


#define SINGLE_MODE 0
//#define DUAL_MODE   1
#define RDX4_MODE    2
#define RDQIO_MODE   3
#define PLX4_MODE    4

/*read and write mode configuration*/
//#define RD_MODE  RDX4_MODE
#define RD_MODE  RDQIO_MODE
//#define RD_MODE  SINGLE_MODE
#define WR_MODE  PLX4_MODE

/* SPI NAND REGISTER */
#define REG_PROTECTION              0xA0
#define REG_FEATURE                 0xB0
#define ECC_EN                      (0x1<<4)
#define QE                          0x0
#define REG_STATUS                  0xC0
#define ECC_ERR_BIT                 (0x4)        /* ECC ERR */
#define ECC_ERR_MASK                (0x3<<4)     /* ECC ERR */
#define P_FAIL                      (0x1<<3)     /* program fail*/
#define E_FAIL                      (0x1<<2)     /* erase fail */
#define WEL                         (0x1<<1)     /* Write Enable Latch */
#define OIP                         (0x1<<0)     /* Operation In Progress */

#define WRAP_SIZE_MAIN_OOB         (0x0<<12)      /* 2048 +64 = 2112 */
#define WRAP_SIZE_MAIN             (0x4<<12)      /* 2048 */
#define WRAP_SIZE_OOB			   (0x8<<12)      /* 64 */
#define WRAP_SIZE_MINI			   (0xC<<12)      /* 16 */


/*spi flash 豸ṹ*/
struct spi_flash_device_para
{
	uint8_t		manuf_id;             /* ID */
	uint8_t 		device_id;            /* 豸ID */
	uint8_t 		res_id;               /* ID */
	uint16_t  	page_size;            /* ÿҳmainС */
	uint16_t  	page_size_shift;      
	uint16_t  	oob_size;             /* ÿҳspareС */
	uint16_t  	block_size_shift;
	uint16_t  	block_num;            /*  */
	uint32_t  	block_size;           /* ÿĴС */
	uint32_t		planes;
};

#endif	/* __SPI_FC_H__ */

