/*
 * (C) Copyright 2016 ZXIC Inc.
 *
 */

#include <config.h>
#include <board.h>
#include <load_mode.h>

.globl stack_setup

stack:
#if (CONFIG_DL_DISABLE)
	.word	0x045A0000    /* DL port: 0x5A->Disable. */
#else
	.word	0x04000000    /* DL port: 0x00->Enable. */
#endif
	.word	0x3537585A    /* = string "57XZ" */
	.word	0x31563132    /* = string "1V12" */
	.word	0x00001E70	  /* zdata size = 8K - HdrSize = 8192 - 400 = 7792 Bytes = 0x1E70*/

	/* NOT used now, Just reverse memory for RSA/HASH in near future. */
	.word	0x00000000    /*puk_rsa_d*/
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000

	.word	0x00000000    /*puk_rsa_n*/
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000

	.word	0x00000000    /*hash_y*/
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000
	.word	0x00000000	/* VID+PID */
#if defined(CFG_ZLOAD)
	.word	0x00102800
	.word	_start - 0x100000 + 0x8A001    /* TBD: MACRO instead of number. */
#else
	.word	0x0008A000
	.word	_start + 0x1
#endif
	.word	loop + 1
	.word	loop + 1
	
.globl _bss_start
_bss_start:
	.word __bss_start
	nop
	nop

.globl _bss_end
_bss_end:
	.word __bss_end

.globl _para_start
_para_start:
	.word __para_start

.globl _para_end
_para_end:
	.word __para_end
	
.globl _start
_start:
	
#if defined(CFG_ZLOAD)
	/* check stage1 state */
	ldr	r3,=CFG_START_STAGE1_ADDR
	ldr	r4,=CFG_START_STAGE1_STATE
	ldr	r5, [r3]
	cmp r4, r5
	beq set_stack
	
	ldr	r0, =0x8a000
	msr	MSP, r0
	
	bl copy_to_iram1
	ldr	r3,=0x1001B1    /* 0x1b1 = 0x194(header len) + 0x1c(first Ins. offset) + 0x1(16bit thumb instruction) */
	mov	pc,r3
set_stack:
	/* Set up the stack */
	ldr	r2, =0x100000
	ldr	r3,=0x194    /*header len=0x194*/
	add	r2,r3
	ldr	r0, [r2]
	msr	MSP, r0

#else

	/* Set up the stack */
	ldr	r2, =stack
	ldr	r3,=0x194    /*header len=0x194*/
	add	r2,r3
	ldr	r0, [r2]
	msr	MSP, r0

#endif    /* CFG_ZLOAD */	

/* clear the bss */
clear_bss:
	ldr 	r3, =_bss_start
	ldr	r0, [r3]       /* find start of bss segment     */
	ldr 	r3, =_bss_end
	ldr	r1, [r3]       /* stop here                     */
	cmp	r0, r1
	beq	clbss_over
	mov 	r2, #0x0   /* clear value                   */
clbss_l:
	str	r2, [r0]       /* clear BSS location            */
	add	r0, r0, #4     /* increment clear index pointer */
	cmp	r0, r1         /* are we at the end yet         */	
	bne	clbss_l        /* keep clearing till at end     */
clbss_over:

/* remove the para section */
	ldr	r3, =_para_start
	ldr 	r4, [r3]
	ldr	r3, =_para_end
	ldr 	r1, [r3]
	sub	r1, r1, r4
	ldr 	r3, =_bss_end	
	ldr	r0, [r3]
	add	r1, r1, r0
	cmp	r0, r1
	beq	remove_over
re_move:	
	ldr	r2, [r0]
	str	r2, [r4]
	add 	r4, r4, #4
	add	r0, r0, #4    /* increment clear index pointer    */
	cmp	r0, r1        /* are we at the end yet            */	
	bne	re_move
remove_over:

	b	start_armboot

loop:
	b loop

