#include "global.h"

__align(4) const dwc_config_all_t  desc =
{
//T_CONFIG_DESCRIPTOR
{
	sizeof(dwc_config_descriptor_t),				//bLength
	CONFIG_DESCRIPTOR,							//bDescriptorType
	sizeof(dwc_config_all_t),
	2,											//bNumInterfaces
	1,											//bConfigurationValue
	0,											//iConfigurationַ
	ATTR_D7 |ATTR_SELF_POWERED ,	//bmAttributes
	POWER_MA(500),											//
},


//T_INTERFACE_DESCRIPTOR
{
	sizeof(dwc_interface_descriptor_t),		//bLength
	INTERFACE_DESCRIPTOR,				//bDescriptorType
	0,									//bInterfaceNumber
	0,									//bAlternateSetting
	0x02,						//bNumEndpoints
	VERDOR_SPECIFIC,					//bInterfaceClass
	0xff,								//bInterfaceSubClass
	0xff,								//bInterfaceProtocol
	0x04,									//iInterfaceַ
},

{
	sizeof(dwc_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	EP_ADDRESS_DIRECTION_IN	|0x1, 	//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	USB_HIGHSPEED_BULK_MAXSIZE, 		   //wMaxPacketSize
	0,								//bInterval
},
{
	sizeof(dwc_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	0x1, 							//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	USB_HIGHSPEED_BULK_MAXSIZE, 		 //wMaxPacketSize
	0,							//bInterval
},
//T_INTERFACE_DESCRIPTOR
{
    sizeof(dwc_interface_descriptor_t),		//bLength
    INTERFACE_DESCRIPTOR,				//bDescriptorType
    1,									//bInterfaceNumber
    0,									//bAlternateSetting
    0x02,						//bNumEndpoints
    VERDOR_SPECIFIC,					//bInterfaceClass
    0xff,								//bInterfaceSubClass
    0xff,								//bInterfaceProtocol
    0x05,									//iInterfaceַ
},

{
	sizeof(dwc_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	EP_ADDRESS_DIRECTION_IN	|0x2, 	//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	USB_HIGHSPEED_BULK_MAXSIZE, 	      //wMaxPacketSize
	0,								//bInterval
},

{
	sizeof(dwc_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	0x2, 							//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	USB_HIGHSPEED_BULK_MAXSIZE, 	     //wMaxPacketSize
	0,							//bInterval
},
};


struct g_data	  					global;

__align(4) dwc_config_all_t g_config_desc;

void data_init(void)
{
	int i;
	char *src 	= (char*)&desc;
	char *dst	= (char*)&g_config_desc;

	for(i = 0; i < sizeof(dwc_config_all_t); i++)
	{
		*dst++	= *src++;
	}
}


