/*
 * Copyright (C) 2016 ZXIC Inc.
 *
 */

#include <common.h>
#include <asm/arch/uart.h>
#include <asm/io.h>
#include <asm/arch/top_clock.h>
#include <asm/arch/gpio.h>

#define CONFIG_BAUDRATE 921600

/*******************************************************************************
 * Function:    serial_gpio_config
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
static void serial_gpio_config(void)
{
#ifdef CONFIG_ZX297520V3E_CPE
	unsigned int tmp = 0;
	/*uart0_cts----->uart1_txd*/
	__REG(PAD_TOP_FUNC_BASE+0x20) |= (1<<2);
	tmp = __REG(PAD_PD_FUNC_BASE+0x4);
	tmp &= ~(0x3<<2);
	__REG(PAD_PD_FUNC_BASE+0x4) = tmp | (0x1<<2);

	/*uart0_rts----->uart1_rxd*/
    __REG(PAD_TOP_FUNC_BASE+0x20) |= (1<<3);
	tmp = __REG(PAD_PD_FUNC_BASE+0x4);
	tmp &= ~(0x3<<4);
	__REG(PAD_PD_FUNC_BASE+0x4) = tmp | (0x1<<4);

#endif
}

/*******************************************************************************
 * Function: 
 * Description: ôڵĲ
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
static void serial_setbrg(void)
{
    u32 uartClk = 26000000;
    u32 ibrd = uartClk / (CONFIG_BAUDRATE << 4);
    u32 fbrd = (((uartClk-((ibrd*CONFIG_BAUDRATE)<<4))<<6)+(CONFIG_BAUDRATE<<3))/(CONFIG_BAUDRATE<<4);
    __REG(UART_IBRD) = ibrd;
    __REG(UART_FBRD) = fbrd;  
    #if 0
    if( __REG(PLL_624_208_CFG0_REG) & PLL_624_208_CFG0_LOCK )  
    {
        __REG(UART_IBRD) = 0x38;
        __REG(UART_FBRD) = 0x1b;
    }            
    else
    {
        __REG(UART_IBRD) = 0x2;     /* midify !!! */
        __REG(UART_FBRD) = 0x16;
    }    
    #endif
}


/*******************************************************************************
 * Function: 
 * Description: ʼڲ  115200
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
void uart_init(void)
{
	int count = 3000;

	while(__REG(UART_FR) & UART_FR_TXBUSY){

		if(--count == 0)
		{
			break;
		}
	}
	
	/* Ÿ */
	serial_gpio_config();

	/*  UART */
	__REG(UART_ICR) = 0xffff;
	__REG(UART_CR) &= (~(UART_EN | UART_TXE)); 

	

	/*   */
	serial_setbrg();    

	/*  ôʽΪ: У/1λֹͣλ/8λλ/ʹ FIFO ĴʼΪ 0x0 */
	__REG(UART_LCR_H) &= (~(UART_BREAK | UART_PEN | UART_STP2 ));
	__REG(UART_LCR_H) |= (UART_WLEN_8 | UART_FEN );

	/*  еuartģ鷢ж */
	__REG(UART_IMSC) &= (~UART_INT_MASK);

	/*  ʹUART */
	__REG(UART_CR) |= (UART_TXE | UART_EN ); 

}



/*******************************************************************************
 * Function:    uart_putc
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
 void uart_putc(const char c)
{
	/* ȴ FIFO д */
	while ((__REG(UART_FR) & UART_TXFF) != 0 );
    __REG(UART_DR) = c;
    
	/* If \n, also do \r */
	if (c == '\n')
		uart_putc('\r');
}


/*******************************************************************************
 * Function:    uart_puts
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
void uart_puts (const char *s)
{
	while (*s) {
		uart_putc (*s++);
	}
}

/*******************************************************************************
 * Function:    uart_getc
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
char uart_getc(void)
{
	while ((__REG(UART_FR) & UART_RXFE) != 0 );
	return (__REG(UART_DR) & 0xff);
}

/*******************************************************************************
 * Function:    uart_tstc
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
int uart_tstc(void)
{
    if( __REG(UART_FR) & UART_RXFE )
        return 0;       //1ʱFIFOΪգû
    else
        return 1;       //0ʱFIFOΪգ;
}

/*******************************************************************************
 * Function: 
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/

int UART_Read(char *pchBuf, int dwLen)
{
    int i = 0;
	for(i=0;i<dwLen;i++)
	{
	    pchBuf[i] = (char)uart_getc();
	}

	return dwLen;
}

/*******************************************************************************
 * Function: 
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/

int UART_Write(char *pchBuf, int dwLen)

{
	int i = 0;
	for(i=0;i<dwLen;i++)
	{
	    uart_putc(pchBuf[i]);
	}

	return dwLen;
}

int UART_Check_Sync(char *pchBuf, int dwLen)
{
    int ret = 0;
	ret = UART_Read(pchBuf,1);
    
	if(0x5A!=*pchBuf)
	{
		return 0;
	}

	return ret;
}



