/*
 ******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-3-4
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 *******************************************************************************
 */

/*
 ***************************************************************************
 * 	                                           Include files
 ***************************************************************************
 */
#include <common.h>
#include <command.h>
#include <net.h>
#include "downloader_serial.h"
#include "partition_table.h"


/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define TSP_DOWNLOADER_CBSIZE		256 
 
/****************************************************************************
*							Local Types
****************************************************************************/

/****************************************************************************
*							Global Variables
****************************************************************************/
//char        tsp_console_buffer[TSP_DOWNLOADER_CBSIZE + 1];	/* downloader I/O buffer	*/
 char *tsp_console_buffer = (char*)(CONFIG_NAND_DMA_BUF_ADDR+0x4000);

unsigned int null_slice_flag = 0;


/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
extern	void downloader_serial_init(void);
extern int UART_CmdRead(char *pchBuf, int dwLen);

/****************************************************************************
*							Function Definitions
****************************************************************************/
/*******************************************************************************
 * Function:downloader_readline_into_buffer
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int downloader_readline_into_buffer (char * buffer)
{
	char * p_buf = buffer;
	unsigned int retSize = 0;
	unsigned int recvSize = 0;
	
	while(1)
		{
#if CONFIG_USB_DL
		retSize = downloader_serial_read(p_buf,512);
#else
		retSize = UART_CmdRead(p_buf,512);
#endif
		if(retSize<=0)
			{
				continue;
			}
		recvSize += retSize;
		if(recvSize >= TSP_DOWNLOADER_CBSIZE)
		{
			recvSize = 0;
			p_buf = buffer;
		}
		if(buffer[0] == 0x5a) /*filter syc 0x5a*/
		{
			printf("readline filter syc 0x5a\n");
			recvSize = 0;
			continue;
		}

		switch(p_buf[retSize-1])
			{
			case '\r':           /*Enter */
			case '\n':
			case '\0':
				while(retSize>0)
					{
					if( (p_buf[retSize-1] >='a' && p_buf[retSize-1]<='z')  ||\
						(p_buf[retSize-1] >='A' && p_buf[retSize-1]<='Z') || \
						(p_buf[retSize-1] >='0' && p_buf[retSize-1]<='9') )   /*filter invalid character*/
						{
							break;
						}
					retSize--;
					}
				p_buf[retSize]='\0';
				return 0;
			default:
				p_buf += retSize;
				continue;
			}

		}

	return 0;
}
/*******************************************************************************
 * Function:downloader_readline
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int downloader_readline (char * buffer)
{
	/*
	 * If console_buffer isn't 0-length the user will be prompted to modify
	 * it instead of entering it from scratch as desired.
	 */
	buffer[0] = '\0';

	return downloader_readline_into_buffer(buffer);
}

/*******************************************************************************
 * Function:do_downloader
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_downloader(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	int ret = 0;
	int type = 0;
	char ack[20] = {0};
    printf( "[sys_entry]: do downloader\n");
	
    ret = read_partition_and_check();
    if( ret != 0 )
    {
        printf( "[sys_entry]: read_partition error...\n");
    }

	type = read_boot_flashtype();
	if(type == IF_TYPE_NOR)
	{
		ret = get_nor_null_slice_flag(&null_slice_flag);
	    if(ret)
	    {
			printf ("nor flash read null_slice_flag error.\n");
			return 1; 
	    }
	}

	downloader_serial_init();
	printf ("### downloader : serial init success \n");

	/*sync*/
	while(1)
		{
#if CONFIG_USB_DL
		downloader_serial_read(tsp_console_buffer,512);
#else
		downloader_serial_read(tsp_console_buffer,1);
#endif
		if(tsp_console_buffer[0]==0x5a)
			{
				tsp_console_buffer[0]=0xa7; /*ack*/
				downloader_serial_write(tsp_console_buffer,1);
				break;
			}
		}
	
	/*run commands*/
	while(1)
		{
			downloader_readline(tsp_console_buffer);
			ret = run_command (tsp_console_buffer, 0);
			if(ret == -2)
			{
				sprintf(ack,"UNKNOWN COMMAND");
        		downloader_serial_write(ack, strlen(ack)+1);
			}
		}
	
	return 0;
}

U_BOOT_CMD(
	downloader, 1, 0,	do_downloader,
	"Perform ZIXC TSP downloader",
	""
);

