/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:      
 * Author:        
 * Date:          
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/
#ifndef __SECURE_VERIFY_H__
#define __SECURE_VERIFY_H__
//#include <image.h>

/*--------------CRM Ĵ------------*/
#define SYS_CTRL_BASE          0x00140000
#define SYS_LSP_CRM_BASE       0x01400000
#define SYS_MATRIX_CRM_BASE    0x01306000
#define SYS_SOC_CRM_BASE       0x0013b000


#define EFUSE_BYPASS      (SYS_CTRL_BASE+0x140)
#define BOOTSEL_INFO      (SYS_SOC_CRM_BASE+0x4)
#define MPLL_CFG0         (SYS_SOC_CRM_BASE+0x8)
#define UPLL_CFG0         (SYS_SOC_CRM_BASE+0x10)
#define RMCORE_CLK_CFG    (SYS_SOC_CRM_BASE+0x38)
#define RM_MOD_CLKSEL     (SYS_SOC_CRM_BASE+0x3c)
#define MATRIX_AXI_SEL    (SYS_MATRIX_CRM_BASE+0x0)

/* -------- efuse -------------*/
#define SYS_EFUSE_BASE					0x0121b000
#define EFUSE_RAM_BASE		(SYS_EFUSE_BASE+0x40)

/* -------- RSA, HASH -------------*/
#define SYS_RSA_BASE					0x0121c000
#define SYS_HASH_BASE					0x0121d000

/*Ϊ˿, hashkeybufferĴ˳Ϊ͵ַŸλ*/
// ṹ
typedef volatile struct
{
	u32		secure_flag;
	u32		puk_hash[4];
	u32		dev_id[3];	
} efuse_struct;

typedef volatile struct
{
	u32		secure_flag;
	u32		puk_hash[8];
	u32		dev_id[3];	
} otp_struct;

typedef struct
{
	u32 uiPubKeyRsaE[32];
	u32 uiPubKeyRsaN[32];
	u32 uiHashY[32];
} sImageHeader;

typedef struct
{
	uint16_t   signtype;
    uint16_t   hashtype;   
	uint32_t   uiPubKeyRsaELen;
	uint32_t   uiPubKeyRsaNLen;
	uint8_t    uiPubKeyRsaE[4];
	uint8_t    uiPubKeyRsaN[256];
	uint8_t    reserve[112]; //380 bytes
    uint8_t    uiHashY[256];    //256 bytes
} sImageNewHeader;

extern otp_struct otpInfo;

static void get_efuse_data(void);
static u32 SMALL2BIG(u32 *puiArrIn, u32 *puiArrOut, u32 uiLen);
u8 secure_verify(u32 addr);
u8 rootfs_secure_verify(u32 addr);
static u8 data_cmp_word(u32* src, u32* dst, u32 cnt);
int efuse_init(void);
void efuse_get_devinfo(efuse_struct *efuse_info);

#endif /* __SECURE_VERIFY_H__ */
