/*
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net) at
 * Carlstedt Research & Technology.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Modified by Synopsys, Inc, 12/12/2007 */


#ifndef _USB_H_
#define _USB_H_

#include "common.h"
#include <linux/types.h>
#ifdef __cplusplus
extern "C" {
#endif

// T_LANGID_DESCRIPTOR
#define LANGID_US_ENGLISH					0x0409

// T_STRING_DESCRIPTOR
#define MAX_STRING_LENGTH					(0x20)//(0x100)


typedef enum
{

 NEED_ENUM = 0,
 DONOT_NEED_ENUM
 
}T_USB_ENUM;

/*usb*/
typedef enum
{
    TRA_CTRL = 0,
    TRA_BULK,
    TRA_INTR,
    TRA_ISO
}T_USB_TRAN;

/* USBƴ*/
typedef struct
{
    BYTE     bmRequestType;
    BYTE     bRequest;
    WORD16     wValue;
    WORD16     wIndex;
    WORD16     wLength;
}T_CTRL_COMMAND;


// ˵ݰС
typedef enum
{
	CONTROL_8		=8,
	CONTROL_16		=16,
	CONTROL_32		=32,
	CONTROL_64		=64,

	BULK_8			=8,
	BULK_16			=16,
	BULK_32			=32,
	BULKL_64		=64	
}T_EP_PKT_SIZE;


// CLEAR_FEATURE, SET_FEATURE
#define FEATURE_DEVICE_REMOTE_WAKEUP		(0x1)
#define FEATURE_ENDPOINT_HALT				(0x0)
#define FEATURE_TEST_MODE					(0x2)

// ʵ޸
#define	USB_VENDOR_ID			                      (0x19D2)	// 2ֽ
#define USB_PRODUCT_ID			                      (0x0256)	// 2ֽ
#define PRODUCT_RELEASE_NUMBER	               (0x7520)	// 2ֽ

#define VERDOR_SPECIFIC			(0xff)

#define EP0_PACKET_SIZE CONTROL_64
#define EP1_PACKET_SIZE 64
#define EPX_PACKET_SIZE 64

#define EP_FOR_IN 2
#define EP_FOR_OUT 3


/*usb豸߸״̬*/
typedef enum
{
    eUSB_ATTACHED = 0,
    eUSB_POWERED,
    eUSB_DEFAULT,
    eUSB_SUSPEND,
    eUSB_RUSUME,
    eUSB_ADDRESS,    
    eUSB_CONFIG
}E_USB_STATE;


// ׼
typedef enum
{
	GET_STATUS          =0x0,
	CLEAR_FEATURE       =0x1,
	SET_FEATURE         =0x3,
	SET_ADDRESS         =0x5,
	GET_DESCRIPTOR      =0x6,
	SET_DESCRIPTOR      =0x7,
	GET_CONFIGURATION   =0x8,
	SET_CONFIGURATION   =0x9,
	GET_INTERFACE       =0xa,
	SET_INTERFACE       =0xb,
	SYNCH_FRAME         =0xc
}T_STANDARD_REQUST;


// 
typedef enum
{
    DEVICE_DESCRIPTOR   = 0x01,
    CONFIG_DESCRIPTOR   = 0x02,
    STRING_DESCRIPTOR   = 0x03,
    INTERFACE_DESCRIPTOR= 0x04,
    ENDPOINT_DESCRIPTOR = 0x05
} T_DESCRIPTORS_TYPE;

// USBֵ֧
typedef enum
{
	DEVICE_REMOTE_WAKEUP	=1,		// Device 
	ENDPOINT_HALT 			=0, 	// Endpoint 
	TEST_MODE 				=2		//Device 
}T_FEATURE;


// bmAttributes
#define ATTR_D7						       (0x01 <<7)		// Ϊ1
#define ATTR_SELF_POWERED			       (0x01 <<6)		// Թ
#define ATTR_SUPPORT_REMOTE_WAKEUP	(0x01 <<5)		// Զ̻

// bMaxPower
#define POWER_MA(power)				        (power>>1)		// λ: 2mA

#define EP_ADDRESS_DIRECTION_MASK	        (0x01 <<7)	//Direction, ignored for control endpoints
#define EP_ADDRESS_DIRECTION_IN		 (0x01 <<7)
#define EP_ADDRESS_DIRECTION_OUT	         (0x0   <<7)


//bmAttributes
#define EP_ATTR_TRANSFER_TYPE_MASK		 (0x03 <<0)
#define EP_ATTR_TRANSFER_TYPE_CONTROL	        (0     <<0)
#define EP_ATTR_TRANSFER_TYPE_ISO		        (1     <<0)
#define EP_ATTR_TRANSFER_TYPE_BULK		 (2     <<0)
#define EP_ATTR_TRANSFER_TYPE_INTERRUPT	 (3     <<0)

//ͬ˵, 1023ֽ, ѯ---2^(bInterval -1)֡
#define MAX_ISO_PKT			(256)	//1023ֽ
#define MAX_ISO_R_INTERVAL	(1)		//ѯ---2^(bInterval -1)֡
#define MAX_ISO_T_INTERVAL	(1)		//ѯ---2^(bInterval -1)֡

//T_STRING_DESCRIPTOR, ascii to unicode---*2, length,type--+2
#define STRING_DESCRIPTOR_SIZE(size)    	((size*2)+2)
//תasciiַΪunicodeַ
#define UNICODE(ascii)							ascii,0x00

/**************************************************************************/
typedef uint8_t uByte;
typedef uint8_t uWord[2];
typedef uint8_t uDWord[4];


#define UT_GET_TYPE(a) ((a) & 0x60)
#define UT_STANDARD		0x00
#define UT_CLASS		0x20
#define UT_VENDOR		0x40

#define UT_GET_RECIPIENT(a) ((a) & 0x1f)
#define UT_DEVICE		0x00
#define UT_INTERFACE		0x01
#define UT_ENDPOINT		0x02
#define UT_OTHER		0x03
/* Requests */
#define  UR_GET_STATUS		0x00
#define  USTAT_STANDARD_STATUS  0x00
#define  UR_CLEAR_FEATURE	0x01
#define  UR_SET_FEATURE		0x03
#define  UR_SET_ADDRESS		0x05
#define  UR_GET_DESCRIPTOR	0x06
#define UR_SET_CONFIG		0x09
/* Feature numbers */
#define UF_ENDPOINT_HALT	0





#define UE_GET_DIR(a)	((a) & 0x80)
#define UE_SET_DIR(a,d)	((a) | (((d)&1) << 7))
#define UE_DIR_IN	0x80
#define UE_DIR_OUT	0x00
#define UE_ADDR		0x0f
#define UE_GET_ADDR(a)	((a) & UE_ADDR)


#define USB_MAX_STRING_LEN 128
#define USB_LANGUAGE_TABLE 0	/* # of the string language id table */

/* Hub specific request */
#define UR_GET_BUS_STATE	0x02
#define UR_CLEAR_TT_BUFFER	0x08
#define UR_RESET_TT		0x09
#define UR_GET_TT_STATE		0x0a
#define UR_STOP_TT		0x0b

/* Hub features */
#define UHF_C_HUB_LOCAL_POWER	0
#define UHF_C_HUB_OVER_CURRENT	1
#define UHF_PORT_CONNECTION	0
#define UHF_PORT_ENABLE		1
#define UHF_PORT_SUSPEND	2
#define UHF_PORT_OVER_CURRENT	3
#define UHF_PORT_RESET		4
#define UHF_PORT_L1		5
#define UHF_PORT_POWER		8
#define UHF_PORT_LOW_SPEED	9
#define UHF_PORT_HIGH_SPEED	10
#define UHF_C_PORT_CONNECTION	16
#define UHF_C_PORT_ENABLE	17
#define UHF_C_PORT_SUSPEND	18
#define UHF_C_PORT_OVER_CURRENT	19
#define UHF_C_PORT_RESET	20
#define UHF_C_PORT_L1		23
#define UHF_PORT_TEST		21
#define UHF_PORT_INDICATOR	22

#define UHD_PWR			0x0003
#define  UHD_PWR_GANGED		0x0000
#define  UHD_PWR_INDIVIDUAL	0x0001
#define  UHD_PWR_NO_SWITCH	0x0002
#define UHD_COMPOUND		0x0004
#define UHD_OC			0x0018
#define  UHD_OC_GLOBAL		0x0000
#define  UHD_OC_INDIVIDUAL	0x0008
#define  UHD_OC_NONE		0x0010
#define UHD_TT_THINK		0x0060
#define  UHD_TT_THINK_8		0x0000
#define  UHD_TT_THINK_16	0x0020
#define  UHD_TT_THINK_24	0x0040
#define  UHD_TT_THINK_32	0x0060
#define UHD_PORT_IND		0x0080
#define UHD_PWRON_FACTOR 2
#define UHD_NOT_REMOV(desc, i)  (((desc)->DeviceRemovable[(i)/8] >> ((i) % 8)) & 1)
    
#define USB_HUB_DESCRIPTOR_SIZE 9 /* includes deprecated PortPowerCtrlMask */


/* OTG feature selectors */
#define UOTG_B_HNP_ENABLE	3
#define UOTG_A_HNP_SUPPORT	4
#define UOTG_A_ALT_HNP_SUPPORT	5

/* Device status flags */
#define UDS_SELF_POWERED		0x0001
#define UDS_REMOTE_WAKEUP		0x0002
/* Endpoint status flags */
#define UES_HALT			0x0001



#define UHS_LOCAL_POWER	    0x0001
#define UHS_OVER_CURRENT		0x0002



#define UPS_CURRENT_CONNECT_STATUS	0x0001
#define UPS_PORT_ENABLED		0x0002
#define UPS_SUSPEND			0x0004
#define UPS_OVERCURRENT_INDICATOR	0x0008
#define UPS_RESET			0x0010
#define UPS_PORT_POWER			0x0100
#define UPS_LOW_SPEED			0x0200
#define UPS_HIGH_SPEED			0x0400
#define UPS_PORT_TEST			0x0800
#define UPS_PORT_INDICATOR		0x1000
#define UPS_C_CONNECT_STATUS		0x0001
#define UPS_C_PORT_ENABLED		0x0002
#define UPS_C_SUSPEND			0x0004
#define UPS_C_OVERCURRENT_INDICATOR	0x0008
#define UPS_C_PORT_RESET		0x0010


/* Device class codes */
#define UDCLASS_IN_INTERFACE	0x00
#define UDCLASS_COMM		0x02
#define UDCLASS_HUB		0x09
#define  UDSUBCLASS_HUB		0x00
#define  UDPROTO_FSHUB		0x00
#define  UDPROTO_HSHUBSTT	0x01
#define  UDPROTO_HSHUBMTT	0x02
#define UDCLASS_DIAGNOSTIC	0xdc
#define UDCLASS_WIRELESS	0xe0
#define  UDSUBCLASS_RF		0x01
#define   UDPROTO_BLUETOOTH	0x01
#define UDCLASS_VENDOR		0xff

/* Interface class codes */
#define UICLASS_UNSPEC		0x00

#define UICLASS_AUDIO		0x01
#define  UISUBCLASS_AUDIOCONTROL	1
#define  UISUBCLASS_AUDIOSTREAM		2
#define  UISUBCLASS_MIDISTREAM		3

#define UICLASS_CDC		0x02 /* communication */
#define  UISUBCLASS_DIRECT_LINE_CONTROL_MODEL	1
#define  UISUBCLASS_ABSTRACT_CONTROL_MODEL	2
#define  UISUBCLASS_TELEPHONE_CONTROL_MODEL	3
#define  UISUBCLASS_MULTICHANNEL_CONTROL_MODEL	4
#define  UISUBCLASS_CAPI_CONTROLMODEL		5
#define  UISUBCLASS_ETHERNET_NETWORKING_CONTROL_MODEL 6
#define  UISUBCLASS_ATM_NETWORKING_CONTROL_MODEL 7
#define   UIPROTO_CDC_AT			1

#define UICLASS_HID		0x03
#define  UISUBCLASS_BOOT	1
#define  UIPROTO_BOOT_KEYBOARD	1

#define UICLASS_PHYSICAL	0x05

#define UICLASS_IMAGE		0x06

#define UICLASS_PRINTER		0x07
#define  UISUBCLASS_PRINTER	1
#define  UIPROTO_PRINTER_UNI	1
#define  UIPROTO_PRINTER_BI	2
#define  UIPROTO_PRINTER_1284	3

#define UICLASS_MASS		0x08
#define  UISUBCLASS_RBC		1
#define  UISUBCLASS_SFF8020I	2
#define  UISUBCLASS_QIC157	3
#define  UISUBCLASS_UFI		4
#define  UISUBCLASS_SFF8070I	5
#define  UISUBCLASS_SCSI	6
#define  UIPROTO_MASS_CBI_I	0
#define  UIPROTO_MASS_CBI	1
#define  UIPROTO_MASS_BBB_OLD	2	/* Not in the spec anymore */
#define  UIPROTO_MASS_BBB	80	/* 'P' for the Iomega Zip drive */

#define UICLASS_HUB		0x09
#define  UISUBCLASS_HUB		0
#define  UIPROTO_FSHUB		0
#define  UIPROTO_HSHUBSTT	0 /* Yes, same as previous */
#define  UIPROTO_HSHUBMTT	1

#define UICLASS_CDC_DATA	0x0a
#define  UISUBCLASS_DATA		0
#define   UIPROTO_DATA_ISDNBRI		0x30    /* Physical iface */
#define   UIPROTO_DATA_HDLC		0x31    /* HDLC */
#define   UIPROTO_DATA_TRANSPARENT	0x32    /* Transparent */
#define   UIPROTO_DATA_Q921M		0x50    /* Management for Q921 */
#define   UIPROTO_DATA_Q921		0x51    /* Data for Q921 */
#define   UIPROTO_DATA_Q921TM		0x52    /* TEI multiplexer for Q921 */
#define   UIPROTO_DATA_V42BIS		0x90    /* Data compression */
#define   UIPROTO_DATA_Q931		0x91    /* Euro-ISDN */
#define   UIPROTO_DATA_V120		0x92    /* V.24 rate adaption */
#define   UIPROTO_DATA_CAPI		0x93    /* CAPI 2.0 commands */
#define   UIPROTO_DATA_HOST_BASED	0xfd    /* Host based driver */
#define   UIPROTO_DATA_PUF		0xfe    /* see Prot. Unit Func. Desc.*/
#define   UIPROTO_DATA_VENDOR		0xff    /* Vendor specific */

#define UICLASS_SMARTCARD	0x0b

/*#define UICLASS_FIRM_UPD	0x0c*/

#define UICLASS_SECURITY	0x0d

#define UICLASS_DIAGNOSTIC	0xdc

#define UICLASS_WIRELESS	0xe0
#define  UISUBCLASS_RF			0x01
#define   UIPROTO_BLUETOOTH		0x01

#define UICLASS_APPL_SPEC	0xfe
#define  UISUBCLASS_FIRMWARE_DOWNLOAD	1
#define  UISUBCLASS_IRDA		2
#define  UIPROTO_IRDA			0

#define UICLASS_VENDOR		0xff

#define USB_HUB_MAX_DEPTH 5

/*
 * Minimum time a device needs to be powered down to go through
 * a power cycle.  XXX Are these time in the spec?
 */
#define USB_POWER_DOWN_TIME	200 /* ms */
#define USB_PORT_POWER_DOWN_TIME	100 /* ms */


/* Allow for marginal (i.e. non-conforming) devices. */
#define USB_PORT_RESET_DELAY	50  /* ms */
#define USB_PORT_ROOT_RESET_DELAY 250  /* ms */
#define USB_PORT_RESET_RECOVERY	250  /* ms */
#define USB_PORT_POWERUP_DELAY	300 /* ms */
#define USB_SET_ADDRESS_SETTLE	10  /* ms */
#define USB_RESUME_DELAY	(50*5)  /* ms */
#define USB_RESUME_WAIT		50  /* ms */
#define USB_RESUME_RECOVERY	50  /* ms */
#define USB_EXTRA_POWER_UP_TIME	20  /* ms */


#define USB_MIN_POWER		100 /* mA */
#define USB_MAX_POWER		500 /* mA */

#define USB_BUS_RESET_DELAY	100 /* ms XXX?*/

#define USB_UNCONFIG_NO 0
#define USB_UNCONFIG_INDEX (-1)

typedef struct usb_device_request_t
{
	uint8_t		bmRequestType;
	uint8_t		bRequest;
	uint16_t		wValue;
	uint16_t		wIndex;
	uint16_t		wLength;
} __attribute__ ((__packed__)) usb_device_request_t;

/*** ioctl() related stuff ***/

#define USBD_SHORT_XFER_OK	0x04	/* allow short reads */
#define USB_CURRENT_CONFIG_INDEX (-1)
#define USB_CURRENT_ALT_INDEX (-1)



typedef struct usb_endpoint_descriptor_t
{
	        uint8_t		bLength;
	        uint8_t		bDescriptorType;
	        uint8_t		bEndpointAddress;
            uint8_t		bmAttributes;
			uint16_t	wMaxPacketSize;
	        uint8_t		bInterval;
} __attribute__ ((__packed__)) usb_endpoint_descriptor_t;

#define USB_MAX_DEVNAMES 4
#define USB_MAX_DEVNAMELEN 16
#define USB_SPEED_UNKNOWN	0
#define USB_SPEED_LOW		1
#define USB_SPEED_FULL		2
#define USB_SPEED_HIGH		3
/*
 * USB directions
 *
 * This bit flag is used in endpoint descriptors' bEndpointAddress field.
 * It's also one of three fields in control requests bRequestType.
 */
#define USB_DIR_OUT			0		/* to device */
#define USB_DIR_IN			0x80		/* to host */

#define USB_DT_DEVICE			0x01
#define USB_DT_CONFIG			0x02
#define USB_DT_STRING			0x03
#define USB_DT_INTERFACE		0x04
#define USB_DT_ENDPOINT			0x05
#define USB_DT_DEVICE_QUALIFIER		0x06
#define USB_DT_OTHER_SPEED_CONFIG	0x07
#define USB_DT_INTERFACE_POWER		0x08

/***************************************************/
// ׼ӿ
typedef struct dwc_interface_descriptor_t
{
	BYTE 	bLength;
	BYTE 	bDescriptorType;
	BYTE 	bInterfaceNumber;
	BYTE 	bAlternateSetting;
	BYTE 	bNumEndpoints;
	BYTE 	bInterfaceClass;
	BYTE 	bInterfaceSubClass;
	BYTE 	bInterfaceProtocol;
	BYTE 	iInterface;
}__attribute__ ((__packed__)) dwc_interface_descriptor_t;


// ׼˵
typedef struct dwc_ep_descriptor_t
{
	BYTE 	bLength;
	BYTE 	bDescriptorType;
	BYTE 	bEndpointAddress;
	BYTE 	bmAttributes;
	WORD16	wMaxPacketSize;
	BYTE 	bInterval;
}__attribute__ ((__packed__)) dwc_ep_descriptor_t;


// ַ
typedef struct dwc_langid_descriptor_t
{
	BYTE	bLength;
	BYTE 	bDescriptorType;
	WORD16	wLANGID0;

}__attribute__ ((__packed__)) dwc_langid_descriptor_t;

typedef struct dwc_string_descriptor_t
{
	BYTE	bLength;
	BYTE 	bDescriptorType;
	BYTE	bString[MAX_STRING_LENGTH];

}__attribute__ ((__packed__)) dwc_string_descriptor_t;

// 豸
typedef struct dwc_device_descriptor_t
{
    BYTE    bLength;
    BYTE    bDescriptorType;
    WORD16	bcdUSB;
    BYTE    bDeviceClass;
    BYTE    bDeviceSubClass;
    BYTE    bDeviceProtocol;
    BYTE    bMaxPacketSize0;
    WORD16 	idVendor;
    WORD16 	idProduct;
    WORD16 	bcdDevice;
    BYTE 	iManufacturer;
    BYTE    iProduct;
    BYTE    iSerialNumber;
    BYTE    bNumConfigurations;
}__attribute__ ((__packed__)) dwc_device_descriptor_t;

//device qualifier
typedef struct dwc_dev_qual_descriptor_t
{
    BYTE    bLength;
    BYTE    bDescriptorType;
    WORD16	bcdUSB;
    BYTE    bDeviceClass;
    BYTE    bDeviceSubClass;
    BYTE    bDeviceProtocol;
    BYTE    bMaxPacketSize0;
    BYTE    bNumConfigurations;
    BYTE    Reserved;
}__attribute__ ((__packed__)) dwc_dev_qual_descriptor_t;


// ׼
typedef struct dwc_config_descriptor_t
{
	BYTE 	bLength;
	BYTE 	bDescriptorType;
	WORD16 	wTotalLength;
	BYTE 	bNumInterfaces;
	BYTE 	bConfigurationValue;
	BYTE 	iConfiguration;
	BYTE 	bmAttributes;
	BYTE 	bMaxPower;
}__attribute__ ((__packed__)) dwc_config_descriptor_t;

typedef struct dwc_product_descriptor_t
{
	BYTE 	bLength;
	BYTE 	bDescriptorType;
    char    Prod_Desc[98];
} __attribute__ ((__packed__)) dwc_product_descriptor_t;

//#define	MAX_EPS				(0x8)
#define	MAX_EPS				(0x2)
typedef enum
{
    USB_MAX_PACKET_SIZE_NOT_SET      = 0,
    USB_FULLSPEED_BULK_MAXSIZE         = 64,
    USB_HIGHSPEED_BULK_MAXSIZE        = 512,
}T_USB_MAX_PACKET_SIZE;

typedef struct dwc_config_all_t
{
  dwc_config_descriptor_t		tConfig;
  dwc_interface_descriptor_t	tInterface;
  dwc_ep_descriptor_t			atTxEP[1];	//Ͷ˵(ep0)
  dwc_ep_descriptor_t			atRxEP[1];	//ն˵(ep0)
  dwc_interface_descriptor_t	tInterface1;
  dwc_ep_descriptor_t			atTxEP1[1];	//Ͷ˵(ep0)
  dwc_ep_descriptor_t			atRxEP1[1];	//ն˵(ep0)
}__attribute__ ((__packed__)) dwc_config_all_t;

#ifdef __cplusplus
}
#endif

#endif /* _USB_H_ */
