/*******************************************************************************
 * Copyright (C) 2008, ZTE Corporation.
 *
 * File Name: drv_chip_cfg.h
 * File Mark:
 * Description:  This file contains the
 * Others:
 * Version:       V1.0
 * Author:        zhangdongdong
 * Date:          2015-07-31
 * History 1:
 *
 *********************************************************************************/

#ifndef _DRV_CHIP_CFG_H
#define _DRV_CHIP_CFG_H

#include    "drvs_bits.h"


/****************************************************************************
*                                           type
****************************************************************************/


/****************************************************************************
*                                           MACRO
****************************************************************************/

#define TOP_MAIN_CLK_IN     26000000            /*      26MHz       */

/****************************************************************************
*                                           register map
****************************************************************************/
#ifdef _OS_TOS

#include "drvs_regmap.inc"

/*SYS*/
#define TOP_SYS_REG_BASE    ADDR_SOC_SYS
#define SOC_SYS_REG_BASE    ADDR_SOC_SYS
#define A1_SYS_REG_BASE     ADDR_SOC_SYS

/*CRM*/
#define SOC_CRM_REG_BASE    ADDR_STD_CRM
#define LSP_CRM_REG_BASE    ADDR_LSP_CRM
#define A1_CRM_REG_BASE     ADDR_TOP_CRM
#define PS_CRM_REG_BASE     ADDR_MG_CRM

/*PS*/
#define PS_CFG_REG_BASE     ADDR_MG_CFG

#if defined (_CHIP_ZX297520V2)
/*L2 CACHE*/
#define L2CACHE_REG_BASE    ADDR_MG_L2CACHE
#endif

/*PCU*/
#define PCU_REG_BASE        ADDR_PCU

/*SCU*/
#if defined (_CHIP_ZX297520V2)
#define SCU_REG_BASE       ADDR_MG_SCU  /*only in 7520v2*/
#endif

/*GIC*/
#define GICC_REG_BASE       ADDR_MG_GICC
#define GICD_REG_BASE       ADDR_MG_GICD
#if defined (_CHIP_ZX297520V3)
#define GICR_REG_BASE       ADDR_MG_GICR
#endif

/*TIMER*/
#define TIMER0_REG_BASE     ADDR_LSP_PS_TIMER0		/*ps tick*/
#define TIMER1_REG_BASE     ADDR_PS_TIMER1			/*psm wake timer*/
#define TIMER2_REG_BASE     ADDR_PS_TIMER2			
#define PSRM_TIMER_REG_BASE ADDR_LSP_PS_RM_TIMER	/*uicc timer*/
#define TIMER3_REG_BASE     ADDR_RM_TIMER1			/*psm compensate timer*/

/*WDT*/
#define EXT_WDT_BASE        ADDR_LSP_PS_WDT
//#define PT_WDT_BASE         ADDR_MG_PT_WDT

/*I2C*/
//#define I2C0_REG_BASE       ADDR_APB_I2C0	    /*V2һI2C*/
#define I2C1_REG_BASE       ADDR_LSP_I2C1
#define I2C_PMIC_REG_BASE   ADDR_I2C_PMIC

/*USB*/
#define USB0_REG_BASE       ADDR_HSIC
#define USB1_REG_BASE       ADDR_USB

/*NAND*/
#define NAND_REG_BASE       ADDR_NAND_REG
#define NAND_DATA_BASE      ADDR_NAND_DATA

/*DMA*/
#define DMA0_REG_BASE       ADDR_DMA_PS
#define DMA1_REG_BASE       ADDR_DMA_PHY

/*SPI*/
#define SPI0_REG_BASE       ADDR_LSP_SSP0
#define SPI1_REG_BASE       ADDR_LSP_SSP1

/*ICP*/
#define ICP0_REG_BASE       ADDR_ICP

/*I2S*/
#define I2S0_REG_BASE       ADDR_LSP_I2S0
#define I2S1_REG_BASE       ADDR_LSP_I2S1

/*SDMMC*/
#define SDMMC0_REG_BASE     ADDR_SD0
#define SDMMC1_REG_BASE     ADDR_SD1

/*USIM*/
#define USIM0_REG_BASE      ADDR_GSM_USIM	/*ȷϣV2һUSIM*/

/*EDCP*/
#define EDCP0_REG_BASE      ADDR_EDCP

/*CHECKSUM*/
#define CHECKSUM0_REG_BASE  0

/*UART*/
#define UART0_REG_BASE      ADDR_UART0
#define UART1_REG_BASE      ADDR_LSP_UART1
#define UART2_REG_BASE      ADDR_LSP_UART2

/*PAD*/
#define PAD_CTRL_REG_BASE   ADDR_PAD_CTRL_A0

/*GPIO*/
#define GPIO0_REG_BASE      ADDR_GPIO0
#define GPIO1_REG_BASE      ADDR_GPIO1

/*PIN MUX*/
#define GPIO_PINMUX_REG_BASE ADDR_PIN_MUX

/*GSM_MODEM1*/
#define GSM_MODEM1          ADDR_GSM_MODEM1

/*GSM_MODEM2*/
#define GSM_MODEM2          ADDR_GSM_MODEM2

/*DDR*/
#define DDR_CTRL_BASE       ADDR_DDR_CTRL
#define DDR_PHY_BASE        ADDR_DDR_PHY
#if defined (_CHIP_ZX297520V3)
#define DDR_FFC_BASE		ADDR_DDR_FFC
#endif

/*IRAM*/
#define IRAM1_BASE     ADDR_IRAM1	/*ʡ罻IRAM*/
#define IRAM2_BASE     ADDR_IRAM2	/*M0*/

/*LPM*/
#define GSM_LPM_BASE     ADDR_LPM_GSM
#define LTE_LPM_BASE     ADDR_LPM_LTE
#define TD_LPM_BASE      ADDR_LPM_TD
#define W_LPM_BASE       ADDR_LPM_W

/*EFUSE*/
#define EFUSE_BASE_ADDR  ADDR_EFUSE 

#if defined (_CHIP_ZX297520V3)
/*VOU*/
#define VOU_CTRL_BASE    		ADDR_VOU_CFG
#define VOU_CLK_CTRL_BASE	    ADDR_STD_CRM	
#endif
#endif

#ifdef _OS_LINUX
#include <mach/iomap.h>

/*SYS*/
#define TOP_SYS_REG_BASE    ((unsigned int)ZX_SOC_SYS_BASE)
#define SOC_SYS_REG_BASE    ((unsigned int)ZX_SOC_SYS_BASE)
#define A1_SYS_REG_BASE     ((unsigned int)ZX_SOC_SYS_BASE)

/*CRM*/
#define SOC_CRM_REG_BASE    ((unsigned int)ZX_MATRIX_CRM_BASE)
#define LSP_CRM_REG_BASE    ((unsigned int)ZX_LSP_CRPM_BASE)
#define A1_CRM_REG_BASE     ((unsigned int)ZX_TOP_CRM_BASE)
#define PS_CRM_REG_BASE     ((unsigned int)ZX_AP_PERIPHERAL_BASE)

/*PS*/
//#define PS_CFG_REG_BASE     ZX297520V3_MG_CFG

/*L2 CACHE*/
//#define L2CACHE_REG_BASE    ZX297520V3_MG_L2CACHE

/*PCU*/
#define PCU_REG_BASE        ((unsigned int)ZX_PCU_BASE)

/*GIC*/
#define GICC_REG_BASE       ((unsigned int)ZX_GICC_BASE)
#define GICD_REG_BASE       ((unsigned int)ZX_GIC_BASE)
#define GICR_REG_BASE       ((unsigned int)GIC_REDIST_BASE)


/*TIMER*/
#define TIMER0_REG_BASE     ((unsigned int)ZX_PS_TIMER0_BASE)		/*ps tick*/
#define TIMER1_REG_BASE     ((unsigned int)ZX_PS_TIMER1_BASE)		/*psm wake timer*/
#define TIMER2_REG_BASE     ((unsigned int)ZX_PS_TIMER2_BASE)		/*psm compensate timer*/
#define PSRM_TIMER_REG_BASE ((unsigned int)ZX_PS_RM_TIMER_BASE)	/*uicc timer*/
#define TIMER3_REG_BASE     ((unsigned int)ZX_RM_TIMER1_BASE)		/*rm timer1*/

/*WDT*/
#define EXT_WDT_BASE        ((unsigned int)ZX_PS_WDT_BASE)
//#define PT_WDT_BASE         ZX297520V3_MG_PT_WDT

/*I2C*/
//#define I2C0_REG_BASE       ZX297520V3_APB_I2C0	    /*V2һI2C*/
#define I2C1_REG_BASE       ((unsigned int)ZX_I2C1_BASE)
#define I2C_PMIC_REG_BASE   ((unsigned int)ZX_PMIC_I2C_BASE)

/*USB*/
#define USB0_REG_BASE       ((unsigned int)ZX_HSIC_BASE)
#define USB1_REG_BASE       ((unsigned int)ZX_USB_BASE)

/*NAND*/
#define NAND_REG_BASE       ((unsigned int)ZX_NAND_REG_BASE)
#define NAND_DATA_BASE      ((unsigned int)ZX_NAND_DATA_BASE)

/*DMA*/
#define DMA0_REG_BASE       ((unsigned int)ZX_DMA_PS_BASE)
#define DMA1_REG_BASE       ((unsigned int)ZX_DMA_PHY_BASE)

/*SPI*/
#define SPI0_REG_BASE       ((unsigned int)ZX_SSP0_BASE)
#define SPI1_REG_BASE       ((unsigned int)ZX_SSP1_BASE)

/*ICP*/
#define ICP0_REG_BASE       ((unsigned int)ZX_ICP_BASE)

/*I2S*/
#define I2S0_REG_BASE       ((unsigned int)ZX_I2S0_BASE)
#define I2S1_REG_BASE       ((unsigned int)ZX_I2S1_BASE)

/*TDM*/
#define TDM_REG_BASE        ((unsigned int)ZX_TDM_BASE) 

/*SDMMC*/
#define SDMMC0_REG_BASE     ((unsigned int)ZX_SD0_BASE)
#define SDMMC1_REG_BASE     ((unsigned int)ZX_SD1_BASE)

/*USIM*/
//#define USIM0_REG_BASE      ZX297520V3_GSM_USIM	/*ȷϣV2һUSIM*/
#define USIM1_REG_BASE		((unsigned int)ZX_USIM1_BASE)

/*EDCP*/
#define EDCP0_REG_BASE      ((unsigned int)ZX_EDCP_BASE)

/*CHECKSUM*/
#define CHECKSUM0_REG_BASE  0

/*UART*/
#define UART0_REG_BASE      ((unsigned int)ZX_UART0_BASE)
#define UART1_REG_BASE      ((unsigned int)ZX_UART1_BASE)
#define UART2_REG_BASE      ((unsigned int)ZX_UART2_BASE)

/*PAD*/
#define PAD_CTRL_REG_BASE   ((unsigned int)ZX_PAD_CTRL_BASE)

/*GPIO*/
#define GPIO0_REG_BASE      ((unsigned int)ZX_GPIO0_BASE)
#define GPIO1_REG_BASE      ((unsigned int)ZX_GPIO1_BASE)

/*PIN MUX*/
#define GPIO_PINMUX_REG_BASE ((unsigned int)ZX_PIN_MUX_BASE)

/*GSM_CFG*/
#define GSM_CFG_BASE        ((unsigned int)ZX_GSM_CFG_BASE)

/*GSM_MODEM1*/
#define GSM_MODEM1          ((unsigned int)ZX_GSM_MODEM_BASE)

/*GSM_MODEM2*/
#define GSM_MODEM2          ((unsigned int)(ZX_GSM_MODEM_BASE+0x2000000))

/*DDR*/
#define DDR_CTRL_BASE       ((unsigned int)ZX_DDR_CTRL_BASE)
#define DDR_PHY_BASE        ((unsigned int)ZX_DDR_PHY_BASE)
#define DDR_FFC_BASE		((unsigned int)ZX_DDR_FFC_BASE)
/**/
#define SYS_CTRL_BASE 	    ((unsigned int)ZX_SOC_SYS_BASE)

/*IRAM*/
#define IRAM1_BASE     ((unsigned int)ZX_IRAM1_BASE)	/*ʡ罻IRAM*/
#define IRAM2_BASE_ADDR     ((unsigned int)ZX_IRAM2_BASE)	/*M0*/

/*LPM*/
#define GSM_LPM_BASE     ((unsigned int)ZX_LPM_GSM_BASE)
#define LTE_LPM_BASE     ((unsigned int)ZX_LPM_LTE_BASE)
#define TD_LPM_BASE      ((unsigned int)ZX_LPM_TD_BASE)
#define W_LPM_BASE       ((unsigned int)ZX_LPM_W_BASE)

/*EFUSE*/
#define EFUSE_BASE_ADDR  ((unsigned int)ZX_EFUSE_BASE)
/*VOU*/
#define VOU_CTRL_BASE    		((unsigned int)ZX_VOU_CFG_BASE)
#define VOU_CLK_CTRL_BASE	    ((unsigned int)ZX_MATRIX_CRM_BASE)
#endif

#endif/*_DRV_CFG_H*/

