/***********************************************************************
* Copyright (C) 2008, ZTE Corporation.
* 
* File Name:     audio_api.h
* File Mark:      
* Description:  Provide audio module function prototype declaration and type declaration.
*                    For no multimedia processor platform.
* Others:      
* Version:      v0.5
* Author:      DangMaochang
* Date:            2008-06-30
* 
* History 1:          
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
**********************************************************************/

#ifndef _AUDIO_API_H
#define _AUDIO_API_H

#include "drvs_io.h"
#include "drvs_io_voice.h"

/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/


/**************************************************************************
 *                                  Macro                                                                                      *
 **************************************************************************/
#define ZDRV_DEV_AUDIO  "audio"  /*The device name of audio driver.*/

/**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/

/*Information from driver to upper application.*/
typedef enum {
    AUDIO_INFO_FILE_INVALID     = 0,
    AUDIO_INFO_PLAY_END            ,
    AUDIO_INFO_PLAY_ERR            ,
    AUDIO_INFO_REC_END             ,
    AUDIO_INFO_REC_ERR             ,

    MAX_AUDIO_INFO
} T_ZDrvAudio_Info;

/* Audio input channel volum level selection. */
typedef enum{
    AUDIO_INPUT_VOL_LEVEL_0 = 0,
    AUDIO_INPUT_VOL_LEVEL_1,
    AUDIO_INPUT_VOL_LEVEL_2,
    AUDIO_INPUT_VOL_LEVEL_3,
    AUDIO_INPUT_VOL_LEVEL_4,
    AUDIO_INPUT_VOL_LEVEL_5,
	AUDIO_INPUT_VOL_LEVEL_6,
    AUDIO_INPUT_VOL_LEVEL_7,
    AUDIO_INPUT_VOL_LEVEL_8,
    AUDIO_INPUT_VOL_LEVEL_9,
    AUDIO_INPUT_VOL_LEVEL_10,
    AUDIO_INPUT_VOL_LEVEL_11,
    MAX_AUDIO_INPUT_VOL_LEVEL     
} T_ZDrvAudio_InputVolLevel;

/* Audio output channel volum level selection. */
typedef enum{
    AUDIO_OUTPUT_VOL_LEVEL_0 = 0,
    AUDIO_OUTPUT_VOL_LEVEL_1,
    AUDIO_OUTPUT_VOL_LEVEL_2,
    AUDIO_OUTPUT_VOL_LEVEL_3,
    AUDIO_OUTPUT_VOL_LEVEL_4,
    AUDIO_OUTPUT_VOL_LEVEL_5,
    AUDIO_OUTPUT_VOL_LEVEL_6,
    AUDIO_OUTPUT_VOL_LEVEL_7,
    AUDIO_OUTPUT_VOL_LEVEL_8,
    AUDIO_OUTPUT_VOL_LEVEL_9,
    AUDIO_OUTPUT_VOL_LEVEL_10,
    AUDIO_OUTPUT_VOL_LEVEL_11,

    MAX_AUDIO_OUTPUT_VOL_LEVEL     
} T_ZDrvAudio_OutputVolLevel;

/* brief Select the audio data sampling rate for the Stereo DAC.
 * note: This enumeration defines all of the possible sampling rates currently
 * supported by the Stereo DAC. One of these sampling rates must be selected
 * and it must match that of the audio stream or else signal distortion will
 * occur.
 */
typedef enum
{
    AUDIO_RATE_8_KHZ,               /* Use 8 kHz sampling rate.      */
    AUDIO_RATE_11_025_KHZ,          /* Use 11.025 kHz sampling rate. */
    AUDIO_RATE_12_KHZ,              /* Use 12 kHz sampling rate.     */
    AUDIO_RATE_16_KHZ,              /* Use 16 kHz sampling rate.     */
    AUDIO_RATE_22_050_KHZ,          /* Use 22.050 kHz sampling rate. */
    AUDIO_RATE_24_KHZ,              /* Use 24 kHz sampling rate.     */
    AUDIO_RATE_32_KHZ,              /* Use 32 kHz sampling rate.     */
    AUDIO_RATE_44_1_KHZ,            /* Use 44.1 kHz sampling rate.   */
    AUDIO_RATE_48_KHZ,              /* Use 48 kHz sampling rate.     */
    AUDIO_RATE_64_KHZ,              /* Use 64 kHz sampling rate      */
    AUDIO_RATE_96_KHZ,              /* Use 96 kHz sampling rate.     */
    MAX_AUDIO_RATE
 } T_ZDrvAudio_SampleRate;

/*  Audio stereoDAC balance left level selection. */
typedef enum{
    AUDIO_STEREO_BALANCE_LEVEL_0 = 0,
    AUDIO_STEREO_BALANCE_LEVEL_1,
    AUDIO_STEREO_BALANCE_LEVEL_2,
    AUDIO_STEREO_BALANCE_LEVEL_3,
    AUDIO_STEREO_BALANCE_LEVEL_4,
    AUDIO_STEREO_BALANCE_LEVEL_5,
    AUDIO_STEREO_BALANCE_LEVEL_6,
    AUDIO_STEREO_BALANCE_LEVEL_7,
    MAX_AUDIO_STEREO_BALANCE_LEVEL     
} T_ZDrvAudio_BalanceLevel;

/* Audio stereoDAC BANLANCE */
typedef struct
{
    T_ZDrvAudio_BalanceLevel   balanceLeft;   /* left */
    T_ZDrvAudio_BalanceLevel   balanceright;  /* right */
} T_ZDrvAudio_Banlance;

/* Audio 3DEFFECT */
typedef struct
{
    UINT16 setbass;                  /*set bass effect*/
    UINT16 setsurr;                  /*set surround effect*/
}T_ZDrvAudio_3DEFFECT;

/* Audio eq mode */
typedef enum 
{
    AUDIO_EQMODE_NORMAL=0,
    AUDIO_EQMODE_CLASSIC,
    AUDIO_EQMODE_POP,
    AUDIO_EQMODE_JAZZ,
    AUDIO_EQMODE_ROCK,
    MAX_AUDIO_EQMODE
}T_ZDrvAUDIO_EQMODE;

/* Audio play info */
typedef struct
{
    UINT32 DataLenth;    /*Total play datalenth(byte).*/
      
} T_ZDrvAudio_PlayInfo;

/* Audio buffer info */
typedef struct         
{
    VOID *buf;           /* Audio buffer pointer */
    UINT32 buffersize;   /* Audio buffer size */
}T_ZDrvAudio_BufInfo;

#if 0
typedef enum
{
    AUDIO_MONO_CHANNEL,
    AUDIO_DUAL_CHANNEL
}T_ZDrvAudio_Channel;
#endif

/* Audio buffer size */
typedef struct
{
    T_ZDrvAudio_Channel channel;
    UINT32 buffersize;
}T_ZDrvAudio_PlayParam;

/**************************************************************************
 *                           Global  Variable                             *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                          *
 **************************************************************************/
typedef void (*T_ZDrvAudio_CallbackFunc) (T_ZDrvAudio_Info);

/**************************************************************************
* Function: zDrv_Open
* Description: This function is used to open device according to device name.
* Parameters: 
*   Input:
            pathname:device name, ZDRV_DEV_AUDIO in audio 
*         flags: no use
*   Output: None
* Returns:   
*       device file descriptor if successed. [1, ZDRV_MAX_DEV_FILE_NUM), please refer to dal_api.h
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
*       DRV_ERR_FD_OVERFLOW: no free fd entry
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       DRV_ERR_OPEN_TIMES: has been opened already. 
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Open (const CHAR *pathname, SINT32 flags)*/


/**************************************************************************
* Function: zDrv_Close
* Description: This function is used to close a device according to device file descriptor.
* Parameters: 
*   Input:
*              fd :device file descriptor 
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support close operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Close(UINT32 fd)*/

/**************************************************************************
* Function: zDrv_Write
* Description: This function is used to write data to a device according to the device file descriptor.
* Parameters:
*       (IN)
*               fd: device file descriptor
*               buf_len: buffer length
*               buf: pointer to the  data to be written
*       (OUT)
*                None 
* Returns:
*       the write byte number of read data if successed
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_DEV_CLOSED: has not been opend yet.
*       DRV_ERR_NOT_SUPPORTED: this device don't support read operation.
*       others: for detailed information, please refer to the header file of hal layer
* Others:   
*       None.

**************************************************************************/
/* SINT32 zDrv_Write(UINT32 fd, VOID *buf, UINT32 buf_len) */

/**************************************************************************
* Function: zDrv_Ioctl
* Description:  This function is used to control audio device.
* Parameters: 
*   Input:
*           private:device private data
*           cmd:command code
*           param:command parameters
*   Output:None
* Returns: 
*           T_ZDrv_ErrCode
*             others: if errcode<-100 ,please refer to the hal layer errcode file

* Others:     cmd-arg 
                     1  CMD:IOCTL_AUDIO_RECORD_START:
                              arg: T_ZDrvRcd_InfoParam*
                            return:
         
                     2  CMD:IOCTL_AUDIO_RECORD_STOP:
                              arg: void
                            return: 
         
                     3  CMD:IOCTL_AUDIO_SET_RECORD_PATH:
                              arg: T_HalAudio_Block*
                            return:   
           
                     4  CMD:IOCTL_AUDIO_SET_RECORD_VOL:
                              arg: T_HalAudio_Block*
                            return:   

                     5  CMD:IOCTL_AUDIO_RECORD_GETDATA:
                              arg: T_ZDrvAudio_BufInfo*
                            return:     

                     6  CMD:IOCTL_AUDIO_RCD_FREE_BUFF:
                              arg: VOID
                            return: 

                     7  CMD:IOCTL_AUDIO_SET_SAMPLE:
                              arg: T_ZDrvAudio_SampleRate*
                            return: 
         
                     8  CMD:IOCTL_AUDIO_SET_BANLANCE:
                              arg: T_ZDrvAudio_Banlance*
                            return: 

                     9  CMD:IOCTL_AUDIO_SET_OUTPUT_PATH:
                              arg: T_ZDrv_AudioOutputPath*
                            return: 
                               
                     10  CMD:IOCTL_AUDIO_SET_OUTPUT_VOL:
                              arg: T_ZDrvAudio_OutputVolLevel*
                            return:    
         
                     11  CMD:IOCTL_AUDIO_SET_EQMODE:
                              arg: T_ZDrvAUDIO_EQMODE*
                            return: 
         
                     12  CMD:IOCTL_AUDIO_ENABLE_3DEFFECT:
                              arg: T_ZDrvAudio_3DEFFECT*
                            return: 
                
                     13  CMD:IOCTL_AUDIO_SET_MUTE:
                              arg: BOOL*
                            return:     
        
                     14  CMD:IOCTL_AUDIO_PLAY_START:
                              arg: VOID*;
                            return: 
         
                     15  CMD:IOCTL_AUDIO_PLAY_STOP:
                              arg: VOID*;
                            return: 
         
                     16  CMD:IOCTL_AUDIO_PLAY_PAUSE:
                              arg: VOID*;
                            return: 
         
                     17  CMD:IOCTL_AUDIO_PLAY_RESUME:
                              arg: VOID*;
                            return: 
         
                     18  CMD:IOCTL_AUDIO_GET_PLAY_INFO:
                              arg: T_ZDrvAudio_PlayInfo*
                            return:    
         
                     19  CMD:IOCTL_AUDIO_GET_BUFFER:
                              arg: T_ZDrvAudio_BufInfo*
                            return: 
                     20. CMD :IOCTL_AUDIO_SET_RECORD_SAMPLE:
                             arg: T_ZDrvAudio_SampleRate*
                            return: 
                            
                     21  CMD:MAX_IOCTL_AUDIO
                          ERROR CMD INPUT        
                                                               
**************************************************************************/
/* SINT32 zDrv_Ioctl(UINT32 fd, UINT32 cmd, VOID* arg); */

/**************************************************************************
* Function: zDrv_Read
* Description: This function is used to read data from a device according to device file descriptor.
* Parameters:
*   Input:
*	    fd:device file descriptor
*         buf: user buffer pointer
*	    buf_len:buffer length
*   Output:	
*         buf:pointer to the read data buffer			 
* Returns:
*   DRV_SUCCESS:success to read data
*   DRV_ERR_NOT_OPENED:device is not openned before
*   DRV_ERROR:fail to read data
*   DRV_ERR_INVALID_PARAM: invalid paraments.
* Others: None

**************************************************************************/
/*SINT32 zDrv_Read(UINT32 fd, VOID *buf, UINT32 buf_len)*/


#endif  /* _AUDIO_API_H */
