/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_io_led.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        yuxiang
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_CHG_H
#define _DRVS_IO_CHG_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define ZDRV_DEV_CHG  "charger"

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum
{
    CHG_STATE_CALLBACK_AC_IN,
    CHG_STATE_CALLBACK_AC_OUT,
    CHG_STATE_CALLBACK_USB_IN,
    CHG_STATE_CALLBACK_USB_OUT,
    CHG_STATE_CALLBACK_START,
    CHG_STATE_CALLBACK_STOP,
    CHG_STATE_CALLBACK_FINISH,
    CHG_STATE_CALLBACK_LOAD_IN,
    CHG_STATE_CALLBACK_LOAD_OUT,
    CHG_STATE_CALLBACK_ABNORMAL,
    CHG_STATE_CALLBACK_LOW_VOL_DETECT,
    CHG_STATE_CALLBACK_OVER_TEMP_PROTECT,

    CHG_STATE_CALLBACK_MAX
}T_ZDrvChg_CallbackState;

/*the message that should send to dm*/
 typedef enum
 {
    STATE_CHARGING,                 /*charge start msg*/
    STATE_DISCHARGING,                     /*charge stop msg*/
    STATE_FINISH,                      /*charge stop msg*/
    STATE_TEMP_ABORT,
    STATE_TEMP_ERROR,
    STATE_ERROR,

    STATE_MAX

} T_ZDrvChg_Status;

 typedef enum
 {
	 DISCHG_STATUS_ON = 0,	 
	 DISCHG_STATUS_OFF,
	 DISCHG_STATUS_MAX
 }T_ZDrvChg_DisChgStatus;

 typedef enum
 {
	 USB_STATUS_IN = 0,	 
	 USB_STATUS_OUT,
	 USB_STATUS_MAX
 }T_ZDrvChg_UsbStatus;


 typedef enum 
 {
    CHG_TYPE_NOTHING, 
    CHG_TYPE_COMPUTER,                
    CHG_TYPE_CHARGER, 
    
    CHG_TYPE_MAX    
} T_ZDrvChg_ChgType;

/*temperature detect*/
typedef enum
{
    CHG_TEMP_DETECT_SUPER_LOW,
    CHG_TEMP_DETECT_LOW,
    CHG_TEMP_DETECT_NORMAL,
    CHG_TEMP_DETECT_HIGH,
    CHG_TEMP_DETECT_HIGH_55,
    CHG_TEMP_DETECT_SUPER_HIGH,

    CHG_TEMP_DETECT_MAX
}T_ZDrvChg_TempDetect;

typedef enum
{
	CHG_SWTICH_CHG_OFF,
	CHG_SWTICH_CHG_ON,

	CHG_SWTICH_CHG_MAX
}T_ZDrvChg_ChgSwitch;

typedef enum
{
	CHG_SWTICH_DISCHG_OFF,
	CHG_SWTICH_DISCHG_ON,

	CHG_SWTICH_DISCHG_MAX
}T_ZDrvChg_DisChgSwitch;

typedef enum
{
	CHG_OTG_STATE_OFF,
	CHG_OTG_STATE_ON,

	CHG_OTG_STATE_MAX
}T_ZDrvChg_OTGState;

typedef enum
{
	CHG_SHIPPINGMODE_OFF,
	CHG_SHIPPINGMODE_ON,

	CHG_SHIPPINGMODE_MAX
}T_ZDrvChg_ShippingMode;


typedef enum
{
	CHG_ERROR_DPM_STATE = 1<<11,
	CHG_ERROR_POWER_BAD = 1<<10, /*the diff*/
	CHG_ERROR_VSYS_MINI = 1<<8,
	CHG_ERROR_TERM_STATE = 1<<9,
	CHG_ERROR_WACHDOG_FAULT = 1<<7,
	CHG_ERROR_OTG_FAULT = 1<<6,
	CHG_ERROR_CHRG_OVP = 1<<5,
	CHG_ERROR_CHRG_TIMEOUT = 1<<4,
	CHG_ERROR_BAT_FAULT = 1<<3,
	CHG_ERROR_NTC_COLD = 1<<1,
	CHG_ERROR_NTC_HOT = 1<<0,
	CHG_ERROR_STATE_CONFLIT = 1<<15,


	CHG_ERROR_MAX = 1<<16,
}T_ZDrvChg_ErrorCode;


typedef enum
{
	CHG_QUICK_START_OFF,
	CHG_QUICK_START_ON,

	CHG_QUICK_START_MAX
}T_ZDrvChg_QucikStartFlag;

typedef enum
{
	CHG_NOT_STOP,
	CHG_COMPLETE,
	AC_NOT_EXIST,
	CHG_TEMP_OVERFLOW,
	CHG_OTHER_REASON
}T_ZDrvChg_StopReason;
/*charge stop reason*/


typedef void(*T_ZDrvCHG_CALLBACK)(T_ZDrvChg_CallbackState); /*the send msg callback function */


#endif/*_DRVS_IO_LED_H*/

