/***********************************************************************
* Copyright (C) 2014, ZTE Corporation.
* 
* File Name: drvs_io_lcd.h
* File Mark:  	
* Description:  lcd define.
* Others:  	
* Version:  1.0
* Author:   YinWenguan
* Date:      2014-11-11
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/

#ifndef    _DRVS_IO_LCD_H_
#define    _DRVS_IO_LCD_H_
#include "drvs_vou.h"
#include "drvs_vou_ref.h"

/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/


/*************************************************************************
  *                                  Macro                                                                                  *
  *************************************************************************/

/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/
typedef enum
{
    LCD_DCX_CMD = 0,    // ͵ƽ
    LCD_DCX_DATA,       // ߵƽ

    MAX_LCD_DCX_TYPE
} T_ZDrvLcd_DcxType; // transmission byte type

typedef enum 
{
    LCD_XFER_POLL = 0, // ѯʽ
    LCD_XFER_INT,       // жϷʽ
    LCD_XFER_DMA,   // DMAʽ
    LCD_XFER_CPU,
    
    MAX_LCD_XFER_TYPE
} T_ZDrvLcd_XferType;

/* lcd mode */
typedef enum
{
    LCD_NORMAL,        /* normal mode */
    LCD_SLEEP,          /* sleep mode */

    MAX_LCD_MODE
} T_ZDrvLcd_Mode;

/* lcd instance */
typedef struct
{
    BOOL                        bOpen;  /* status: open, close */
    T_ZDrvLcd_Mode          eMode;    /* working mode: normal, sleep */
    T_ZDrvLcd_XferType      eXferType; /* poll, interrupt or DMA */
    T_ZDrvLcd_DcxType       eDcxType; /* command or parameter/data */
    ZOSS_MUTEX_ID           mutexUpdate; /* mutex for updating rectangle */
    ZOSS_SEMAPHORE_ID   semDmaInt; /* semaphore for DMA transimision */
} T_ZDrvLcd_Instance;

#if IOKEYS(IOCTL_LCD_UPDATE)
typedef struct
{
    UINT16 uiLeft;
    UINT16 uiTop;
    UINT16 uiWidth;
    UINT16 uiHeight;
    UINT8* pBuf;
} T_ZDrvLcd_DisplayParam;
#endif

#if IOKEYS(IOCTL_LCD_SLEEP)
typedef enum
{
    LCD_SLEEP_OUT = 0,
    LCD_SLEEP_IN,
    
} T_ZDrvLcd_SleepStatus;
#endif

#if IOKEYS(IOCTL_LCD_BACKLIGHT)
typedef enum
{
    LCD_BACKLIGHT_OFF = 0,
    LCD_BACKLIGHT_ON,
    
} T_ZDrvLcd_BacklightStatus;
#endif

#if IOKEYS(IOCTL_LCD_BRIGHTNESS)
typedef unsigned int T_ZDrvLcd_Brightness; /* [0, 255]: 0 - darkest; 255 - brightest */
#endif

#if IOKEYS(IOCTL_LCD_GET_INFO)
typedef struct
{
    UINT16  width;
    UINT16  height;
    UINT16  bitsPerPixel;
    UINT16  rMask;
    UINT16  gMask;
    UINT16  bMask;
    UINT16  lcd_pow_st;
    UINT16  lcd_pix_st;   
    T_ZDrvLcd_Instance instance;
    T_ZDrvLcd_BacklightStatus backlight;
    T_ZDrvLcd_Brightness brightness;

} T_ZDrvLcd_Info;

typedef struct
{
    T_ZDrv_OSDInfo *OSD_Info;
	T_ZDrvLcd_Info *Lcd_Info;

}T_ZDrv_LCDVOUInfo;

#endif

#endif
