/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	earpiece_api.h
* File Mark:  	
* Description:  Provide earpiece module function prototype declaration and type declaration.
* Others:  	
* Version:  	v0.5
* Author:  	LvWenhua
* Date:  	      2007-10-25
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
**********************************************************************/

#ifndef _EARPIECE_API_H
#define _EARPIECE_API_H

/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/

/**************************************************************************
 *                                  Macro                                                                                      *
 **************************************************************************/
#define ZDRV_DEV_EARP   "earpiece"  /*The device name of earpiece driver.*/

/**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/
/*Information from driver to upper application.*/
typedef enum {
    EARP_INFO_PLUG           = 0, /*Earpiece is plugged.*/
    EARP_INFO_UNPLUG              , /*Earpiece is unplugged.*/
    EARP_INFO_HOOK_SWITCH      ,  /*Earpiece hook key is pressed and released.*/

    MAX_EARP_INFO             
} T_ZDrvEarp_Info;

typedef enum {
    EARP_STATE_PLUG          = 0, /*Earpiece is plugged.*/
    EARP_STATE_UNPLUG           , /*Earpiece is unplugged.*/

    MAX_EARP_STATE             
} T_ZDrvEarp_State;

typedef void (*T_ZDrvEarp_CallbackFunc) (T_ZDrvEarp_Info);

#if 0
typedef enum 
{
    IOCTL_EARP_SET_CALLBACK     = 0,  /*Set callback function, it is used to register the callback function which will send the earpiece switch status to user.*/
    IOCTL_EARP_GET_PLUG_STATUS   ,  /*Get earpiece plug status, replace the read function.*/
    IOCTL_EARP_SET_HOOK_ENABLE,
    IOCTL_EARP_SET_HOOK_DISABLE,
    MAX_IOCTL_EARP
}T_ZDrvEarp_IoCtl;
#endif

/**************************************************************************
 *                           Global  Variable                                                                              *
 **************************************************************************/

/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/

/**************************************************************************
* Function: zDrv_Open
* Description: This function is used to open device according to device name.
* Parameters: 
*   Input:
            pathname:device name, ZDRV_DEV_EARP in earpiece 
*	     flags: no use, 0
*   Output: None
* Returns:   
*       device file descriptor if successed. [1, ZDRV_MAX_DEV_FILE_NUM), please refer to dal_api.h
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
*       DRV_ERR_FD_OVERFLOW: no free fd entry
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       DRV_ERR_OPEN_TIMES: has been opened already. 
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Open (const CHAR *pathname, SINT32 flags)*/

/**************************************************************************
* Function: zDrv_Close
* Description: This function is used to close a device according to device file descriptor.
* Parameters: 
*   Input:
*              fd :device file descriptor 
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support close operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Close(UINT32 fd)*/

/**************************************************************************
* Function: zDrv_Ioctl
* Description:  This function is used to control device according to fd(device file descriptor).
* Parameters: 
*   Input:
*           fd:device file descriptor
*           cmd:command code
*           arg:command parameters
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_IOCTL_CMD: this command has not been supported yet.
*       others: for detailed information, please refer to the header file of hal layer
*
* Others: 	None
**************************************************************************/
/*SINT32 zDrv_Ioctl(UINT32 fd, UINT32 cmd, VOID* arg)*/

/**************************************************************************
* Function: zDrvEarp_Init
* Description: This function is used to install earpiece driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_OVERFLOW: no free device driver entry in table
*       DRV_ERR_MEM_ALLOC: failed to alloc memory
* Others: None
**************************************************************************/
SINT32 zDrvEarp_Init(VOID);

/**************************************************************************
* Function: zDrvEarp_Exit
* Description: This function is used to uninstall earpiece driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_TABLE: device driver table has been invalid.
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
* Others: None
**************************************************************************/
SINT32 zDrvEarp_Exit(VOID);

#endif  /* _EARPIECE_API_H */

