/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	hal_dsp.h
* File Mark:  	
* Description:  tu hal interface declaration.
* Others:  	
* Version:  v1.0
* Author:   wangxia
* Date:      2008-08-28
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/

#ifndef    HAL_DSP_H
#define    HAL_DSP_H


/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/


/*************************************************************************
  *                                  Macro                                                                                  *
  *************************************************************************/


/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/
typedef enum
{
    GSM_DSP_INT0 ,/*90*/
    GSM_DSP_INT1,/*91*/
    GSM_DSP_INT2,/*92*/
    GSM_DSP_INT3,/*93*/
    GSM_DSP_INT4,/*94*/
    GSM_DSP_INT5,/*95*/
    GSM_DSP_INT6,/*96*/
    GSM_DSP_INT7,/*97*/

    MAX_DSP_INT
} T_ZDrvDsp_IntId;

/**************************************************************************
 *                           Global  Variable                                                                             *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
/**************************************************************************
* Functin: zDrvDsp_IntRegister
* Description: This function is used to regist isr callback for l1g.
* Parameters:
*       (IN)
*               intNumber: T_ZDrvDsp_IntId.
*               cb: isr callback.
*		   intPrio:prio of interrupt
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
**************************************************************************/
SINT32 zDrvDsp_IntRegister(T_ZDrvDsp_IntId  intNumber,VOID (*cb)(VOID),UINT32 intPrio);


#endif    /* HAL_DSP_H */

