/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  all function defines provided by sys module
 * Others:
 * Version:       1.0
 * Author:        chenjianguo
 * Date:          2013-5-31
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_SPINLOCK_H
#define _DRVS_SPINLOCK_H

#include "drvs_general.h"
/****************************************************************************
* 	                                        Include files
****************************************************************************/

/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum 
{
	CORE_ID_PS=210,
	CORE_ID_PHY=211,
	CORE_ID_ZSP=212,
	CORE_ID_M0=213,
	CORE_ID_AP=214,
	CORE_ID_NUM = 215
}  T_ZDrvSpinlock_CpuId;
/* ʶӲ*/
typedef enum
{
	PCU_HWLOCK  = 0,/*PCU*/
	CLK_HWLOCK  = 1,/*Clock*/
	REGLOCK_HWLOCK	= 2,/*Reg*/
	SOFTLOCK_HWLOCK = 3,/*Software*/
	HWLOCK_NUM	
} T_ZDrvSpinlock_HwLockId;

/* ʶ*/
typedef enum
{
	I2C0_SFLOCK = 0,/*i2c0*/
	I2C1_SFLOCK = 1,/*i2c1*/
	I2C2_SFLOCK = 2,/*pmic-i2c*/
	NAND_SFLOCK = 3,/*NAND*/
	SD0_SFLOCK,
	SD1_SFLOCK,
	ADC_SFLOCK,     /*pmic adc*/
	UART_SFLOCK,
	SFLOCK_ID8,
	SFLOCK_ID9,
	SFLOCK_ID10,
	SFLOCK_ID11,
	SFLOCK_ID12,
	SFLOCK_ID13,
	SFLOCK_ID14,
	SFLOCK_ID15,
	SFLOCK_ID16,
	SFLOCK_ID17,
	SFLOCK_ID18,
	SFLOCK_ID19,
	SFLOCK_ID20,
	SFLOCK_ID21,
	SFLOCK_ID22,
	SFLOCK_ID23,
	SFLOCK_ID24,
	SFLOCK_ID25,
	SFLOCK_ID26,
	SFLOCK_ID27,
	SFLOCK_ID28,
	SFLOCK_ID29,
	SFLOCK_ID30,
	REG_SFLOCK = 31,/*reg*/
	SFLOCK_NUM	
} T_ZDrvSpinlock_SfLockId;
/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
 * Function: zDrvSysSpinlock_HwLock
 * Description:ȡӲid 0~1
 *			id 4ʹãⲿá
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_HwLock(T_ZDrvSpinlock_HwLockId hwid);
/*******************************************************************************
 * Function: zDrvSysSpinlock_HwUnlock
 * Description:ͷӲid 0~1
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_HwUnlock(T_ZDrvSpinlock_HwLockId hwid);
/*******************************************************************************
 * Function: zDrvSysSpinlock_SoftLock
 * Description:ӿ
 * Parameters:
 *   Input:	sfid: id
 *			
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
  VOID  zDrvSysSpinlock_SoftLock(T_ZDrvSpinlock_SfLockId sfid);
/*******************************************************************************
 * Function: zDrvSysSpinlock_soft_unlock
 * Description:zDrvSysSpinlock_SoftLockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_SoftUnlock(T_ZDrvSpinlock_SfLockId sfid);
/*******************************************************************************
 * Function: zDrvSysSpinlock_SoftLockPsm
 * Description:ӿ(ʡר)
 * Parameters:
 *   Input:	sfid: id
 *			coreid: idΪsfidcpuid
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_SoftLockPsm(T_ZDrvSpinlock_SfLockId sfid);

/*******************************************************************************
 * Function: zDrvSysSpinlock_SoftUnlockPsm
 * Description:zDrvSysSpinlock_SoftLockPsmӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_SoftUnlockPsm(T_ZDrvSpinlock_SfLockId sfid);

/*******************************************************************************
 * Function: zDrvSysSpinlock_RegLock
 * Description:ӿ
 * Parameters:
 *   Input:	
 *			
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
  VOID  zDrvSysSpinlock_RegLock(VOID);
/*******************************************************************************
 * Function: zDrvSysSpinlock_reg_unlock
 * Description:zDrvSysSpinlock_RegLockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID  zDrvSysSpinlock_RegUnlock(VOID);
/*******************************************************************************
 * Function: zDrvSysSpinlock_Initiate
 * Description:ʼ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvSysSpinlock_Initiate(VOID);
#endif/*_DRVS_SYS_H*/

