/***********************************************************************
* Copyright (C) 2016, ZTE Corporation.
* 
* File Name:    drvs_tdm.h
* File Mark:  	
* Description:  TDM hal interface declaration.
* Others:  	
* Version:  v1.0
* Author:   daixunkang
* Date:     2018-02-26
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  
**********************************************************************/
#ifndef _HAL_TDM_H
#define _HAL_TDM_H
/*************************************************************************
 *                                  Include files                        *
  *************************************************************************/
#include "drvs_general.h"
#include "drvs_io_voice.h"
#include "drvs_i2s.h"
/*************************************************************************
 *                                  Macro                                 *
  *************************************************************************/


/**************************************************************************
*                                  Types                                   *
 **************************************************************************/
#define TDM_MOD_CLK_SEL *((volatile UINT32 *)(SOC_CRM_REG_BASE+0x50))
#define DMA_SEL_CFG *((volatile UINT32 *)(SOC_SYS_REG_BASE+0x120))

typedef enum
{
    TDM_NORMAL_MODE,
    TDM_LOOPBACK_MODE,

    MAX_TDM_TEST_MODE
} T_ZDrvTdm_TestMode;

typedef enum
{
    TDM_MSB_FIRST,
    TDM_LSB_FIRST,
    
    MAX_FIRSTBIT
} T_ZDrvTdm_FstBitSel;

typedef enum {
    TDM_CLK_8000 = 0x00,
    TDM_CLK_16000 = 0x01,

    TDM_MAX_CLK
} T_ZDrvTdm_Clk;

typedef enum
{
    TDM_1_SLOT = 0x00,
    TDM_2_SLOT = 0x01,
    TDM_3_SLOT = 0x02,
    TDM_4_SLOT = 0x03,
    TDM_5_SLOT = 0x04,
    TDM_6_SLOT = 0x05,
    TDM_7_SLOT = 0x06,
    TDM_8_SLOT = 0x07,
    TDM_9_SLOT = 0x08,
    TDM_10_SLOT = 0x09,
    TDM_16_SLOT = 0xa,
    TDM_32_SLOT = 0xb,
    TDM_64_SLOT = 0xc,
    //TDM_128_SLOT = 0x7f,

    MAX_TDM_SLOTNUM
} T_ZDrvTdm_SlotNum;

typedef enum
{
    TDM_TS_8CYCLE = 0x0,
	TDM_TS_16CYCLE = 0x1,
	TDM_TS_32CYCLE = 0x2,
    MAX_TDM_TS_WIDTH
} T_ZDrvTdm_TsWidth;

/*TDM track select*/

typedef enum
{
    TDM_1TS_ENABLE = 0x00,
    TDM_2TS_ENABLE   = 0x01,

    MAX_TDM_TS_ENABLE
} T_ZDrvTdm_TsEnable;

typedef enum
{
    TDM_TX_1BIT_OFFSET = 0x01,
    TDM_TX_2BIT_OFFSET = 0x02,
	TDM_TX_3BIT_OFFSET = 0x03,
	TDM_TX_4BIT_OFFSET = 0x04,

    MAX_TDM_TX_OFFSET
} T_ZDrvTdm_TxOffset;

typedef enum
{
    TDM_RX_1BIT_OFFSET = 0x01,
    TDM_RX_2BIT_OFFSET = 0x02,
	TDM_RX_3BIT_OFFSET = 0x03,
	TDM_RX_4BIT_OFFSET = 0x04,

    MAX_TDM_RX_OFFSET
} T_ZDrvTdm_RxOffset;

typedef VOID(*T_ZDrvTdm_AUD_PLAY_CB)(VOID); 
/* TDM configuration */

typedef enum
{
    TDM_FS_CLK_NEG = 0,
    TDM_FS_CLK_POS,
    
    MAX_FS_CLK_SELECT
} T_ZDrvTdm_FsClkSel;

typedef enum
{
    TDM_TX_CLK_NEG = 0,
    TDM_TX_CLK_POS,
	
    MAX_TX_CLK_SELECT
} T_ZDrvTdm_TxClkSel;

typedef enum
{
    TDM_RX_CLK_NEG = 0,
    TDM_RX_CLK_POS,
	
    MAX_RX_CLK_SELECT
} T_ZDrvTdm_RxClkSel;

typedef enum
{
    TIMING_TDM_FS_1CLK = 0,
    TIMING_TDM_FS_2CLK,
    TIMING_TDM_FS_3CLK,
	TIMING_TDM_FS_4CLK,
	TIMING_TDM_FS_32CLK = 31,

    MAX_FS_WIDTH
} T_ZDrvTdm_FsWidth;

typedef enum
{
    TIMING_TDM_FS_HIGH = 0,
    TIMING_TDM_FS_LOW = 1,

    MAX_FS_ACTIVE
} T_ZDrvTdm_FsActive;

typedef struct
{
    BOOL               bMaster;        /* TRUE: master mode; FALSE: slave mode */
	UINT32 sample_rate;    
    T_ZDrvTdm_FsClkSel   fsClkSel;
    T_ZDrvTdm_TxClkSel   txClkSel;
    T_ZDrvTdm_RxClkSel   rxClkSel;
	T_ZDrvTdm_TsWidth  tTsWidth;	   /*T_ZDrvTDM_TsWidth*/
    T_ZDrvTdm_SlotNum  tSlotNum;
    T_ZDrvTdm_FsWidth  tFsWidth;	
    T_ZDrvTdm_FsActive  tFsActive;	
    T_ZDrvTdm_FstBitSel tTdmFstBit;
    T_ZDrvTdm_TestMode  tTestMode;
    T_ZDrvTdm_TsEnable  tTsEnable;
	T_ZDrvTdm_TxOffset	tTxOffset;
	T_ZDrvTdm_RxOffset	tRxOffset;
	//T_Tdm_RefClkForTdm  refclk;

} T_ZDrvTdm_Cfg;

typedef struct
{
    T_ZDrvAudio_Channel channel;
    UINT32 buffersize;
	T_ZDrvTdm_AUD_PLAY_CB p_cb; 
} T_ZDrvTdm_Params;

/**************************************************************************
 *                           Global  Variable                                                                             *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
/**************************************************************************
* Function: zDrvTDM_Open
* Description: This function is used to open a specified TDM device.
* Parameters:
*       (IN)
*               tId: TDM index
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_OPEN_TIMES: has already been opened
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
**************************************************************************/
SINT32 zDrvTdm_Open(T_ZDrvI2s_TransMode tdmTransMode);

SINT32 zDrvTdm_Reset();

/**************************************************************************
* Function: zDrvTDM_Close
* Description: This function is used to close a specified TDM device.
* Parameters:
*       (IN)
*               tId: TDM index
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*       must match the use of zDrvTDM_Open.
**************************************************************************/
SINT32 zDrvTdm_Close();

/**************************************************************************
* Function: zDrvTDM_Start
* Description: This function is used to start TDM.
* Parameters:
*       (IN)
*               tId: TDM index
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_START_TIMES: has been started already. 
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
**************************************************************************/
SINT32 zDrvTdm_Start(UINT32 buf_size);

/**************************************************************************
* Function: zDrvTDM_Stop
* Description: This function is used to stop TDM.
* Parameters:
*       (IN)
*               tId: TDM index
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_STARTED: has not been started yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*       must match the use of zDrvTDM_Start.
**************************************************************************/
SINT32 zDrvTdm_Write_Stop();
SINT32 zDrvTdm_Read_Stop();

/**************************************************************************
* Function: zDrvTDM_Read
* Description: This function is used to read data by TDM.
* Parameters:
*       (IN)
*               tId: TDM index
*               uiLen: buffer length
*       (OUT)
*               pBuf: pointer to the read data buffer             
* Returns:
*       the real byte number of read data if successed
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_STARTED: has not been started yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
**************************************************************************/
SINT32 zDrvTdm_Read(UINT8 **pBuf, UINT32 *uiLen);

/**************************************************************************
* Function: zDrvTDM_Write
* Description: This function is used to write data by TDM.
* Parameters:
*       (IN)
*               tId: TDM index
*               pBuf: pointer to the read data buffer             
*               uiLen: buffer length
*       (OUT)
*               None.
* Returns:
*       the real byte number of write data if successed
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_STARTED: has not been started yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_BUSY: now is transfering data
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
**************************************************************************/
SINT32 zDrvTdm_Write(const UINT8 *pBuf, UINT32 uiLen);

SINT32 zDrvTdm_Write_Start(T_ZDrvTdm_Params *params, T_ZDrvTdm_Cfg *ptCfg);
SINT32 zDrvTdm_Read_Start(T_ZDrvTdm_Params *params, T_ZDrvTdm_Cfg *ptCfg);
SINT32 zDrvTdm_Vousb_Start(T_ZDrvTdm_Params *params, T_ZDrvTdm_Cfg *ptCfg);

SINT32 zDrvTdm_GetBuf(UINT8 **pBuf, UINT32 *uiLen);
SINT32 zDrvTdm_GetRemained(UINT32 *len);
SINT32 zDrvTdm_FreeBuf(UINT8 *pBuf);
VOID zDrvTdm_Pause();
VOID zDrvTdm_Resume();

VOID zDrvTdm_RxRlsSemaBeforeStop();
VOID zDrvTdm_TxRlsSemaBeforeStop();

#endif    /* _HAL_TDM_H */
