/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  all function defines provided by sys module
 * Others:
 * Version:       1.0
 * Author:        limeifeng
 * Date:          2014-01-17
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_TIMER_H
#define _DRVS_TIMER_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#ifdef _OS_LINUX
#include <linux/delay.h>
#endif

/****************************************************************************
* 	                                        Macros
****************************************************************************/

#define SYSTIMER_INT  TIMER0_INT

/****************************************************************************
* 	                                        Types
****************************************************************************/


typedef enum _T_ZDrv_TimerId
{
    TIMER0 = 0,/*ps timer0--sysTick */
    TIMER1 = 1,/*ps timer1--psm wake timer,must AON tiner**/
    TIMER2 = 2,/*ps timer2--psm compensate timer,must AON tiner*/
    TIMER3 = 3,/* rm timer1*/
    TIMER4 = 4,/*ps rm timer--uicc timer*/
    NUM_TIMERS
}T_ZDrv_TimerId;

typedef enum _T_ZDrv_TIMER_SRC_CLK
{
    CLK_32K = 0,
    CLK_26M,
}T_ZDrv_TIMER_SRC_CLK;

typedef enum _T_ZDrv_TIMER_SRC_DIV
{
    CLK_DIV0 = 0,
    CLK_DIV2 = 1,
    CLK_DIV4 = 3,
    CLK_DIV6 = 5,
    CLK_DIV8 = 7,
    CLK_DIV10 = 9,
    CLK_DIV12 = 11,
    CLK_DIV14 = 13,
    CLK_DIV16 = 15,
    CLK_DIV_NUM,
}T_ZDrv_TIMER_SRC_DIV;

typedef enum _T_ZDrv_CLK_PTV
{
    CLK_PTV0 =0,		/*not divide the work clock*/
    CLK_PTV1 ,  		/*divide the work clock 2 times*/
    CLK_PTV2,       	/*divide the work clock 4 times*/
    CLK_PTV3,       	/*divide the work clock 8 times*/
    CLK_PTV4,
    CLK_PTV5,
    CLK_PTV6,
    CLK_PTV7,
    CLK_PTV8,
    CLK_PTV9,
    CLK_PTV10,
    CLK_PTV11,
    CLK_PTV12,
    CLK_PTV13,
    CLK_PTV14,
    CLK_PTV15,
    CLK_PTV16,
    CLK_PTV17,
    CLK_PTV18,
    CLK_PTV19,
    CLK_PTV20,
    CLK_PTV21,
    CLK_PTV22,
    CLK_PTV23,
    CLK_PTV24,
    CLK_PTV25,
    CLK_PTV26,
    CLK_PTV27,
    CLK_PTV28,
    CLK_PTV29,
    CLK_PTV30,
    CLK_PTV31,         /*divide the work clock 2**31 times*/
    CLK_PTV_NUM,
}T_ZDrv_CLK_PTV;

/*CLK_1MHz: src_clk=26MHz    CLK_1KHz: src_clk=32KHz.*/
typedef enum _T_ZDrv_TIMER_CLK
{
    CLK_1MHz = 0,
    CLK_1KHz,
    TIMER_CLK_NUM,
}T_ZDrv_TIMER_CLK;

typedef VOID (*ZDRV_TIMER_CALLBACK)(VOID);
typedef VOID (*ZDRV_TIMER_ISR_CALLBACK)( UINT32 uiTimerId );

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/


/*******************************************************************************
 * Function: zDrvTimer_Stamp
 * Description:úڻȡϵͳtimerϵͳеľʱ䣬ϵͳж
 *             1msԼϵͳ˯ߵʱ䲹
 * Parameters:
 *   Input:
 *
 *   Output: ϵͳʱ䣬26M(λ:us) 32K(λ:ms) 
 *
 * Returns:
 *
 * Others:
 ********************************************************************************/
UINT32 zDrvTimer_Stamp( VOID );

/**************************************************************************
* Functin: zDrvTimer_Create
* Description: This function is used to create a timer.
* Parameters:
*		(IN)
*				pCallback: callback function pointer.
*				bPeriod: if auto-restart after the interval val reached zero
*		(OUT)
*				None.
* Returns:
*		timer id if successed. [1, timers number )
*		DRV_ERROR if failed.
* Others:
*		None.
**************************************************************************/
SINT32 zDrvTimer_Create( ZDRV_TIMER_CALLBACK pCallback, BOOL bPeriod );


/**************************************************************************
* Functin: zDrvTimer_Release
* Description: This function is used to release a timer.
* Parameters:
*		(IN)
*				uiTimerId: the id of created timer.
*		(OUT)
*				None.
* Returns:
*		DRV_SUCCESS: successed.
*		DRV_ERROR if failed.
* Others:
*		None.
**************************************************************************/
SINT32 zDrvTimer_Release( UINT32 uiTimerId );

/**************************************************************************
* Functin: zDrvTimer_Start
* Description: This function is used to start a timer.
* Parameters:
*		(IN)
*				uiTimerId: the id of created timer.
*				uiDuration: time length. Unit: us
*		(OUT)
*				None.
* Returns:
*		DRV_SUCCESS: successed.
*		DRV_ERROR if failed.
* Others:
*		None.
**************************************************************************/
SINT32 zDrvTimer_Start( UINT32 uiTimerId, UINT32 uiDuration );

/*******************************************************************************
 * Function:zDrvTimer_SetWorkClk
 * Description:TIMER_ID ʱԴƵʡרãģ鲻
 * Parameters:
 *   Input:TIMER_ID : Timer ID , zDrvTimer_Open Ρ
 *		 tick: CLK_1MHzʱԴѡ26M
 			 CLK_1KHz ʱԴѡ32K
 *   Output:ɹDRV_SUCCESSֵʾʧԭ
 *
 * Returns:
 *
 *
 * Others:ʡרãģ鲻!!!
 ********************************************************************************/
SINT32 zDrvTimer_SetWorkClk(T_ZDrv_TimerId TIMER_ID, T_ZDrv_TIMER_CLK tick);
/*******************************************************************************
* Function: zDrvTimer_SetCallBack
* Description: zDrvTimer_StartTimer趨صô˺
* 			˺ṩһzDrvTimer_StartTimer֮עصķ
* Parameters:
*   Input:uiTimerId : Timer ID , zDrvTimer_Open ķֵ
*		fIsrCb: ϣڶʱ0ʱtimerжISRִеĻص
*   Output:
*
* Returns:
*
* Others:ʡרãģ鲻!!!
********************************************************************************/
SINT32 zDrvTimer_SetCallBack(T_ZDrv_TimerId uiTimerId, ZDRV_TIMER_ISR_CALLBACK fIsrCb);

/*******************************************************************************
 * Function:zDrvTimer_Open
 * Description::zDrvTimer_Open->zDrvTimer_SetWorkClk->zDrvTimer_StartTimer->zDrvTimer_Close
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:ʡרãģ鲻
 ********************************************************************************/
SINT32 zDrvTimer_Open( T_ZDrv_TimerId TIMER_ID);
/*******************************************************************************
 * Function:zDrvTimer_Close
 * Description:رնӦʱжж
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:ɹDRV_SUCCESSֵʾʧԭ
 *
 *
 * Others:ʡרãģ鲻!!!
 ********************************************************************************/
SINT32 zDrvTimer_Close( T_ZDrv_TimerId uiTimerId );
/*******************************************************************************
 * Function:zDrvTimer_StartTimer
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:ɹDRV_SUCCESSֵʾʧԭ
 *
 *
 * Others:ʡרãģ鲻!!!
 ********************************************************************************/
SINT32 zDrvTimer_StartTimer( T_ZDrv_TimerId uiTimerId, UINT32 uiDuration, BOOL bPeriod , ZDRV_TIMER_ISR_CALLBACK fIsrCb );

/*******************************************************************************
 * Function:zDrvTimer_Remain
 * Description:ѯǰʱʣඨʱʱ䡣
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:ʣඨʱʱ䣬λzDrvTimer_SetWorkClkõʱԴƵȷ
 *		  ʱԴΪ1M_HZʱλΪus1K_HZʱλΪms
 *
 *
 * Others:ʡרãģ鲻!!!
 ********************************************************************************/
UINT32 zDrvTimer_Remain( T_ZDrv_TimerId uiTimerId );
/*******************************************************************************
 * Function:zDrvTimer_StopTimer
 * Description:ֹͣʱʱ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:ɹDRV_SUCCESSֵʾʧԭ
 *
 *
 * Others:ʡרãģ鲻!!!
 ********************************************************************************/
SINT32 zDrvTimer_StopTimer( T_ZDrv_TimerId uiTimerId );
#endif/*_DRVS_TIMER_H*/

