/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_spi.h
 * File Mark:    
 * Description:  Provide spi hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V0.5
 * Author:        zhenghong
 * Date:          2008-03-19
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_SPI_H
#define _HAL_SPI_H

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
* 	                               Include files
****************************************************************************/
#include "drvs_gpio.h"
/****************************************************************************
* 	                                Macros
****************************************************************************/
#define     USB_SWITCH_GPIO_OUT		    0
#define     USB_SWITCH_GPIO_IN		    1
#define     USB_SWITCH_PIN_MODE_FUNC	    0
#define     USB_SWITCH_PIN_MODE_GPIO	    1
#define     USB_SWTICH_SEL                46
#define     USB_SWTICH_OE_N               43
#define     DBB2AR9342_POWER_ON           39
#define     DBB2AR9342_RESET              48
#define     DBB2USB_DPOS_PULL_UP          7
#define     USB2DBB_DNEG_DETECT           8
#define     USB_CHAR_DET                   8
#define     VTELECOM_18_ARM_UART2_RXD    33
/****************************************************************************
* 	                                Types
****************************************************************************/
/*
OE*     S           HSD1+(HSD1-)   HSD2+(HSD2-)
1         X            OFF                      OFF
0         0            ON                        OFF                 
0         1            OFF                      ON

ps:HSD1+(HSD1-)  connect PC;HSD2+(HSD2-) connect wifi
OE* connect from GPIO43(ARM_I2S2_WS)
S connect from GPIO42(ARM_I2S2_DOUT)
*/
typedef enum Usb_Switch_Select_Option
{
    USB_SWITCH_CONNECT_PC,
    USB_SWITCH_CONNECT_WIFI,
    USB_SWITCH_ALL_OFF,
}T_Usb_Switch_Select_Option;

typedef enum Ar9342_On_Off_Option
{
	Ar9342_ON,
	Ar9342_OFF,
}T_Ar9342_On_Off_Option;

typedef enum Charger_Usbdevice
{
	USBCHARGER,//change to USBCHARGER because it`s the same to Charger_Usbdevice in Drvs_usb_switch.h
	USBDEVICE,
}Charger_Usbdevice;
/****************************************************************************
* 	                                Constants
****************************************************************************/

/****************************************************************************
* 	                                Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                Function Prototypes
****************************************************************************/
UINT32 zDrvUsb_Switch_Select(T_Usb_Switch_Select_Option select);

UINT32 zDrvSetAR9342_ON_OFF(T_Ar9342_On_Off_Option select);

VOID zDrvUSB_2V8_WriteGpio(UINT32 pinNum, UINT32 Value);
/*******************************************************************************
 * Function:                           zDrvCharger_UsbDevice_Detect             
 * Function:                           return charger or usb device    connect         
 * Description:            
 * Parameters:    
 *   Input:                   
 *
 *   Output:                
 *
 * Returns:                    success or fail
 *
 *
 * Others:
********************************************************************************/
Charger_Usbdevice zDrvCharger_UsbDevice_Detect(VOID);
/*******************************************************************************
 * Function:                           zDrvCharger_UsbDevice_Prepare             
 * Function:                           prepare gpio zpm_2v8_gpio08       
 * Description:            
 * Parameters:    
 *   Input:                   
 *
 *   Output:                
 *
 * Returns:                   
 *
 *
 * Others:
********************************************************************************/
VOID zDrvCharger_UsbDevice_Prepare(VOID);

#ifdef __cplusplus
}
#endif

#endif /*_HAL_SPI_H*/
