/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_REGIO_H_
#define _DRVS_REGIO_H_

/****************************************************************************
* 	                                        Include files
****************************************************************************/

/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
#ifdef _OS_TOS
#define wfi()	__asm__ __volatile__ ("wfi" : : : "memory")
	
/*
*	memory barriers
*/
#define isb()   __asm__ __volatile__ ("isb" : : : "memory")
#define dsb()   __asm__ __volatile__ ("dsb" : : : "memory")
#define dmb()   __asm__ __volatile__ ("dmb" : : : "memory")
	
#define wmb()	do { dsb(); zDrvL2x0_Sync(); } while (0)
#define rmb()	dsb()
#endif
	
/****************************************************************************
*  io operation definition
****************************************************************************/
/*
*  io operation without memory barriers
*/
#define reg(addr)			(*(volatile unsigned *)(addr))
#define reg8(addr)			(*(volatile unsigned char *)(addr))
#define reg16(addr)			(*(volatile unsigned short *)(addr))
#define reg32(addr)			(*(volatile unsigned long *)(addr))

/*
* io operation with memory barriers
* cortex-R7 has out-of-order  instruction execution
* these macro functions below maybe used in some special case 
*/
#define ioread8(p)	({ unsigned char  __v = reg8(p); rmb(); __v; })
#define ioread16(p)	({ unsigned short __v = reg16(p)); rmb(); __v; })
#define ioread32(p)	({ unsigned long  __v = reg32(p)); rmb(); __v; })
	
#define iowrite8(v,p)	({ wmb(); reg8(p) = v; })
#define iowrite16(v,p)	({ wmb(); reg16(p) = v; })
#define iowrite32(v,p)	({ wmb(); reg32(p) = v; })

VOID zDrv_MemcpyToIo32(VOID *dst, VOID *src, UINT32 byteCount);

#endif
