/***********************************************************************
* Copyright (C) 2016, ZTE Corporation.
*
* File Name: 	hal_fm_rda5802.h
* File Mark:
* Description:  fm RDA5802 chiper hal interface declaration.
* Others:
* Version:  v1.0
* Author:   taochao
* Date:      2016-03-09
*
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:

* History 2:
**********************************************************************/
#ifndef _HAL_FM_RDA5802_H
#define _HAL_FM_RDA5802_H

//#include "drv_pub.h"
#include "oss_api.h"
#include "oss_pub.h"

#define FM_BAND_LOWER	8700 /*87MHz*/
#define FM_BAND_UPPER	10800 /*108MHz*/
#define FM_CHAN_SPACING    10       /*100KHz */

/*fm volume level limits*/
typedef enum
{
    FM_VOLUME_MIN = 0,    //mute
    FM_VOLUME_MAX = 15
}T_HalFm_Volume_Level;

//stc --- Seek/Tune complete
//rssi--- Receive signal strength indicator
typedef union
{
    UINT16  value;
    struct
    {
        UINT16  enable:1;  // 0
        UINT16  softReset:1;  // 1
        UINT16  :2;  // 2-3
        UINT16  clkMode:3;  // 4-6
        UINT16  seekMode:1;  // 7
        UINT16  seek:1;  // 8
        UINT16  seekUp:1;  // 9
        UINT16  clkDirectMode:1;  // 10
        UINT16  :1;
        UINT16  bassBoost:1;  // 12
        UINT16  monoSel:1;  // 13
        UINT16  disMute:1;  //14
        UINT16  disHighZ:1;  // 15
    }bitSet;
}T_Rda5802_Reg02H;

typedef union
{
    UINT16  value;
    struct
    {
        UINT16  channelSpace:2;  // 0-1
        UINT16  bandSel:2;  // 2-3
        UINT16  tune:1;  // 4
        UINT16  :1;  //5
        UINT16  channelSel:10;  //6-15
    }bitSet;
}T_Rda5802_Reg03H;

typedef union
{
    UINT16  value;
    struct
    {
        UINT16  gpio1:2;  // 0-1
        UINT16  gpio2:2;  // 2-3
        UINT16  gpio3:2;  // 4-5
        UINT16  i2sEnable:1;  // 6
        UINT16  :1;  // 7
        UINT16  afcDisable:1;  // 8
        UINT16  softMuteEnable:1; // 9
        UINT16  :1;  // 10
        UINT16  de:1;  // 11
        UINT16  :2;  // 12-13
        UINT16  stcIntrEnable:1;  // 14
    }bitSet;
}T_Rda5802_Reg04H;
#if 0
typedef union
{
    UINT16  value;
    struct
    {
        UINT16  volume:4;  // 0-3
        UINT16  lnaIcSel:2;  // 4-5
        UINT16  lnaPortSel:2;  // 6-7
        UINT16  seekThreshold:7;  // 8-14
        UINT16  intrMode:1;  //15
    }bitSet;
}T_Rda5802_Reg05H;
#else
typedef union
{
    UINT16  value;
    struct
    {
        UINT16  volume:4;  // 0-3
        UINT16  :2;  // 4-5
        UINT16  lnaPortSel:2;  // 6-7
        UINT16  seekThreshold:4;  // 8-11
        UINT16  :1;  // 12
        UINT16  seekMode:2;  // 13-14
        UINT16  intrMode:1;  //15
    }bitSet;
}T_Rda5802_Reg05H;
#endif
typedef union
{
    UINT16  value;
    struct
    {
        UINT16  noSet:4;  // 0-3
        UINT16  i2sWsCnt:4;  // 4-7
        UINT16  :4;  // 8-11
        UINT16  i2sModeSel:1; // 12
        UINT16  openmode:2; // 13-14
    }bitSet;
}T_Rda5802_Reg06H;

typedef union
{
    UINT16  value;
    struct
    {
        UINT16  readChannel:10;  // 0-9
        UINT16  stereo:1;  // 10
        UINT16  :2;  // 11-12
        UINT16  seekFail:1;  // 13
        UINT16  stc:1;  //14
    }bitSet;
}T_Rda5802_Reg0AH;

typedef union
{
    UINT16  value;
    struct
    {
        UINT16  :7;  // 0-6
        UINT16  fmReady:1;  // 7
        UINT16  fmTrue:1;  // 8
        UINT16  rssi:7;  // 9-15
    }bitSet;
}T_Rda5802_Reg0BH;

typedef enum
{
    FM_RESET = 1,
    FM_TUNE = 2,
    FM_WORK = 3,
    FM_SEEK = 4,
    FM_SLEEP = 5
}T_Rda5802_State;

typedef struct _T_Rda5802_DevInfo
{
    T_Rda5802_Reg02H       reg02h;
    T_Rda5802_Reg03H       reg03h;
    T_Rda5802_Reg04H       reg04h;
    T_Rda5802_Reg05H       reg05h;
    T_Rda5802_Reg06H       reg06h;
    T_Rda5802_Reg0AH       reg0Ah;
    T_Rda5802_Reg0BH       reg0Bh;
    
    T_Rda5802_State          devState;
    BOOL                           canWaitSTC;
    ZOSS_SEMAPHORE_ID  stcSema;
}T_Rda5802_DevInfo;


#endif
