#ifndef _USB_LINUX_TYPES_H
#define _USB_LINUX_TYPES_H

#ifndef _OS_LINUX

#if 0
#include <mtd_linux/posix_types.h>
#include <mtd_asm/types.h>
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int		__kernel_size_t;
typedef __kernel_size_t		size_t;
#endif

#if 0
typedef __kernel_loff_t		loff_t;

typedef __kernel_dev_t		dev_t;
#endif

/* bsd */
typedef unsigned char		u_char;
typedef unsigned short		u_short;
typedef unsigned int		u_int;
typedef unsigned long		u_long;

/* sysv */
typedef unsigned char		unchar;
typedef unsigned short		ushort;
typedef unsigned int		uint;
typedef unsigned long		ulong;

#if 0
#ifndef __BIT_TYPES_DEFINED__
#define __BIT_TYPES_DEFINED__

typedef		__u8		u_int8_t;
typedef		__s8		int8_t;
typedef		__u16		u_int16_t;
typedef		__s16		int16_t;
typedef		__u32		u_int32_t;
typedef		__s32		int32_t;

#endif /* !(__BIT_TYPES_DEFINED__) */


typedef		__u8		uint8_t;
typedef		__u16		uint16_t;
typedef		__u32		uint32_t;
#else
typedef signed char __s8;
typedef signed char s8;
typedef unsigned char __u8;
typedef unsigned char u8;

typedef signed short __s16;
typedef signed short s16;
typedef unsigned short __u16;
typedef unsigned short u16;


typedef signed int __s32;
typedef signed int s32;
typedef unsigned int __u32;
typedef unsigned int u32;

typedef signed long long __s64;
typedef signed long long s64;
typedef unsigned long long __u64;
typedef unsigned long long u64;

typedef		__s8		int8_t;
typedef		__u8		uint8_t;
typedef		__u16		uint16_t;
typedef		__u32		uint32_t;
typedef		__u8		u_int8_t;
typedef		__u32		u_int32_t;
#endif

typedef		__u64		uint64_t;
typedef		__u64		u_int64_t;
typedef		__s64		int64_t;

typedef int						int32_t;
typedef u32						uint32_t;
typedef u16						uint16_t;
typedef u8						uint8_t;


#define __cpu_to_le64(x) ((__u64)(x))
#define __le64_to_cpu(x) ((__u64)(x))
#define __cpu_to_le32(x) ((__u32)(x))
#define __le32_to_cpu(x) ((__u32)(x))
#define __cpu_to_le16(x) ((__u16)(x))
#define __le16_to_cpu(x) ((__u16)(x))


/*
 * Below are truly Linux-specific types that should never collide with
 * any application/library that wants linux/types.h.
 */
#ifdef __CHECKER__
#define __bitwise__ __attribute__((bitwise))
#else
#define __bitwise__
#endif
#ifdef __CHECK_ENDIAN__
#define __bitwise __bitwise__
#else
#define __bitwise
#endif


typedef __u16 __bitwise __le16;
typedef __u16 __bitwise __be16;
typedef __u32 __bitwise __le32;
typedef __u32 __bitwise __be32;
#if defined(__GNUC__)
typedef __u64 __bitwise __le64;
typedef __u64 __bitwise __be64;
#endif
typedef __u16 __bitwise __sum16;
typedef __u32 __bitwise __wsum;

typedef signed long long s64;


typedef u32		compat_size_t;
typedef s32		compat_ssize_t;
typedef s32		compat_time_t;
typedef s32		compat_clock_t;
typedef s32		compat_pid_t;
typedef u32		__compat_uid_t;
typedef u32		__compat_gid_t;
typedef u32		__compat_uid32_t;
typedef u32		__compat_gid32_t;
typedef u32		compat_mode_t;
typedef u32		compat_ino_t;
typedef u32		compat_dev_t;
typedef s32		compat_off_t;
typedef s64		compat_loff_t;
typedef s16		compat_nlink_t;
typedef u16		compat_ipc_pid_t;
typedef s32		compat_daddr_t;
typedef u32		compat_caddr_t;
//typedef __kernel_fsid_t	compat_fsid_t;
typedef s32		compat_key_t;
typedef s32		compat_timer_t;

typedef s32		compat_int_t;
typedef s32		compat_long_t;
typedef s64		compat_s64;
typedef u32		compat_uint_t;
typedef u32		compat_ulong_t;
typedef u64		compat_u64;

typedef enum {
	GFP_KERNEL,
	GFP_ATOMIC,
} gfp_t;

//typedef int spinlock_t;

#define ___GFP_WAIT		0x10u
#define __force
#define __GFP_WAIT	((__force gfp_t)___GFP_WAIT)
#define GFP_NOIO	(__GFP_WAIT)

#if 0
typedef struct { volatile int counter; } atomic_t;
#endif

#if 0
typedef struct {
	int counter;
} usbHostTos_atomic_t;
#else
typedef int atomic_t;
#endif

typedef u32 dma_addr_t;

#define __iomem

//typedef unsigned char bool;

#ifndef NULL
#define NULL 0
#endif
#endif
typedef int usbHostTos_atomic_t;

#if 0
#ifndef __BIT_TYPES_DEFINED__
#define __BIT_TYPES_DEFINED__

typedef		__u8		u_int8_t;
typedef		__s8		int8_t;
typedef		__u16		u_int16_t;
typedef		__s16		int16_t;
typedef		__u32		u_int32_t;
typedef		__s32		int32_t;

#endif /* !(__BIT_TYPES_DEFINED__) */


typedef		__u8		uint8_t;
typedef		__u16		uint16_t;
typedef		__u32		uint32_t;
#else
typedef signed char __s8;
typedef signed char s8;
typedef unsigned char __u8;
typedef unsigned char u8;

typedef signed short __s16;
typedef signed short s16;
typedef unsigned short __u16;
typedef unsigned short u16;


typedef signed int __s32;
typedef signed int s32;
typedef unsigned int __u32;
typedef unsigned int u32;

typedef signed long long __s64;
typedef signed long long s64;
typedef unsigned long long __u64;
typedef unsigned long long u64;

typedef		__s8		int8_t;
typedef		__u8		uint8_t;
typedef		__u16		uint16_t;
typedef		__u8		u_int8_t;
typedef		__u32		u_int32_t;
#endif

typedef		__u64		uint64_t;
typedef		__u64		u_int64_t;
typedef		__s64		int64_t;

typedef int						int32_t;
typedef u32						uint32_t;
typedef u16						uint16_t;
typedef u8						uint8_t;

#endif /* _LINUX_TYPES_H */
