/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IODEV_H_
#define _DRVS_IODEV_H_

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_io.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
/*ײ豸*/
typedef void * T_ZDrvIODev_Handle;


/*豸ҽʵֽӿ*/
typedef struct _T_ZDrvIODev_Ops
{
    SINT32 (*open)(VOID *devData, T_ZDRVIO_FLAGS flags);
    SINT32 (*read)(VOID *devData, VOID *buffer, UINT32 length);
    SINT32 (*write)(VOID *devData, const VOID *buffer, UINT32 length);
    SINT32 (*bread)(VOID *devData, VOID *buffer, UINT32 blkCnt, UINT32 pos);
    SINT32 (*bwrite)(VOID *devData, const VOID *buffer, UINT32 blkCnt, UINT32 pos);
    SINT32 (*ctrl)(VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg);
    SINT32 (*close)(VOID *devData);
}
T_ZDrvIODev_Ops;


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function: zDrvIODev_Connect
 * Description:install and connect io device to device table.
 * Input:
     name: the device name to connect.
     devData: the device private data to be combined.
     ops: the device I/O operation.
 * Output:None
 *
 * Returns:
              T_ZDrvIODev_Handle: none zero.
              NULL: error.
 * Others:
 ********************************************************************************/
T_ZDrvIODev_Handle zDrvIODev_Connect(const char *name, VOID *devData, T_ZDrvIODev_Ops *ops);

/*******************************************************************************
 * Function: zDrvIODev_Disconnect
 * Description:uninstall the io device.
 * Input:
      handle: the device handle to disconnect.
 * Output:None
 *
 * Returns:
              NULL: error.
 * Others:
 ********************************************************************************/
VOID zDrvIODev_Disconnect(T_ZDrvIODev_Handle handle);

/*******************************************************************************
 * Function: zDrvIODev_Show
 * Description:show the device debug information.
 * Input:
 * Output:None
 *
 * Returns:None
 * Others:
 ********************************************************************************/
VOID zDrvIODev_Show(VOID);

/*******************************************************************************
 * Function: zDrvIODev_Initiate
 * Description:initialize the io base structure.
 * Input:
 * Output:None
 *
 * Returns:
              DRV_SUCCESS: success.
              DRV_ERROR: error.
 * Others:
 ********************************************************************************/
SINT32 zDrvIODev_Initiate(VOID);




#endif/*_DRVS_IO_H_*/

