/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_io_led.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        yuxiang
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_LED_H
#define _DRVS_IO_LED_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define ZDRV_DEV_LED  "led"
/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum {
	LED_BRIGHTNESS_0 = 0,
	LED_BRIGHTNESS_1 , /* 0000 - 10mA   */
	LED_BRIGHTNESS_2 , /* 0001 - 15mA   */
	LED_BRIGHTNESS_3 , /* 0010 - 20mA  */
	LED_BRIGHTNESS_4 , /* 30mA  */
	LED_BRIGHTNESS_5 , /* 40mA */
	LED_BRIGHTNESS_6 , /* 50mA */
	LED_BRIGHTNESS_7 , /* 60mA */
	LED_BRIGHTNESS_8 , /* 70mA */
	LED_BRIGHTNESS_9 , /* 80mA */
	LED_BRIGHTNESS_10 , /* 90mA	  */
	LED_BRIGHTNESS_11 , /* 100mA */
	LED_BRIGHTNESS_12 , /* 110mA */
	LED_BRIGHTNESS_13 , /* 1100 - 120mA	  */
	LED_BRIGHTNESS_14 , /* 1101 - 120mA	  */
	LED_BRIGHTNESS_15 , /* 1110 - 120mA	  */
	LED_BRIGHTNESS_16 , /* 1111 - 120mA	  */
	LED_BRIGHTNESS_MAX,
}T_ZDrvLed_Brightness;

#define LED_RED_ON			(1<<0)
#define LED_GREEN_ON		(1<<1)
#define LED_BLUE_ON		    (1<<2)
typedef enum
{
	LED_COLOR_RED   =LED_RED_ON,
	LED_COLOR_GREEN =LED_GREEN_ON,
	LED_COLOR_BLUE  =LED_BLUE_ON,
	LED_COLOR_YELLOW=LED_RED_ON | LED_GREEN_ON,
	LED_COLOR_PURPLE=LED_RED_ON | LED_BLUE_ON,
	LED_COLOR_CYAN  =LED_GREEN_ON | LED_BLUE_ON,
	LED_COLOR_WHITE =LED_RED_ON |LED_GREEN_ON | LED_BLUE_ON,
	//LED_COLOR_BLACK,
	LED_COLOR_MAX,
}T_ZDrvLed_Color;

typedef enum
{
	LED_STATE_OFF = 0,
	LED_STATE_ON ,
	//LED_STATE_BLINK_OFF,
	//LED_STATE_BLINK_ON,
	LED_STATE_BLINK,
	LED_STATE_MAX,
}T_ZDrvLed_State;

typedef enum
{
	LED_TRAFFIC_10 = 0,
	LED_TRAFFIC_20 ,
	LED_TRAFFIC_30,
	LED_TRAFFIC_40,
	LED_TRAFFIC_50,
	LED_TRAFFIC_60,
	LED_TRAFFIC_70,
	LED_TRAFFIC_80,
	LED_TRAFFIC_90,
	LED_TRAFFIC_100,
	LED_TRAFFIC_MAX,
}T_ZDrvLed_Traffic;

typedef enum
{
	LED_SLEEP_ENTER = 0,
    LED_SLEEP_EXIT,
    LED_SLEEP_MAX,

}T_ZDrvLed_Sleep;

typedef enum
{
	LED_DEVICE_NAME_WAN = 0,
	LED_DEVICE_NAME_LAN,
	LED_DEVICE_NAME_SMS,
	LED_DEVICE_NAME_BATTERY,
	LED_DEVICE_NAME_TRAFFIC,
	LED_DEVICE_LEFT_1,
	LED_DEVICE_LEFT_2,
	LED_DEVICE_LEFT_3,
	LED_DEVICE_LEFT_4,
	LED_DEVICE_NAME_LGP,

	LED_DEVICE_NAME_SLEEP,
    LED_DEVICE_NAME_MAX,
}T_ZDrvLed_DevName;

typedef struct
{
    UINT32 uBlinkOnTime;
    UINT32 uBlinkOffTime;
}T_ZDrvLed_Blink;

/*define for led ctrl mod by mcu or hardware 0x01 BLED_REG*/

typedef enum
{
	LED_HW_CTRL = 0,	
	LED_MCU_CTRL,
	
	LED_MAX_CTRL,
}T_ZDrvLed_CtrlMod;


/*IOCTLƲݲ*/
typedef struct
{
	//T_ZDrvLed_DevName uDeviceName;
	T_ZDrvLed_Brightness  uBrightness;
	T_ZDrvLed_Color uColor;
    T_ZDrvLed_State uState;
    T_ZDrvLed_Traffic uTraffic;
    T_ZDrvLed_Sleep uSleep;
    T_ZDrvLed_Blink ledBlink;
	T_ZDrvLed_CtrlMod ledCtrlMod;
}T_ZDrvLed_Descriptor;

#if 0
/*ڻȡ豸Ϣ*/
typedef struct
{
	T_ZDrvLed_DevName  ledName;
	T_ZDrvLed_State        ledState ;
	T_ZDrvLed_Color  ledColor ;
	T_ZDrvLed_Brightness   ledBrightNess;

}T_LED_INFO;
#endif

#endif/*_DRVS_IO_LED_H*/

