/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_io_led.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        yuxiang
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_RTC_H
#define _DRVS_IO_RTC_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define ZDRV_DEV_RTC  "rtc"
/****************************************************************************
* 	                                        Types
****************************************************************************/


typedef struct 
{  
    BOOL    mode_12_hour; /* TRUE->12 hour mode ; FALSE-> 24 hour mode */
    BOOL    PM_flag;      /* if 12 hour flag = TRUE    TRUE->PM ; FALSE->AM */
    UINT8   second;       /* seconds after the minute   - [0,59]  */
    UINT8   minute;       /* minutes after the hour      - [0,59]  */
    UINT8   hour;         /* hours after the midnight   - [0,23]  */
    UINT8   day;          /* day of the month            - [1,31]  */
    UINT8   month;        /* months                     - [01,12] */   
    UINT8   wday;         /* days in a week               - [1,7] */
    UINT16  year;         /* years                        - [0000,9999] */
} T_ZDrvRtc_TimeDate;


typedef enum 
{
    RTC_IRQ_SEC_INT,	/*second interrupt  */
    RTC_IRQ_MIN_INT,	/* minute interrupt */
    RTC_IRQ_HOUR_INT,	/* hour interrupt */
    RTC_IRQ_DAY_INT,	/* day interrupt */

    RTC_IRQ_INT_MAX
} T_ZDrvRtc_EventInt;

typedef enum 
{
    RTC_INT_DISABLE,
    RTC_INT_ENABLE,

    MAX_RTC_INT_SETUP
}T_ZDrvRtc_IntSetup;

typedef enum 
{
    ALARM_POWER_OFF,
    ALARM_POWER_ON,

    MAX_ALARM_POWER
} T_ZDrvRtc_AlarmPower;

typedef    VOID (*zDrvRtc_AlarmCallbackFunc)(VOID);
typedef    VOID (*zDrvRtc_CycleCallbackFunc)(T_ZDrvRtc_EventInt);


/*IOCTLƲݲ*/
typedef struct
{
	T_ZDrvRtc_TimeDate  TimeDate;
	T_ZDrvRtc_AlarmPower AlarmEnable;
    T_ZDrvRtc_IntSetup IntEnable;
    zDrvRtc_CycleCallbackFunc CycleCallback;
    zDrvRtc_AlarmCallbackFunc AlarmCallback;
}T_ZDrvRtc_Descriptor;



/*ƽ̨ṩĶȡʱڵĽӿ*/
SINT32  Rtc_GetDateTime(T_ZDrvRtc_TimeDate * pDateTime);
SINT32  Rtc_SetDateTime(T_ZDrvRtc_TimeDate * pDateTime);


#endif/*_DRVS_IO_LED_H*/

